/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 1999-2000 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

**************************************************************************** */
#ifndef SETTINGS_H
#define SETTINGS_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qstring.h>
#include <qstringlist.h>
#include <qfont.h>
#include <qcolor.h>
#include <kurl.h>

#include "catalogsettings.h"

struct SearchSettings
{
   bool autoSearch;
   QString defaultModule;
};

struct EditorSettings
{
   bool autoUnsetFuzzy;
   bool autoCheckArgs;
   bool autoCheckAccel;
   bool autoCheckEquation;
   bool autoCheckContext;
   bool beepOnError;
   bool autoCheckColorError;

   bool highlightBg;
   bool whitespacePoints;
   bool quotes;
   bool highlightSyntax;

   bool ledInStatusbar;

   QColor bgColor;
   QColor quotedColor;
   QColor errorColor;
   QColor cformatColor;
   QColor accelColor;
   QColor ledColor;

   QFont msgFont;

   // spellchecking
   bool noRootAffix;
   bool runTogether;
   int spellEncoding;
   int spellClient;
   QString spellDict;

   bool rememberIgnored;
   QString ignoreURL;
};


/** settings of the CatalogManager */
struct CatManSettings
{
   QString poBaseDir;
   QString potBaseDir;

   bool openWindow;

   QStringList dirCommands;
   QStringList dirCommandNames;
   QStringList fileCommands;
   QStringList fileCommandNames;

   bool killCmdOnExit;
};


/**
* This namespace provides static methods and variables to get the default
* values of configuration values
*/
namespace Defaults
{
   class  Editor
   {
    public:
       static const bool autoUnsetFuzzy=true;
	   static const bool autoCheckArgs=true;
	   static const bool autoCheckAccel=true;
	   static const bool autoCheckEquation=true;
	   static const bool autoCheckContext=true;
       static const bool beepOnError=false;
       static const bool autoCheckColorError=true;

       static const bool highlightBg=false;
       static const bool whitespacePoints=true;
       static const bool quotes=false;
       static const bool highlightSyntax=true;

       static const bool ledInStatusbar=true;

       static const QColor bgColor;
       static const QColor quotedColor;
       static const QColor errorColor;
       static const QColor cformatColor;
       static const QColor accelColor;
       static const QColor ledColor;

       static QFont msgFont();

	   static const bool rememberIgnored=true;
       static QString ignoreURL();

    private:
       static QString _ignoreURL;
   };


   class Search
   {
    public:
       static const bool autoSearch=false;
       static const QString defaultModule;
   };

   class CatalogManager
   {
    public:
       static QString poBaseDir();
       static QString potBaseDir();
       static const bool openWindow=false;

       static QStringList dirCommands();
       static QStringList dirCommandNames();
       static QStringList fileCommands();
       static QStringList fileCommandNames();

       static const bool killCmdOnExit=true;

    private:
       static QString _poBaseDir;
       static QString _potBaseDir;
   };
}


#endif // SETTINGS_H
