/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 1999-2000 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

**************************************************************************** */
#ifndef KBCATALOG_H
#define KBCATALOG_H


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include "catalog.h"

class HeaderEditor;


/**
* This class adds some functionality to the catalog, 
* that is needed by the gui.
* * @author Matthias Kiefer <matthias.kiefer@gmx.de>
*/
class KBCatalog : public Catalog
{
    Q_OBJECT

public:
   KBCatalog(QObject* parent=0, const char* name=0);
   virtual ~KBCatalog();

   HeaderEditor* headerEditor();

private:
   HeaderEditor* _headerEditor;

};

#endif //CATALOG_H
