// $Id: kofilterview.cpp,v 1.2 2001/01/08 15:48:41 faure Exp $

#include <qcheckbox.h>

#include "calfilter.h"

#include "kofilterview.h"

/* 
 *  Constructs a KOFilterView which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 */
KOFilterView::KOFilterView(CalFilter *filter,QWidget* parent,const char* name,
                           WFlags fl )
  : KOFilterView_base(parent,name,fl)
{
  mFilter = filter;
}

/*  
 *  Destroys the object and frees any allocated resources
 */
KOFilterView::~KOFilterView()
{
    // no need to delete child widgets, Qt does it all for us
}

void KOFilterView::updateFilter()
{
  if (!mEnabledCheck->isChecked()) {
    // Only emit filterChanged(), when enabled state has changed.
    if (mFilter->isEnabled()) {
      mFilter->setEnabled(false);
      emit filterChanged();
    }
    // If filter is disabled just return and don't check the filter settings.
    return;
  } else {
    mFilter->setEnabled(true);
  }

  int inclusion = 0;
  if (mInRecurringCheck->isChecked()) inclusion |= CalFilter::Recurring;
  if (mInFloatingCheck->isChecked()) inclusion |= CalFilter::Floating;
  mFilter->setInclusionCriteria(inclusion);

  int exclusion = 0;  
  if (mExRecurringCheck->isChecked()) exclusion |= CalFilter::Recurring;
  if (mExFloatingCheck->isChecked()) exclusion |= CalFilter::Floating;
  mFilter->setExclusionCriteria(exclusion);
  
  emit filterChanged();
}
#include "kofilterview.moc"
