/* Yo Emacs, this -*- C++ -*-

  Copyright (C) 1999,2000 Jens Hoefkens
  jens@hoefkens.com

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
*/

#ifndef __KBGCONNECTION_H
#define __KBGCONNECTION_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <ksock.h>
#include <qstring.h>
#include <qstrlist.h>


/**
 * A class that handles telnet-like network connections. It is 
 * taylored for the communication with FIBS but should work in 
 * other cases too.
 */
class KBgConnection : public QObject
{
	Q_OBJECT
	
public:

	/**
	 * Constructor
	 */
	KBgConnection(QObject *parent, QString *name, QString *name1, ushort port);

	/**
	 * Destructor
	 */
	virtual ~KBgConnection();

	/**
	 * Returns the file descriptor of the socket, or negative values
	 * if the socket is closed.
	 */
	int status();

private:
	
	/**
	 * rx and tx buffers
	 */
	QString   rxBuffer;
	QStrList  txBuffer;
	
	/**
	 * The actual socket. The rest is just infrastructure
	 */
	KSocket  *socket;
	
public slots:
        
        /**
	 * Sends the string to the server
	 */
        void sendData(const QString &);

protected slots:

        /**
	 * Get data from the server
	 */
        void receiveData(KSocket *s);

	/**
	 * Internally, connected to KSocket::writeEvent()
	 */
	void flushData(KSocket *s);

	/**
	 * Translate KSocket::closeEvent to connectionLost
	 */
	void transmitClose(KSocket *s);
	
signals:

	/**
	 * Emit e new line that came from the server
	 */
	void newData(QString *);

	/**
	 * Error signals that indicate a lost or a remotely closed
	 * connection
	 */
	void connectionDown();
};

#endif // __KBGCONNECTION_H
