#include "EditWidget.moc"
#include "ui.h"
EditWidget::EditWidget(QString const label, QString const text, bool isFile, QWidget *parent, const char *name, WFlags f, bool allowLines):QHBox(parent, name, f, allowLines)
{
	setMargin(SPACE_MARGIN);
	setSpacing(SPACE_INSIDE);
	lbl=new QLabel(label, this);
	setStretchFactor(lbl, 0);
	line=new QLineEdit(text, this);
	setStretchFactor(line, 1);
	connect(line, SIGNAL(textChanged(const QString &)), SIGNAL(textChanged(const QString &)));
	connect(line, SIGNAL(returnPressed()), SIGNAL(returnPressed()));
	lbl->setBuddy(line);
	if(isFile) {
		select=new QPushButton(_("Select"), this);
		connect(select, SIGNAL(clicked()), SLOT(selectFileClicked()));
		select->resize(select->minimumSizeHint());
		setStretchFactor(select, 0);
	} else
		select=0;
}
void EditWidget::selectFileClicked()
{
	line->setText(FileDlg::getOpenFileName(QString::null, QString::null, this));
}
QSize EditWidget::sizeHint() const
{
	int w=2*SPACE_MARGIN+lbl->sizeHint().width()+SPACE_INSIDE+line->sizeHint().width();
	int h=lbl->sizeHint().height();
	if(h<line->sizeHint().height())
		h=line->sizeHint().height();
	if(select!=0) {
		w+=SPACE_INSIDE+select->sizeHint().width();
		if(h<select->sizeHint().height())
			h=select->sizeHint().height();
	}
	return QSize(w, h);
}
QSize EditWidget::minimumSizeHint() const
{
	int w=2*SPACE_MARGIN+lbl->minimumSizeHint().width()+SPACE_INSIDE+line->minimumSizeHint().width();
	int h=lbl->minimumSizeHint().height();
	if(h<line->minimumSizeHint().height())
		h=line->minimumSizeHint().height();
	if(select!=0) {
		w+=SPACE_INSIDE+select->minimumSizeHint().width();
		if(h<select->minimumSizeHint().height())
			h=select->minimumSizeHint().height();
	}
	return QSize(w, h);
}
