/*
 *  This file is part of the KDE System Control Tool,
 *  Copyright (C)1999 Thorsten Westheider <twesthei@physik.uni-bielefeld.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ****************************************************************************/

#include <qkeycode.h>
#include <qtoolbutton.h>

#include <kapp.h>
#include <klocale.h>

#include <qtabwidget.h>

#include <qlayout.h>

#include "mainwindow.h"


KSystemControlMainWindow::KSystemControlMainWindow(QWidget *parent, const char *name)
	: KCModule(parent,name)
{
  setCaption(i18n("Properties of System"));
  //setCancelButton();

  QVBoxLayout *top = new QVBoxLayout(this);
  QTabWidget *tab = new QTabWidget(this);
  
  //_generaltab = new GeneralTab(tab,       "generaltab");
  _devmantab  = new DeviceManagerTab(tab, "devmantab");
  _abouttab   = new AboutTab(tab,         "abouttab");
  
  //tab->addTab(_generaltab, i18n("General"));
  tab->addTab(_devmantab,  i18n("Device Manager"));
  tab->addTab(_abouttab,   i18n("About"));
 
top->addWidget(tab); 
//  connect(this, SIGNAL(applyButtonPressed()),  SLOT(slotApplyPressed()));
//  connect(this, SIGNAL(cancelButtonPressed()), SLOT(slotCancelPressed()));
  
  //resize(430, 450);  
}


/*
 * Protected methods
 ********************/
 
void  KSystemControlMainWindow::closeEvent(QCloseEvent *)
{
  kapp->quit();
}


/*
 * Private methods
 ******************/
 
void  KSystemControlMainWindow::slotApplyPressed()
{
  kapp->quit();
}


void  KSystemControlMainWindow::slotCancelPressed()
{
  kapp->quit();
}




