/*
 *  This file is part of the KDE System Control Tool,
 *  Copyright (C)1999 Thorsten Westheider <twesthei@physik.uni-bielefeld.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ****************************************************************************/

#include <qlabel.h>
#include <qlayout.h>

#include <klocale.h>

#include "drvusginfobox.h"
#include "pie3dwidget.h"


DriveUsageInfoBox::DriveUsageInfoBox(DriveInfo *driveinfo, QWidget *parent,
                                     const char *name) : QGroupBox(parent, name)
{
  QString  devstr  = driveinfo->device();
  QString  partstr;
  int      count   = 0;
  QColor   color[] = { QColor(192,   0,   0), QColor(  0, 128, 128), QColor(255, 255,   0),
                       QColor(  0, 192,   0), QColor(  0,   0, 192), QColor(192,   0, 192),
                       QColor(192, 192, 255), QColor(255, 128,   0), QColor(192, 192,   0),
                       QColor(255, 192, 255), QColor(128, 128, 128), QColor(  0, 192, 192),
                       QColor(128,   0,   0), QColor(128,   0, 128), QColor(  0,   0, 128) };
  
  setTitle(i18n("Usage"));
  setFrameStyle(QFrame::Box | QFrame::Sunken);
  setLineWidth(1);
  
  if (driveinfo->count() == 1)
    partstr = i18n("One partition");
  else
    partstr = i18n("%1 partitions").arg(driveinfo->count());
  
  Pie3DWidget  *pie       = new Pie3DWidget(                       this, "pie");
  QLabel       *partlabel = new QLabel(partstr,                    this, "partlabel");
  QLabel       *devlabel  = new QLabel(driveinfo->device(),        this, "devlabel");
  
  pie->resize(200, 100);
  // Maximum 16 partitions per drive - not enough colors...

  if (driveinfo->count())
  { 
    for (PartitionInfo *part = driveinfo->firstPartition(); part; part = driveinfo->nextPartition())
      pie->addPiece(part->blocks(), color[count++]);
  } else pie->addPiece(1, color[0]);
           
  QHBoxLayout  *toplayout = new QHBoxLayout(this, 16,   4, "toplayout");
  toplayout->addStretch(1);
  
  QVBoxLayout  *usglayout = new QVBoxLayout(toplayout,  4, "usglayout");
  usglayout->addStretch(1);
  
  QHBoxLayout  *partlayout = new QHBoxLayout(usglayout, 4, "partlayout");
  partlayout->addStretch(1);
  partlayout->addWidget(partlabel);
  partlayout->addStretch(1);
  
  usglayout->addSpacing(8);
  
  QHBoxLayout  *pielayout = new QHBoxLayout(usglayout, 4, "pielayout");
  pielayout->addStretch(1);
  pielayout->addWidget(pie, 1);
  pielayout->addStretch(1);
  
  usglayout->addSpacing(8);
  
  QHBoxLayout  *devlayout = new QHBoxLayout(usglayout, 4, "devlayout");
  devlayout->addStretch(1);
  devlayout->addWidget(devlabel);
  devlayout->addStretch(1);

  usglayout->addStretch(1);

  toplayout->addStretch(1);
  toplayout->activate();
}


