//////////////////////////////////////////////////////////////         
//      $Id: updateLoc.h,v 1.15 2000/09/01 20:19:46 waba Exp $ 
//
// Author: Toivo Pedaste
//
#ifndef DEBLOCATE_H
#define DEBLOCATE_H

#include "../config.h"

// Standard Headers
#include <stdio.h>

// Qt Headers
#include <qdir.h>
#include <qwidget.h>
#include <qframe.h>
#include <qlabel.h>
#include <qfiledlg.h> 
#include <qgrpbox.h> 
#include <qchkbox.h>
#include <qlayout.h> 
#include <qlined.h>
#include <qtabdlg.h>

// KDE headers
#include <kapp.h>
#include <kmenubar.h>
//#include <kmsgbox.h>
#include <kbuttonbox.h> 
#include <kfiledialog.h> 

class pkgInterface;
class updateLoc;
class cacheObj;
class LcacheObj;
class KComboBox;

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
class dpanel : public QWidget
{
  Q_OBJECT

public:
  dpanel(updateLoc *upd, QString Pfilter, QWidget *parent,
	 bool buse = TRUE, const char * name  = 0, bool bsubdirs = TRUE );
  ~dpanel();


  QString getText();
  void setText(QString s);
  bool getUse();
  void setUse(int n);
  bool getSubdirs();
  void setSubdirs(int n);

private:

  QCheckBox *psubdirs;
  QCheckBox *puse;
  QHBoxLayout* pack;
  QLineEdit *pent;
  QPushButton *pbut;

  dpanel *base;
  QString filter;

 public slots:
  void fileOpen();
  void dirOpen();

};

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
class updateLoc : public QDialog
{
  Q_OBJECT

public:

  updateLoc (QWidget *p, int panelNumber, int numberLines, pkgInterface *inter,
	     QString options, QString iname, QString filter,
	     QString lmsg, QString bmsg = 0, bool subdirs = FALSE);
  ~updateLoc(); 

  void restore();
  // show window, setting the buttons

  void readSettings();
  void writeSettings();

  void applyS(LcacheObj *slist);

  bool haveBase;
  dpanel *base;

private:

  QString interName;
  QString packL, packU, packS, packC, availB;
  int panNumber;

  int wdth;
  
  QPushButton  *butloc;

  QHBoxLayout* hloc;

  pkgInterface *interface;

  QGroupBox *fbase;
  QVBoxLayout* vbase;

  static const int PNUM = 40;
  int numLines;
  dpanel *dp[PNUM];
  KComboBox *combo[PNUM];

  QVBoxLayout* vl;
  QVBoxLayout* vtop, *vf;
  QGroupBox *frame1;
  KButtonBox* hb;

};
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
class Locations : public QDialog
{
  Q_OBJECT

public:
Locations( QString msg);
void dLocations(int numberDirs,  int numberLines,
		     pkgInterface *inter, QString label,
		     QString iname, QString filter, QString dirMsg,
		     bool subdirs=TRUE );

void pLocations(int numberDirs,  int numberLines,
		     pkgInterface *inter, QString label,
		     QString iname, QString filter,
		     QString packMsg, QString baseMsg = 0,
		     bool subdirs=FALSE);

void cLocations(int numberDirs, int numberLines,
		     pkgInterface *inter, QString label, QString iname,
		     QString filter, 
		QString packMsg, QString baseMsg, QString options);

  // bmsg indicates the panel has a base entry
~Locations();
void restore();

QTabDialog *tab;
int numPanels;
static const int PANNUM = 10;
updateLoc *pn[PANNUM];

public slots:
    void apply_slot();

signals:
  void returnVal(LcacheObj *);

};

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

#endif
