/*
 *  Copyright (C) 2000 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "galeon.h"
#include "mozilla_i18n.h"

#include <libgnome/gnome-defs.h>
#include <libgnome/gnome-i18n.h>

const char *lgroups[] = {
	N_("Arabic"),
	N_("Baltic"),
	N_("Central European"),
	N_("Chinese"),
	N_("Cyrillic"),
	N_("Greek"),
	N_("Hebrew"),
	N_("Indian"),
	N_("Japanese"), 
	N_("Turkish"),
	N_("Unicode"),
	N_("Vietnamese"),
	N_("Western"),
	N_("Other")
};

const CharsetInfo charset_trans_array[] = { 
	{N_("Arabic (IBM-864)"),			LG_ARABIC},
	{N_("Arabic (IBM-864-I)"),			LG_ARABIC},
	{N_("Arabic (ISO-8859-6)"),			LG_ARABIC},
	{N_("Arabic (ISO-8859-6-E)"),			LG_ARABIC},
	{N_("Arabic (ISO-8859-6-I)"),			LG_ARABIC},
	{N_("Arabic (MacArabic)"),			LG_ARABIC},
	{N_("Arabic (Windows-1256)"),			LG_ARABIC},
	{N_("Armenian (ARMSCII-8)"),			LG_OTHER},
	{N_("Baltic (ISO-8859-13)"),			LG_BALTIC},
	{N_("Baltic (ISO-8859-4)"),			LG_BALTIC},
	{N_("Baltic (Windows-1257)"),			LG_BALTIC},
	{N_("Celtic (ISO-8859-14)"),			LG_OTHER},
	{N_("Central European (IBM-852)"),		LG_CENTRAL_EUROPEAN},
	{N_("Central European (ISO-8859-2)"),		LG_CENTRAL_EUROPEAN},
	{N_("Central European (MacCE)"),		LG_CENTRAL_EUROPEAN},
	{N_("Central European (Windows-1250)"),		LG_CENTRAL_EUROPEAN},
	{N_("Chinese Simplified (GB18030)"),		LG_CHINESE},
	{N_("Chinese Simplified (GB2312)"),		LG_CHINESE},
	{N_("Chinese Simplified (GBK)"),		LG_CHINESE},
	{N_("Chinese Simplified (HZ)"),			LG_CHINESE},
	{N_("Chinese Traditional (Big5)"),		LG_CHINESE},
	{N_("Chinese Traditional (Big5-HKSCS)"),	LG_CHINESE},
	{N_("Chinese Traditional (EUC-TW)"),		LG_CHINESE},
	{N_("Croatian (MacCroatian)"),			LG_CENTRAL_EUROPEAN},
	{N_("Cyrillic (IBM-855)"),			LG_CYRILLIC},
	{N_("Cyrillic (ISO-8859-5)"),			LG_CYRILLIC},
	{N_("Cyrillic (ISO-IR-111)"),			LG_CYRILLIC},
	{N_("Cyrillic (KOI8-R)"),			LG_CYRILLIC},
	{N_("Cyrillic (MacCyrillic)"),			LG_CYRILLIC},
	{N_("Cyrillic (Windows-1251)"),			LG_CYRILLIC},
	{N_("Cyrillic/Russian (CP-866)"),		LG_CYRILLIC},
	/* this is left for compatibily with the previous (0.9) moz version */
	{N_("Cyrillic/Russian (IBM-866)"),		LG_CYRILLIC},
	{N_("Cyrillic/Ukrainian (KOI8-U)"),		LG_CYRILLIC},
	{N_("Cyrillic/Ukrainian (MacUkrainian)"),	LG_CYRILLIC},
	{N_("English (US-ASCII)"),			LG_WESTERN},
	{N_("Farsi (MacFarsi)"),			LG_OTHER},
	{N_("Greek (ISO-8859-7)"),			LG_GREEK},
	{N_("Greek (MacGreek)"),			LG_GREEK},
	{N_("Greek (Windows-1253)"),			LG_GREEK},
	{N_("Gujarati (MacGujarati)"),			LG_INDIAN},
	{N_("Gurmukhi (MacGurmukhi)"),			LG_INDIAN},
	{N_("Hebrew (IBM-862)"),			LG_HEBREW},
	{N_("Hebrew (ISO-8859-8-E)"),			LG_HEBREW},
	{N_("Hebrew (ISO-8859-8-I)"),			LG_HEBREW},
	{N_("Hebrew (MacHebrew)"),			LG_HEBREW},
	{N_("Hebrew (Windows-1255)"),			LG_HEBREW},
	{N_("Hindi (MacDevanagari)"),			LG_INDIAN},
	{N_("Icelandic (MacIcelandic)"),		LG_OTHER},
	{N_("Japanese (EUC-JP)"),			LG_JAPANESE},
	{N_("Japanese (ISO-2022-JP)"),			LG_JAPANESE},
	{N_("Japanese (Shift_JIS)"),			LG_JAPANESE},
	{N_("Korean (EUC-KR)"),				LG_OTHER},
	{N_("Nordic (ISO-8859-10)"),			LG_OTHER},
	{N_("Romanian (MacRomanian)"),			LG_OTHER},
	{N_("South European (ISO-8859-3)"),		LG_OTHER},
	{N_("Thai (TIS-620)"),				LG_OTHER},
	{N_("Turkish (IBM-857)"),			LG_TURKISH},
	{N_("Turkish (ISO-8859-9)"),			LG_TURKISH},
	{N_("Turkish (MacTurkish)"),			LG_TURKISH},
	{N_("Turkish (Windows-1254)"),			LG_TURKISH},
	{N_("Unicode (UTF-7)"),				LG_UNICODE},
	{N_("Unicode (UTF-8)"),				LG_UNICODE},
	{N_("User Defined"),				LG_OTHER},
	{N_("Vietnamese (TCVN)"),			LG_VIETNAMESE},
	{N_("Vietnamese (VISCII)"),			LG_VIETNAMESE},
	{N_("Vietnamese (VPS)"),			LG_VIETNAMESE},
	{N_("Vietnamese (Windows-1258)"),		LG_VIETNAMESE},
	{N_("Visual Hebrew (ISO-8859-8)"),		LG_HEBREW},
	{N_("Western (IBM-850)"),			LG_WESTERN},
	{N_("Western (ISO-8859-1)"),			LG_WESTERN},
	{N_("Western (ISO-8859-15)"),			LG_WESTERN},
	{N_("Western (MacRoman)"),			LG_WESTERN},
	{N_("Western (Windows-1252)"),			LG_WESTERN},
	/* charsets whithout names in mozilla */
	{"T61.8bit",					LG_OTHER},
	{"UTF-16BE",					LG_UNICODE},
	{"UTF-16LE",					LG_UNICODE},
	{"UTF-32BE",					LG_UNICODE},
	{"UTF-32LE",					LG_UNICODE},
	{"x-imap4-modified-utf7",			LG_UNICODE},
	{"x-u-escaped",					LG_OTHER},
	{"windows-936",					LG_OTHER},
	/* these are left here for compatibilty with previous mozilla versions
	 * where there was no charset title for the given charset */
	{"x-mac-arabic",				LG_ARABIC},
	{"x-mac-hebrew",				LG_HEBREW},
	{"x-mac-devanagari",				LG_INDIAN},
	{"x-mac-gujarati",				LG_INDIAN},
	{"x-mac-gurmukhi",				LG_INDIAN},
	{"x-mac-farsi",					LG_OTHER}
};

const gchar *lang_encode_name[LANG_ENC_NUM] =
{
	N_("Western"),
	N_("Central European"),
	N_("Japanese"),
 	N_("Traditional Chinese"),
	N_("Simplified Chinese"),
	N_("Korean"),
	N_("Cyrillic"),
	N_("Baltic"),
	N_("Greek"),
	N_("Turkish"),
	N_("Unicode"),
	N_("User Defined"),
	N_("Thai"),
	N_("Hebrew"),
	N_("Arabic")
};

const gchar *lang_encode_item[LANG_ENC_NUM] =
{
	"x-western",
	"x-central-euro",
	"ja",
	"zh-TW",
	"zh-CN",
	"ko",
	"x-cyrillic",
	"x-baltic",
	"el",
	"tr",
	"x-unicode",
	"x-user-def",
	"th",
	"he",
	"ar"
};

gint
get_lgroups_count(void)
{
	return sizeof (lgroups) / sizeof ((lgroups)[0]);
}

gint
get_translated_cscount(void)
{
	return sizeof (charset_trans_array) / sizeof ((charset_trans_array)[0]);
}
