/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999, 2000, 2001  Pan Development Team <pan@rebelbase.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#ifndef __TASK__H__
#define __TASK__H__

#include <pthread.h>

#include <glib.h>

#include <pan/pan-callback.h>
#include <pan/server.h>
#include <pan/status-item.h>

#include <pan/sockets.h>

/**
***  TASK CLASS DEFINITION
**/

enum
{
	TASK_SUCCESS			=  0, /* done */
	TASK_FAIL			= -1, /* failed; retry */
	TASK_FAIL_HOPELESS		= -2  /* failed; don't retry */
};

#define TASK(a) ((Task*)a)
typedef struct _Task Task;
typedef int (*TaskRunFunc)(Task*);
struct _Task
{
	/* Parent Class */
	StatusItem parent;

	/* Public Fields */
	PanCallback * task_ran_callback;

	/* Private Fields */  
	guint gets_bodies        : 1;
	guint is_article_reader  : 1;
	guint high_priority      : 1;
	guint needs_socket       : 1;
	gint8 tries;
	gboolean hint_abort;
	Server * server;
	PanSocket * sock;
	pthread_t thread_id;

	/* virtual functions */
	TaskRunFunc run;
};

/**
***  PROTECTED
**/

void task_destructor      (PanObject                 * object);

void task_constructor     (Task                      * task,
                           PanObjectDestructor         dtor,
                           StatusItemDescribeFunc      describe,
                           TaskRunFunc                 run,
                           Server                    * server,
                           gboolean                    high_priority,
                           gboolean                    needs_socket);

/**
***  PUBLIC
**/

int          task_run                  (Task           * task);

void         task_hint_abort           (Task           * task);

#endif
