/*  This file is part of the KDE libraries
    Copyright (C) 2000 Malte Starostik <malte.starostik@t-online.de>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#ifndef _THUMBCREATOR_H_
#define _THUMBCREATOR_H_ "$Id: thumbcreator.h,v 1.2 2001/01/09 03:05:26 malte Exp $"

class QString;
class QPixmap;

class ThumbCreator
{
public:
    enum Flags { None = 0, DrawFrame = 1, BlendIcon = 2 };
    virtual bool create(const QString &path, int extent, QPixmap &pix) = 0;
    virtual Flags flags() const { return None; }

};

typedef ThumbCreator *(*newCreator)();

#endif
