/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIRefreshURI.idl
 */

#ifndef __gen_nsIRefreshURI_h__
#define __gen_nsIRefreshURI_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

#ifndef __gen_nsIURI_h__
#include "nsIURI.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
/**
 * Protocol writers can obtain a very basic (ok, degenerate) implementation
 * of nsIURI by calling the component manager with NS_SIMPLEURI_CID. The
 * implementation returned will only parse things of the form:
 *
 *    about:cache
 *    \   / \   /
 *     ---   ---
 *      |     |
 *   Scheme  Path
 *
 * where the path is everything after the colon. Note that this is probably 
 * only useful for cases like about: or javascript: URIs. 
 *
 * *** What you most likely will want is NS_STANDARDURL_CID which is much more 
 * full featured. Look at nsIURL.idl for more details.
 *
 * NOTE: CIDs are declared in nsNetCID.h
 */
class nsIChannel; /* forward declaration */


/* starting interface:    nsIRefreshURI */
#define NS_IREFRESHURI_IID_STR "69efc430-2efe-11d2-9e5d-006008bf092e"

#define NS_IREFRESHURI_IID \
  {0x69efc430, 0x2efe, 0x11d2, \
    { 0x9e, 0x5d, 0x00, 0x60, 0x08, 0xbf, 0x09, 0x2e }}

class NS_NO_VTABLE nsIRefreshURI : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IREFRESHURI_IID)

  /**
      * Reloads a uri after waiting millis milliseconds.
      *
      * @param uri The uri to refresh.
      * @param millis The number of milliseconds to wait.
      * @param repeat Do you want the uri to be repeatedly refreshed every millis milliseconds.
      * @param flag to check if this is for a META refresh
      */
  /* void refreshURI (in nsIURI aURI, in long aMillis, in boolean aRepeat, in boolean aMetaRefresh); */
  NS_IMETHOD RefreshURI(nsIURI *aURI, PRInt32 aMillis, PRBool aRepeat, PRBool aMetaRefresh) = 0;

  /**
      * Checks the passed in channel to see if there is a refresh header, if there is, 
      * will setup a refreahURI by calling refreshURI
      */
  /* void setupRefreshURI (in nsIChannel aChannel); */
  NS_IMETHOD SetupRefreshURI(nsIChannel *aChannel) = 0;

  /**
      * Parses the passed in header string and will call refreshURI with
      * the parsed values
      *
      * @param aBaseURI base URI to resolve refresh uri against
      * @param aHeader  The meta refresh header string
      */
  /* void refreshURIFromHeader (in nsIURI aBaseURI, in AString aHeader); */
  NS_IMETHOD RefreshURIFromHeader(nsIURI *aBaseURI, const nsAReadableString & aHeader) = 0;

  /**
      * Cancels all timer loads.
      */
  /* void cancelRefreshURITimers (); */
  NS_IMETHOD CancelRefreshURITimers(void) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIREFRESHURI \
  NS_IMETHOD RefreshURI(nsIURI *aURI, PRInt32 aMillis, PRBool aRepeat, PRBool aMetaRefresh); \
  NS_IMETHOD SetupRefreshURI(nsIChannel *aChannel); \
  NS_IMETHOD RefreshURIFromHeader(nsIURI *aBaseURI, const nsAReadableString & aHeader); \
  NS_IMETHOD CancelRefreshURITimers(void); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIREFRESHURI(_to) \
  NS_IMETHOD RefreshURI(nsIURI *aURI, PRInt32 aMillis, PRBool aRepeat, PRBool aMetaRefresh) { return _to ## RefreshURI(aURI, aMillis, aRepeat, aMetaRefresh); } \
  NS_IMETHOD SetupRefreshURI(nsIChannel *aChannel) { return _to ## SetupRefreshURI(aChannel); } \
  NS_IMETHOD RefreshURIFromHeader(nsIURI *aBaseURI, const nsAReadableString & aHeader) { return _to ## RefreshURIFromHeader(aBaseURI, aHeader); } \
  NS_IMETHOD CancelRefreshURITimers(void) { return _to ## CancelRefreshURITimers(); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIREFRESHURI(_to) \
  NS_IMETHOD RefreshURI(nsIURI *aURI, PRInt32 aMillis, PRBool aRepeat, PRBool aMetaRefresh) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> RefreshURI(aURI, aMillis, aRepeat, aMetaRefresh); } \
  NS_IMETHOD SetupRefreshURI(nsIChannel *aChannel) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> SetupRefreshURI(aChannel); } \
  NS_IMETHOD RefreshURIFromHeader(nsIURI *aBaseURI, const nsAReadableString & aHeader) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> RefreshURIFromHeader(aBaseURI, aHeader); } \
  NS_IMETHOD CancelRefreshURITimers(void) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> CancelRefreshURITimers(); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsRefreshURI : public nsIRefreshURI
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIREFRESHURI

  nsRefreshURI();
  virtual ~nsRefreshURI();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsRefreshURI, nsIRefreshURI)

nsRefreshURI::nsRefreshURI()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsRefreshURI::~nsRefreshURI()
{
  /* destructor code */
}

/* void refreshURI (in nsIURI aURI, in long aMillis, in boolean aRepeat, in boolean aMetaRefresh); */
NS_IMETHODIMP nsRefreshURI::RefreshURI(nsIURI *aURI, PRInt32 aMillis, PRBool aRepeat, PRBool aMetaRefresh)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setupRefreshURI (in nsIChannel aChannel); */
NS_IMETHODIMP nsRefreshURI::SetupRefreshURI(nsIChannel *aChannel)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void refreshURIFromHeader (in nsIURI aBaseURI, in AString aHeader); */
NS_IMETHODIMP nsRefreshURI::RefreshURIFromHeader(nsIURI *aBaseURI, const nsAReadableString & aHeader)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void cancelRefreshURITimers (); */
NS_IMETHODIMP nsRefreshURI::CancelRefreshURITimers()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIRefreshURI_h__ */
