/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIIOService.idl
 */

#ifndef __gen_nsIIOService_h__
#define __gen_nsIIOService_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIProtocolHandler; /* forward declaration */

class nsIChannel; /* forward declaration */

class nsIURI; /* forward declaration */


/* starting interface:    nsIIOService */
#define NS_IIOSERVICE_IID_STR "ab7c3a84-d488-11d3-8cda-0060b0fc14a3"

#define NS_IIOSERVICE_IID \
  {0xab7c3a84, 0xd488, 0x11d3, \
    { 0x8c, 0xda, 0x00, 0x60, 0xb0, 0xfc, 0x14, 0xa3 }}

class NS_NO_VTABLE nsIIOService : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IIOSERVICE_IID)

  /**
     * Returns a protocol handler for a given URI scheme.
	 *
	 * @param scheme	URI scheme
	 * @return	reference to nsIProtcolHandler
     */
  /* nsIProtocolHandler getProtocolHandler (in string scheme); */
  NS_IMETHOD GetProtocolHandler(const char *scheme, nsIProtocolHandler **_retval) = 0;

  /**
     * This method constructs a new URI by first determining the scheme
     * of the URI spec, and then delegating the construction of the URI
     * to the protocol handler for that scheme. QueryInterface can be used
     * on the resulting URI object to obtain a more specific type of URI.
	 *
	 * @param aSpec	URI spec (http, ftp, etc)
	 * @param aBaseURI	nsIURI to construct the actual URI from
	 * @return	reference to a new nsIURI object
     */
  /* nsIURI newURI (in string aSpec, in nsIURI aBaseURI); */
  NS_IMETHOD NewURI(const char *aSpec, nsIURI *aBaseURI, nsIURI **_retval) = 0;

  /**
     * Creates a channel for a given URI. The notificationCallbacks argument
     * is used to obtain the appropriate callbacks for the URI's protocol from the
     * application.
     *
     * @param originalURI - Specifies the original URI which caused the creation
     * of this channel. This can occur when the construction of one channel
     * (e.g. for resource:) causes another channel to be created on its behalf
     * (e.g. a file: channel), or if a redirect occurs, causing the current
     * URL to become different from the original URL. If NULL, the aURI parameter
     * will be used as the originalURI instead.
	 *
	 * @param aURI	- nsIURI to make a channel from
	 * @return	a reference to the new nsIChannel object
     */
  /* nsIChannel newChannelFromURI (in nsIURI aURI); */
  NS_IMETHOD NewChannelFromURI(nsIURI *aURI, nsIChannel **_retval) = 0;

  /**
     * Convenience routine that first creates a URI by calling NewURI, and
     * then passes the URI to NewChannelFromURI. 
     *
     * @param originalURI - Specifies the original URI which caused the creation
     * of this channel. This can occur when the construction of one channel
     * (e.g. for resource:) causes another channel to be created on its behalf
     * (e.g. a file: channel), or if a redirect occurs, causing the current
     * URL to become different from the original URL. If NULL, the aURI parameter
     * will be used as the originalURI instead.
	 *
	 * @param aSpec	URI spec to select the appropriate protocol handler
	 * @param aBaseURI	a base URI to create a channel to
	 * @return	a reference to the new nsIChannel object
     */
  /* nsIChannel newChannel (in string aSpec, in nsIURI aBaseURI); */
  NS_IMETHOD NewChannel(const char *aSpec, nsIURI *aBaseURI, nsIChannel **_retval) = 0;

  /**
     * Returns true if networking is in "offline" mode. When in offline mode, attempts
     * to access the network will fail (although this is not necessarily corrolated with
     * whether there is actually a network available -- that's hard to detect without
     * causing the dialer to come up).
     */
  /* attribute boolean offline; */
  NS_IMETHOD GetOffline(PRBool *aOffline) = 0;
  NS_IMETHOD SetOffline(PRBool aOffline) = 0;

  /**
     * Checks if a port number is banned.
     *
     * |allowPort| will check a list of "known-to-do-bad-things" port numbers.  If the 
     * given port is found on the blacklist, |allowPort| will ask the protocol handler
     * if it wishes to override. Scheme can be null. 
     */
  /* boolean allowPort (in long port, in string scheme); */
  NS_IMETHOD AllowPort(PRInt32 port, const char *scheme, PRBool *_retval) = 0;

  /**
     * Utility for protocol implementors -- extracts the scheme from a URL 
     * string, consistently and according to spec.
     * @param urlString - the URL string to parse
     * @param schemeStartPos - the resulting starting position of the scheme substring
     *        (may skip over whitespace)
     * @param schemeEndPos - the resulting ending position of the scheme substring
     *        (the position of the colon)
     * @param scheme - an allocated substring containing the scheme. If this parameter
     *        is null going into the routine, then the scheme is not allocated and
     *        returned. Free with nsCRT::free.
     *
     * @return NS_OK - if successful
     * @return NS_ERROR_MALFORMED_URI - if the urlString is not of the right form
     */
  /* void extractScheme (in string urlString, out unsigned long schemeStartPos, out unsigned long schemeEndPos, out string scheme); */
  NS_IMETHOD ExtractScheme(const char *urlString, PRUint32 *schemeStartPos, PRUint32 *schemeEndPos, char **scheme) = 0;

  /**
     * Constants for the mask in the call to Escape
     */
  enum { url_Scheme = 1 };

  enum { url_Username = 2 };

  enum { url_Password = 4 };

  enum { url_Host = 8 };

  enum { url_Directory = 16 };

  enum { url_FileBaseName = 32 };

  enum { url_FileExtension = 64 };

  enum { url_Param = 128 };

  enum { url_Query = 256 };

  enum { url_Ref = 512 };

  enum { url_Forced = 1024 };

  /**
     * Encode characters into % escaped hexcodes.
	 *
	 * @param	str	a string to convert from
	 * @param	mask	a mask of flags to tell the converter which part of the url to escape
	 * @return	escaped string
     */
  /* string escape (in string str, in short mask); */
  NS_IMETHOD Escape(const char *str, PRInt16 mask, char **_retval) = 0;

  /**
     * Decode % escaped hex codes into character values.
	 *
	 * @param str	a string to unescape from
	 * @return	resulted unescaped string
     */
  /* string unescape (in string str); */
  NS_IMETHOD Unescape(const char *str, char **_retval) = 0;

  /**
     * Get port from string.
	 *
	 * @param	str	URI-style string
	 * @return	port number
     */
  /* long extractPort (in string str); */
  NS_IMETHOD ExtractPort(const char *str, PRInt32 *_retval) = 0;

  /**
     * Resolves a relative path string containing "." and ".."
     * with respect to a base path (assumed to already be resolved). 
     * For example, resolving "../../foo/./bar/../baz.html" w.r.t.
     * "/a/b/c/d/e/" yields "/a/b/c/foo/baz.html". Attempting to 
     * ascend above the base results in the NS_ERROR_MALFORMED_URI
     * exception. If basePath is null, it treats it as "/".
	 *
	 * @param relativePath	a relative URI
	 * @param basePath	a base URI
	 * @return	a new string, representing canonical uri
     */
  /* string resolveRelativePath (in string relativePath, in string basePath); */
  NS_IMETHOD ResolveRelativePath(const char *relativePath, const char *basePath, char **_retval) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIIOSERVICE \
  NS_IMETHOD GetProtocolHandler(const char *scheme, nsIProtocolHandler **_retval); \
  NS_IMETHOD NewURI(const char *aSpec, nsIURI *aBaseURI, nsIURI **_retval); \
  NS_IMETHOD NewChannelFromURI(nsIURI *aURI, nsIChannel **_retval); \
  NS_IMETHOD NewChannel(const char *aSpec, nsIURI *aBaseURI, nsIChannel **_retval); \
  NS_IMETHOD GetOffline(PRBool *aOffline); \
  NS_IMETHOD SetOffline(PRBool aOffline); \
  NS_IMETHOD AllowPort(PRInt32 port, const char *scheme, PRBool *_retval); \
  NS_IMETHOD ExtractScheme(const char *urlString, PRUint32 *schemeStartPos, PRUint32 *schemeEndPos, char **scheme); \
  NS_IMETHOD Escape(const char *str, PRInt16 mask, char **_retval); \
  NS_IMETHOD Unescape(const char *str, char **_retval); \
  NS_IMETHOD ExtractPort(const char *str, PRInt32 *_retval); \
  NS_IMETHOD ResolveRelativePath(const char *relativePath, const char *basePath, char **_retval); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIIOSERVICE(_to) \
  NS_IMETHOD GetProtocolHandler(const char *scheme, nsIProtocolHandler **_retval) { return _to ## GetProtocolHandler(scheme, _retval); } \
  NS_IMETHOD NewURI(const char *aSpec, nsIURI *aBaseURI, nsIURI **_retval) { return _to ## NewURI(aSpec, aBaseURI, _retval); } \
  NS_IMETHOD NewChannelFromURI(nsIURI *aURI, nsIChannel **_retval) { return _to ## NewChannelFromURI(aURI, _retval); } \
  NS_IMETHOD NewChannel(const char *aSpec, nsIURI *aBaseURI, nsIChannel **_retval) { return _to ## NewChannel(aSpec, aBaseURI, _retval); } \
  NS_IMETHOD GetOffline(PRBool *aOffline) { return _to ## GetOffline(aOffline); } \
  NS_IMETHOD SetOffline(PRBool aOffline) { return _to ## SetOffline(aOffline); } \
  NS_IMETHOD AllowPort(PRInt32 port, const char *scheme, PRBool *_retval) { return _to ## AllowPort(port, scheme, _retval); } \
  NS_IMETHOD ExtractScheme(const char *urlString, PRUint32 *schemeStartPos, PRUint32 *schemeEndPos, char **scheme) { return _to ## ExtractScheme(urlString, schemeStartPos, schemeEndPos, scheme); } \
  NS_IMETHOD Escape(const char *str, PRInt16 mask, char **_retval) { return _to ## Escape(str, mask, _retval); } \
  NS_IMETHOD Unescape(const char *str, char **_retval) { return _to ## Unescape(str, _retval); } \
  NS_IMETHOD ExtractPort(const char *str, PRInt32 *_retval) { return _to ## ExtractPort(str, _retval); } \
  NS_IMETHOD ResolveRelativePath(const char *relativePath, const char *basePath, char **_retval) { return _to ## ResolveRelativePath(relativePath, basePath, _retval); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIIOSERVICE(_to) \
  NS_IMETHOD GetProtocolHandler(const char *scheme, nsIProtocolHandler **_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> GetProtocolHandler(scheme, _retval); } \
  NS_IMETHOD NewURI(const char *aSpec, nsIURI *aBaseURI, nsIURI **_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> NewURI(aSpec, aBaseURI, _retval); } \
  NS_IMETHOD NewChannelFromURI(nsIURI *aURI, nsIChannel **_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> NewChannelFromURI(aURI, _retval); } \
  NS_IMETHOD NewChannel(const char *aSpec, nsIURI *aBaseURI, nsIChannel **_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> NewChannel(aSpec, aBaseURI, _retval); } \
  NS_IMETHOD GetOffline(PRBool *aOffline) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetOffline(aOffline); } \
  NS_IMETHOD SetOffline(PRBool aOffline) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetOffline(aOffline); } \
  NS_IMETHOD AllowPort(PRInt32 port, const char *scheme, PRBool *_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> AllowPort(port, scheme, _retval); } \
  NS_IMETHOD ExtractScheme(const char *urlString, PRUint32 *schemeStartPos, PRUint32 *schemeEndPos, char **scheme) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> ExtractScheme(urlString, schemeStartPos, schemeEndPos, scheme); } \
  NS_IMETHOD Escape(const char *str, PRInt16 mask, char **_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Escape(str, mask, _retval); } \
  NS_IMETHOD Unescape(const char *str, char **_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Unescape(str, _retval); } \
  NS_IMETHOD ExtractPort(const char *str, PRInt32 *_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> ExtractPort(str, _retval); } \
  NS_IMETHOD ResolveRelativePath(const char *relativePath, const char *basePath, char **_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> ResolveRelativePath(relativePath, basePath, _retval); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsIOService : public nsIIOService
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIIOSERVICE

  nsIOService();
  virtual ~nsIOService();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsIOService, nsIIOService)

nsIOService::nsIOService()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsIOService::~nsIOService()
{
  /* destructor code */
}

/* nsIProtocolHandler getProtocolHandler (in string scheme); */
NS_IMETHODIMP nsIOService::GetProtocolHandler(const char *scheme, nsIProtocolHandler **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIURI newURI (in string aSpec, in nsIURI aBaseURI); */
NS_IMETHODIMP nsIOService::NewURI(const char *aSpec, nsIURI *aBaseURI, nsIURI **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIChannel newChannelFromURI (in nsIURI aURI); */
NS_IMETHODIMP nsIOService::NewChannelFromURI(nsIURI *aURI, nsIChannel **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIChannel newChannel (in string aSpec, in nsIURI aBaseURI); */
NS_IMETHODIMP nsIOService::NewChannel(const char *aSpec, nsIURI *aBaseURI, nsIChannel **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean offline; */
NS_IMETHODIMP nsIOService::GetOffline(PRBool *aOffline)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsIOService::SetOffline(PRBool aOffline)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean allowPort (in long port, in string scheme); */
NS_IMETHODIMP nsIOService::AllowPort(PRInt32 port, const char *scheme, PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void extractScheme (in string urlString, out unsigned long schemeStartPos, out unsigned long schemeEndPos, out string scheme); */
NS_IMETHODIMP nsIOService::ExtractScheme(const char *urlString, PRUint32 *schemeStartPos, PRUint32 *schemeEndPos, char **scheme)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* string escape (in string str, in short mask); */
NS_IMETHODIMP nsIOService::Escape(const char *str, PRInt16 mask, char **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* string unescape (in string str); */
NS_IMETHODIMP nsIOService::Unescape(const char *str, char **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* long extractPort (in string str); */
NS_IMETHODIMP nsIOService::ExtractPort(const char *str, PRInt32 *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* string resolveRelativePath (in string relativePath, in string basePath); */
NS_IMETHODIMP nsIOService::ResolveRelativePath(const char *relativePath, const char *basePath, char **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIIOService_h__ */
