#ifndef DIRENT_H
#define DIRENT_H

#include <sys/types.h>

#define MAXNAMLEN          512
#define DIRBUF             1048
#define NUMENT 1

struct dirent {
        u_long  d_ino;                  /* INODE number of the entry */
        off_t   d_off;                  /* Offset to the name field */
        u_short d_reclen;               /* Length of the current entry */
        char    d_name [1];             /* name entry */
};

typedef struct {
        int     dd_fd;                  /* File descriptor to the file */
        int     dd_loc;                 /* Current cursor value */
        int     dd_size;                /* Size of the buffer */
        char    *dd_buf;                /* Pointer to the buffer area */
} DIR;
#endif
