/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.usability;

import java.lang.ref.SoftReference;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import sun.plugin.resources.ResourceHandler;
import sun.plugin.usability.DialogFactory;
import sun.plugin.usability.TraceListener;
import sun.security.action.GetPropertyAction;

public class Trace {
    private static boolean bBasicTraceOn = false;
    private static boolean bExtTraceOn = false;
    private static boolean bSecurityTraceOn = false;
    private static boolean bNetTraceOn = false;
    private static boolean bLiveConnectTraceOn = false;
    private static boolean bAutomationOn = false;
    private static HashMap listeners;

    public static void reset() {
        String string = AccessController.doPrivileged(new GetPropertyAction("javaplugin.trace"));
        if (string != null && string.equalsIgnoreCase("true")) {
            String string2 = AccessController.doPrivileged(new GetPropertyAction("javaplugin.trace.option"));
            if (string2 == null) {
                bBasicTraceOn = true;
                bNetTraceOn = true;
                bSecurityTraceOn = true;
                bExtTraceOn = true;
                bLiveConnectTraceOn = true;
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    if (string3 == null || string3.equalsIgnoreCase("all")) {
                        bBasicTraceOn = true;
                        bNetTraceOn = true;
                        bSecurityTraceOn = true;
                        bExtTraceOn = true;
                        bLiveConnectTraceOn = true;
                        break;
                    }
                    if (string3.equalsIgnoreCase("basic")) {
                        bBasicTraceOn = true;
                        continue;
                    }
                    if (string3.equalsIgnoreCase("net")) {
                        bNetTraceOn = true;
                        continue;
                    }
                    if (string3.equalsIgnoreCase("security")) {
                        bSecurityTraceOn = true;
                        continue;
                    }
                    if (string3.equalsIgnoreCase("ext")) {
                        bExtTraceOn = true;
                        continue;
                    }
                    if (!string3.equalsIgnoreCase("liveconnect")) continue;
                    bLiveConnectTraceOn = true;
                }
            }
        }
    }

    public static boolean isEnabled() {
        return bBasicTraceOn || bNetTraceOn || bSecurityTraceOn || bExtTraceOn || bLiveConnectTraceOn;
    }

    public static void setBasicTrace(boolean bl) {
        bBasicTraceOn = bl;
    }

    public static void setNetTrace(boolean bl) {
        bNetTraceOn = bl;
    }

    public static void setSecurityTrace(boolean bl) {
        bSecurityTraceOn = bl;
    }

    public static void setExtTrace(boolean bl) {
        bExtTraceOn = bl;
    }

    public static void setLiveConnectTrace(boolean bl) {
        bLiveConnectTraceOn = bl;
    }

    public static boolean isAutomationEnabled() {
        return bAutomationOn;
    }

    public static void println(String string) {
        Trace.println(string, null);
    }

    public static void println(String string, int n) {
        Trace.println(string, null, n);
    }

    public static void println(String string, TraceListener traceListener) {
        Trace.println(string, traceListener, 6);
    }

    public static void println(String string, TraceListener traceListener, int n) {
        if (bBasicTraceOn && (n & 2) == 2) {
            System.err.println(string);
            System.err.flush();
        }
        Trace.firePrintlnEvent(string, traceListener, n);
    }

    public static void printException(Throwable throwable) {
        throwable.printStackTrace();
        if (!Trace.isAutomationEnabled()) {
            Object[] objectArray = new Object[]{ResourceHandler.getMessage("usability.general_error"), throwable};
            DialogFactory.showExceptionDialog(objectArray, null);
        }
    }

    public static void printException(Throwable throwable, String string, String string2) {
        throwable.printStackTrace();
        if (!Trace.isAutomationEnabled()) {
            Object[] objectArray = new Object[]{string, throwable};
            DialogFactory.showExceptionDialog(objectArray, string2);
        }
    }

    public static void netPrintln(String string) {
        Trace.netPrintln(string, 6);
    }

    public static void netPrintln(String string, int n) {
        if (bNetTraceOn && (n & 2) == 2) {
            System.err.println(string);
            System.err.flush();
        }
        Trace.firePrintlnEvent(string, null, n);
    }

    public static void netPrintException(Throwable throwable) {
        throwable.printStackTrace();
        if (!Trace.isAutomationEnabled()) {
            Object[] objectArray = new Object[]{ResourceHandler.getMessage("usability.net_error"), throwable};
        }
    }

    public static void netPrintException(Throwable throwable, String string, String string2) {
        throwable.printStackTrace();
        Object[] objectArray = new Object[]{string, throwable};
    }

    public static void securityPrintln(String string) {
        Trace.securityPrintln(string, 6);
    }

    public static void securityPrintln(String string, int n) {
        if (bSecurityTraceOn && (n & 2) == 2) {
            System.err.println(string);
            System.err.flush();
        }
        Trace.firePrintlnEvent(string, null, n);
    }

    public static void securityPrintException(Throwable throwable) {
        throwable.printStackTrace();
        if (!Trace.isAutomationEnabled()) {
            Object[] objectArray = new Object[]{ResourceHandler.getMessage("usability.security_error"), throwable};
            DialogFactory.showExceptionDialog(objectArray, null);
        }
    }

    public static void securityPrintException(Throwable throwable, String string, String string2) {
        throwable.printStackTrace();
        if (!Trace.isAutomationEnabled()) {
            Object[] objectArray = new Object[]{string, throwable};
            DialogFactory.showExceptionDialog(objectArray, string2);
        }
    }

    public static void extPrintln(String string) {
        Trace.extPrintln(string, 6);
    }

    public static void extPrintln(String string, int n) {
        if (bExtTraceOn && (n & 2) == 2) {
            System.err.println(string);
            System.err.flush();
        }
        Trace.firePrintlnEvent(string, null, n);
    }

    public static void extPrintException(Throwable throwable) {
        throwable.printStackTrace();
        if (!Trace.isAutomationEnabled()) {
            Object[] objectArray = new Object[]{ResourceHandler.getMessage("usability.ext_error"), throwable};
            DialogFactory.showExceptionDialog(objectArray, null);
        }
    }

    public static void extPrintException(Throwable throwable, String string, String string2) {
        throwable.printStackTrace();
        if (!Trace.isAutomationEnabled()) {
            Object[] objectArray = new Object[]{string, throwable};
            DialogFactory.showExceptionDialog(objectArray, string2);
        }
    }

    public static void liveConnectPrintln(String string) {
        Trace.liveConnectPrintln(string, 2);
    }

    public static void liveConnectPrintln(String string, int n) {
        if (bLiveConnectTraceOn && (n & 2) == 2) {
            System.err.println(string);
            System.err.flush();
        }
        Trace.firePrintlnEvent(string, null, n);
    }

    public static void liveConnectPrintException(Throwable throwable) {
        throwable.printStackTrace();
    }

    public static void addTraceListener(ThreadGroup threadGroup, TraceListener traceListener) {
        Trace.println("Added trace listener: " + traceListener, 2);
        listeners.put(threadGroup.toString(), new SoftReference<TraceListener>(traceListener));
    }

    public static void removeTraceListener(ThreadGroup threadGroup, TraceListener traceListener) {
        Trace.println("Removed trace listener: " + traceListener, 2);
        listeners.remove(threadGroup.toString());
    }

    private static void firePrintlnEvent(String string, TraceListener traceListener, int n) {
        if (traceListener != null) {
            traceListener.println(string, n);
        } else {
            HashMap hashMap = listeners;
            synchronized (hashMap) {
                Set set = listeners.keySet();
                Iterator iterator = set.iterator();
                Thread thread = Thread.currentThread();
                ThreadGroup threadGroup = thread.getThreadGroup();
                while (iterator.hasNext()) {
                    Object k = iterator.next();
                    if (!k.equals(threadGroup.toString())) continue;
                    SoftReference softReference = (SoftReference)listeners.get(k);
                    Object var10_10 = null;
                    if (softReference != null) {
                        var10_10 = softReference.get();
                    }
                    if (var10_10 == null) continue;
                    TraceListener traceListener2 = var10_10;
                    traceListener2.println(string, n);
                }
            }
        }
    }

    static {
        Trace.reset();
        String string = AccessController.doPrivileged(new GetPropertyAction("javaplugin.automation"));
        if (string != null && string.equalsIgnoreCase("true")) {
            bAutomationOn = true;
        }
        listeners = new HashMap();
    }
}

