/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.im.spi.InputMethod;
import java.awt.im.spi.InputMethodDescriptor;
import java.security.AccessController;
import java.util.Locale;
import sun.awt.motif.X11InputMethod;
import sun.security.action.GetPropertyAction;

class X11InputMethodDescriptor
implements InputMethodDescriptor {
    private static Locale locale;

    X11InputMethodDescriptor() {
        locale = X11InputMethodDescriptor.getSupportedLocale();
    }

    public Locale[] getAvailableLocales() {
        Locale[] localeArray = new Locale[]{locale};
        return localeArray;
    }

    public boolean hasDynamicLocaleList() {
        return false;
    }

    public synchronized String getInputMethodDisplayName(Locale locale, Locale locale2) {
        String string = "System Input Methods";
        if (Locale.getDefault().equals(locale2)) {
            string = Toolkit.getProperty("AWT.HostInputMethodDisplayName", string);
        }
        return string;
    }

    public Image getInputMethodIcon(Locale locale) {
        return null;
    }

    public InputMethod createInputMethod() throws Exception {
        return new X11InputMethod();
    }

    static Locale getSupportedLocale() {
        if (locale == null) {
            String string = (String)AccessController.doPrivileged(new GetPropertyAction("user.language", "en"));
            String string2 = (String)AccessController.doPrivileged(new GetPropertyAction("user.region", ""));
            String string3 = "";
            int n = string2.indexOf(95);
            if (n >= 0) {
                string3 = string2.substring(n + 1);
                string2 = string2.substring(0, n);
            }
            locale = new Locale(string, string2, string3);
        }
        return locale;
    }
}

