/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.midi;

import java.util.Vector;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Patch;
import javax.sound.midi.Track;

public class Sequence {
    public static final float PPQ = 0.0f;
    public static final float SMPTE_24 = 24.0f;
    public static final float SMPTE_25 = 25.0f;
    public static final float SMPTE_30DROP = 29.97f;
    public static final float SMPTE_30 = 30.0f;
    protected float divisionType;
    protected int resolution;
    protected Vector tracks = new Vector();

    public Sequence(float f, int n) throws InvalidMidiDataException {
        if (f == 0.0f) {
            this.divisionType = 0.0f;
        } else if (f == 24.0f) {
            this.divisionType = 24.0f;
        } else if (f == 25.0f) {
            this.divisionType = 25.0f;
        } else if (f == 29.97f) {
            this.divisionType = 29.97f;
        } else if (f == 30.0f) {
            this.divisionType = 30.0f;
        } else {
            throw new InvalidMidiDataException("Unsupported division type: " + f);
        }
        this.resolution = n;
    }

    public Sequence(float f, int n, int n2) throws InvalidMidiDataException {
        if (f == 0.0f) {
            this.divisionType = 0.0f;
        } else if (f == 24.0f) {
            this.divisionType = 24.0f;
        } else if (f == 25.0f) {
            this.divisionType = 25.0f;
        } else if (f == 29.97f) {
            this.divisionType = 29.97f;
        } else if (f == 30.0f) {
            this.divisionType = 30.0f;
        } else {
            throw new InvalidMidiDataException("Unsupported division type: " + f);
        }
        this.resolution = n;
        int n3 = 0;
        while (n3 < n2) {
            this.tracks.addElement(new Track());
            ++n3;
        }
    }

    public float getDivisionType() {
        return this.divisionType;
    }

    public int getResolution() {
        return this.resolution;
    }

    public Track createTrack() {
        Track track = new Track();
        this.tracks.addElement(track);
        return track;
    }

    public boolean deleteTrack(Track track) {
        Vector vector = this.tracks;
        synchronized (vector) {
            boolean bl = this.tracks.removeElement(track);
            return bl;
        }
    }

    public Track[] getTracks() {
        Vector vector = this.tracks;
        synchronized (vector) {
            Track[] trackArray = new Track[this.tracks.size()];
            int n = 0;
            while (n < trackArray.length) {
                trackArray[n] = (Track)this.tracks.elementAt(n);
                ++n;
            }
            Track[] trackArray2 = trackArray;
            return trackArray2;
        }
    }

    public long getMicrosecondLength() {
        int n;
        long l = this.getTickLength();
        if (this.divisionType != 0.0f) {
            double d = (double)this.getTickLength() / (double)(this.divisionType * (float)this.resolution);
            return (long)(1.0E9 * d);
        }
        Track track = new Track();
        Track track2 = null;
        MidiEvent midiEvent = null;
        MidiMessage midiMessage = null;
        Object var9_7 = null;
        Vector vector = this.tracks;
        synchronized (vector) {
            n = 0;
            while (n < this.tracks.size()) {
                track2 = (Track)this.tracks.elementAt(n);
                int n2 = 0;
                while (n2 < track2.size()) {
                    midiEvent = track2.get(n2);
                    midiMessage = midiEvent.getMessage();
                    if (midiMessage instanceof MetaMessage && ((MetaMessage)midiMessage).getType() == 81) {
                        track.add(midiEvent);
                    }
                    ++n2;
                }
                ++n;
            }
        }
        n = 500000;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        int n3 = 0;
        while (n3 < track.size() - 1) {
            midiEvent = track.get(n3);
            l4 = midiEvent.getTick();
            if (l4 >= l3) {
                l2 += (l4 - l3) * (long)n / (long)this.resolution;
                l3 = l4;
                byte[] byArray = ((MetaMessage)midiEvent.getMessage()).getMessage();
                n = 0xFF & byArray[5];
                n |= (0xFF & byArray[4]) << 8;
                n |= (0xFF & byArray[3]) << 16;
            }
            ++n3;
        }
        l4 = this.getTickLength();
        if (l4 > l3) {
            l2 += (l4 - l3) * (long)n / (long)this.resolution;
        }
        return l2;
    }

    public long getTickLength() {
        long l = 0L;
        Vector vector = this.tracks;
        synchronized (vector) {
            long l2;
            int n = 0;
            while (n < this.tracks.size()) {
                l2 = ((Track)this.tracks.elementAt(n)).ticks();
                if (l2 > l) {
                    l = l2;
                }
                ++n;
            }
            l2 = l;
            return l2;
        }
    }

    public Patch[] getPatchList() {
        return new Patch[0];
    }
}

