/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.ByteArrayOutputStream;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ProtocolException;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketInputStream;
import java.net.SocketOutputStream;
import java.net.UnknownHostException;
import java.security.AccessController;
import sun.security.action.GetPropertyAction;
import sun.security.action.LoadLibraryAction;

class PlainSocketImpl
extends SocketImpl {
    static int preferredConnectionTimeout = 0;
    int timeout;
    private static final int SOCKS_PROTO_VERS = 4;
    private static final int SOCKS_REPLY_VERS = 4;
    private static final int COMMAND_CONNECT = 1;
    private static final int COMMAND_BIND = 2;
    private static final int REQUEST_GRANTED = 90;
    private static final int REQUEST_REJECTED = 91;
    private static final int REQUEST_REJECTED_NO_IDENTD = 92;
    private static final int REQUEST_REJECTED_DIFF_IDENTS = 93;
    public static final String socksServerProp = "socksProxyHost";
    public static final String socksPortProp = "socksProxyPort";
    public static final String socksDefaultPortStr = "1080";
    private boolean shut_rd = false;
    private boolean shut_wr = false;
    private SocketInputStream socketInputStream = null;
    public static final int SHUT_RD = 0;
    public static final int SHUT_WR = 1;

    PlainSocketImpl() {
    }

    protected synchronized void create(boolean bl) throws IOException {
        this.fd = new FileDescriptor();
        this.socketCreate(bl);
    }

    protected void connect(String string, int n) throws UnknownHostException, IOException {
        IOException iOException = null;
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            try {
                this.connectToAddress(inetAddress, n);
                return;
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
        }
        catch (UnknownHostException unknownHostException) {
            iOException = unknownHostException;
        }
        this.close();
        throw iOException;
    }

    protected void connect(InetAddress inetAddress, int n) throws IOException {
        this.port = n;
        this.address = inetAddress;
        try {
            this.connectToAddress(inetAddress, n);
            return;
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
    }

    private void connectToAddress(InetAddress inetAddress, int n) throws IOException {
        if (this.usingSocks()) {
            this.doSOCKSConnect(inetAddress, n);
        } else {
            this.doConnect(inetAddress, n);
        }
    }

    public void setOption(int n, Object object) throws SocketException {
        boolean bl = true;
        switch (n) {
            case 128: {
                if (object == null || !(object instanceof Integer) && !(object instanceof Boolean)) {
                    throw new SocketException("Bad parameter for option");
                }
                if (!(object instanceof Boolean)) break;
                bl = false;
                break;
            }
            case 4102: {
                if (object == null || !(object instanceof Integer)) {
                    throw new SocketException("Bad parameter for SO_TIMEOUT");
                }
                int n2 = (Integer)object;
                if (n2 < 0) {
                    throw new IllegalArgumentException("timeout < 0");
                }
                this.timeout = n2;
                return;
            }
            case 15: {
                throw new SocketException("Cannot re-bind socket");
            }
            case 1: {
                if (object == null || !(object instanceof Boolean)) {
                    throw new SocketException("bad parameter for TCP_NODELAY");
                }
                bl = (Boolean)object;
                break;
            }
            case 4097: 
            case 4098: {
                if (object != null && object instanceof Integer && (Integer)object > 0) break;
                throw new SocketException("bad parameter for SO_SNDBUF or SO_RCVBUF");
            }
            case 8: {
                if (object == null || !(object instanceof Boolean)) {
                    throw new SocketException("bad parameter for SO_KEEPALIVE");
                }
                bl = (Boolean)object;
                break;
            }
            default: {
                throw new SocketException("unrecognized TCP option: " + n);
            }
        }
        this.socketSetOption(n, bl, object);
    }

    public Object getOption(int n) throws SocketException {
        if (n == 4102) {
            return new Integer(this.timeout);
        }
        int n2 = this.socketGetOption(n);
        switch (n) {
            case 1: {
                return n2 == -1 ? new Boolean(false) : new Boolean(true);
            }
            case 128: {
                return n2 == -1 ? (Serializable)new Boolean(false) : (Serializable)new Integer(n2);
            }
            case 15: {
                InetAddress inetAddress = new InetAddress();
                inetAddress.address = n2;
                return inetAddress;
            }
            case 4097: 
            case 4098: {
                return new Integer(n2);
            }
            case 8: {
                return n2 == -1 ? new Boolean(false) : new Boolean(true);
            }
        }
        return null;
    }

    private void doSOCKSConnect(InetAddress inetAddress, int n) throws IOException {
        this.connectToSocksServer();
        this.sendSOCKSCommandPacket(1, inetAddress, n);
        int n2 = this.getSOCKSReply();
        switch (n2) {
            case 90: {
                return;
            }
            case 91: 
            case 92: {
                throw new SocketException("SOCKS server cannot connect to identd");
            }
            case 93: {
                throw new SocketException("User name does not match identd name");
            }
        }
    }

    private int getSOCKSReply() throws IOException {
        InputStream inputStream = this.getInputStream();
        byte[] byArray = new byte[8];
        int n = 0;
        int n2 = byArray.length;
        int n3 = 0;
        while (n < n2 && n3 < 3) {
            int n4 = inputStream.read(byArray, n, n2 - n);
            if (n4 < 0) {
                throw new SocketException("Malformed reply from SOCKS server");
            }
            n += n4;
            ++n3;
        }
        if (n != n2) {
            throw new SocketException("Reply from SOCKS server has bad length: " + n);
        }
        if (byArray[0] != 0) {
            throw new SocketException("Reply from SOCKS server has bad version " + byArray[0]);
        }
        return byArray[1];
    }

    private void connectToSocksServer() throws IOException {
        int n;
        String string = null;
        String string2 = null;
        string = (String)AccessController.doPrivileged(new GetPropertyAction(socksServerProp));
        string2 = (String)AccessController.doPrivileged(new GetPropertyAction(socksPortProp, socksDefaultPortStr));
        if (string == null) {
            return;
        }
        InetAddress inetAddress = InetAddress.getByName(string);
        try {
            n = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            throw new SocketException("Bad port number format");
        }
        this.doConnect(inetAddress, n);
    }

    private void doConnect(InetAddress inetAddress, int n) throws IOException {
        ProtocolException protocolException = null;
        int n2 = 0;
        while (n2 < 3) {
            try {
                this.socketConnect(inetAddress, n);
                return;
            }
            catch (ProtocolException protocolException2) {
                this.close();
                this.fd = new FileDescriptor();
                this.socketCreate(true);
                protocolException = protocolException2;
            }
            catch (IOException iOException) {
                this.close();
                throw iOException;
            }
            ++n2;
        }
        this.close();
        throw protocolException;
    }

    private void sendSOCKSCommandPacket(int n, InetAddress inetAddress, int n2) throws IOException {
        byte[] byArray = this.makeCommandPacket(n, inetAddress, n2);
        OutputStream outputStream = this.getOutputStream();
        outputStream.write(byArray);
    }

    private byte[] makeCommandPacket(int n, InetAddress inetAddress, int n2) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(9);
        byteArrayOutputStream.write(4);
        byteArrayOutputStream.write(n);
        byteArrayOutputStream.write(n2 >> 8 & 0xFF);
        byteArrayOutputStream.write(n2 >> 0 & 0xFF);
        byte[] byArray = inetAddress.getAddress();
        byteArrayOutputStream.write(byArray, 0, byArray.length);
        String string = (String)AccessController.doPrivileged(new GetPropertyAction("user.name"));
        byte[] byArray2 = new byte[string.length()];
        string.getBytes(0, string.length(), byArray2, 0);
        byteArrayOutputStream.write(byArray2, 0, byArray2.length);
        byteArrayOutputStream.write(0);
        return byteArrayOutputStream.toByteArray();
    }

    private boolean usingSocks() {
        String string = (String)AccessController.doPrivileged(new GetPropertyAction(socksServerProp));
        return string != null;
    }

    protected synchronized void bind(InetAddress inetAddress, int n) throws IOException {
        this.socketBind(inetAddress, n);
    }

    protected synchronized void listen(int n) throws IOException {
        this.socketListen(n);
    }

    protected synchronized void accept(SocketImpl socketImpl) throws IOException {
        this.socketAccept(socketImpl);
    }

    protected synchronized InputStream getInputStream() throws IOException {
        if (this.fd == null) {
            throw new IOException("Socket Closed");
        }
        if (this.shut_rd) {
            throw new IOException("Socket input is shutdown");
        }
        if (this.socketInputStream == null) {
            this.socketInputStream = new SocketInputStream(this);
        }
        return this.socketInputStream;
    }

    protected synchronized OutputStream getOutputStream() throws IOException {
        if (this.fd == null) {
            throw new IOException("Socket Closed");
        }
        if (this.shut_wr) {
            throw new IOException("Socket output is shutdown");
        }
        return new SocketOutputStream(this);
    }

    protected synchronized int available() throws IOException {
        if (this.fd == null) {
            throw new IOException("Stream closed.");
        }
        return this.socketAvailable();
    }

    protected void close() throws IOException {
        if (this.fd != null) {
            this.socketClose();
            this.fd = null;
        }
    }

    protected void shutdownInput() throws IOException {
        if (this.fd != null) {
            this.socketShutdown(0);
            if (this.socketInputStream != null) {
                this.socketInputStream.setEOF(true);
            }
            this.shut_rd = true;
        }
    }

    protected void shutdownOutput() throws IOException {
        if (this.fd != null) {
            this.socketShutdown(1);
            this.shut_wr = true;
        }
    }

    protected void finalize() throws IOException {
        this.close();
    }

    private native void socketCreate(boolean var1) throws IOException;

    private native void socketConnect(InetAddress var1, int var2) throws IOException;

    private native void socketBind(InetAddress var1, int var2) throws IOException;

    private native void socketListen(int var1) throws IOException;

    private native void socketAccept(SocketImpl var1) throws IOException;

    private native int socketAvailable() throws IOException;

    private native void socketClose() throws IOException;

    private native void socketShutdown(int var1) throws IOException;

    private static native void initProto();

    private native void socketSetOption(int var1, boolean var2, Object var3) throws SocketException;

    private native int socketGetOption(int var1) throws SocketException;

    static {
        AccessController.doPrivileged(new LoadLibraryAction("net"));
        String string = (String)AccessController.doPrivileged(new GetPropertyAction("java.net.connectiontimeout"));
        if (string != null) {
            preferredConnectionTimeout = Integer.parseInt(string);
        }
        PlainSocketImpl.initProto();
    }
}

