/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import sun.misc.CompoundEnumeration;
import sun.misc.Launcher;
import sun.misc.Resource;
import sun.misc.URLClassPath;

public abstract class ClassLoader {
    private boolean initialized = false;
    private ClassLoader parent;
    private Hashtable package2certs = new Hashtable(11);
    Certificate[] nocerts;
    private Vector classes = new Vector();
    private Set domains = new HashSet();
    private HashMap packages = new HashMap();
    private static URLClassPath bootstrapClassPath;
    private static ClassLoader scl;
    private static boolean sclSet;
    private static RuntimePermission getClassLoaderPerm;
    private ProtectionDomain defaultDomain = null;
    private static PermissionCollection defaultPermissions;
    private static Vector loadedLibraryNames;
    private static Vector systemNativeLibraries;
    private Vector nativeLibraries = new Vector();
    private static Stack nativeLibraryContext;
    private static String[] usr_paths;
    private static String[] sys_paths;
    static /* synthetic */ Class class$java$lang$ClassLoader;

    void addClass(Class clazz) {
        this.classes.addElement(clazz);
    }

    protected ClassLoader(ClassLoader classLoader) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        this.parent = classLoader;
        this.initialized = true;
    }

    protected ClassLoader() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        this.parent = ClassLoader.getSystemClassLoader();
        this.initialized = true;
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        return this.loadClass(string, false);
    }

    protected synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class clazz = this.findLoadedClass(string);
        if (clazz == null) {
            try {
                clazz = this.parent != null ? this.parent.loadClass(string, false) : this.findBootstrapClass0(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = this.findClass(string);
            }
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    private synchronized Class loadClassInternal(String string) throws ClassNotFoundException {
        return this.loadClass(string);
    }

    private void checkPackageAccess(Class clazz, ProtectionDomain protectionDomain) {
        String string;
        int n;
        final SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (n = (string = clazz.getName()).lastIndexOf(46)) != -1) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    securityManager.checkPackageAccess(string.substring(0, n));
                    return null;
                }
            }, new AccessControlContext(new ProtectionDomain[]{protectionDomain}));
        }
        this.domains.add(protectionDomain);
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        throw new ClassNotFoundException(string);
    }

    protected final Class defineClass(byte[] byArray, int n, int n2) throws ClassFormatError {
        return this.defineClass(null, byArray, n, n2, null);
    }

    protected final Class defineClass(String string, byte[] byArray, int n, int n2) throws ClassFormatError {
        return this.defineClass(string, byArray, n, n2, null);
    }

    protected final Class defineClass(String string, byte[] byArray, int n, int n2, ProtectionDomain protectionDomain) throws ClassFormatError {
        Object[] objectArray;
        this.check();
        if (string != null && string.startsWith("java.")) {
            throw new SecurityException("Prohibited package name: " + string.substring(0, string.lastIndexOf(46)));
        }
        if (protectionDomain == null) {
            protectionDomain = this.getDefaultDomain();
        }
        if (string != null) {
            this.checkCerts(string, protectionDomain.getCodeSource());
        }
        Class clazz = this.defineClass0(string, byArray, n, n2, protectionDomain);
        if (protectionDomain.getCodeSource() != null && (objectArray = protectionDomain.getCodeSource().getCertificates()) != null) {
            this.setSigners(clazz, objectArray);
        }
        return clazz;
    }

    private synchronized void checkCerts(String string, CodeSource codeSource) {
        int n = string.lastIndexOf(46);
        String string2 = n == -1 ? "" : string.substring(0, n);
        Certificate[] certificateArray = (Certificate[])this.package2certs.get(string2);
        if (certificateArray == null) {
            if (codeSource != null) {
                certificateArray = codeSource.getCertificates();
            }
            if (certificateArray == null) {
                if (this.nocerts == null) {
                    this.nocerts = new Certificate[0];
                }
                certificateArray = this.nocerts;
            }
            this.package2certs.put(string2, certificateArray);
        } else {
            Certificate[] certificateArray2 = null;
            if (codeSource != null) {
                certificateArray2 = codeSource.getCertificates();
            }
            if (!this.compareCerts(certificateArray, certificateArray2)) {
                throw new SecurityException("class \"" + string + "\"'s signer information does not match signer information of other classes in the same package");
            }
        }
    }

    private boolean compareCerts(Certificate[] certificateArray, Certificate[] certificateArray2) {
        int n;
        boolean bl;
        if (certificateArray2 == null || certificateArray2.length == 0) {
            return certificateArray.length == 0;
        }
        if (certificateArray2.length != certificateArray.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < certificateArray2.length) {
            bl = false;
            n = 0;
            while (n < certificateArray.length) {
                if (certificateArray2[n2].equals(certificateArray[n])) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                return false;
            }
            ++n2;
        }
        n = 0;
        while (n < certificateArray.length) {
            bl = false;
            int n3 = 0;
            while (n3 < certificateArray2.length) {
                if (certificateArray[n].equals(certificateArray2[n3])) {
                    bl = true;
                    break;
                }
                ++n3;
            }
            if (!bl) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected final void resolveClass(Class clazz) {
        this.check();
        this.resolveClass0(clazz);
    }

    protected final Class findSystemClass(String string) throws ClassNotFoundException {
        this.check();
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        if (classLoader == null) {
            return this.findBootstrapClass(string);
        }
        return classLoader.loadClass(string);
    }

    public final ClassLoader getParent() {
        ClassLoader classLoader;
        if (this.parent == null) {
            return null;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (classLoader = ClassLoader.getCallerClassLoader()) != null && !this.isAncestor(classLoader)) {
            securityManager.checkPermission(ClassLoader.getGetClassLoaderPerm());
        }
        return this.parent;
    }

    protected final void setSigners(Class clazz, Object[] objectArray) {
        this.check();
        clazz.setSigners(objectArray);
    }

    private Class findBootstrapClass0(String string) throws ClassNotFoundException {
        this.check();
        return this.findBootstrapClass(string);
    }

    private native Class defineClass0(String var1, byte[] var2, int var3, int var4, ProtectionDomain var5);

    private native void resolveClass0(Class var1);

    private native Class findBootstrapClass(String var1) throws ClassNotFoundException;

    private void check() {
        if (!this.initialized) {
            throw new SecurityException("ClassLoader object not initialized");
        }
    }

    protected final native Class findLoadedClass(String var1);

    public URL getResource(String string) {
        URL uRL = this.parent != null ? this.parent.getResource(string) : ClassLoader.getBootstrapResource(string);
        if (uRL == null) {
            uRL = this.findResource(string);
        }
        return uRL;
    }

    public final Enumeration getResources(String string) throws IOException {
        Enumeration[] enumerationArray = new Enumeration[]{this.parent != null ? this.parent.getResources(string) : ClassLoader.getBootstrapResources(string), this.findResources(string)};
        return new CompoundEnumeration(enumerationArray);
    }

    protected Enumeration findResources(String string) throws IOException {
        return new CompoundEnumeration(new Enumeration[0]);
    }

    protected URL findResource(String string) {
        return null;
    }

    public static URL getSystemResource(String string) {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        if (classLoader == null) {
            return ClassLoader.getBootstrapResource(string);
        }
        return classLoader.getResource(string);
    }

    private static URL getBootstrapResource(String string) {
        URLClassPath uRLClassPath = ClassLoader.getBootstrapClassPath();
        Resource resource = uRLClassPath.getResource(string);
        return resource != null ? resource.getURL() : null;
    }

    public static Enumeration getSystemResources(String string) throws IOException {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        if (classLoader == null) {
            return ClassLoader.getBootstrapResources(string);
        }
        return classLoader.getResources(string);
    }

    private static Enumeration getBootstrapResources(String string) throws IOException {
        final Enumeration enumeration = ClassLoader.getBootstrapClassPath().getResources(string);
        return new Enumeration(){

            public Object nextElement() {
                return ((Resource)enumeration.nextElement()).getURL();
            }

            public boolean hasMoreElements() {
                return enumeration.hasMoreElements();
            }
        };
    }

    static URLClassPath getBootstrapClassPath() {
        if (bootstrapClassPath == null) {
            bootstrapClassPath = Launcher.getBootstrapClassPath();
        }
        return bootstrapClassPath;
    }

    public InputStream getResourceAsStream(String string) {
        URL uRL = this.getResource(string);
        try {
            return uRL != null ? uRL.openStream() : null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static InputStream getSystemResourceAsStream(String string) {
        URL uRL = ClassLoader.getSystemResource(string);
        try {
            return uRL != null ? uRL.openStream() : null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static ClassLoader getSystemClassLoader() {
        ClassLoader classLoader;
        Object object;
        if (!sclSet) {
            object = Launcher.getLauncher();
            if (object != null) {
                scl = ((Launcher)object).getClassLoader();
            }
            sclSet = true;
        }
        if (scl == null) {
            return null;
        }
        object = System.getSecurityManager();
        if (object != null && (classLoader = ClassLoader.getCallerClassLoader()) != null && classLoader != scl && !scl.isAncestor(classLoader)) {
            ((SecurityManager)object).checkPermission(ClassLoader.getGetClassLoaderPerm());
        }
        return scl;
    }

    boolean isAncestor(ClassLoader classLoader) {
        ClassLoader classLoader2 = this;
        do {
            if (classLoader != (classLoader2 = classLoader2.parent)) continue;
            return true;
        } while (classLoader2 != null);
        return false;
    }

    static native ClassLoader getCallerClassLoader();

    static RuntimePermission getGetClassLoaderPerm() {
        if (getClassLoaderPerm == null) {
            getClassLoaderPerm = new RuntimePermission("getClassLoader");
        }
        return getClassLoaderPerm;
    }

    protected Package definePackage(String string, String string2, String string3, String string4, String string5, String string6, String string7, URL uRL) throws IllegalArgumentException {
        HashMap hashMap = this.packages;
        synchronized (hashMap) {
            Package package_ = this.getPackage(string);
            if (package_ != null) {
                throw new IllegalArgumentException(string);
            }
            package_ = new Package(string, string2, string3, string4, string5, string6, string7, uRL);
            this.packages.put(string, package_);
            Package package_2 = package_;
            return package_2;
        }
    }

    protected Package getPackage(String string) {
        HashMap hashMap = this.packages;
        synchronized (hashMap) {
            Package package_ = (Package)this.packages.get(string);
            if (package_ == null && (package_ = this.parent != null ? this.parent.getPackage(string) : Package.getSystemPackage(string)) != null) {
                this.packages.put(string, package_);
            }
            Package package_2 = package_;
            return package_2;
        }
    }

    protected Package[] getPackages() {
        Map map;
        HashMap hashMap = this.packages;
        synchronized (hashMap) {
            map = (Map)this.packages.clone();
        }
        Package[] packageArray = this.parent != null ? this.parent.getPackages() : Package.getSystemPackages();
        if (packageArray != null) {
            int n = 0;
            while (n < packageArray.length) {
                String string = packageArray[n].getName();
                if (map.get(string) == null) {
                    map.put(string, packageArray[n]);
                }
                ++n;
            }
        }
        return (Package[])map.values().toArray(new Package[map.size()]);
    }

    protected String findLibrary(String string) {
        return null;
    }

    private ProtectionDomain getDefaultDomain() {
        if (this.defaultDomain == null) {
            Class clazz = class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = ClassLoader.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader;
            synchronized (clazz) {
                if (defaultPermissions == null) {
                    defaultPermissions = (PermissionCollection)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            CodeSource codeSource = new CodeSource(null, null);
                            return Policy.getPolicy().getPermissions(codeSource);
                        }
                    });
                }
                if (this.defaultDomain == null) {
                    CodeSource codeSource = new CodeSource(null, null);
                    this.defaultDomain = new ProtectionDomain(codeSource, defaultPermissions);
                }
            }
        }
        return this.defaultDomain;
    }

    private static String[] initializePath(String string) {
        String string2 = System.getProperty(string, "");
        String string3 = File.pathSeparator;
        int n = string2.length();
        int n2 = string2.indexOf(string3);
        int n3 = 0;
        while (n2 >= 0) {
            ++n3;
            n2 = string2.indexOf(string3, n2 + 1);
        }
        String[] stringArray = new String[n3 + 1];
        n2 = 0;
        n3 = 0;
        int n4 = string2.indexOf(string3);
        while (n4 >= 0) {
            if (n4 - n2 > 0) {
                stringArray[n3++] = string2.substring(n2, n4);
            } else if (n4 - n2 == 0) {
                stringArray[n3++] = ".";
            }
            n2 = n4 + 1;
            n4 = string2.indexOf(string3, n2);
        }
        stringArray[n3] = string2.substring(n2, n);
        return stringArray;
    }

    static void loadLibrary(Class clazz, String string, boolean bl) {
        String string2;
        ClassLoader classLoader;
        ClassLoader classLoader2 = classLoader = clazz == null ? null : clazz.getClassLoader();
        if (sys_paths == null) {
            usr_paths = ClassLoader.initializePath("java.library.path");
            sys_paths = ClassLoader.initializePath("sun.boot.library.path");
        }
        if (bl) {
            if (ClassLoader.loadLibrary0(clazz, new File(string))) {
                return;
            }
            throw new UnsatisfiedLinkError("Can't load library: " + string);
        }
        if (classLoader != null && (string2 = classLoader.findLibrary(string)) != null) {
            File file = new File(string2);
            if (!file.isAbsolute()) {
                throw new UnsatisfiedLinkError("ClassLoader.findClass failed to return an absolute path: " + string2);
            }
            if (ClassLoader.loadLibrary0(clazz, file)) {
                return;
            }
            throw new UnsatisfiedLinkError("Can't load " + string2);
        }
        int n = 0;
        while (n < sys_paths.length) {
            File file = new File(sys_paths[n], System.mapLibraryName(string));
            if (ClassLoader.loadLibrary0(clazz, file)) {
                return;
            }
            ++n;
        }
        if (classLoader != null) {
            int n2 = 0;
            while (n2 < usr_paths.length) {
                File file = new File(usr_paths[n2], System.mapLibraryName(string));
                if (ClassLoader.loadLibrary0(clazz, file)) {
                    return;
                }
                ++n2;
            }
        }
        throw new UnsatisfiedLinkError("no " + string + " in java.library.path");
    }

    private static boolean loadLibrary0(Class clazz, final File file) {
        Vector vector;
        String string;
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Boolean(file.exists());
            }
        });
        if (!bl.booleanValue()) {
            return false;
        }
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return false;
        }
        ClassLoader classLoader = clazz == null ? null : clazz.getClassLoader();
        Vector vector2 = vector = classLoader != null ? classLoader.nativeLibraries : systemNativeLibraries;
        synchronized (vector2) {
            Object object;
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                object = (NativeLibrary)vector.elementAt(n2);
                if (string.equals(((NativeLibrary)object).name)) {
                    boolean bl2 = true;
                    return bl2;
                }
                ++n2;
            }
            object = loadedLibraryNames;
            synchronized (object) {
                NativeLibrary nativeLibrary;
                if (loadedLibraryNames.contains(string)) {
                    throw new UnsatisfiedLinkError("Native Library " + string + " already loaded in another classloader");
                }
                int n3 = nativeLibraryContext.size();
                int n4 = 0;
                while (n4 < n3) {
                    nativeLibrary = (NativeLibrary)nativeLibraryContext.elementAt(n4);
                    if (string.equals(nativeLibrary.name)) {
                        if (classLoader == nativeLibrary.fromClass.getClassLoader()) {
                            boolean bl3 = true;
                            return bl3;
                        }
                        throw new UnsatisfiedLinkError("Native Library " + string + " is being loaded in another classloader");
                    }
                    ++n4;
                }
                nativeLibrary = new NativeLibrary(clazz, string);
                nativeLibraryContext.push(nativeLibrary);
                try {
                    nativeLibrary.load(string);
                    Object var15_16 = null;
                    nativeLibraryContext.pop();
                }
                catch (Throwable throwable) {
                    Object var15_17 = null;
                    nativeLibraryContext.pop();
                    throw throwable;
                }
                if (nativeLibrary.handle != 0L) {
                    loadedLibraryNames.addElement(string);
                    vector.addElement(nativeLibrary);
                    boolean bl4 = true;
                    return bl4;
                }
                boolean bl5 = false;
                return bl5;
            }
        }
    }

    static long findNative(ClassLoader classLoader, String string) {
        Vector vector;
        Vector vector2 = vector = classLoader != null ? classLoader.nativeLibraries : systemNativeLibraries;
        synchronized (vector2) {
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                NativeLibrary nativeLibrary = (NativeLibrary)vector.elementAt(n2);
                long l = nativeLibrary.find(string);
                if (l != 0L) {
                    long l2 = l;
                    return l2;
                }
                ++n2;
            }
        }
        return 0L;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        getClassLoaderPerm = null;
        defaultPermissions = null;
        loadedLibraryNames = new Vector();
        systemNativeLibraries = new Vector();
        nativeLibraryContext = new Stack();
    }

    static class NativeLibrary {
        long handle;
        private int jniVersion;
        private Class fromClass;
        String name;

        native void load(String var1);

        native long find(String var1);

        native void unload();

        public NativeLibrary(Class clazz, String string) {
            this.name = string;
            this.fromClass = clazz;
        }

        protected void finalize() {
            Vector vector = loadedLibraryNames;
            synchronized (vector) {
                if (this.fromClass.getClassLoader() != null && this.handle != 0L) {
                    int n = loadedLibraryNames.size();
                    int n2 = 0;
                    while (n2 < n) {
                        if (this.name.equals(loadedLibraryNames.elementAt(n2))) {
                            loadedLibraryNames.removeElementAt(n2);
                            break;
                        }
                        ++n2;
                    }
                    nativeLibraryContext.push(this);
                    try {
                        this.unload();
                        Object var5_4 = null;
                        nativeLibraryContext.pop();
                    }
                    catch (Throwable throwable) {
                        Object var5_5 = null;
                        nativeLibraryContext.pop();
                        throw throwable;
                    }
                    {
                    }
                }
            }
        }

        static Class getFromClass() {
            return ((NativeLibrary)nativeLibraryContext.peek()).fromClass;
        }
    }
}

