/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.print.PrinterJob;
import java.security.AccessControlException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToolBar;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Tools
extends JPanel
implements ActionListener,
ChangeListener,
MouseListener,
Runnable {
    private ImageIcon stopIcon;
    private ImageIcon startIcon;
    private Font font = new Font("serif", 0, 10);
    private Color roColor = new Color(204, 204, 255);
    private Surface surface;
    private Thread thread;
    private JPanel toolbarPanel;
    private JPanel sliderPanel;
    private JLabel label;
    private ToggleIcon bumpyIcon;
    private ToggleIcon rolloverIcon;
    protected boolean focus;
    public JButton toggleB;
    public JButton printB;
    public JComboBox screenCombo;
    public JButton renderB;
    public JButton aliasB;
    public JButton textureB;
    public JButton compositeB;
    public JButton startStopB;
    public JButton cloneB;
    public boolean issueRepaint = true;
    public JToolBar toolbar;
    public JSlider slider;
    public boolean doSlider;
    public boolean isExpanded;

    public Tools(Surface surface) {
        this.surface = surface;
        this.setBackground(Color.gray);
        this.setLayout(new BorderLayout());
        this.stopIcon = new ImageIcon(DemoImages.getImage("stop.gif", this));
        this.startIcon = new ImageIcon(DemoImages.getImage("start.gif", this));
        this.bumpyIcon = new ToggleIcon(this, Color.lightGray);
        this.rolloverIcon = new ToggleIcon(this, this.roColor);
        this.toggleB = new JButton(this.bumpyIcon);
        this.toggleB.addMouseListener(this);
        this.isExpanded = false;
        this.toggleB.addActionListener(this);
        this.toggleB.setMargin(new Insets(0, 0, -4, 0));
        this.toggleB.setBorderPainted(false);
        this.toggleB.setFocusPainted(false);
        this.toggleB.setContentAreaFilled(false);
        this.toggleB.setRolloverIcon(this.rolloverIcon);
        this.add("North", this.toggleB);
        this.toolbar = new JToolBar();
        this.toolbar.setPreferredSize(new Dimension(100, 26));
        this.toolbar.setFloatable(false);
        String string = surface.AntiAlias == RenderingHints.VALUE_ANTIALIAS_ON ? "On" : "Off";
        this.aliasB = this.addTool("A", "Antialiasing " + string, this);
        string = surface.Rendering == RenderingHints.VALUE_RENDER_SPEED ? "Speed" : "Quality";
        this.renderB = this.addTool("R", "Rendering " + string, this);
        string = surface.texture != null ? "On" : "Off";
        this.textureB = this.addTool("T", "Texture " + string, this);
        string = surface.composite != null ? "On" : "Off";
        this.compositeB = this.addTool("C", "Composite " + string, this);
        this.printB = this.addTool("print.gif", "Print the Surface", this);
        if (surface instanceof AnimatingSurface) {
            this.startStopB = this.addTool("stop.gif", "Stop Animation", this);
            this.toolbar.setPreferredSize(new Dimension(122, 26));
        }
        this.screenCombo = new JComboBox();
        this.screenCombo.setPreferredSize(new Dimension(100, 18));
        this.screenCombo.setFont(this.font);
        int n = 0;
        while (n < GlobalControls.screenNames.length) {
            this.screenCombo.addItem(GlobalControls.screenNames[n]);
            ++n;
        }
        this.screenCombo.addActionListener(this);
        this.toolbarPanel = new JPanel(new FlowLayout(1, 5, 0));
        this.toolbarPanel.setBackground(Color.gray);
        this.toolbarPanel.setLocation(0, 6);
        this.toolbarPanel.setVisible(false);
        this.toolbarPanel.add(this.toolbar);
        this.toolbarPanel.add(this.screenCombo);
        this.add(this.toolbarPanel);
        this.setPreferredSize(new Dimension(200, 6));
        if (surface instanceof AnimatingSurface) {
            this.sliderPanel = new JPanel(new GridLayout(0, 2, 5, 5));
            this.sliderPanel.setBackground(Color.gray);
            this.label = new JLabel("sleep = 30 ms");
            this.label.setForeground(Color.black);
            this.sliderPanel.add(this.label);
            this.slider = new JSlider(0, 0, 200, 30);
            this.slider.setBackground(Color.gray);
            this.slider.addChangeListener(this);
            TitledBorder titledBorder = new TitledBorder(new EtchedBorder());
            titledBorder.setTitleFont(new Font("serif", 0, 8));
            titledBorder.setTitle("sleep = 30 ms");
            EmptyBorder emptyBorder = new EmptyBorder(4, 5, 4, 5);
            this.slider.setBorder(new CompoundBorder(emptyBorder, new EtchedBorder()));
            this.sliderPanel.add(this.slider);
            this.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (Tools.this.toolbarPanel.isVisible()) {
                        Tools.this.invalidate();
                        Tools.this.doSlider = !Tools.this.doSlider;
                        if (Tools.this.doSlider) {
                            Tools.this.remove(Tools.this.toolbarPanel);
                            Tools.this.add(Tools.this.sliderPanel);
                        } else {
                            Tools.this.remove(Tools.this.sliderPanel);
                            Tools.this.add(Tools.this.toolbarPanel);
                        }
                        Tools.this.validate();
                        Tools.this.repaint();
                    }
                }
            });
        }
    }

    public JButton addTool(String string, String string2, ActionListener actionListener) {
        JButton jButton = null;
        if (string.indexOf(".") == -1) {
            jButton = (JButton)this.toolbar.add(new JButton(string));
            if (string2.equals("Rendering Quality") || string2.equals("Antialiasing On") || string2.equals("Texture On") || string2.equals("Composite On")) {
                jButton.setBackground(Color.green);
                jButton.setSelected(true);
            } else {
                jButton.setBackground(Color.lightGray);
                jButton.setSelected(false);
            }
            jButton.setPreferredSize(new Dimension(18, 22));
            jButton.setMaximumSize(new Dimension(18, 22));
            jButton.setMinimumSize(new Dimension(18, 22));
        } else {
            Image image = DemoImages.getImage(string, this);
            jButton = (JButton)this.toolbar.add(new JButton(new ImageIcon(image)));
            jButton.setSelected(true);
        }
        jButton.setToolTipText(string2);
        jButton.addActionListener(actionListener);
        return jButton;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JButton jButton;
        Object object = actionEvent.getSource();
        if (object.equals(this.toggleB)) {
            boolean bl = this.isExpanded = !this.isExpanded;
            if (this.isExpanded) {
                this.setPreferredSize(new Dimension(200, 38));
            } else {
                this.setPreferredSize(new Dimension(200, 6));
            }
            this.toolbarPanel.setVisible(this.isExpanded);
            if (this.sliderPanel != null) {
                this.sliderPanel.setVisible(this.isExpanded);
            }
            this.getParent().validate();
            this.toggleB.getModel().setRollover(false);
            return;
        }
        if (object.equals(this.printB)) {
            this.start();
            return;
        }
        if (object instanceof JButton) {
            jButton.setSelected(!(jButton = (JButton)object).isSelected());
            if (jButton.getIcon() == null) {
                jButton.setBackground(jButton.isSelected() ? Color.green : Color.lightGray);
            }
        }
        if (object.equals(this.startStopB)) {
            if (this.startStopB.getToolTipText().equals("Stop Animation")) {
                this.startStopB.setIcon(this.startIcon);
                this.startStopB.setToolTipText("Start Animation");
                this.surface.animating.stop();
            } else {
                this.startStopB.setIcon(this.stopIcon);
                this.startStopB.setToolTipText("Stop Animation");
                this.surface.animating.start();
            }
        } else if (object.equals(this.aliasB)) {
            if (this.aliasB.getToolTipText().equals("Antialiasing On")) {
                this.aliasB.setToolTipText("Antialiasing Off");
            } else {
                this.aliasB.setToolTipText("Antialiasing On");
            }
            this.surface.setAntiAlias(this.aliasB.isSelected());
        } else if (object.equals(this.renderB)) {
            if (this.renderB.getToolTipText().equals("Rendering Quality")) {
                this.renderB.setToolTipText("Rendering Speed");
            } else {
                this.renderB.setToolTipText("Rendering Quality");
            }
            this.surface.setRendering(this.renderB.isSelected());
        } else if (object.equals(this.textureB)) {
            jButton = null;
            if (this.textureB.getToolTipText().equals("Texture On")) {
                this.textureB.setToolTipText("Texture Off");
                this.surface.setTexture(null);
                this.surface.clearSurface = true;
            } else {
                this.textureB.setToolTipText("Texture On");
                this.surface.setTexture(TextureChooser.texture);
            }
        } else if (object.equals(this.compositeB)) {
            if (this.compositeB.getToolTipText().equals("Composite On")) {
                this.compositeB.setToolTipText("Composite Off");
            } else {
                this.compositeB.setToolTipText("Composite On");
            }
            this.surface.setComposite(this.compositeB.isSelected());
        } else if (object.equals(this.screenCombo)) {
            this.surface.setImageType(this.screenCombo.getSelectedIndex());
        }
        if (this.issueRepaint && this.surface.animating != null) {
            if (this.surface.getSleepAmount() != 0L && this.surface.animating.thread != null) {
                this.surface.animating.thread.interrupt();
            }
        } else if (this.issueRepaint) {
            this.surface.repaint();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        int n = this.slider.getValue();
        this.label.setText("sleep = " + String.valueOf(n) + " ms");
        this.label.repaint();
        this.surface.setSleepAmount(n);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.focus = true;
        this.bumpyIcon.start();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.focus = false;
        this.bumpyIcon.stop();
    }

    public void start() {
        this.thread = new Thread(this);
        this.thread.setPriority(10);
        this.thread.setName("Printing " + this.surface.name);
        this.thread.start();
    }

    public synchronized void stop() {
        this.thread = null;
        this.notifyAll();
    }

    public void run() {
        boolean bl = false;
        if (this.surface.animating != null && this.surface.animating.thread != null) {
            bl = true;
            this.startStopB.doClick();
        }
        try {
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            printerJob.setPrintable(this.surface);
            boolean bl2 = true;
            if (!Java2Demo.printCB.isSelected()) {
                bl2 = printerJob.printDialog();
            }
            if (bl2) {
                printerJob.print();
            }
        }
        catch (AccessControlException accessControlException) {
            String string = "Applet access control exception; to allow access to printer, run policytool and set\npermission for \"queuePrintJob\" in RuntimePermission.";
            JOptionPane.showMessageDialog(this, string, "Printer Access Error", 0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (bl) {
            this.startStopB.doClick();
        }
        this.thread = null;
    }

    static class ToggleIcon
    implements Icon,
    Runnable {
        private Color topColor = new Color(153, 153, 204);
        private Color shadowColor = new Color(102, 102, 153);
        private Color backColor = new Color(204, 204, 255);
        private Tools tools;
        private Thread thread;
        private Color fillColor;

        public ToggleIcon(Tools tools, Color color) {
            this.tools = tools;
            this.fillColor = color;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            int n3 = this.getIconWidth();
            int n4 = this.getIconHeight();
            graphics.setColor(this.fillColor);
            graphics.fillRect(0, 0, n3, n4);
            while (n < n3 - 2) {
                graphics.setColor(Color.white);
                graphics.fillRect(n, 1, 1, 1);
                graphics.fillRect(n + 2, 3, 1, 1);
                graphics.setColor(this.shadowColor);
                graphics.fillRect(n + 1, 2, 1, 1);
                graphics.fillRect(n + 3, 4, 1, 1);
                n += 4;
            }
        }

        public int getIconWidth() {
            return this.tools.getSize().width;
        }

        public int getIconHeight() {
            return 6;
        }

        public void start() {
            this.thread = new Thread(this);
            this.thread.setPriority(1);
            this.thread.setName("ToggleIcon");
            this.thread.start();
        }

        public synchronized void stop() {
            if (this.thread != null) {
                this.thread.interrupt();
            }
            this.thread = null;
        }

        public void run() {
            try {
                Thread.sleep(400L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.tools.focus && this.thread != null) {
                this.tools.toggleB.doClick();
            }
            this.thread = null;
        }
    }
}

