/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.usability;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import sun.plugin.resources.ResourceHandler;
import sun.plugin.usability.DialogFactory;
import sun.plugin.usability.Trace;

public class DialogFactory {
    private static ImageIcon icon = null;
    private static String confirmDialogTitle;
    private static String inputDialogTitle;
    private static String messageDialogTitle;
    private static String exceptionDialogTitle;
    private static String optionDialogTitle;
    private static String aboutDialogTitle;

    public static synchronized void showAboutPluginDialog() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(System.getProperty("java.runtime.name") + " " + System.getProperty("java.version"));
                stringBuffer.append("\n");
                stringBuffer.append(ResourceHandler.getMessage("default_vm_version") + System.getProperty("java.vm.version"));
                stringBuffer.append("\n");
                stringBuffer.append(ResourceHandler.getMessage("product_name"));
                stringBuffer.append(" ");
                stringBuffer.append(System.getProperty("javaplugin.version"));
                JOptionPane jOptionPane = new JOptionPane();
                jOptionPane.setIcon(icon);
                jOptionPane.setOptionType(-1);
                jOptionPane.setWantsInput(false);
                jOptionPane.setMessage(stringBuffer);
                DialogFactory.showDialog(jOptionPane, aboutDialogTitle, false);
                return null;
            }
        });
    }

    public static synchronized int showConfirmDialog(Object object) {
        return DialogFactory.showConfirmDialog(object, confirmDialogTitle);
    }

    public static synchronized String showInputDialog(Object object) {
        return DialogFactory.showInputDialog(object, inputDialogTitle);
    }

    public static synchronized void showMessageDialog(Object object) {
        DialogFactory.showMessageDialog(object, messageDialogTitle);
    }

    public static synchronized void showExceptionDialog(Object object) {
        DialogFactory.showExceptionDialog(object, exceptionDialogTitle);
    }

    public static synchronized int showConfirmDialog(Object object, String string) {
        String string2 = ResourceHandler.getMessage("usability.confirm.yes");
        String string3 = ResourceHandler.getMessage("usability.confirm.no");
        Object[] objectArray = new Object[]{string2, string3};
        if (string == null) {
            string = confirmDialogTitle;
        }
        return DialogFactory.showOptionDialog(object, string, objectArray, objectArray[0]);
    }

    public static synchronized int showOptionDialog(Object object, String string, Object[] objectArray, Object object2) {
        Object object3;
        int n = -1;
        JOptionPane jOptionPane = new JOptionPane();
        jOptionPane.setIcon(icon);
        jOptionPane.setOptions(objectArray);
        jOptionPane.setInitialValue(object2);
        jOptionPane.setWantsInput(false);
        Object object4 = DialogFactory.extractMessage(jOptionPane, object);
        jOptionPane.setMessage(object4);
        if (string == null) {
            string = optionDialogTitle;
        }
        if (DialogFactory.showDialog(jOptionPane, string) && (object3 = jOptionPane.getValue()) != null) {
            int n2 = 0;
            while (n2 < objectArray.length) {
                if (objectArray[n2].equals(object3)) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            Trace.println("User selected: " + n, 2);
        }
        return n;
    }

    public static synchronized String showInputDialog(Object object, String string) {
        Object object2;
        String string2 = null;
        JOptionPane jOptionPane = new JOptionPane();
        jOptionPane.setIcon(icon);
        jOptionPane.setOptionType(2);
        jOptionPane.setWantsInput(true);
        Object object3 = DialogFactory.extractMessage(jOptionPane, object);
        jOptionPane.setMessage(object3);
        if (string == null) {
            string = inputDialogTitle;
        }
        if (DialogFactory.showDialog(jOptionPane, string) && (object2 = jOptionPane.getInputValue()) != null) {
            if (object2 instanceof String) {
                string2 = object2.toString();
            }
            Trace.println("User typed: " + string2, 2);
        }
        return string2;
    }

    public static synchronized void showMessageDialog(Object object, String string, boolean bl) {
        JOptionPane jOptionPane = new JOptionPane();
        jOptionPane.setIcon(icon);
        jOptionPane.setOptionType(-1);
        jOptionPane.setWantsInput(false);
        Object object2 = DialogFactory.extractMessage(jOptionPane, object);
        jOptionPane.setMessage(object2);
        if (string == null) {
            string = messageDialogTitle;
        }
        DialogFactory.showDialog(jOptionPane, string, bl);
    }

    public static synchronized void showMessageDialog(Object object, String string) {
        DialogFactory.showMessageDialog(object, string, true);
    }

    public static synchronized void showExceptionDialog(Object object, String string) {
        JOptionPane jOptionPane = new JOptionPane();
        jOptionPane.setIcon(icon);
        jOptionPane.setOptionType(-1);
        jOptionPane.setWantsInput(false);
        Object object2 = DialogFactory.extractMessage(jOptionPane, object);
        jOptionPane.setMessage(object2);
        if (string == null) {
            string = exceptionDialogTitle;
        }
        DialogFactory.showDialog(jOptionPane, string);
    }

    private static synchronized boolean showDialog(JOptionPane jOptionPane, String string) {
        return DialogFactory.showDialog(jOptionPane, string, true);
    }

    private static synchronized boolean showDialog(final JOptionPane jOptionPane, final String string, final boolean bl) {
        boolean bl2 = true;
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws InterruptedException, InvocationTargetException {
                    jOptionPane.setValue(null);
                    Runnable runnable = new Runnable(this){
                        private final /* synthetic */ 3 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        public void run() {
                            JDialog jDialog = 3.access$400(this.this$0).createDialog(null, 3.access$300(this.this$0));
                            jDialog.setResizable(false);
                            jDialog.setModal(3.access$500(this.this$0));
                            jDialog.addWindowListener(new WindowAdapter(this, jDialog){
                                private final /* synthetic */ JDialog val$dialog;
                                private final /* synthetic */ 4 this$1;
                                {
                                    this.this$1 = var1_1;
                                    this.val$dialog = jDialog;
                                }

                                public void windowClosing(WindowEvent windowEvent) {
                                    this.val$dialog.removeWindowListener(this);
                                    this.val$dialog.dispose();
                                }
                            });
                            jDialog.show();
                            jDialog.toFront();
                        }
                    };
                    if (!SwingUtilities.isEventDispatchThread()) {
                        if (bl) {
                            SwingUtilities.invokeAndWait(runnable);
                        } else {
                            SwingUtilities.invokeLater(runnable);
                        }
                    } else {
                        runnable.run();
                    }
                    return null;
                }

                static /* synthetic */ String access$300(3 var0) {
                    return var0.string;
                }

                static /* synthetic */ JOptionPane access$400(3 var0) {
                    return var0.jOptionPane;
                }

                static /* synthetic */ boolean access$500(3 var0) {
                    return var0.bl;
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl2 = false;
        }
        return bl2;
    }

    private static synchronized Object extractMessage(JOptionPane jOptionPane, Throwable throwable) {
        return DialogFactory.formatExceptionMessage(jOptionPane, throwable);
    }

    private static synchronized Object extractMessage(JOptionPane jOptionPane, String string) {
        return DialogFactory.formatStringMessage(jOptionPane, string);
    }

    private static synchronized Object extractMessage(JOptionPane jOptionPane, Object[] objectArray) {
        Object[] objectArray2 = null;
        if (objectArray != null) {
            objectArray2 = new Object[objectArray.length];
            int n = 0;
            while (n < objectArray.length) {
                objectArray2[n] = DialogFactory.extractMessage(jOptionPane, objectArray[n]);
                ++n;
            }
        }
        return objectArray2;
    }

    private static synchronized Object extractMessage(JOptionPane jOptionPane, Object object) {
        if (object instanceof Object[]) {
            return DialogFactory.extractMessage(jOptionPane, (Object[])object);
        }
        if (object instanceof String) {
            return DialogFactory.extractMessage(jOptionPane, (String)object);
        }
        if (object instanceof Exception) {
            return DialogFactory.extractMessage(jOptionPane, (Exception)object);
        }
        return object;
    }

    private static synchronized Object formatStringMessage(JOptionPane jOptionPane, String string) {
        JTextArea jTextArea = new JTextArea("" + string);
        jTextArea.setColumns(40);
        jTextArea.setAutoscrolls(true);
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setBackground(jOptionPane.getBackground());
        return jTextArea;
    }

    private static synchronized Object formatExceptionMessage(JOptionPane jOptionPane, Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        JTextArea jTextArea = new JTextArea("" + stringWriter.toString());
        jTextArea.setColumns(40);
        jTextArea.setRows(10);
        jTextArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jTextArea.setBackground(jOptionPane.getBackground());
        return jScrollPane;
    }

    static {
        try {
            icon = (ImageIcon)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    URL uRL = ClassLoader.getSystemResource("sun/plugin/usability/dukeWave.gif");
                    return new ImageIcon(uRL);
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        confirmDialogTitle = ResourceHandler.getMessage("usability.confirmDialogTitle");
        inputDialogTitle = ResourceHandler.getMessage("usability.inputDialogTitle");
        messageDialogTitle = ResourceHandler.getMessage("usability.messageDialogTitle");
        exceptionDialogTitle = ResourceHandler.getMessage("usability.exceptionDialogTitle");
        optionDialogTitle = ResourceHandler.getMessage("usability.optionDialogTitle");
        aboutDialogTitle = ResourceHandler.getMessage("usability.aboutDialogTitle");
    }
}

