/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.debug;

import java.io.DataInputStream;
import sun.tools.agent.AgentConstants;
import sun.tools.debug.DebuggerCallback;
import sun.tools.debug.RemoteAgent;
import sun.tools.debug.RemoteThread;

class AgentIn
implements Runnable,
AgentConstants {
    RemoteAgent agent;
    DebuggerCallback client;
    DataInputStream in;
    boolean isQuitting = false;

    AgentIn(RemoteAgent remoteAgent, DataInputStream dataInputStream, DebuggerCallback debuggerCallback, boolean bl) {
        this.agent = remoteAgent;
        this.client = debuggerCallback;
        this.in = dataInputStream;
    }

    void quit() {
        this.isQuitting = true;
    }

    public void run() {
        Thread.currentThread().setPriority(10);
        try {
            block12: while (true) {
                int n = this.in.read();
                switch (n) {
                    case -1: {
                        if (!this.isQuitting) {
                            this.agent.printToClientConsole("\nThe communications channel closed.\n");
                            this.agent.handleRemoteClose();
                            this.client.quitEvent();
                            return;
                        }
                    }
                    case 33: {
                        int n2 = this.in.readInt();
                        Object object = new byte[n2];
                        this.in.readFully((byte[])object, 0, n2);
                        String string = new String((byte[])object);
                        this.agent.printToClientConsole(string);
                        continue block12;
                    }
                    case 46: {
                        RemoteThread remoteThread = (RemoteThread)this.agent.readValue(this.in);
                        this.agent.resetStacks();
                        this.client.breakpointEvent(remoteThread);
                        continue block12;
                    }
                    case 52: {
                        this.agent.message("AgentIn: exceptionEvent!");
                        RemoteThread remoteThread = (RemoteThread)this.agent.readValue(this.in);
                        Object object = this.in.readUTF();
                        this.agent.message("text=" + (String)object);
                        this.agent.resetStacks();
                        this.client.exceptionEvent(remoteThread, (String)object);
                        continue block12;
                    }
                    case 66: {
                        RemoteThread remoteThread = (RemoteThread)this.agent.readValue(this.in);
                        this.client.threadDeathEvent(remoteThread);
                        continue block12;
                    }
                    case 67: {
                        if (!this.isQuitting) {
                            this.isQuitting = true;
                            this.client.quitEvent();
                            this.agent.closeRemoteInterpreter = false;
                            this.agent.close();
                        }
                        return;
                    }
                }
            }
        }
        catch (Exception exception) {
            try {
                if (!this.isQuitting) {
                    this.agent.printToClientConsole("\nFatal exception: " + exception + "\n");
                    exception.printStackTrace();
                    this.agent.handleRemoteClose();
                    this.client.quitEvent();
                    return;
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            return;
        }
    }
}

