/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.InternalException;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.Transport;
import com.sun.tools.jdi.LinkedHashMap;
import com.sun.tools.jdi.VirtualMachineManagerImpl;
import com.sun.tools.jdi.VirtualMachineManagerService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

abstract class ConnectorImpl
implements Connector {
    Map defaultArguments = new LinkedHashMap();
    final VirtualMachineManagerService manager;
    static String trueString = null;
    static String falseString;

    ConnectorImpl(VirtualMachineManagerService virtualMachineManagerService) {
        this.manager = virtualMachineManagerService;
    }

    VirtualMachineManagerService manager() {
        return this.manager;
    }

    public Map defaultArguments() {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        Collection collection = this.defaultArguments.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ArgumentImpl argumentImpl = (ArgumentImpl)iterator.next();
            linkedHashMap.put(argumentImpl.name(), argumentImpl.clone());
        }
        return linkedHashMap;
    }

    void addStringArgument(String string, String string2, String string3, String string4, boolean bl) {
        this.defaultArguments.put(string, new StringArgumentImpl(string, string2, string3, string4, bl));
    }

    void addBooleanArgument(String string, String string2, String string3, boolean bl, boolean bl2) {
        this.defaultArguments.put(string, new BooleanArgumentImpl(string, string2, string3, bl, bl2));
    }

    void addIntegerArgument(String string, String string2, String string3, String string4, boolean bl, int n, int n2) {
        this.defaultArguments.put(string, new IntegerArgumentImpl(string, string2, string3, string4, bl, n, n2));
    }

    void addSelectedArgument(String string, String string2, String string3, String string4, boolean bl, List list) {
        this.defaultArguments.put(string, new SelectedArgumentImpl(string, string2, string3, string4, bl, list));
    }

    ArgumentImpl argument(String string, Map map) throws IllegalConnectorArgumentsException {
        ArgumentImpl argumentImpl = (ArgumentImpl)map.get(string);
        if (argumentImpl == null) {
            throw new IllegalConnectorArgumentsException("Argument missing", string);
        }
        String string2 = argumentImpl.value();
        if (string2 == null || string2.length() == 0) {
            if (argumentImpl.mustSpecify()) {
                throw new IllegalConnectorArgumentsException("Argument unspecified", string);
            }
        } else if (!argumentImpl.isValid(string2)) {
            throw new IllegalConnectorArgumentsException("Argument invalid", string);
        }
        return argumentImpl;
    }

    String getString(String string) {
        return ((VirtualMachineManagerImpl)this.manager).getString(string);
    }

    public String toString() {
        String string = this.name() + " (defaults: ";
        Iterator iterator = this.defaultArguments().values().iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            ArgumentImpl argumentImpl = (ArgumentImpl)iterator.next();
            if (!bl) {
                string = string + ", ";
            }
            string = string + argumentImpl.toString();
            bl = false;
        }
        return string;
    }

    public abstract Transport transport();

    public abstract String description();

    public abstract String name();

    class SelectedArgumentImpl
    extends ArgumentImpl
    implements Connector.SelectedArgument {
        private final List choices;

        SelectedArgumentImpl(String string, String string2, String string3, String string4, boolean bl, List list) {
            super(string, string2, string3, string4, bl);
            this.choices = Collections.unmodifiableList(new ArrayList(list));
        }

        public List choices() {
            return this.choices;
        }

        public boolean isValid(String string) {
            return this.choices.contains(string);
        }
    }

    class StringArgumentImpl
    extends ArgumentImpl
    implements Connector.StringArgument {
        StringArgumentImpl(String string, String string2, String string3, String string4, boolean bl) {
            super(string, string2, string3, string4, bl);
        }

        public boolean isValid(String string) {
            return true;
        }
    }

    class IntegerArgumentImpl
    extends ArgumentImpl
    implements Connector.IntegerArgument {
        private final int min;
        private final int max;

        IntegerArgumentImpl(String string, String string2, String string3, String string4, boolean bl, int n, int n2) {
            super(string, string2, string3, string4, bl);
            this.min = n;
            this.max = n2;
        }

        public void setValue(int n) {
            this.setValue(this.stringValueOf(n));
        }

        public boolean isValid(String string) {
            if (string == null) {
                return false;
            }
            try {
                return this.isValid(Integer.decode(string));
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }

        public boolean isValid(int n) {
            return this.min <= n && n <= this.max;
        }

        public String stringValueOf(int n) {
            return "" + n;
        }

        public int intValue() {
            if (this.value() == null) {
                return 0;
            }
            try {
                return Integer.decode(this.value());
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }

        public int max() {
            return this.max;
        }

        public int min() {
            return this.min;
        }
    }

    class BooleanArgumentImpl
    extends ArgumentImpl
    implements Connector.BooleanArgument {
        BooleanArgumentImpl(String string, String string2, String string3, boolean bl, boolean bl2) {
            super(string, string2, string3, null, bl2);
            if (trueString == null) {
                trueString = ConnectorImpl.this.getString("true");
                falseString = ConnectorImpl.this.getString("false");
            }
            this.setValue(bl);
        }

        public void setValue(boolean bl) {
            this.setValue(this.stringValueOf(bl));
        }

        public boolean isValid(String string) {
            return string.equals(trueString) || string.equals(falseString);
        }

        public String stringValueOf(boolean bl) {
            return bl ? trueString : falseString;
        }

        public boolean booleanValue() {
            return this.value().equals(trueString);
        }
    }

    abstract class ArgumentImpl
    implements Connector.Argument,
    Cloneable,
    Serializable {
        private String name;
        private String label;
        private String description;
        private String value;
        private boolean mustSpecify;

        ArgumentImpl(String string, String string2, String string3, String string4, boolean bl) {
            this.name = string;
            this.label = string2;
            this.description = string3;
            this.value = string4;
            this.mustSpecify = bl;
        }

        public abstract boolean isValid(String var1);

        public String name() {
            return this.name;
        }

        public String label() {
            return this.label;
        }

        public String description() {
            return this.description;
        }

        public String value() {
            return this.value;
        }

        public void setValue(String string) {
            if (string == null) {
                throw new NullPointerException("Can't set null value");
            }
            this.value = string;
        }

        public boolean mustSpecify() {
            return this.mustSpecify;
        }

        public boolean equals(Object object) {
            if (object != null && object instanceof Connector.Argument) {
                Connector.Argument argument = (Connector.Argument)object;
                return this.name().equals(argument.name()) && this.description().equals(argument.description()) && this.mustSpecify() == argument.mustSpecify() && this.value().equals(argument.value());
            }
            return false;
        }

        public int hashCode() {
            return this.description().hashCode();
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalException();
            }
        }

        public String toString() {
            return this.name() + "=" + this.value();
        }
    }
}

