/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class WeakHashMap
extends AbstractMap
implements Map {
    private static final int DEFAULT_CAPACITY = 11;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final Object NULL_KEY = new Object();
    private ReferenceQueue queue;
    private int size;
    private float loadFactor;
    private int threshold;
    private int modCount;
    private WeakEntrySet theEntrySet;
    private WeakBucket[] buckets;

    static /* synthetic */ int access$6(WeakHashMap inst$, int write_parm_value$) {
        inst$.size = write_parm_value$;
        return inst$.size;
    }

    static /* synthetic */ WeakBucket[] access$2(WeakHashMap inst$, WeakBucket[] write_parm_value$) {
        inst$.buckets = write_parm_value$;
        return write_parm_value$;
    }

    public WeakHashMap() {
        this(11, 0.75f);
    }

    public WeakHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public WeakHashMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0 || loadFactor <= 0.0f || loadFactor > 1.0f) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)initialCapacity * loadFactor);
        this.theEntrySet = new WeakEntrySet(this);
        this.queue = new ReferenceQueue();
        this.buckets = new WeakBucket[initialCapacity];
    }

    private int hash(Object key) {
        return Math.abs(key.hashCode() % this.buckets.length);
    }

    private void cleanQueue() {
        Reference bucket = this.queue.poll();
        while (bucket != null) {
            this.internalRemove((WeakBucket)bucket);
            bucket = this.queue.poll();
        }
    }

    private void rehash() {
        WeakBucket[] oldBuckets = this.buckets;
        int newsize = this.buckets.length * 2 + 1;
        this.threshold = (int)((float)newsize * this.loadFactor);
        this.buckets = new WeakBucket[newsize];
        for (int i = 0; i < oldBuckets.length; ++i) {
            WeakBucket bucket = oldBuckets[i];
            while (bucket != null) {
                WeakBucket nextBucket = bucket.next;
                Object key = bucket.get();
                if (key == null) {
                    bucket.slot = -1;
                    this.size += -1;
                } else {
                    int slot;
                    bucket.slot = slot = this.hash(key);
                    bucket.next = this.buckets[slot];
                    this.buckets[slot] = bucket;
                }
                bucket = nextBucket;
            }
        }
    }

    private WeakBucket.Entry internalGet(Object key) {
        if (key == null) {
            key = NULL_KEY;
        }
        int slot = this.hash(key);
        WeakBucket bucket = this.buckets[slot];
        while (bucket != null) {
            WeakBucket.Entry entry = bucket.getEntry();
            if (entry != null && key.equals(entry.key)) {
                return entry;
            }
            bucket = bucket.next;
        }
        return null;
    }

    private void internalAdd(Object key, Object value) {
        if (key == null) {
            key = NULL_KEY;
        }
        int slot = this.hash(key);
        WeakBucket bucket = new WeakBucket(key, this.queue, value, slot);
        bucket.next = this.buckets[slot];
        this.buckets[slot] = bucket;
        ++this.size;
    }

    private void internalRemove(WeakBucket bucket) {
        int slot = bucket.slot;
        if (slot == -1) {
            return;
        }
        bucket.slot = -1;
        if (this.buckets[slot] == bucket) {
            this.buckets[slot] = bucket.next;
        } else {
            WeakBucket prev = this.buckets[slot];
            while (prev.next != bucket) {
                prev = prev.next;
            }
            prev.next = bucket.next;
        }
        this.size += -1;
    }

    public int size() {
        this.cleanQueue();
        return this.size;
    }

    public boolean isEmpty() {
        this.cleanQueue();
        return this.size == 0;
    }

    public boolean containsKey(Object key) {
        this.cleanQueue();
        return this.internalGet(key) != null;
    }

    public Object get(Object key) {
        this.cleanQueue();
        WeakBucket.Entry entry = this.internalGet(key);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    public Object put(Object key, Object value) {
        this.cleanQueue();
        WeakBucket.Entry entry = this.internalGet(key);
        if (entry != null) {
            return entry.setValue(value);
        }
        if (this.size >= this.threshold) {
            this.rehash();
        }
        this.internalAdd(key, value);
        ++this.modCount;
        return null;
    }

    public Object remove(Object key) {
        this.cleanQueue();
        WeakBucket.Entry entry = this.internalGet(key);
        if (entry == null) {
            return null;
        }
        this.internalRemove(entry.getBucket());
        ++this.modCount;
        return entry.getValue();
    }

    public Set entrySet() {
        this.cleanQueue();
        return this.theEntrySet;
    }

    static class WeakBucket
    extends WeakReference {
        Object value;
        WeakBucket next;
        int slot;

        public WeakBucket(Object key, ReferenceQueue queue, Object value, int slot) {
            super(key, queue);
            this.value = value;
            this.slot = slot;
        }

        Entry getEntry() {
            Object key = this.get();
            if (key == null) {
                return null;
            }
            return new Entry(this, key);
        }

        class Entry
        implements Map.Entry {
            private /* synthetic */ WeakBucket this$1;
            Object key;

            public Entry(WeakBucket this$1, Object key) {
                this.this$1 = this$1;
                this.key = key;
            }

            public WeakBucket getBucket() {
                return this.this$1;
            }

            public Object getKey() {
                if (this.key == NULL_KEY) {
                    return null;
                }
                return this.key;
            }

            public Object getValue() {
                return this.this$1.value;
            }

            public Object setValue(Object newVal) {
                Object oldVal = this.this$1.value;
                this.this$1.value = newVal;
                return oldVal;
            }

            public int hashCode() {
                return (this.key == NULL_KEY ? 0 : this.key.hashCode()) ^ (this.this$1.value == null ? 0 : this.this$1.value.hashCode());
            }

            public boolean equals(Object o) {
                if (o instanceof Map.Entry) {
                    Map.Entry e = (Map.Entry)o;
                    return (this.key == NULL_KEY ? e.getKey() == null : this.key.equals(e.getKey())) && (this.this$1.value == null ? e.getValue() == null : this.this$1.value.equals(e.getValue()));
                }
                return false;
            }
        }
    }

    class WeakEntrySet
    extends AbstractSet {
        private /* synthetic */ WeakHashMap this$0;

        static /* synthetic */ WeakHashMap access$3(WeakEntrySet inst$, WeakHashMap write_parm_value$) {
            inst$.this$0 = write_parm_value$;
            return inst$.this$0;
        }

        static WeakHashMap access$0(WeakEntrySet inst$) {
            return inst$.this$0;
        }

        public int size() {
            return this.this$0.size;
        }

        public Iterator iterator() {
            return new Iterator(this){
                private /* synthetic */ WeakEntrySet this$1;
                WeakBucket.Entry lastEntry;
                WeakBucket.Entry nextEntry;
                int knownMod;
                {
                    this.this$1 = this$1;
                    this.finit$();
                }

                private /* synthetic */ void finit$() {
                    this.nextEntry = this.findNext(null);
                    this.knownMod = WeakEntrySet.access$0(this.this$1).modCount;
                }

                private void checkMod() {
                    if (this.knownMod != WeakEntrySet.access$0(this.this$1).modCount) {
                        throw new ConcurrentModificationException();
                    }
                }

                private WeakBucket.Entry findNext(WeakBucket.Entry lastEntry) {
                    int slot;
                    WeakBucket nextBucket;
                    if (lastEntry != null) {
                        nextBucket = lastEntry.getBucket().next;
                        slot = lastEntry.getBucket().slot;
                    } else {
                        nextBucket = WeakEntrySet.access$0(this.this$1).buckets[0];
                        slot = 0;
                    }
                    while (true) {
                        if (nextBucket != null) {
                            WeakBucket.Entry entry = nextBucket.getEntry();
                            if (entry != null) {
                                return entry;
                            }
                            nextBucket = nextBucket.next;
                            continue;
                        }
                        if (++slot == WeakEntrySet.access$0(this.this$1).buckets.length) {
                            return null;
                        }
                        nextBucket = WeakEntrySet.access$0(this.this$1).buckets[slot];
                    }
                }

                public boolean hasNext() {
                    this.this$1.this$0.cleanQueue();
                    this.checkMod();
                    return this.nextEntry != null;
                }

                public Object next() {
                    this.this$1.this$0.cleanQueue();
                    this.checkMod();
                    if (this.nextEntry == null) {
                        throw new NoSuchElementException();
                    }
                    this.lastEntry = this.nextEntry;
                    this.nextEntry = this.findNext(this.lastEntry);
                    return this.lastEntry;
                }

                public void remove() {
                    this.this$1.this$0.cleanQueue();
                    this.checkMod();
                    if (this.lastEntry == null) {
                        throw new IllegalStateException();
                    }
                    this.this$1.this$0.internalRemove(this.lastEntry.getBucket());
                    this.lastEntry = null;
                    WeakEntrySet.access$0(this.this$1).modCount = WeakEntrySet.access$0(this.this$1).modCount + 1;
                    this.knownMod = WeakEntrySet.access$0(this.this$1).modCount;
                }
            };
        }

        WeakEntrySet(WeakHashMap this$0) {
            this.this$0 = this$0;
        }
    }
}

