/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.BasicMapEntry;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;

public class TreeMap
extends AbstractMap
implements SortedMap,
Cloneable,
Serializable {
    private static final int RED = -1;
    private static final int BLACK = 1;
    transient Node nil;
    transient Node root;
    transient int size;
    transient int modCount;
    Comparator comparator;
    static final long serialVersionUID = 919286545866124006L;

    private /* synthetic */ void finit$() {
        this.root = this.nil = new Node(null, null);
        this.size = 0;
        this.modCount = 0;
        this.comparator = null;
    }

    public TreeMap() {
        this.finit$();
    }

    public TreeMap(Comparator c) {
        this.finit$();
        this.comparator = c;
    }

    public TreeMap(Map map) {
        this.finit$();
        this.putAll(map);
    }

    public TreeMap(SortedMap sm) {
        this(sm.comparator());
        int sm_size = sm.size();
        Iterator itr = sm.entrySet().iterator();
        this.fabricateTree(sm_size);
        Node node = this.firstNode();
        for (int i = 0; i < sm_size; ++i) {
            Map.Entry me = (Map.Entry)itr.next();
            node.key = me.getKey();
            node.value = me.getValue();
            node = this.successor(node);
        }
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        ++this.modCount;
        this.root = this.nil;
        this.nil.parent = null;
        this.size = 0;
    }

    public Object clone() {
        TreeMap copy = null;
        try {
            copy = (TreeMap)super.clone();
        }
        catch (CloneNotSupportedException x) {
            // empty catch block
        }
        copy.nil = new Node(null, null);
        copy.fabricateTree(this.size);
        Node node = this.firstNode();
        Node cnode = copy.firstNode();
        while (node != this.nil) {
            cnode.key = node.key;
            cnode.value = node.value;
            node = this.successor(node);
            cnode = copy.successor(cnode);
        }
        return copy;
    }

    public Comparator comparator() {
        return this.comparator;
    }

    public boolean containsKey(Object key) {
        return this.getNode(key) != this.nil;
    }

    public boolean containsValue(Object value) {
        Node node = this.firstNode();
        while (node != this.nil) {
            Object currentVal = node.getValue();
            if (value == null ? currentVal == null : value.equals(currentVal)) {
                return true;
            }
            node = this.successor(node);
        }
        return false;
    }

    public Set entrySet() {
        return new AbstractSet(this){
            private /* synthetic */ TreeMap this$0;
            {
                this.this$0 = this$0;
            }

            public int size() {
                return this.this$0.size;
            }

            public Iterator iterator() {
                return new TreeIterator(this.this$0, 0);
            }

            public void clear() {
                this.this$0.clear();
            }

            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry me = (Map.Entry)o;
                Node n = this.this$0.getNode(me.getKey());
                return n != this.this$0.nil && me.getValue().equals(n.value);
            }

            public boolean remove(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry me = (Map.Entry)o;
                Node n = this.this$0.getNode(me.getKey());
                if (n != this.this$0.nil && me.getValue().equals(n.value)) {
                    this.this$0.removeNode(n);
                    return true;
                }
                return false;
            }
        };
    }

    public Object firstKey() {
        if (this.root == this.nil) {
            throw new NoSuchElementException("empty");
        }
        return this.firstNode().getKey();
    }

    private Node firstNode() {
        if (this.root == this.nil) {
            return this.nil;
        }
        Node node = this.root;
        while (node.left != this.nil) {
            node = node.left;
        }
        return node;
    }

    public Object lastKey() {
        if (this.root == this.nil) {
            throw new NoSuchElementException("empty");
        }
        return this.lastNode().getKey();
    }

    private Node lastNode() {
        if (this.root == this.nil) {
            return this.nil;
        }
        Node node = this.root;
        while (node.right != this.nil) {
            node = node.right;
        }
        return node;
    }

    public Object get(Object key) {
        return this.getNode((Object)key).value;
    }

    private Node getNode(Object key) {
        Node current = this.root;
        while (current != this.nil) {
            int comparison = this.compare(key, current.key);
            if (comparison > 0) {
                current = current.right;
                continue;
            }
            if (comparison < 0) {
                current = current.left;
                continue;
            }
            return current;
        }
        return current;
    }

    public Set keySet() {
        return new AbstractSet(this){
            private /* synthetic */ TreeMap this$0;
            {
                this.this$0 = this$0;
            }

            public int size() {
                return this.this$0.size;
            }

            public Iterator iterator() {
                return new TreeIterator(this.this$0, 1);
            }

            public void clear() {
                this.this$0.clear();
            }

            public boolean contains(Object o) {
                return this.this$0.containsKey(o);
            }

            public boolean remove(Object key) {
                Node n = this.this$0.getNode(key);
                if (n == this.this$0.nil) {
                    return false;
                }
                this.this$0.removeNode(n);
                return true;
            }
        };
    }

    public Object put(Object key, Object value) {
        ++this.modCount;
        Node current = this.root;
        Node parent = this.nil;
        int comparison = 0;
        while (current != this.nil) {
            parent = current;
            comparison = this.compare(key, current.key);
            if (comparison > 0) {
                current = current.right;
                continue;
            }
            if (comparison < 0) {
                current = current.left;
                continue;
            }
            Object r = current.value;
            current.value = value;
            return r;
        }
        Node n = new Node(key, value);
        n.color = -1;
        n.parent = parent;
        n.left = this.nil;
        n.right = this.nil;
        ++this.size;
        if (parent == this.nil) {
            this.root = n;
            n.color = 1;
            return null;
        }
        if (comparison > 0) {
            parent.right = n;
        } else {
            parent.left = n;
        }
        this.insertFixup(n);
        return null;
    }

    private void insertFixup(Node n) {
        while (n != this.root && n.parent.parent != this.nil && n.parent.color == -1) {
            Node uncle;
            if (n.parent == n.parent.parent.left) {
                uncle = n.parent.parent.right;
                if (uncle != this.nil && uncle.color == -1) {
                    n.parent.color = 1;
                    uncle.color = 1;
                    n.parent.parent.color = -1;
                    n = n.parent.parent;
                    continue;
                }
                if (n == n.parent.right) {
                    n = n.parent;
                    this.rotateLeft(n);
                }
                n.parent.color = 1;
                n.parent.parent.color = -1;
                this.rotateRight(n.parent.parent);
                continue;
            }
            uncle = n.parent.parent.left;
            if (uncle != this.nil && uncle.color == -1) {
                n.parent.color = 1;
                uncle.color = 1;
                n.parent.parent.color = -1;
                n = n.parent.parent;
                continue;
            }
            if (n == n.parent.left) {
                n = n.parent;
                this.rotateRight(n);
            }
            n.parent.color = 1;
            n.parent.parent.color = -1;
            this.rotateLeft(n.parent.parent);
        }
        this.root.color = 1;
    }

    public void putAll(Map m) {
        Iterator itr = m.entrySet().iterator();
        int msize = m.size();
        for (int i = 0; i < msize; ++i) {
            Map.Entry e = (Map.Entry)itr.next();
            this.put(e.getKey(), e.getValue());
        }
    }

    public Object remove(Object key) {
        Node n = this.getNode(key);
        if (n != this.nil) {
            this.removeNode(n);
            return n.value;
        }
        return null;
    }

    private void removeNode(Node node) {
        Node parent;
        Node child;
        Node splice;
        ++this.modCount;
        this.size += -1;
        if (node.left == this.nil || node.right == this.nil) {
            splice = node;
            child = node.left == this.nil ? node.right : node.left;
        } else {
            splice = node.right;
            while (splice.left != this.nil) {
                splice = splice.left;
            }
            child = splice.right;
        }
        child.parent = parent = splice.parent;
        if (parent != this.nil) {
            if (splice == parent.left) {
                parent.left = child;
            } else {
                parent.right = child;
            }
        } else {
            this.root = child;
        }
        int spliceColor = splice.color;
        if (splice != node) {
            if (node == this.root) {
                this.root = splice;
            } else if (node.parent.left == node) {
                node.parent.left = splice;
            } else {
                node.parent.right = splice;
            }
            splice.parent = node.parent;
            splice.left = node.left;
            splice.right = node.right;
            splice.left.parent = splice;
            splice.right.parent = splice;
            splice.color = node.color;
        }
        if (spliceColor == 1) {
            this.deleteFixup(child);
        }
    }

    private void deleteFixup(Node node) {
        while (node != this.root && node.color == 1) {
            Node sibling;
            if (node == node.parent.left) {
                sibling = node.parent.right;
                if (sibling.color == -1) {
                    sibling.color = 1;
                    node.parent.color = -1;
                    this.rotateLeft(node.parent);
                    sibling = node.parent.right;
                }
                if (sibling.left.color == 1 && sibling.right.color == 1) {
                    sibling.color = -1;
                    node = node.parent;
                    continue;
                }
                if (sibling.right.color == 1) {
                    sibling.left.color = 1;
                    sibling.color = -1;
                    this.rotateRight(sibling);
                    sibling = node.parent.right;
                }
                sibling.color = sibling.parent.color;
                sibling.parent.color = 1;
                sibling.right.color = 1;
                this.rotateLeft(node.parent);
                node = this.root;
                continue;
            }
            sibling = node.parent.left;
            if (sibling.color == -1) {
                sibling.color = 1;
                node.parent.color = -1;
                this.rotateRight(node.parent);
                sibling = node.parent.left;
            }
            if (sibling.left.color == 1 && sibling.right.color == 1) {
                sibling.color = -1;
                node = node.parent;
                continue;
            }
            if (sibling.left.color == 1) {
                sibling.right.color = 1;
                sibling.color = -1;
                this.rotateLeft(sibling);
                sibling = node.parent.left;
            }
            sibling.color = sibling.parent.color;
            sibling.parent.color = 1;
            sibling.left.color = 1;
            this.rotateRight(node.parent);
            node = this.root;
        }
        node.color = 1;
    }

    public SortedMap subMap(Object fromKey, Object toKey) {
        if (this.compare(fromKey, toKey) <= 0) {
            return new SubMap(this, fromKey, toKey);
        }
        throw new IllegalArgumentException("fromKey > toKey");
    }

    public SortedMap headMap(Object toKey) {
        return new SubMap(this, this.nil, toKey);
    }

    public SortedMap tailMap(Object fromKey) {
        return new SubMap(this, fromKey, this.nil);
    }

    public Collection values() {
        return new AbstractCollection(this){
            private /* synthetic */ TreeMap this$0;
            {
                this.this$0 = this$0;
            }

            public int size() {
                return this.this$0.size;
            }

            public Iterator iterator() {
                return new TreeIterator(this.this$0, 2);
            }

            public void clear() {
                this.this$0.clear();
            }
        };
    }

    private Node highestLessThan(Object key) {
        if (key == this.nil) {
            return this.lastNode();
        }
        Node last = this.nil;
        Node current = this.root;
        int comparison = 0;
        while (current != this.nil) {
            last = current;
            comparison = this.compare(key, current.key);
            if (comparison > 0) {
                current = current.right;
                continue;
            }
            if (comparison < 0) {
                current = current.left;
                continue;
            }
            return this.predecessor(last);
        }
        if (comparison <= 0) {
            return this.predecessor(last);
        }
        return last;
    }

    private Node lowestGreaterThan(Object key) {
        if (key == this.nil) {
            return this.firstNode();
        }
        Node last = this.nil;
        Node current = this.root;
        int comparison = 0;
        while (current != this.nil) {
            last = current;
            comparison = this.compare(key, current.key);
            if (comparison > 0) {
                current = current.right;
                continue;
            }
            if (comparison < 0) {
                current = current.left;
                continue;
            }
            return current;
        }
        if (comparison > 0) {
            return this.successor(last);
        }
        return last;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        Node node = this.firstNode();
        out.writeInt(this.size);
        while (node != this.nil) {
            out.writeObject(node.key);
            out.writeObject(node.value);
            node = this.successor(node);
        }
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        int size = in.readInt();
        this.putFromObjStream(in, size, true);
    }

    private int compare(Object o1, Object o2) {
        if (this.comparator == null) {
            return ((Comparable)o1).compareTo(o2);
        }
        return this.comparator.compare(o1, o2);
    }

    private Node successor(Node node) {
        if (node.right != this.nil) {
            node = node.right;
            while (node.left != this.nil) {
                node = node.left;
            }
            return node;
        }
        Node parent = node.parent;
        while (parent != this.nil && node == parent.right) {
            node = parent;
            parent = parent.parent;
        }
        return parent;
    }

    private Node predecessor(Node node) {
        if (node.left != this.nil) {
            node = node.left;
            while (node.right != this.nil) {
                node = node.right;
            }
            return node;
        }
        Node parent = node.parent;
        while (parent != this.nil && node == parent.left) {
            node = parent;
            parent = parent.parent;
        }
        return parent;
    }

    private void rotateLeft(Node node) {
        Node child = node.right;
        node.right = child.left;
        if (child.left != this.nil) {
            child.left.parent = node;
        }
        child.parent = node.parent;
        if (node.parent != this.nil) {
            if (node == node.parent.left) {
                node.parent.left = child;
            } else {
                node.parent.right = child;
            }
        } else {
            this.root = child;
        }
        child.left = node;
        if (node != this.nil) {
            node.parent = child;
        }
    }

    private void rotateRight(Node node) {
        Node child = node.left;
        node.left = child.right;
        if (child.right != this.nil) {
            child.right.parent = node;
        }
        child.parent = node.parent;
        if (node.parent != this.nil) {
            if (node == node.parent.right) {
                node.parent.right = child;
            } else {
                node.parent.left = child;
            }
        } else {
            this.root = child;
        }
        child.right = node;
        if (node != this.nil) {
            node.parent = child;
        }
    }

    void putKeysLinear(Iterator keys, int count) {
        this.fabricateTree(count);
        Node node = this.firstNode();
        for (int i = 0; i < count; ++i) {
            node.key = keys.next();
            node.value = Boolean.TRUE;
            node = this.successor(node);
        }
    }

    void putFromObjStream(ObjectInputStream in, int count, boolean readValues) throws ClassNotFoundException, IOException {
        this.fabricateTree(count);
        Node node = this.firstNode();
        for (int i = 0; i < count; ++i) {
            node.key = in.readObject();
            node.value = readValues ? in.readObject() : Boolean.TRUE;
            node = this.successor(node);
        }
    }

    private void fabricateTree(int count) {
        if (count == 0) {
            return;
        }
        double ddepth = Math.log(count + 1) / Math.log(2.0);
        int maxdepth = (int)Math.ceil(ddepth);
        int max = (int)Math.pow(2.0, maxdepth - 1) - 1;
        int overflow = count - max;
        this.size = count;
        this.root = new Node(null, null);
        this.root.parent = this.nil;
        this.root.left = this.nil;
        this.root.right = this.nil;
        Node row = this.root;
        for (int depth = 2; depth <= maxdepth; ++depth) {
            Node node;
            int i;
            int rowcap = (int)Math.pow(2.0, depth - 1);
            Node parent = row;
            Node last = null;
            int rowsize = depth == maxdepth ? overflow : rowcap;
            boolean colorRowRed = depth % 2 == maxdepth % 2;
            for (i = 1; i <= rowsize; ++i) {
                node = new Node(null, null);
                node.parent = parent;
                if (i % 2 == 1) {
                    parent.left = node;
                } else {
                    Node nextparent = parent.right;
                    parent.right = node;
                    parent = nextparent;
                }
                if (last != null) {
                    last.right = node;
                }
                last = node;
                if (colorRowRed) {
                    node.color = -1;
                }
                if (i != 1) continue;
                row = node;
            }
            if (depth != maxdepth) continue;
            if (parent != null) {
                Node next;
                if (i % 2 == 0) {
                    next = parent.right;
                    parent.right = this.nil;
                    parent = next;
                }
                while (parent != null) {
                    parent.left = this.nil;
                    next = parent.right;
                    parent.right = this.nil;
                    parent = next;
                }
            }
            node = row;
            while (node != null) {
                node.left = this.nil;
                Node next = node.right;
                node.right = this.nil;
                node = next;
            }
        }
    }

    private void verifyTree() {
        if (this.root == this.nil) {
            System.err.println("Verify: empty tree");
            if (this.size != 0) {
                this.verifyError(this, "no root node but size=" + this.size);
            }
            return;
        }
        VerifyResult vr = this.verifySub(this.root);
        if (vr.count != this.size) {
            this.verifyError(this, "Tree size not consistent with actual nodes counted. counted " + vr.count + ", size=" + this.size);
            System.exit(1);
        }
        System.err.println("Verify: " + vr.count + " nodes, black height=" + vr.black + ", maxdepth=" + vr.maxdepth);
    }

    private VerifyResult verifySub(Node n) {
        VerifyResult vr1 = null;
        VerifyResult vr2 = null;
        if (n.left == this.nil && n.right == this.nil) {
            VerifyResult r = new VerifyResult(this);
            r.black = n.color == 1 ? 1 : 0;
            r.count = 1;
            r.maxdepth = 1;
            return r;
        }
        if (n.left != this.nil) {
            if (n.left.parent != n) {
                this.verifyError(n.left, "Node's parent link does not point to " + n);
            }
            if (n.color == -1 && n.left.color == -1) {
                this.verifyError(n, "Red node has red left child");
            }
            vr1 = this.verifySub(n.left);
            if (n.right == this.nil) {
                if (n.color == 1) {
                    ++vr1.black;
                }
                ++vr1.count;
                ++vr1.maxdepth;
                return vr1;
            }
        }
        if (n.right != this.nil) {
            if (n.right.parent != n) {
                this.verifyError(n.right, "Node's parent link does not point to " + n);
            }
            if (n.color == -1 && n.right.color == -1) {
                this.verifyError(n, "Red node has red right child");
            }
            vr2 = this.verifySub(n.right);
            if (n.left == this.nil) {
                if (n.color == 1) {
                    ++vr2.black;
                }
                ++vr2.count;
                ++vr2.maxdepth;
                return vr2;
            }
        }
        if (vr1.black != vr2.black) {
            this.verifyError(n, "Black heights: " + vr1.black + "," + vr2.black + " don't match.");
        }
        vr1.count += vr2.count + 1;
        vr1.maxdepth = Math.max(vr1.maxdepth, vr2.maxdepth) + 1;
        if (n.color == 1) {
            ++vr1.black;
        }
        return vr1;
    }

    private void verifyError(Object obj, String msg) {
        System.err.print("Verify error: ");
        try {
            System.err.print(obj);
        }
        catch (Exception x) {
            System.err.print("(error printing obj): " + x);
        }
        System.err.println();
        System.err.println(msg);
        Thread.dumpStack();
        System.exit(1);
    }

    class SubMap
    extends AbstractMap
    implements SortedMap {
        private /* synthetic */ TreeMap this$0;
        Object minKey;
        Object maxKey;

        static /* synthetic */ TreeMap access$1(SubMap inst$, TreeMap write_parm_value$) {
            inst$.this$0 = write_parm_value$;
            return inst$.this$0;
        }

        static TreeMap access$0(SubMap inst$) {
            return inst$.this$0;
        }

        SubMap(TreeMap this$0, Object minKey, Object maxKey) {
            this.this$0 = this$0;
            this.minKey = minKey;
            this.maxKey = maxKey;
        }

        public void clear() {
            Node current;
            Node next = this.this$0.lowestGreaterThan(this.minKey);
            Node max = this.this$0.highestLessThan(this.maxKey);
            if (this.this$0.compare(next.key, max.key) > 0) {
                return;
            }
            do {
                current = next;
                next = this.this$0.successor(current);
                this.remove(current);
            } while (current != max);
        }

        private boolean keyInRange(Object key) {
            return !(this.minKey != this.this$0.nil && this.this$0.compare(key, this.minKey) < 0 || this.maxKey != this.this$0.nil && this.this$0.compare(key, this.maxKey) >= 0);
        }

        public boolean containsKey(Object key) {
            return this.keyInRange(key) && this.this$0.containsKey(key);
        }

        public boolean containsValue(Object value) {
            Node node = this.this$0.lowestGreaterThan(this.minKey);
            Node max = this.this$0.highestLessThan(this.maxKey);
            if (node == this.this$0.nil || max == this.this$0.nil || this.this$0.compare(node.key, max.key) > 0) {
                return false;
            }
            while (true) {
                Object currentVal = node.getValue();
                if (value == null ? currentVal == null : value.equals(currentVal)) {
                    return true;
                }
                if (node == max) {
                    return false;
                }
                node = this.this$0.successor(node);
            }
        }

        public Object get(Object key) {
            if (this.keyInRange(key)) {
                return this.this$0.get(key);
            }
            return null;
        }

        public Object put(Object key, Object value) {
            if (this.keyInRange(key)) {
                return this.this$0.put(key, value);
            }
            throw new IllegalArgumentException("Key outside range");
        }

        public Object remove(Object key) {
            if (this.keyInRange(key)) {
                return this.this$0.remove(key);
            }
            return null;
        }

        public int size() {
            Node node = this.this$0.lowestGreaterThan(this.minKey);
            Node max = this.this$0.highestLessThan(this.maxKey);
            if (node == this.this$0.nil || max == this.this$0.nil || this.this$0.compare(node.key, max.key) > 0) {
                return 0;
            }
            int count = 1;
            while (node != max) {
                ++count;
                node = this.this$0.successor(node);
            }
            return count;
        }

        public Set entrySet() {
            return new AbstractSet(this){
                private /* synthetic */ SubMap this$1;
                {
                    this.this$1 = this$1;
                }

                public int size() {
                    return this.this$1.size();
                }

                public Iterator iterator() {
                    Node first = this.this$1.this$0.lowestGreaterThan(this.this$1.minKey);
                    Node max = this.this$1.this$0.highestLessThan(this.this$1.maxKey);
                    return new TreeIterator(SubMap.access$0(this.this$1), 0, first, max);
                }

                public void clear() {
                    this.clear();
                }

                public boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry me = (Map.Entry)o;
                    Object key = me.getKey();
                    if (!this.this$1.keyInRange(key)) {
                        return false;
                    }
                    Node n = this.this$1.this$0.getNode(key);
                    return n != SubMap.access$0((SubMap)this.this$1).nil && me.getValue().equals(n.value);
                }

                public boolean remove(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry me = (Map.Entry)o;
                    Object key = me.getKey();
                    if (!this.this$1.keyInRange(key)) {
                        return false;
                    }
                    Node n = this.this$1.this$0.getNode(key);
                    if (n != SubMap.access$0((SubMap)this.this$1).nil && me.getValue().equals(n.value)) {
                        this.this$1.this$0.removeNode(n);
                        return true;
                    }
                    return false;
                }
            };
        }

        public Comparator comparator() {
            return this.this$0.comparator;
        }

        public Object firstKey() {
            Node node = this.this$0.lowestGreaterThan(this.minKey);
            if (node == this.this$0.nil || !this.keyInRange(node.key)) {
                throw new NoSuchElementException("empty");
            }
            return node.key;
        }

        public Object lastKey() {
            Node node = this.this$0.highestLessThan(this.maxKey);
            if (node == this.this$0.nil || !this.keyInRange(node.key)) {
                throw new NoSuchElementException("empty");
            }
            return node.key;
        }

        public SortedMap subMap(Object fromKey, Object toKey) {
            if (!this.keyInRange(fromKey) || !this.keyInRange(toKey)) {
                throw new IllegalArgumentException("key outside range");
            }
            return this.this$0.subMap(fromKey, toKey);
        }

        public SortedMap headMap(Object toKey) {
            if (!this.keyInRange(toKey)) {
                throw new IllegalArgumentException("key outside range");
            }
            return this.this$0.subMap(this.minKey, toKey);
        }

        public SortedMap tailMap(Object fromKey) {
            if (!this.keyInRange(fromKey)) {
                throw new IllegalArgumentException("key outside range");
            }
            return this.this$0.subMap(fromKey, this.maxKey);
        }
    }

    class TreeIterator
    implements Iterator {
        private /* synthetic */ TreeMap this$0;
        static final int ENTRIES = 0;
        static final int KEYS = 1;
        static final int VALUES = 2;
        int type;
        int knownMod;
        Node last;
        Node next;
        Node max;

        private /* synthetic */ void finit$() {
            this.knownMod = this.this$0.modCount;
        }

        TreeIterator(TreeMap this$0, int type) {
            this.this$0 = this$0;
            this.finit$();
            this.type = type;
            this.next = this$0.firstNode();
        }

        TreeIterator(TreeMap this$0, int type, Node first, Node max) {
            this.this$0 = this$0;
            this.finit$();
            this.type = type;
            this.next = first;
            this.max = max;
        }

        public boolean hasNext() {
            if (this.knownMod != this.this$0.modCount) {
                throw new ConcurrentModificationException();
            }
            return this.next != this.this$0.nil;
        }

        public Object next() {
            if (this.next == this.this$0.nil) {
                throw new NoSuchElementException();
            }
            if (this.knownMod != this.this$0.modCount) {
                throw new ConcurrentModificationException();
            }
            Node n = this.next;
            this.next = n != this.max ? this.this$0.successor(n) : this.this$0.nil;
            this.last = n;
            if (this.type == 2) {
                return n.value;
            }
            if (this.type == 1) {
                return n.key;
            }
            return n;
        }

        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            if (this.knownMod != this.this$0.modCount) {
                throw new ConcurrentModificationException();
            }
            this.this$0.removeNode(this.last);
            ++this.knownMod;
            this.last = null;
        }
    }

    class VerifyResult {
        private /* synthetic */ TreeMap this$0;
        int count;
        int black;
        int maxdepth;

        VerifyResult(TreeMap this$0) {
            this.this$0 = this$0;
        }
    }

    static class Node
    extends BasicMapEntry
    implements Map.Entry {
        int color = 1;
        Node left;
        Node right;
        Node parent;

        Node(Object key, Object value) {
            super(key, value);
        }
    }
}

