/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSequentialList;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

public class Collections {
    public static final Set EMPTY_SET = new AbstractSet(null){
        private /* synthetic */ Collections this$0;
        {
            this.this$0 = this$0;
        }

        public int size() {
            return 0;
        }

        public Iterator iterator() {
            return EMPTY_LIST.iterator();
        }
    };
    public static final List EMPTY_LIST = new AbstractList(null){
        private /* synthetic */ Collections this$0;
        {
            this.this$0 = this$0;
        }

        public int size() {
            return 0;
        }

        public Object get(int index) {
            throw new IndexOutOfBoundsException();
        }
    };
    public static final Map EMPTY_MAP = new AbstractMap(null){
        private /* synthetic */ Collections this$0;
        {
            this.this$0 = this$0;
        }

        public Set entrySet() {
            return EMPTY_SET;
        }
    };
    static ReverseComparator rcInstance = new ReverseComparator();
    private static Random defaultRandom = null;

    static /* synthetic */ Class class$(String type$) {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    private Collections() {
    }

    private static int compare(Object o1, Object o2, Comparator c) {
        if (c == null) {
            return ((Comparable)o1).compareTo(o2);
        }
        return c.compare(o1, o2);
    }

    private static int search(List l, Object key, Comparator c) {
        int pos = 0;
        if (l instanceof AbstractSequentialList) {
            ListIterator itr = l.listIterator();
            for (int i = l.size() - 1; i >= 0; --i) {
                int d = Collections.compare(key, itr.next(), c);
                if (d == 0) {
                    return pos;
                }
                if (d < 0) {
                    return -pos - 1;
                }
                ++pos;
            }
        } else {
            int low = 0;
            int hi = l.size() - 1;
            while (low <= hi) {
                pos = low + hi >> 1;
                int d = Collections.compare(key, l.get(pos), c);
                if (d == 0) {
                    return pos;
                }
                if (d < 0) {
                    hi = pos - 1;
                    continue;
                }
                low = ++pos;
            }
        }
        return -pos - 1;
    }

    public static int binarySearch(List l, Object key) {
        return Collections.search(l, key, null);
    }

    public static int binarySearch(List l, Object key, Comparator c) {
        if (c == null) {
            throw new NullPointerException();
        }
        return Collections.search(l, key, c);
    }

    public static void copy(List dest, List source) {
        Iterator i1 = source.iterator();
        ListIterator i2 = dest.listIterator();
        try {
            for (int i = source.size() - 1; i >= 0; --i) {
                i2.next();
                i2.set(i1.next());
            }
        }
        catch (NoSuchElementException x) {
            throw new IndexOutOfBoundsException("Source doesn't fit in dest.");
        }
    }

    public static Enumeration enumeration(Collection c) {
        Iterator i = c.iterator();
        return new Enumeration(null, i){
            private /* synthetic */ Collections this$0;
            private /* synthetic */ Iterator val$i;
            {
                this.this$0 = this$0;
                this.finit$(parm$i);
            }

            private /* synthetic */ void finit$(Iterator parm$i) {
                this.val$i = parm$i;
            }

            public final boolean hasMoreElements() {
                return this.val$i.hasNext();
            }

            public final Object nextElement() {
                return this.val$i.next();
            }
        };
    }

    public static void fill(List l, Object val) {
        ListIterator itr = l.listIterator();
        for (int i = l.size() - 1; i >= 0; --i) {
            itr.next();
            itr.set(val);
        }
    }

    public static Object max(Collection c) {
        Iterator itr = c.iterator();
        Comparable max = (Comparable)itr.next();
        int csize = c.size();
        for (int i = 1; i < csize; ++i) {
            Object o = itr.next();
            if (max.compareTo(o) >= 0) continue;
            max = (Comparable)o;
        }
        return max;
    }

    public static Object max(Collection c, Comparator order) {
        Iterator itr = c.iterator();
        Object max = itr.next();
        int csize = c.size();
        for (int i = 1; i < csize; ++i) {
            Object o = itr.next();
            if (order.compare(max, o) >= 0) continue;
            max = o;
        }
        return max;
    }

    public static Object min(Collection c) {
        Iterator itr = c.iterator();
        Comparable min = (Comparable)itr.next();
        int csize = c.size();
        for (int i = 1; i < csize; ++i) {
            Object o = itr.next();
            if (min.compareTo(o) <= 0) continue;
            min = (Comparable)o;
        }
        return min;
    }

    public static Object min(Collection c, Comparator order) {
        Iterator itr = c.iterator();
        Object min = itr.next();
        int csize = c.size();
        for (int i = 1; i < csize; ++i) {
            Object o = itr.next();
            if (order.compare(min, o) <= 0) continue;
            min = o;
        }
        return min;
    }

    public static List nCopies(int n, Object o) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        return new AbstractList(null, n, o){
            private /* synthetic */ Collections this$0;
            private /* synthetic */ int val$n;
            private /* synthetic */ Object val$o;
            {
                this.this$0 = this$0;
                this.finit$(parm$n, parm$o);
            }

            private /* synthetic */ void finit$(int parm$n, Object parm$o) {
                this.val$o = parm$o;
                this.val$n = parm$n;
            }

            public int size() {
                return this.val$n;
            }

            public Object get(int index) {
                if (index < 0 || index >= this.val$n) {
                    throw new IndexOutOfBoundsException();
                }
                return this.val$o;
            }
        };
    }

    public static void reverse(List l) {
        int pos2;
        ListIterator i1 = l.listIterator();
        int pos1 = 0;
        ListIterator i2 = l.listIterator(pos2);
        for (pos2 = l.size(); pos1 < pos2; ++pos1, --pos2) {
            Object o = i1.next();
            i1.set(i2.previous());
            i2.set(o);
        }
    }

    public static Comparator reverseOrder() {
        return rcInstance;
    }

    public static void shuffle(List l) {
        if (defaultRandom == null) {
            Class clazz = Collections.class$("java.util.Collections");
            synchronized (clazz) {
                block4: {
                    try {
                        if (defaultRandom != null) break block4;
                        defaultRandom = new Random();
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        throw throwable;
                    }
                }
                Object var3_2 = null;
            }
        }
        Collections.shuffle(l, defaultRandom);
    }

    public static void shuffle(List l, Random r) {
        Object[] a = l.toArray();
        int lsize = l.size();
        ListIterator i = l.listIterator(lsize);
        for (int pos = lsize - 1; pos >= 0; --pos) {
            int swap = r.nextInt(pos + 1);
            Object o = a[swap];
            a[swap] = a[pos];
            a[pos] = o;
            i.previous();
            i.set(o);
        }
    }

    public static Set singleton(Object o) {
        return new AbstractSet(null, o){
            private /* synthetic */ Collections this$0;
            private /* synthetic */ Object val$o;
            {
                this.this$0 = this$0;
                this.finit$(parm$o);
            }

            private /* synthetic */ void finit$(Object parm$o) {
                this.val$o = parm$o;
            }

            static /* synthetic */ Object access$1(6 inst$, Object write_parm_value$) {
                inst$.val$o = write_parm_value$;
                return inst$.val$o;
            }

            public int size() {
                return 1;
            }

            public Iterator iterator() {
                return new Iterator(this){
                    private /* synthetic */ 6 this$1;
                    private boolean hasNext;
                    {
                        this.this$1 = this$1;
                        this.finit$();
                    }

                    private /* synthetic */ void finit$() {
                        this.hasNext = true;
                    }

                    public boolean hasNext() {
                        return this.hasNext;
                    }

                    public Object next() {
                        if (this.hasNext) {
                            this.hasNext = false;
                            return this.this$1.val$o;
                        }
                        throw new NoSuchElementException();
                    }

                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static List singletonList(Object o) {
        return new AbstractList(null, o){
            private /* synthetic */ Collections this$0;
            private /* synthetic */ Object val$o;
            {
                this.this$0 = this$0;
                this.finit$(parm$o);
            }

            private /* synthetic */ void finit$(Object parm$o) {
                this.val$o = parm$o;
            }

            public int size() {
                return 1;
            }

            public Object get(int index) {
                if (index == 0) {
                    throw new IndexOutOfBoundsException();
                }
                return this.val$o;
            }
        };
    }

    public static Map singletonMap(Object key, Object value) {
        return new AbstractMap(null, key, value){
            private /* synthetic */ Collections this$0;
            private /* synthetic */ Object val$key;
            private /* synthetic */ Object val$value;
            {
                this.this$0 = this$0;
                this.finit$(parm$key, parm$value);
            }

            private /* synthetic */ void finit$(Object parm$key, Object parm$value) {
                this.val$value = parm$value;
                this.val$key = parm$key;
            }

            public Set entrySet() {
                return Collections.singleton(new HashMap.Entry(this.val$key, this.val$value));
            }
        };
    }

    public static void sort(List l) {
        Object[] a = l.toArray();
        Arrays.sort(a);
        ListIterator i = l.listIterator();
        for (int pos = 0; pos < a.length; ++pos) {
            i.next();
            i.set(a[pos]);
        }
    }

    public static void sort(List l, Comparator c) {
        Object[] a = l.toArray();
        Arrays.sort(a, c);
        ListIterator i = l.listIterator();
        for (int pos = 0; pos < a.length; ++pos) {
            i.next();
            i.set(a[pos]);
        }
    }

    public static Collection synchronizedCollection(Collection c) {
        return new SynchronizedCollection(c);
    }

    public static List synchronizedList(List l) {
        return new SynchronizedList(l);
    }

    public static Map synchronizedMap(Map m) {
        return new SynchronizedMap(m);
    }

    public static Set synchronizedSet(Set s) {
        return new SynchronizedSet(s);
    }

    public static SortedMap synchronizedSortedMap(SortedMap m) {
        return new SynchronizedSortedMap(m);
    }

    public static SortedSet synchronizedSortedSet(SortedSet s) {
        return new SynchronizedSortedSet(s);
    }

    public static Collection unmodifiableCollection(Collection c) {
        return new UnmodifiableCollection(c);
    }

    public static List unmodifiableList(List l) {
        return new UnmodifiableList(l);
    }

    public static Map unmodifiableMap(Map m) {
        return new UnmodifiableMap(m);
    }

    public static Set unmodifiableSet(Set s) {
        return new UnmodifiableSet(s);
    }

    public static SortedMap unmodifiableSortedMap(SortedMap m) {
        return new UnmodifiableSortedMap(m);
    }

    public static SortedSet unmodifiableSortedSet(SortedSet s) {
        return new UnmodifiableSortedSet(s);
    }

    static class SynchronizedSortedMap
    extends SynchronizedMap
    implements SortedMap {
        private SortedMap sm;

        public SynchronizedSortedMap(Object sync, SortedMap sm) {
            super(sync, sm);
            this.sm = sm;
        }

        public SynchronizedSortedMap(SortedMap sm) {
            super(sm);
            this.sm = sm;
        }

        public Comparator comparator() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    Comparator comparator = this.sm.comparator();
                    Object var4_3 = null;
                    return comparator;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
        }

        public Object firstKey() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    Object object2 = this.sm.firstKey();
                    Object var4_3 = null;
                    return object2;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
        }

        public Object lastKey() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    Object object2 = this.sm.lastKey();
                    Object var4_3 = null;
                    return object2;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
        }

        public SortedMap headMap(Object toKey) {
            return new SynchronizedSortedMap(this.sync, this.sm.headMap(toKey));
        }

        public SortedMap tailMap(Object fromKey) {
            return new SynchronizedSortedMap(this.sync, this.sm.tailMap(fromKey));
        }

        public SortedMap subMap(Object fromKey, Object toKey) {
            return new SynchronizedSortedMap(this.sync, this.sm.subMap(fromKey, toKey));
        }
    }

    static class SynchronizedMap
    implements Map,
    Serializable {
        Object sync;
        Map m;

        public SynchronizedMap(Object sync, Map m) {
            this.sync = sync;
            this.m = m;
        }

        public SynchronizedMap(Map m) {
            this.m = m;
            this.sync = this;
        }

        public void clear() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    this.m.clear();
                }
                finally {
                    Object var3_2 = null;
                }
                return;
            }
        }

        public boolean containsKey(Object key) {
            Object object = this.sync;
            synchronized (object) {
                try {
                    boolean bl = this.m.containsKey(key);
                    Object var5_4 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    throw throwable;
                }
            }
        }

        public boolean containsValue(Object value) {
            Object object = this.sync;
            synchronized (object) {
                try {
                    boolean bl = this.m.containsValue(value);
                    Object var5_4 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    throw throwable;
                }
            }
        }

        public Set entrySet() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    SynchronizedSet synchronizedSet = new SynchronizedSet(this, this.sync, this.m.entrySet()){
                        private /* synthetic */ SynchronizedMap this$1;
                        {
                            this.this$1 = this$1;
                            super(parm0, parm1);
                        }

                        static SynchronizedMap access$0(13 inst$) {
                            return inst$.this$1;
                        }

                        public Iterator iterator() {
                            Object object = this.this$1.sync;
                            synchronized (object) {
                                try {
                                    SynchronizedIterator synchronizedIterator = new SynchronizedIterator(this, this.this$1.sync, this.c.iterator()){
                                        private /* synthetic */ 13 this$2;
                                        {
                                            this.this$2 = this$2;
                                            super(parm0, parm1);
                                        }

                                        static 13 access$0(14 inst$) {
                                            return inst$.this$2;
                                        }

                                        public Object next() {
                                            Object object = 13.access$0(this.this$2).sync;
                                            synchronized (object) {
                                                try {
                                                    Map.Entry e = (Map.Entry)super.next();
                                                    Map.Entry entry = new Map.Entry(this, e){
                                                        private /* synthetic */ 14 this$3;
                                                        private /* synthetic */ Map.Entry val$e;
                                                        {
                                                            this.this$3 = this$3;
                                                            this.finit$(parm$e);
                                                        }

                                                        private /* synthetic */ void finit$(Map.Entry parm$e) {
                                                            this.val$e = parm$e;
                                                        }

                                                        public Object getKey() {
                                                            Object object = 13.access$0(14.access$0(this.this$3)).sync;
                                                            synchronized (object) {
                                                                try {
                                                                    Object object2 = this.val$e.getKey();
                                                                    Object var4_3 = null;
                                                                    return object2;
                                                                }
                                                                catch (Throwable throwable) {
                                                                    Object var4_4 = null;
                                                                    throw throwable;
                                                                }
                                                            }
                                                        }

                                                        public Object getValue() {
                                                            Object object = 13.access$0(14.access$0(this.this$3)).sync;
                                                            synchronized (object) {
                                                                try {
                                                                    Object object2 = this.val$e.getValue();
                                                                    Object var4_3 = null;
                                                                    return object2;
                                                                }
                                                                catch (Throwable throwable) {
                                                                    Object var4_4 = null;
                                                                    throw throwable;
                                                                }
                                                            }
                                                        }

                                                        public Object setValue(Object value) {
                                                            Object object = 13.access$0(14.access$0(this.this$3)).sync;
                                                            synchronized (object) {
                                                                try {
                                                                    Object object2 = this.val$e.setValue(value);
                                                                    Object var5_4 = null;
                                                                    return object2;
                                                                }
                                                                catch (Throwable throwable) {
                                                                    Object var5_5 = null;
                                                                    throw throwable;
                                                                }
                                                            }
                                                        }

                                                        public int hashCode() {
                                                            Object object = 13.access$0(14.access$0(this.this$3)).sync;
                                                            synchronized (object) {
                                                                try {
                                                                    int n = this.val$e.hashCode();
                                                                    Object var4_3 = null;
                                                                    return n;
                                                                }
                                                                catch (Throwable throwable) {
                                                                    Object var4_4 = null;
                                                                    throw throwable;
                                                                }
                                                            }
                                                        }

                                                        public boolean equals(Object o) {
                                                            Object object = 13.access$0(14.access$0(this.this$3)).sync;
                                                            synchronized (object) {
                                                                try {
                                                                    boolean bl = this.val$e.equals(o);
                                                                    Object var5_4 = null;
                                                                    return bl;
                                                                }
                                                                catch (Throwable throwable) {
                                                                    Object var5_5 = null;
                                                                    throw throwable;
                                                                }
                                                            }
                                                        }
                                                    };
                                                    Object var4_5 = null;
                                                    return entry;
                                                }
                                                catch (Throwable throwable) {
                                                    Object var4_6 = null;
                                                    throw throwable;
                                                }
                                            }
                                        }
                                    };
                                    Object var4_3 = null;
                                    return synchronizedIterator;
                                }
                                catch (Throwable throwable) {
                                    Object var4_4 = null;
                                    throw throwable;
                                }
                            }
                        }
                    };
                    Object var4_3 = null;
                    return synchronizedSet;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
        }

        public boolean equals(Object o) {
            Object object = this.sync;
            synchronized (object) {
                try {
                    boolean bl = this.m.equals(o);
                    Object var5_4 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    throw throwable;
                }
            }
        }

        public Object get(Object key) {
            Object object = this.sync;
            synchronized (object) {
                try {
                    Object object2 = this.m.get(key);
                    Object var5_4 = null;
                    return object2;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    throw throwable;
                }
            }
        }

        public Object put(Object key, Object value) {
            Object object = this.sync;
            synchronized (object) {
                try {
                    Object object2 = this.m.put(key, value);
                    Object var6_5 = null;
                    return object2;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    throw throwable;
                }
            }
        }

        public int hashCode() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    int n = this.m.hashCode();
                    Object var4_3 = null;
                    return n;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
        }

        public boolean isEmpty() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    boolean bl = this.m.isEmpty();
                    Object var4_3 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
        }

        public Set keySet() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    SynchronizedSet synchronizedSet = new SynchronizedSet(this.sync, this.m.keySet());
                    Object var4_3 = null;
                    return synchronizedSet;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
        }

        public void putAll(Map map) {
            Object object = this.sync;
            synchronized (object) {
                try {
                    this.m.putAll(map);
                }
                finally {
                    Object var4_3 = null;
                }
                return;
            }
        }

        public Object remove(Object o) {
            Object object = this.sync;
            synchronized (object) {
                try {
                    Object object2 = this.m.remove(o);
                    Object var5_4 = null;
                    return object2;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    throw throwable;
                }
            }
        }

        public int size() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    int n = this.m.size();
                    Object var4_3 = null;
                    return n;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
        }

        public Collection values() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    SynchronizedCollection synchronizedCollection = new SynchronizedCollection(this.sync, this.m.values());
                    Object var4_3 = null;
                    return synchronizedCollection;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
        }

        public String toString() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    String string = this.m.toString();
                    Object var4_3 = null;
                    return string;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
        }
    }

    static class SynchronizedSortedSet
    extends SynchronizedSet
    implements SortedSet {
        private SortedSet ss;

        public SynchronizedSortedSet(Object sync, SortedSet ss) {
            super(sync, ss);
            this.ss = ss;
        }

        public SynchronizedSortedSet(SortedSet ss) {
            super(ss);
            this.ss = ss;
        }

        public Comparator comparator() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    Comparator comparator = this.ss.comparator();
                    Object var4_3 = null;
                    return comparator;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
        }

        public Object first() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    Object object2 = this.ss.first();
                    Object var4_3 = null;
                    return object2;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
        }

        public Object last() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    Object object2 = this.ss.last();
                    Object var4_3 = null;
                    return object2;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
        }

        public SortedSet headSet(Object toElement) {
            Object object = this.sync;
            synchronized (object) {
                try {
                    SynchronizedSortedSet synchronizedSortedSet = new SynchronizedSortedSet(this.sync, this.ss.headSet(toElement));
                    Object var5_4 = null;
                    return synchronizedSortedSet;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    throw throwable;
                }
            }
        }

        public SortedSet tailSet(Object fromElement) {
            Object object = this.sync;
            synchronized (object) {
                try {
                    SynchronizedSortedSet synchronizedSortedSet = new SynchronizedSortedSet(this.sync, this.ss.tailSet(fromElement));
                    Object var5_4 = null;
                    return synchronizedSortedSet;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    throw throwable;
                }
            }
        }

        public SortedSet subSet(Object fromElement, Object toElement) {
            Object object = this.sync;
            synchronized (object) {
                try {
                    SynchronizedSortedSet synchronizedSortedSet = new SynchronizedSortedSet(this.sync, this.ss.subSet(fromElement, toElement));
                    Object var6_5 = null;
                    return synchronizedSortedSet;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    throw throwable;
                }
            }
        }
    }

    static class SynchronizedSet
    extends SynchronizedCollection
    implements Set {
        public SynchronizedSet(Object sync, Set s) {
            super(sync, s);
        }

        public SynchronizedSet(Set s) {
            super(s);
        }

        public boolean equals(Object o) {
            Object object = this.sync;
            synchronized (object) {
                try {
                    boolean bl = this.c.equals(o);
                    Object var5_4 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    throw throwable;
                }
            }
        }

        public int hashCode() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    int n = this.c.hashCode();
                    Object var4_3 = null;
                    return n;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
        }
    }

    static class SynchronizedList
    extends SynchronizedCollection
    implements List {
        List l;

        public SynchronizedList(Object sync, List l) {
            super(sync, l);
            this.l = l;
        }

        public SynchronizedList(List l) {
            super(l);
            this.l = l;
        }

        public void add(int index, Object o) {
            Object object = this.sync;
            synchronized (object) {
                try {
                    this.l.add(index, o);
                }
                finally {
                    Object var5_4 = null;
                }
                return;
            }
        }

        public boolean addAll(int index, Collection c) {
            Object object = this.sync;
            synchronized (object) {
                try {
                    boolean bl = this.l.addAll(index, c);
                    Object var6_5 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    throw throwable;
                }
            }
        }

        public boolean equals(Object o) {
            Object object = this.sync;
            synchronized (object) {
                try {
                    boolean bl = this.l.equals(o);
                    Object var5_4 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    throw throwable;
                }
            }
        }

        public Object get(int index) {
            Object object = this.sync;
            synchronized (object) {
                try {
                    Object object2 = this.l.get(index);
                    Object var5_4 = null;
                    return object2;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    throw throwable;
                }
            }
        }

        public int hashCode() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    int n = this.l.hashCode();
                    Object var4_3 = null;
                    return n;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
        }

        public int indexOf(Object o) {
            Object object = this.sync;
            synchronized (object) {
                try {
                    int n = this.l.indexOf(o);
                    Object var5_4 = null;
                    return n;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    throw throwable;
                }
            }
        }

        public int lastIndexOf(Object o) {
            Object object = this.sync;
            synchronized (object) {
                try {
                    int n = this.l.lastIndexOf(o);
                    Object var5_4 = null;
                    return n;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    throw throwable;
                }
            }
        }

        public ListIterator listIterator() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    SynchronizedListIterator synchronizedListIterator = new SynchronizedListIterator(this.sync, this.l.listIterator());
                    Object var4_3 = null;
                    return synchronizedListIterator;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
        }

        public ListIterator listIterator(int index) {
            Object object = this.sync;
            synchronized (object) {
                try {
                    SynchronizedListIterator synchronizedListIterator = new SynchronizedListIterator(this.sync, this.l.listIterator(index));
                    Object var5_4 = null;
                    return synchronizedListIterator;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    throw throwable;
                }
            }
        }

        public Object remove(int index) {
            Object object = this.sync;
            synchronized (object) {
                try {
                    Object object2 = this.l.remove(index);
                    Object var5_4 = null;
                    return object2;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    throw throwable;
                }
            }
        }

        public boolean remove(Object o) {
            Object object = this.sync;
            synchronized (object) {
                try {
                    boolean bl = this.l.remove(o);
                    Object var5_4 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    throw throwable;
                }
            }
        }

        public Object set(int index, Object o) {
            Object object = this.sync;
            synchronized (object) {
                try {
                    Object object2 = this.l.set(index, o);
                    Object var6_5 = null;
                    return object2;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    throw throwable;
                }
            }
        }

        public List subList(int fromIndex, int toIndex) {
            Object object = this.sync;
            synchronized (object) {
                try {
                    SynchronizedList synchronizedList = new SynchronizedList(this.l.subList(fromIndex, toIndex));
                    Object var6_5 = null;
                    return synchronizedList;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    throw throwable;
                }
            }
        }
    }

    static class SynchronizedCollection
    implements Collection,
    Serializable {
        Object sync;
        Collection c;

        public SynchronizedCollection(Collection c) {
            this.sync = this;
            this.c = c;
        }

        public SynchronizedCollection(Object sync, Collection c) {
            this.c = c;
            this.sync = sync;
        }

        public boolean add(Object o) {
            Object object = this.sync;
            synchronized (object) {
                try {
                    boolean bl = this.c.add(o);
                    Object var5_4 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    throw throwable;
                }
            }
        }

        public boolean addAll(Collection col) {
            Object object = this.sync;
            synchronized (object) {
                try {
                    boolean bl = this.c.addAll(col);
                    Object var5_4 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    throw throwable;
                }
            }
        }

        public void clear() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    this.c.clear();
                }
                finally {
                    Object var3_2 = null;
                }
                return;
            }
        }

        public boolean contains(Object o) {
            Object object = this.sync;
            synchronized (object) {
                try {
                    boolean bl = this.c.contains(o);
                    Object var5_4 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    throw throwable;
                }
            }
        }

        public boolean containsAll(Collection c1) {
            Object object = this.sync;
            synchronized (object) {
                try {
                    boolean bl = this.c.containsAll(c1);
                    Object var5_4 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    throw throwable;
                }
            }
        }

        public boolean isEmpty() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    boolean bl = this.c.isEmpty();
                    Object var4_3 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
        }

        public Iterator iterator() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    SynchronizedIterator synchronizedIterator = new SynchronizedIterator(this.sync, this.c.iterator());
                    Object var4_3 = null;
                    return synchronizedIterator;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
        }

        public boolean remove(Object o) {
            Object object = this.sync;
            synchronized (object) {
                try {
                    boolean bl = this.c.remove(o);
                    Object var5_4 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    throw throwable;
                }
            }
        }

        public boolean removeAll(Collection col) {
            Object object = this.sync;
            synchronized (object) {
                try {
                    boolean bl = this.c.removeAll(col);
                    Object var5_4 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    throw throwable;
                }
            }
        }

        public boolean retainAll(Collection col) {
            Object object = this.sync;
            synchronized (object) {
                try {
                    boolean bl = this.c.retainAll(col);
                    Object var5_4 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    throw throwable;
                }
            }
        }

        public int size() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    int n = this.c.size();
                    Object var4_3 = null;
                    return n;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
        }

        public Object[] toArray() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    Object[] objectArray = this.c.toArray();
                    Object var4_3 = null;
                    return objectArray;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
        }

        public Object[] toArray(Object[] a) {
            Object object = this.sync;
            synchronized (object) {
                try {
                    Object[] objectArray = this.c.toArray(a);
                    Object var5_4 = null;
                    return objectArray;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    throw throwable;
                }
            }
        }

        public String toString() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    String string = this.c.toString();
                    Object var4_3 = null;
                    return string;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
        }
    }

    static class SynchronizedListIterator
    extends SynchronizedIterator
    implements ListIterator {
        private ListIterator li;

        public SynchronizedListIterator(Object sync, ListIterator li) {
            super(sync, li);
            this.li = li;
        }

        public boolean hasPrevious() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    boolean bl = this.li.hasPrevious();
                    Object var4_3 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
        }

        public Object previous() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    Object object2 = this.li.previous();
                    Object var4_3 = null;
                    return object2;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
        }

        public int nextIndex() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    int n = this.li.nextIndex();
                    Object var4_3 = null;
                    return n;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
        }

        public int previousIndex() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    int n = this.li.previousIndex();
                    Object var4_3 = null;
                    return n;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
        }

        public void add(Object o) {
            Object object = this.sync;
            synchronized (object) {
                try {
                    this.li.add(o);
                }
                finally {
                    Object var4_3 = null;
                }
                return;
            }
        }

        public void set(Object o) {
            Object object = this.sync;
            synchronized (object) {
                try {
                    this.li.set(o);
                }
                finally {
                    Object var4_3 = null;
                }
                return;
            }
        }
    }

    static class SynchronizedIterator
    implements Iterator {
        Object sync;
        private Iterator i;

        public SynchronizedIterator(Object sync, Iterator i) {
            this.sync = sync;
            this.i = i;
        }

        public Object next() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    Object object2 = this.i.next();
                    Object var4_3 = null;
                    return object2;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
        }

        public boolean hasNext() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    boolean bl = this.i.hasNext();
                    Object var4_3 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
        }

        public void remove() {
            Object object = this.sync;
            synchronized (object) {
                try {
                    this.i.remove();
                }
                finally {
                    Object var3_2 = null;
                }
                return;
            }
        }
    }

    static class UnmodifiableSortedMap
    extends UnmodifiableMap
    implements SortedMap {
        private SortedMap sm;

        public UnmodifiableSortedMap(SortedMap sm) {
            super(sm);
            this.sm = sm;
        }

        public Comparator comparator() {
            return this.sm.comparator();
        }

        public Object firstKey() {
            return this.sm.firstKey();
        }

        public Object lastKey() {
            return this.sm.lastKey();
        }

        public SortedMap headMap(Object toKey) {
            return new UnmodifiableSortedMap(this.sm.headMap(toKey));
        }

        public SortedMap tailMap(Object fromKey) {
            return new UnmodifiableSortedMap(this.sm.tailMap(fromKey));
        }

        public SortedMap subMap(Object fromKey, Object toKey) {
            return new UnmodifiableSortedMap(this.sm.subMap(fromKey, toKey));
        }
    }

    static class UnmodifiableMap
    implements Map,
    Serializable {
        Map m;

        public UnmodifiableMap(Map m) {
            this.m = m;
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean containsKey(Object key) {
            return this.m.containsKey(key);
        }

        public boolean containsValue(Object value) {
            return this.m.containsValue(value);
        }

        public Set entrySet() {
            return new UnmodifiableSet(this, this.m.entrySet()){
                private /* synthetic */ UnmodifiableMap this$1;
                {
                    this.this$1 = this$1;
                    super(parm0);
                }

                static UnmodifiableMap access$0(10 inst$) {
                    return inst$.this$1;
                }

                public Iterator iterator() {
                    return new UnmodifiableIterator(this, this.c.iterator()){
                        private /* synthetic */ 10 this$2;
                        {
                            this.this$2 = this$2;
                            super(parm0);
                        }

                        public Object next() {
                            Map.Entry e = (Map.Entry)super.next();
                            return new Map.Entry(this, e){
                                private /* synthetic */ 11 this$3;
                                private /* synthetic */ Map.Entry val$e;
                                {
                                    this.this$3 = this$3;
                                    this.finit$(parm$e);
                                }

                                private /* synthetic */ void finit$(Map.Entry parm$e) {
                                    this.val$e = parm$e;
                                }

                                public Object getKey() {
                                    return this.val$e.getKey();
                                }

                                public Object getValue() {
                                    return this.val$e.getValue();
                                }

                                public Object setValue(Object value) {
                                    throw new UnsupportedOperationException();
                                }

                                public int hashCode() {
                                    return this.val$e.hashCode();
                                }

                                public boolean equals(Object o) {
                                    return this.val$e.equals(o);
                                }
                            };
                        }
                    };
                }
            };
        }

        public boolean equals(Object o) {
            return this.m.equals(o);
        }

        public Object get(Object key) {
            return this.m.get(key);
        }

        public Object put(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        public int hashCode() {
            return this.m.hashCode();
        }

        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        public Set keySet() {
            return new UnmodifiableSet(this.m.keySet());
        }

        public void putAll(Map m) {
            throw new UnsupportedOperationException();
        }

        public Object remove(Object o) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return this.m.size();
        }

        public Collection values() {
            return new UnmodifiableCollection(this.m.values());
        }

        public String toString() {
            return this.m.toString();
        }
    }

    static class UnmodifiableSortedSet
    extends UnmodifiableSet
    implements SortedSet {
        private SortedSet ss;

        public UnmodifiableSortedSet(SortedSet ss) {
            super(ss);
            this.ss = ss;
        }

        public Comparator comparator() {
            return this.ss.comparator();
        }

        public Object first() {
            return this.ss.first();
        }

        public Object last() {
            return this.ss.last();
        }

        public SortedSet headSet(Object toElement) {
            return new UnmodifiableSortedSet(this.ss.headSet(toElement));
        }

        public SortedSet tailSet(Object fromElement) {
            return new UnmodifiableSortedSet(this.ss.tailSet(fromElement));
        }

        public SortedSet subSet(Object fromElement, Object toElement) {
            return new UnmodifiableSortedSet(this.ss.subSet(fromElement, toElement));
        }
    }

    static class UnmodifiableSet
    extends UnmodifiableCollection
    implements Set {
        public UnmodifiableSet(Set s) {
            super(s);
        }

        public boolean equals(Object o) {
            return this.c.equals(o);
        }

        public int hashCode() {
            return this.c.hashCode();
        }
    }

    static class UnmodifiableList
    extends UnmodifiableCollection
    implements List {
        List l;

        public UnmodifiableList(List l) {
            super(l);
            this.l = l;
        }

        public void add(int index, Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int index, Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object o) {
            return this.l.equals(o);
        }

        public Object get(int index) {
            return this.l.get(index);
        }

        public int hashCode() {
            return this.l.hashCode();
        }

        public int indexOf(Object o) {
            return this.l.indexOf(o);
        }

        public int lastIndexOf(Object o) {
            return this.l.lastIndexOf(o);
        }

        public ListIterator listIterator() {
            return new UnmodifiableListIterator(this.l.listIterator());
        }

        public ListIterator listIterator(int index) {
            return new UnmodifiableListIterator(this.l.listIterator(index));
        }

        public Object remove(int index) {
            throw new UnsupportedOperationException();
        }

        public Object set(int index, Object o) {
            throw new UnsupportedOperationException();
        }

        public List subList(int fromIndex, int toIndex) {
            return new UnmodifiableList(this.l.subList(fromIndex, toIndex));
        }
    }

    static class UnmodifiableCollection
    implements Collection,
    Serializable {
        Collection c;

        public UnmodifiableCollection(Collection c) {
            this.c = c;
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean contains(Object o) {
            return this.c.contains(o);
        }

        public boolean containsAll(Collection c1) {
            return this.c.containsAll(c1);
        }

        public boolean isEmpty() {
            return this.c.isEmpty();
        }

        public Iterator iterator() {
            return new UnmodifiableIterator(this.c.iterator());
        }

        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return this.c.size();
        }

        public Object[] toArray() {
            return this.c.toArray();
        }

        public Object[] toArray(Object[] a) {
            return this.c.toArray(a);
        }

        public String toString() {
            return this.c.toString();
        }
    }

    static class UnmodifiableListIterator
    extends UnmodifiableIterator
    implements ListIterator {
        private ListIterator li;

        public UnmodifiableListIterator(ListIterator li) {
            super(li);
            this.li = li;
        }

        public boolean hasPrevious() {
            return this.li.hasPrevious();
        }

        public Object previous() {
            return this.li.previous();
        }

        public int nextIndex() {
            return this.li.nextIndex();
        }

        public int previousIndex() {
            return this.li.previousIndex();
        }

        public void add(Object o) {
            throw new UnsupportedOperationException();
        }

        public void set(Object o) {
            throw new UnsupportedOperationException();
        }
    }

    static class UnmodifiableIterator
    implements Iterator {
        private Iterator i;

        public UnmodifiableIterator(Iterator i) {
            this.i = i;
        }

        public Object next() {
            return this.i.next();
        }

        public boolean hasNext() {
            return this.i.hasNext();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class ReverseComparator
    implements Comparator,
    Serializable {
        public int compare(Object a, Object b) {
            return -((Comparable)a).compareTo(b);
        }

        ReverseComparator() {
        }
    }
}

