/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.CollationKey;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.Comparator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class Collator
implements Comparator,
Cloneable {
    public static final int NO_DECOMPOSITION = 0;
    public static final int CANONICAL_DECOMPOSITION = 1;
    public static final int FULL_DECOMPOSITION = 2;
    public static final int PRIMARY = 0;
    public static final int SECONDARY = 1;
    public static final int TERTIARY = 2;
    public static final int IDENTICAL = 3;
    int decmp = 1;
    int strength = 2;

    protected Collator() {
    }

    public abstract int compare(String var1, String var2);

    public int compare(Object o1, Object o2) {
        return this.compare((String)o1, (String)o2);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Collator)) {
            return false;
        }
        Collator c = (Collator)obj;
        return this.decmp == c.decmp && this.strength == c.strength;
    }

    public boolean equals(String source, String target) {
        return this.compare(source, target) == 0;
    }

    public Object clone() {
        return super.clone();
    }

    public static synchronized Locale[] getAvailableLocales() {
        return null;
    }

    public abstract CollationKey getCollationKey(String var1);

    public synchronized int getDecomposition() {
        return this.decmp;
    }

    public static Collator getInstance() {
        return Collator.getInstance(Locale.getDefault());
    }

    public static Collator getInstance(Locale loc) {
        String pattern;
        try {
            ResourceBundle res = ResourceBundle.getBundle("gnu.gcj.text.LocaleData", loc);
            pattern = res.getString("collatorRule");
        }
        catch (MissingResourceException x) {
            return null;
        }
        try {
            return new RuleBasedCollator(pattern);
        }
        catch (ParseException x) {
            return null;
        }
    }

    public synchronized int getStrength() {
        return this.strength;
    }

    public abstract int hashCode();

    public synchronized void setDecomposition(int mode) {
        if (mode != 0 && mode != 1 && mode != 2) {
            throw new IllegalArgumentException();
        }
        this.decmp = mode;
    }

    public synchronized void setStrength(int strength) {
        if (strength != 0 && strength != 1 && strength != 2 && strength != 3) {
            throw new IllegalArgumentException();
        }
        this.strength = strength;
    }

    final native void decomposeCharacter(char var1, StringBuffer var2);
}

