/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;

public abstract class KeyPairGenerator
extends KeyPairGeneratorSpi {
    private String name;

    protected KeyPairGenerator(String algorithm) {
        this.name = algorithm;
    }

    public static KeyPairGenerator getInstance(String algorithm) throws NoSuchAlgorithmException {
        String name = "KeyPairGenerator." + algorithm;
        Provider[] provs = Security.getProviders();
        for (int i = 0; i < provs.length; ++i) {
            String val = provs[i].getProperty(name);
            if (val == null) continue;
            try {
                return (KeyPairGenerator)Class.forName(val).newInstance();
            }
            catch (Throwable _) {
                // empty catch block
            }
        }
        throw new NoSuchAlgorithmException(algorithm);
    }

    public static KeyPairGenerator getInstance(String algorithm, String provider) throws NoSuchProviderException, NoSuchAlgorithmException {
        String name = "KeyPairGenerator." + algorithm;
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException(provider);
        }
        String val = p.getProperty(name);
        if (val != null) {
            try {
                return (KeyPairGenerator)Class.forName(val).newInstance();
            }
            catch (Throwable _) {
                // empty catch block
            }
        }
        throw new NoSuchAlgorithmException(algorithm);
    }

    public String getAlgorithm() {
        return this.name;
    }

    public abstract void initialize(int var1, SecureRandom var2);

    public abstract KeyPair generateKeyPair();
}

