/*
 * Decompiled with CFR 0.152.
 */
package gnu.gcj.text;

import gnu.gcj.text.BaseBreakIterator;
import java.text.CharacterIterator;

public class CharacterBreakIterator
extends BaseBreakIterator {
    private static final int LBase = 4352;
    private static final int VBase = 4449;
    private static final int TBase = 4519;
    private static final int LCount = 19;
    private static final int VCount = 21;
    private static final int TCount = 28;
    private static final int highSurrogateStart = 55296;
    private static final int highSurrogateEnd = 56319;
    private static final int lowSurrogateStart = 56320;
    private static final int lowSurrogateEnd = 57343;

    public Object clone() {
        return new CharacterBreakIterator(this);
    }

    public CharacterBreakIterator() {
        this.iter = null;
    }

    private CharacterBreakIterator(CharacterBreakIterator other) {
        this.iter = (CharacterIterator)other.iter.clone();
    }

    private final boolean isL(char c) {
        return c > '\u10ff' && c <= '\u1113';
    }

    private final boolean isV(char c) {
        return c > '\u1160' && c <= '\u1176';
    }

    private final boolean isT(char c) {
        return c > '\u11a6' && c <= '\u11c3';
    }

    private final boolean isLVT(char c) {
        return this.isL(c) || this.isV(c) || this.isT(c);
    }

    private final boolean isHighSurrogate(char c) {
        return c > '\ud7ff' && c <= '\udbff';
    }

    private final boolean isLowSurrogate(char c) {
        return c > '\udbff' && c <= '\udfff';
    }

    public int next() {
        int type;
        char c;
        int end = this.iter.getEndIndex();
        if (this.iter.getIndex() == end) {
            return -1;
        }
        char prev = '\uffff';
        while (this.iter.getIndex() < end && (c = this.iter.next()) != '\uffff' && (type = Character.getType(c)) != 14) {
            int aheadType;
            char ahead = this.iter.next();
            this.iter.previous();
            if (ahead == '\uffff' || (aheadType = Character.getType(ahead)) != 6 && !this.isLowSurrogate(ahead) && !this.isLVT(ahead) || !this.isLVT(c) && this.isLVT(ahead) || this.isL(c) && !this.isLVT(ahead) && aheadType != 6 || this.isV(c) && !this.isV(ahead) && !this.isT(ahead) && aheadType != 6 || this.isT(c) && !this.isT(ahead) && aheadType != 6 || !this.isHighSurrogate(c) && this.isLowSurrogate(ahead) || this.isHighSurrogate(c) && !this.isLowSurrogate(ahead) || !this.isHighSurrogate(prev) && this.isLowSurrogate(c)) break;
            prev = c;
        }
        return this.iter.getIndex();
    }

    public int previous() {
        int type;
        char c;
        if (this.iter.getIndex() == this.iter.getBeginIndex()) {
            return -1;
        }
        int start = this.iter.getBeginIndex();
        while (this.iter.getIndex() >= this.iter.getBeginIndex() && (c = this.iter.previous()) != '\uffff' && ((type = Character.getType(c)) == 6 || this.isLowSurrogate(c) || this.isLVT(c))) {
            int aheadType;
            char ahead = this.iter.previous();
            if (ahead == '\uffff') {
                this.iter.next();
                break;
            }
            char ahead2 = this.iter.previous();
            this.iter.next();
            this.iter.next();
            if (!(ahead2 == '\uffff' || (aheadType = Character.getType(ahead)) == 14 || this.isLVT(c) && !this.isLVT(ahead) || !this.isLVT(c) && type != 6 && this.isL(ahead) || !this.isV(c) && !this.isT(c) && type != 6 && this.isV(ahead) || !this.isT(c) && type != 6 && this.isT(ahead) || this.isLowSurrogate(c) && !this.isHighSurrogate(ahead) || !this.isLowSurrogate(c) && this.isHighSurrogate(ahead)) && (!this.isLowSurrogate(ahead) || this.isHighSurrogate(ahead2))) continue;
            break;
        }
        return this.iter.getIndex();
    }
}

