/*
 * Decompiled with CFR 0.152.
 */
package gnu.gcj.awt;

import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;

public final class Buffers {
    public static DataBuffer createBuffer(int dataType, Object data, int size) {
        if (data == null) {
            return Buffers.createBuffer(dataType, size, 1);
        }
        return Buffers.createBufferFromData(dataType, data, size);
    }

    public static DataBuffer createBuffer(int dataType, int size) {
        return Buffers.createBuffer(dataType, size, 1);
    }

    public static DataBuffer createBuffer(int dataType, int size, int numBanks) {
        switch (dataType) {
            case 0: {
                return new DataBufferByte(size, numBanks);
            }
            case 1: {
                return new DataBufferUShort(size, numBanks);
            }
            case 3: {
                return new DataBufferInt(size, numBanks);
            }
        }
        throw new UnsupportedOperationException();
    }

    public static DataBuffer createBufferFromData(int dataType, Object data, int size) {
        switch (dataType) {
            case 0: {
                return new DataBufferByte((byte[])data, size);
            }
            case 1: {
                return new DataBufferUShort((short[])data, size);
            }
            case 3: {
                return new DataBufferInt((int[])data, size);
            }
        }
        throw new UnsupportedOperationException();
    }

    public static Object getData(DataBuffer buffer) {
        if (buffer instanceof DataBufferByte) {
            return ((DataBufferByte)buffer).getData();
        }
        if (buffer instanceof DataBufferUShort) {
            return ((DataBufferUShort)buffer).getData();
        }
        if (buffer instanceof DataBufferInt) {
            return ((DataBufferInt)buffer).getData();
        }
        throw new ClassCastException("Unknown data buffer type");
    }

    public static Object getData(DataBuffer src, int srcOffset, Object dest, int destOffset, int length) {
        Object[] from;
        if (src instanceof DataBufferByte) {
            from = ((DataBufferByte)src).getData();
            if (dest == null) {
                dest = new byte[length + destOffset];
            }
        } else if (src instanceof DataBufferUShort) {
            from = ((DataBufferUShort)src).getData();
            if (dest == null) {
                dest = new short[length + destOffset];
            }
        } else if (src instanceof DataBufferInt) {
            from = ((DataBufferInt)src).getData();
            if (dest == null) {
                dest = new int[length + destOffset];
            }
        } else {
            throw new ClassCastException("Unknown data buffer type");
        }
        System.arraycopy(from, srcOffset, dest, destOffset, length);
        return dest;
    }

    public static int smallestAppropriateTransferType(int bits) {
        if (bits <= 8) {
            return 0;
        }
        if (bits <= 16) {
            return 1;
        }
        if (bits <= 32) {
            return 3;
        }
        return 32;
    }
}

