# CFLAGS and library paths for XMPS
# HEAVILY based on the one from XMPS

dnl Usage:
dnl AM_PATH_XMPS([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]]])
dnl
dnl Example:
dnl AM_PATH_XMPS(0.1.1, , AC_MSG_ERROR([*** XMPS >= 0.1.1 not installed - please install first ***]))
dnl
dnl Defines XMPS_CFLAGS, XMPS_LIBS, XMPS_DATA_DIR, XMPS_PLUGIN_DIR, 
dnl XMPS_INPUT_PLUGIN_DIR, 
dnl XMPS_OUTPUT_PLUGIN_DIR,
dnl and XMPS_VERSION for your plugin pleasure.
dnl

AC_DEFUN(XMPS_TEST_VERSION, [

# Determine which version number is greater. Prints 2 to stdout if	
# the second number is greater, 1 if the first number is greater,	
# 0 if the numbers are equal.						
									
# Written 15 December 1999 by Ben Gertzfield <che@debian.org>		
# Revised 15 December 1999 by Jim Monty <monty@primenet.com>		
									
    AC_PROG_AWK
    xmps_got_version=[` $AWK '						\
BEGIN {									\
    print vercmp(ARGV[1], ARGV[2]);					\
}									\
									\
function vercmp(ver1, ver2,    ver1arr, ver2arr,			\
                               ver1len, ver2len,			\
                               ver1int, ver2int, len, i, p) {		\
									\
    ver1len = split(ver1, ver1arr, /\./);				\
    ver2len = split(ver2, ver2arr, /\./);				\
									\
    len = ver1len > ver2len ? ver1len : ver2len;			\
									\
    for (i = 1; i <= len; i++) {					\
        p = 1000 ^ (len - i);						\
        ver1int += ver1arr[i] * p;					\
        ver2int += ver2arr[i] * p;					\
    }									\
									\
    if (ver1int < ver2int)						\
        return 2;							\
    else if (ver1int > ver2int)						\
        return 1;							\
    else								\
        return 0;							\
}' $1 $2`]								

    if test $xmps_got_version -eq 2; then 	# failure
	ifelse([$4], , :, $4)			
    else  					# success!
	ifelse([$3], , :, $3)
    fi
])

AC_DEFUN(AM_PATH_XMPS,
[
AC_ARG_WITH(xmps-prefix,[  --with-xmps-prefix=PFX  Prefix where XMPS is installed (optional)],
	xmps_config_prefix="$withval", xmps_config_prefix="")
AC_ARG_WITH(xmps-exec-prefix,[  --with-xmps-exec-prefix=PFX Exec prefix where XMPS is installed (optional)],
	xmps_config_exec_prefix="$withval", xmps_config_exec_prefix="")

if test x$xmps_config_exec_prefix != x; then
    xmps_config_args="$xmps_config_args --exec-prefix=$xmps_config_exec_prefix"
    if test x${XMPS_CONFIG+set} != xset; then
	XMPS_CONFIG=$xmps_config_exec_prefix/bin/xmps-config
    fi
fi

if test x$xmps_config_prefix != x; then
    xmps_config_args="$xmps_config_args --prefix=$xmps_config_prefix"
    if test x${XMPS_CONFIG+set} != xset; then
  	XMPS_CONFIG=$xmps_config_prefix/bin/xmps-config
    fi
fi

AC_PATH_PROG(XMPS_CONFIG, xmps-config, no)
min_xmps_version=ifelse([$1], ,0.1.1, $1)

if test "$XMPS_CONFIG" = "no"; then
    no_xmps=yes
else
    XMPS_CFLAGS=`$XMPS_CONFIG $xmps_config_args --cflags`
    XMPS_LIBS=`$XMPS_CONFIG $xmps_config_args --libs`
    XMPS_VERSION=`$XMPS_CONFIG $xmps_config_args --version`
    XMPS_DATA_DIR=`$XMPS_CONFIG $xmps_config_args --data-dir`
    XMPS_PLUGIN_DIR=`$XMPS_CONFIG $xmps_config_args --plugin-dir`
    XMPS_INPUT_PLUGIN_DIR=`$XMPS_CONFIG $xmps_config_args --input-plugin-dir`
    XMPS_OUTPUT_PLUGIN_DIR=`$XMPS_CONFIG $xmps_config_args --output-plugin-dir`

    XMPS_TEST_VERSION($XMPS_VERSION, $min_xmps_version, ,no_xmps=version)
fi

AC_MSG_CHECKING(for XMPS - version >= $min_xmps_version)

if test "x$no_xmps" = x; then
    AC_MSG_RESULT(yes)
    ifelse([$2], , :, [$2])
else
    AC_MSG_RESULT(no)

    if test "$XMPS_CONFIG" = "no" ; then
	echo "*** The xmps-config script installed by XMPS could not be found."
      	echo "*** If XMPS was installed in PREFIX, make sure PREFIX/bin is in"
	echo "*** your path, or set the XMPS_CONFIG environment variable to the"
	echo "*** full path to xmps-config."
    else
	if test "$no_xmps" = "version"; then
	    echo "*** An old version of XMPS, $XMPS_VERSION, was found."
	    echo "*** You need a version of XMPS newer than $min_xmps_version."
	    echo "*** The latest version of XMPS is always available from"
	    echo "*** http://www.xmps.org/"
	    echo "***"

            echo "*** If you have already installed a sufficiently new version, this error"
            echo "*** probably means that the wrong copy of the xmps-config shell script is"
            echo "*** being found. The easiest way to fix this is to remove the old version"
            echo "*** of XMPS, but you can also set the XMPS_CONFIG environment to point to the"
            echo "*** correct copy of xmps-config. (In this case, you will have to"
            echo "*** modify your LD_LIBRARY_PATH enviroment variable, or edit /etc/ld.so.conf"
            echo "*** so that the correct libraries are found at run-time)"
	fi
    fi
    XMPS_CFLAGS=""
    XMPS_LIBS=""
    ifelse([$3], , :, [$3])
fi
AC_SUBST(XMPS_CFLAGS)
AC_SUBST(XMPS_LIBS)
AC_SUBST(XMPS_VERSION)
AC_SUBST(XMPS_DATA_DIR)
AC_SUBST(XMPS_PLUGIN_DIR)
AC_SUBST(XMPS_VISUALIZATION_PLUGIN_DIR)
AC_SUBST(XMPS_INPUT_PLUGIN_DIR)
AC_SUBST(XMPS_OUTPUT_PLUGIN_DIR)
AC_SUBST(XMPS_GENERAL_PLUGIN_DIR)
AC_SUBST(XMPS_EFFECT_PLUGIN_DIR)
])
