/*  XMPS - X MPEG Player System
 *  Copyright (C) 1999 Damien Chavarria
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef MPEG3TITLE_H
#define MPEG3TITLE_H

#include "mpeg3io.h"

typedef struct {

  long   start_byte;
  double start_time;
  double absolute_start_time;
  double absolute_end_time;
  long   end_byte;
  double end_time;
  int    program;

} mpeg3demux_timecode_t;

typedef struct {

  void                   *file;
  mpeg3_fs_t            *fs;
  long                   total_bytes;
  mpeg3demux_timecode_t *timecode_table;
  long                   timecode_table_size;
  long                   timecode_table_allocation;

} mpeg3_title_t;

#endif
