/*  XMPS - X MPEG Player System
 *  Copyright (C) 1999 Damien Chavarria
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef MPEG3PRIVATE_H
#define MPEG3PRIVATE_H

#include "mpeg3atrack.h"
#include "mpeg3io.h"
#include "mpeg3private.inc"
#include "mpeg3title.h"
#include "mpeg3vtrack.h"
#include "mpeg3strack.h"


#define MPEG3_RGB565 2
#define MPEG3_BGR888 0
#define MPEG3_BGRA8888 1
#define MPEG3_RGB888 3
#define MPEG3_RGBA8888 4
#define MPEG3_RGBA16161616 5
#define MPEG3_601_RGB565 11
#define MPEG3_601_BGR888 7
#define MPEG3_601_BGRA8888 8
#define MPEG3_601_RGB888 9
#define MPEG3_601_RGBA8888 10

typedef struct {

  mpeg3_fs_t      *fs;
  mpeg3_demuxer_t *demuxer;

  int              has_audio;
  int              has_video;
  int              has_subtitles;

  int              total_astreams;
  int              total_vstreams;
  int              total_sstreams;

  mpeg3_atrack_t  *atrack[MPEG3_MAX_STREAMS];
  mpeg3_vtrack_t  *vtrack[MPEG3_MAX_STREAMS];
  mpeg3_strack_t  *strack[MPEG3_MAX_STREAMS];

  int              is_transport_stream;
  int              is_program_stream;

  int              is_audio_stream; 
  int              is_video_stream;     
  int              is_subtitle_stream;

  long             packet_size;
  int              last_type_read; 
  int              last_stream_read;
  int              program; 
  int              cpus;
  int              have_mmx;

  int              subtitle_time;
  int              video_time;

} mpeg3_t;




#endif
