/*  XMPS - X MPEG Player System
 *  Copyright (C) 1999 Damien Chavarria
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef MPEG3DEMUX_H
#define MPEG3DEMUX_H

#include "mpeg3title.h"
#include <stdio.h>

typedef struct {

  void* file;
  unsigned char *raw_data;
  long raw_offset;
  int raw_size;
  long packet_size;
  int do_audio;
  int do_video;
  int do_subtitles;
  unsigned char *data_buffer;
  long data_size;
  long data_position;
  long data_allocated;
  int reverse;
  int error_flag;
  unsigned char next_char;
  double time_offset;
  int generating_timecode;
  mpeg3_title_t *titles[MPEG3_MAX_STREAMS];
  int total_titles;
  int current_title;
  int astream_table[MPEG3_MAX_STREAMS];
  int vstream_table[MPEG3_MAX_STREAMS];
  int sstream_table[MPEG3_MAX_STREAMS];
  int total_programs;
  int current_program;
  int current_timecode;
  long current_byte;
  int transport_error_indicator;
  int payload_unit_start_indicator;
  int pid;
  int transport_scrambling_control;
  int adaptation_field_control;
  int continuity_counter;
  int is_padding;
  int pid_table[MPEG3_PIDMAX];
  int continuity_counters[MPEG3_PIDMAX];
  int total_pids;
  int adaptation_fields;
  double time;  
  int audio_pid;
  int video_pid;
  int astream;  
  int vstream;
  int sstream;
  int aformat;  
  long program_association_tables;
  int table_id;
  int section_length;
  int transport_stream_id;
  long pes_packets;
  double pes_audio_time;
  double pes_video_time;
  
} mpeg3_demuxer_t;

#define mpeg3demux_error(demuxer)        (((mpeg3_demuxer_t *)(demuxer))->error_flag)

#define mpeg3demux_time_offset(demuxer)  (((mpeg3_demuxer_t *)(demuxer))->time_offset)

#define mpeg3demux_current_time(demuxer) (((mpeg3_demuxer_t *)(demuxer))->time + ((mpeg3_demuxer_t *)(demuxer))->time_offset)

#define mpeg3demux_read_char(demuxer) \
    ((((mpeg3_demuxer_t *)(demuxer))->data_position < ((mpeg3_demuxer_t *)(demuxer))->data_size) ? \
    ((mpeg3_demuxer_t *)(demuxer))->data_buffer[((mpeg3_demuxer_t *)(demuxer))->data_position++] : \
    mpeg3demux_read_char_packet(demuxer))

#define mpeg3demux_read_prev_char(demuxer) \
    ((((mpeg3_demuxer_t *)(demuxer))->data_position != 0) ? \
    ((mpeg3_demuxer_t *)(demuxer))->data_buffer[((mpeg3_demuxer_t *)(demuxer))->data_position--] : \
    mpeg3demux_read_prev_char_packet(demuxer))


#endif
