/*  XMPS - X MPEG Player System
 *  Copyright (C) 1999 Damien Chavarria
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * dummy_system.c : dummy system plugin.
 *
 */

/*********************************************************************
 *                             INCLUDES                              *
 *********************************************************************/

/*
 * includes : local
 *
 */

#include "dummy_system.h"

/*********************************************************************
 *                             VARIABLES                             *
 *********************************************************************/

typedef struct {

  xmps_media_plugin_t     *our_media;
  xmps_data_t             *data_stream;
  GList                   *output_list;
  unsigned int             buffer_size;
  double                   frame_rate;

} dummy_system_t;

/*********************************************************************
 *                            FUNCTIONS                              *
 *********************************************************************/

/*
 * get_system_info : MANDATORY
 *
 * Used by the plugin_center to get a pointer to the system object.
 *
 */

xmps_system_plugin_t *get_system_info(void)
{
  xmps_system_plugin_t *system;

  system = (xmps_system_plugin_t *) malloc(sizeof(xmps_system_plugin_t));

  system->name = "DUMMY";
  system->data = (void *) malloc(sizeof(dummy_system_t));

  system->open  = dummy_open;
  system->get   = dummy_get;
  system->set   = dummy_set;
  system->read  = dummy_read;
  system->seek  = dummy_seek;
  system->write = dummy_write;
  system->close = dummy_close;

  ((dummy_system_t *) system->data)->our_media   = NULL;
  ((dummy_system_t *) system->data)->data_stream = (xmps_data_t *) malloc(sizeof(xmps_data_t));
  ((dummy_system_t *) system->data)->output_list = NULL;
  ((dummy_system_t *) system->data)->buffer_size = 0;



  return system;
}


/*
 * dummy_open
 *
 * - try to open a media.
 *
 */

unsigned int dummy_open(xmps_system_plugin_t *system) //unsigned int flag, void *p_center, xmps_media_plugin *media)
{
  if(system == NULL) {
    return 0;
  }

  return 1;
}

/*
 * dummy_set_info
 *
 */

unsigned int dummy_set(xmps_system_plugin_t *system, unsigned int flag, void *data)
{
  
  if(system == NULL) {
    return 0;
  }
  
  switch(flag)
    {

    case XMPS_FLAG_INPUT:
      {
	xmps_data_t *data_stream;

	data_stream = (xmps_data_t *) data;

	if(data_stream != NULL && data_stream->type == XMPS_DATA_RAW && data_stream->plugin_type == XMPS_PLUGIN_MEDIA) {
	  
	  XMPS_DEBUG("we accept %s media", 
		     ((xmps_media_plugin_t *) data_stream->plugin)->name);

	  ((dummy_system_t *) system->data)->our_media = (xmps_media_plugin_t *) data_stream->plugin;
	  
	  return 1;
	}

	return 0;
      }
      break;
      
    default:
      break;
  }

  return 0;
}

/*
 * dummy_get_info
 *
 *
 */

void *dummy_get(xmps_system_plugin_t *system, unsigned int flag, void *data)
{
  if(system == NULL) {
    return NULL;
  }

  switch(flag)
    {
    case XMPS_FLAG_VIDEO_BUFFER_SIZE:

      return &((dummy_system_t *) system->data)->buffer_size;
      break;

    case XMPS_FLAG_FRAMERATE:

      ((dummy_system_t *) system->data)->frame_rate = 25;
      return (void *) &((dummy_system_t *) system->data)->frame_rate;
      break;

    case XMPS_FLAG_OUTPUT_LIST:
      {
	if( ((dummy_system_t *) system->data)->our_media != NULL ) {
	  
	  /*
	   * re-init output list
	   *
	   */

	  ((dummy_system_t *) system->data)->output_list = NULL;

	  /*
	   * fill data structure
	   *
	   */

	  ((dummy_system_t *) system->data)->data_stream->id          = 0;
	  ((dummy_system_t *) system->data)->data_stream->type        = XMPS_DATA_RAW;

	  ((dummy_system_t *) system->data)->data_stream->plugin_type = XMPS_PLUGIN_SYSTEM;
	  ((dummy_system_t *) system->data)->data_stream->plugin      = (void *) system;

	  /*
	   * and add the output data
	   *
	   */

	  ((dummy_system_t *) system->data)->output_list = g_list_prepend(((dummy_system_t *) system->data)->output_list, 
									  ((dummy_system_t *) system->data)->data_stream);
	
	  return (void *) ((dummy_system_t *) system->data)->output_list;
	}
      }
      break;

    default:
      break;
    }

  return NULL;
}

/*
 * dummy_read
 *
 */

int dummy_read(xmps_system_plugin_t *system, 
			unsigned int stream_id, 
			void *buffer, 
			long size)
{
  if(system == NULL || ((dummy_system_t *) system->data)->our_media == NULL)
    return -1;
  
  return ((dummy_system_t *) system->data)->our_media->read(((dummy_system_t *) system->data)->our_media, buffer, size);
}

/*
 * dummy_seek
 *
 */

unsigned int dummy_seek(xmps_system_plugin_t *system, 
			unsigned int stream_id, 
			unsigned int pos, 
			xmps_seeking_method_t method)
{
  if(system == NULL || ((dummy_system_t *) system->data)->our_media == NULL) {
    return 0;
  }

  switch(method)
    {
    case XMPS_SEEK_PERCENT:
      break;
    default:
      return ((dummy_system_t *) system->data)->our_media->seek(((dummy_system_t *) system->data)->our_media, pos, method);
      break;
    }

  return 0;
}

/*
 * dummy_write
 *
 */

unsigned int dummy_write(xmps_system_plugin_t *system, 
			 unsigned int data_id, 
			 const void *buffer, 
			 unsigned int size)
{
  return 0;
}

/*
 * dummy_close
 *
 */

unsigned int dummy_close(xmps_system_plugin_t *system)
{
  if(system == NULL) {
    return 0;
  }

  if(((dummy_system_t *) system->data)->our_media != NULL)
    {
      ((dummy_system_t *) system->data)->our_media->close(((dummy_system_t *) system->data)->our_media);
      ((dummy_system_t *) system->data)->our_media = NULL;
    }

  return 1;
}





