/*  XMPS - X MPEG Player System
 *  Copyright (C) 1999 Damien Chavarria
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/**
 *
 * sdl_audio_renderer.h
 *
 * SDL Audio Renderer.
 * @Author Chavarria Damien.
 * 	   Copyright 1999-2000
 */

#ifndef _SDL_AUDIO_RENDERER_H
#define _SDL_AUDIO_RENDERER_H

/*********************************************************************
 *                             INCLUDES                              *
 *********************************************************************/

#include "libxmps/libxmps.h"

#include <SDL/SDL.h>
#include <string.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

/*********************************************************************
 *                            FUNCTIONS                              *
 *********************************************************************/

unsigned int sdl_audio_open (xmps_audio_renderer_plugin_t *audio_renderer);
void*        sdl_audio_get  (xmps_audio_renderer_plugin_t *audio_renderer, unsigned int flag, void* data);
unsigned int sdl_audio_set  (xmps_audio_renderer_plugin_t *audio_renderer, unsigned int flag, void *data);
unsigned int sdl_audio_write(xmps_audio_renderer_plugin_t *audio_renderer, const void *buffer, unsigned int size);
unsigned int sdl_audio_start(xmps_audio_renderer_plugin_t *audio_renderer);
unsigned int sdl_audio_close(xmps_audio_renderer_plugin_t *audio_renderer);

#endif


