/*  XMPS - X MPEG Player System
 *  Copyright (C) 1999 Damien Chavarria
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * http_media.h : definitions for the http media.
 *
 */

#ifndef _XMPS_HTTP_H
#define _XMPS_HTTP_H

/*********************************************************************
 *                             INCLUDES                              *
 *********************************************************************/

#include "libxmps/libxmps.h"
#include <unistd.h>
#include <fcntl.h> 
#include <string.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/socket.h>
#include <arpa/inet.h>

/*********************************************************************
 *                             FUNCTIONS                             *
 *********************************************************************/

unsigned int http_open (xmps_media_plugin_t *media, char *full_path);
void*        http_get  (xmps_media_plugin_t *media, unsigned int flag, void *data);
unsigned int http_set  (xmps_media_plugin_t *media, unsigned int flag, void *data);
unsigned int http_read (xmps_media_plugin_t *media, void *buffer, unsigned int size);
unsigned int http_seek (xmps_media_plugin_t *media, long pos, xmps_seeking_method_t method);
unsigned int http_write(xmps_media_plugin_t *media, const void *buffer, unsigned int size);
unsigned int http_close(xmps_media_plugin_t *media);

#endif
