/*  XMPS - X MPEG Player System
 *  Copyright (C) 1999 Damien Chavarria
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * xmps_item.c : playlist items functions.
 *
 */

/* includes */

#include <stdlib.h>
#include <string.h>
#include "libxmpsutils.h"

/* functions */

xmps_item_t *xmps_item_new(xmps_media_types_t type, char *full_path)
{
  xmps_item_t *item;

  item            = (xmps_item_t *) malloc(sizeof(xmps_item_t));
  item->type      = type;
  item->selected  = 0;

  switch(type)
    {
    case XMPS_MEDIA_FILE:

      item->full_path = (char *) malloc(strlen(full_path) + 8);
      sprintf(item->full_path, "FILE://%s", full_path);
      
      item->display_name =  strrchr(full_path, '/') + 1;

      if(item->display_name == NULL)
	item->display_name = full_path;

      break;
    case XMPS_MEDIA_VCD:
      break;
      
    case XMPS_MEDIA_HTTP:
      
      item->full_path = (char *) malloc(strlen(full_path) + 8);
      sprintf(item->full_path, "%s", full_path);
      
      item->display_name = full_path;

      break;

    default:
      break;
    }
  return item;
}
