/*  XMPS - X MPEG Player System
 *  Copyright (C) 1999 Damien Chavarria
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/**
 *
 * xmps_gtk_config.c
 *
 * XMPS Video Adapter
 * @Author Chavarria Damien.
 * 	   Copyright 1999-2000
 */

#include <xmps_gtk_config.h>

typedef struct _xmps_config_node_t {

  GtkWidget *panel;
  GList     *xml;
  char      *plugin;
  struct    _xmps_config_node_t *next;

} xmps_config_node_t;

typedef struct {

  GtkWidget *widget1;
  GtkWidget *widget2;

} gtk_config_double;

/* variables */

static GtkWidget *xmps_config;
static GtkWidget *tree1;
static GtkWidget *hpaned1;
static GtkWidget *empty_frame;
static GtkWidget *viewport2;

xmps_config_node_t *config_node;

/*
 * config nodes functions
 *
 */

xmps_config_node_t *xmps_config_node_new(GtkWidget *panel, GList *xml, char *plugin)
{
  xmps_config_node_t *node;

  node = (xmps_config_node_t *) malloc(sizeof(xmps_config_node_t));

  node->panel  = panel;
  node->xml    = xml;
  node->plugin = plugin;

  node->next = NULL;

  return node;
}

xmps_config_node_t *xmps_config_node_prepend(xmps_config_node_t *new, xmps_config_node_t *old)
{
  new->next = old;
  return new;
}

GList *xmps_config_node_get_xml(char *plugin, xmps_config_node_t *node)
{
  GList *xml = NULL;
  xmps_config_node_t *n;

  for(n = node; n!= NULL; n = n->next) {

    if(strstr(n->plugin, plugin) != NULL) {
      xml = n->xml;
      break;
    }
  }
  
  return xml;
}

GtkWidget *xmps_config_node_get_panel(char *plugin, xmps_config_node_t *node)
{
  GtkWidget *w = NULL;
  xmps_config_node_t *n;

  for(n = node; n!= NULL; n = n->next) {

    if(strstr(n->plugin, plugin) != NULL) {
      w = n->panel;
      break;
    }
  }
  
  return w;  
}

/* 
 * callbacks
 *
 */

GList *gtk_config_get_values(char *pname) 
{
  GtkWidget                    *panel;
  char                         *name;
  GtkWidget                    *item;
  char                         *control;
  int                           integer;
  char                         *string;
  GList                        *xmls, *xml_item, *xml_dest;
  
  panel = xmps_config_node_get_panel(pname, config_node);
  xmls  = xmps_config_node_get_xml  (pname, config_node);
    
  XMPS_DEBUG("saving attributes for %s", pname);

  xml_dest = NULL;

  for(xml_item = xmls; xml_item != NULL; xml_item = g_list_next(xml_item)) {
      
    char *x_item;
    
    x_item = (char *) xml_item->data; 
    
    name =  xmps_xml_get_value(x_item, "name");
    
    item = (GtkWidget*) gtk_object_get_data (GTK_OBJECT (panel),
					     name);
    
    if(item == NULL) {
      XMPS_DEBUG("problem saving config with %s", name);
      return NULL;
    }
    
    control = xmps_xml_get_value(x_item, "control");
    
    if(strstr(control, "checkbox") != NULL) {
      
      integer = GTK_TOGGLE_BUTTON(item)->active;
      
      XMPS_DEBUG("%s value = %d", name, integer);
      
      /*
       * now add it to the be-saved xml
       */
      
      xml_dest = g_list_prepend( xml_dest, (void *) xmps_xml_config_entry_int_new(name, integer, "", ""));
      
    }
    else {
      
      if(strstr(control, "entry") != NULL || strstr(control, "dir") != NULL) {
	
	string = gtk_entry_get_text(GTK_ENTRY(item));
	
	XMPS_DEBUG("%s value = %s", name, string);
	
	/*
	 * now add it to the be-saved xml
	 */
	
	xml_dest = g_list_prepend( xml_dest, (void *) xmps_xml_config_entry_string_new(name, string, "", ""));
	
      }
    }
  }

  return xml_dest;
}

void gtk_config_ok (GtkButton       *button,
		    gpointer         user_data)
{
  xmps_session_t *session;
  GList          *node;
  
  session = (xmps_session_t *) user_data;

  if(session == NULL) {
    
    XMPS_DEBUG("param is no good");
    return;
  }

  //
  // video decoders
  //

  for(node = session->plugin_center->video_decoder_plugins_list; node != NULL; node = g_list_next(node)) {

    xmps_video_decoder_plugin_t *d;
    GList                       *xml_dest;

    /*
     * get the panel
     */
    
    d = (xmps_video_decoder_plugin_t *) node->data;
    xml_dest = gtk_config_get_values(d->name);
      
    /*
     * and send it back to plugin
     */
    
    d->set(d, XMPS_FLAG_XML_CONFIG,  (void *) xml_dest);
    d->set(d, XMPS_FLAG_SAVE_CONFIG, (void *) session->plugin_center->config_file);
  }

  //
  // video renderers
  //

  for(node = session->plugin_center->video_renderer_plugins_list; node != NULL; node = g_list_next(node)) {

    xmps_video_renderer_plugin_t *v;
    GList                        *xml_dest;

    /*
     * get the panel
     */
    
    v = (xmps_video_renderer_plugin_t *) node->data;
    xml_dest = gtk_config_get_values(v->name);
      
    /*
     * and send it back to plugin
     */
    
    v->set(v, XMPS_FLAG_XML_CONFIG,  (void *) xml_dest);
    v->set(v, XMPS_FLAG_SAVE_CONFIG, (void *) session->plugin_center->config_file);
  }
  
  gtk_container_remove(GTK_CONTAINER (viewport2), 
		       (GtkWidget *) gtk_container_children(GTK_CONTAINER (viewport2))->data);
  
  gtk_container_add (GTK_CONTAINER (viewport2), empty_frame);
}

void gtk_config_cancel (GtkButton       *button,
			gpointer         user_data)
{
  /*
   * switch back to empty frame
   *
   */

  gtk_container_remove(GTK_CONTAINER (viewport2), 
		       (GtkWidget *) gtk_container_children(GTK_CONTAINER (viewport2))->data);

  gtk_container_add (GTK_CONTAINER (viewport2), empty_frame);

}

void gtk_config_dir_ok(GtkWidget *w, gpointer item)
{
  char *dir;

  gtk_widget_hide(((gtk_config_double *) item)->widget1);
  
  dir = gtk_file_selection_get_filename(GTK_FILE_SELECTION(((gtk_config_double *) item)->widget1));

  if(dir[strlen(dir) - 1] == '/') {
    dir[strlen(dir) - 1] = '\0';
  }

  gtk_entry_set_text(GTK_ENTRY(((gtk_config_double *) item)->widget2), dir);
}

void gtk_config_dir_cancel(GtkWidget *w, GtkFileSelection *fs)
{
  gtk_widget_hide((GtkWidget *) fs);
}

void gtk_browse_clicked(GtkButton       *button,
			gpointer         user_data)
{
  gtk_widget_show(GTK_WIDGET(user_data));
}

void gtk_config_close (GtkButton       *button,
		       gpointer         user_data)
{
  xmps_gtk_config_hide();
  gtk_widget_destroy(xmps_config);
}

void display_item_callback( GtkWidget *item,
			    gpointer   panel )
{
  gtk_container_remove(GTK_CONTAINER (viewport2), 
		       (GtkWidget *) gtk_container_children(GTK_CONTAINER (viewport2))->data);

  if(panel != NULL) {
 
    XMPS_DEBUG("switching");
    gtk_container_add (GTK_CONTAINER (viewport2), (GtkWidget *) panel);
  }
  else {
    gtk_container_add (GTK_CONTAINER (viewport2), empty_frame);
  }
}

GtkWidget *gtk_get_config_panel_from_xml(GList *xml, char *plugin_name)
{
  GtkWidget *panel;
  GtkWidget *vbox1;
  GtkWidget *item;
  GtkWidget *pad;
  char      *control;
  char      *label;
  char      *name;
  char      *value;
  GList     *xml_node;
  char      *xml_data;
  gtk_config_double *c_double;

  XMPS_DEBUG("creating configuration for %s", plugin_name);

  panel = gtk_frame_new (g_strconcat(" Options for ", plugin_name, ": ", NULL) );
  gtk_container_set_border_width (GTK_CONTAINER (panel), 4);
  gtk_widget_ref (panel);
  gtk_widget_show (panel);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox1);
  gtk_object_set_data_full (GTK_OBJECT (panel), "vbox1", vbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox1);
  gtk_container_set_border_width (GTK_CONTAINER (vbox1), 5);
  gtk_container_add (GTK_CONTAINER (panel), vbox1);

  for(xml_node = xml; xml_node != NULL; xml_node = g_list_next(xml_node)) {

    xml_data = (char *) xml_node->data;

    if(xml_data == NULL) {

      XMPS_DEBUG("problem in xml data!");
      return NULL;
    }

    XMPS_DEBUG("processing %s", xml_data);

    name    = xmps_xml_get_value(xml_data, "name");
    label   = xmps_xml_get_value(xml_data, "label");
    control = xmps_xml_get_value(xml_data, "control");
    value   = xmps_xml_get_value(xml_data, "value");

    /*
     * check box
     *
     */

    if(control != NULL && strstr(control, "checkbox") != NULL && label != NULL) {

      int val;

      item = gtk_check_button_new_with_label(label);
      gtk_widget_ref (item);
      gtk_object_set_data_full (GTK_OBJECT (panel), name, item,
				(GtkDestroyNotify) gtk_widget_unref);
      
      sscanf(value, "%d", &val);

      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(item),
				    val);

      gtk_widget_show(item);

      gtk_box_pack_start (GTK_BOX (vbox1), item, FALSE, TRUE, 3);
    
    }
    else {
   
      if(control != NULL && strstr(control, "entry") != NULL && label != NULL) {
	
	GtkWidget *vbox;
	GtkWidget *label_item;

	/*
	 * text entry
	 *
	 */
      
	vbox = gtk_vbox_new (FALSE, 0);
	gtk_widget_show(vbox);

	XMPS_DEBUG("label = %s", label);

	label_item = gtk_label_new(label);
	gtk_widget_show(label_item);
	gtk_label_set_justify   (GTK_LABEL(label_item),
				 GTK_JUSTIFY_LEFT);
	gtk_misc_set_alignment (GTK_MISC (label_item), 0, 0.5);

	gtk_box_pack_start (GTK_BOX (vbox), label_item, FALSE, TRUE, 3);

	item = gtk_entry_new();
	gtk_widget_ref (item);
	gtk_object_set_data_full (GTK_OBJECT (panel), name, item,
				  (GtkDestroyNotify) gtk_widget_unref);
	
	gtk_entry_set_text(GTK_ENTRY(item),
			   value);
	gtk_widget_show(item);
	
	gtk_box_pack_start (GTK_BOX (vbox), item, FALSE, TRUE, 3);

	gtk_box_pack_start (GTK_BOX (vbox1), vbox, FALSE, TRUE, 2);

      }
      else {
	
	if(control != NULL && strstr(control, "dir") != NULL && label != NULL) {
	  
	  GtkWidget *vbox;
	  GtkWidget *hbox;
	  GtkWidget *button;
	  GtkWidget *label_item;
	  GtkFileSelection *fs;

	  /*
	   * dir entry
	   *
	   */
	  
	  vbox = gtk_vbox_new (FALSE, 0);
	  gtk_widget_show(vbox);
	  
	  XMPS_DEBUG("label = %s", label);
	  
	  label_item = gtk_label_new(label);
	  gtk_widget_show(label_item);
	  gtk_label_set_justify   (GTK_LABEL(label_item),
				   GTK_JUSTIFY_LEFT);
	  gtk_misc_set_alignment (GTK_MISC (label_item), 0, 0.5);
	  
	  gtk_box_pack_start (GTK_BOX (vbox), label_item, FALSE, TRUE, 3);
	  
	  hbox = gtk_hbox_new (FALSE, 0);
	  gtk_widget_show(hbox);
	  
	  item = gtk_entry_new();
	  gtk_widget_ref (item);
	  gtk_object_set_data_full (GTK_OBJECT (panel), name, item,
				    (GtkDestroyNotify) gtk_widget_unref);
	  
	  gtk_entry_set_text(GTK_ENTRY(item),
			     value);

	  gtk_widget_show(item);
	  
	  gtk_box_pack_start (GTK_BOX (hbox), item, TRUE, TRUE, 3);
	  
	  button = gtk_button_new_with_label(" Browse... ");
	  gtk_widget_show(button);

	  gtk_box_pack_start (GTK_BOX (hbox), button, FALSE, TRUE, 3);
	  
	  gtk_box_pack_start (GTK_BOX (vbox),  hbox, FALSE, TRUE, 2);
	  gtk_box_pack_start (GTK_BOX (vbox1), vbox, FALSE, TRUE, 2);
	  
	  /*
	   * the file selection
	   *
	   */

	  fs = (GtkFileSelection *) gtk_file_selection_new("Select Directory...");
	  
	  gtk_widget_set_sensitive( GTK_WIDGET(GTK_FILE_SELECTION(fs)->file_list),
				    FALSE );
	  
	  c_double = (gtk_config_double *) malloc(sizeof(gtk_config_double));
	  
	  c_double->widget1 = (GtkWidget *) fs;
	  c_double->widget2 = item;

	  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (fs)->ok_button),
			      "clicked", (GtkSignalFunc) gtk_config_dir_ok, c_double);
	  
	  gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION (fs)->cancel_button),
				     "clicked", (GtkSignalFunc) gtk_config_dir_cancel, GTK_OBJECT (fs));
	  
	  gtk_file_selection_set_filename (GTK_FILE_SELECTION(fs), g_strconcat(value, "/", NULL));
	
	  gtk_signal_connect (GTK_OBJECT (button),
			      "clicked", (GtkSignalFunc) gtk_browse_clicked, (gpointer) fs);
	}
      }
    }
    
    item = gtk_hseparator_new();
    gtk_widget_show(item);
    gtk_box_pack_start (GTK_BOX (vbox1), item, FALSE, TRUE, 0);

  }

  pad = gtk_frame_new (NULL);
  gtk_widget_ref (pad);
  gtk_object_set_data_full (GTK_OBJECT (panel), "pad", pad,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pad);
  gtk_box_pack_start (GTK_BOX (vbox1), pad, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (pad), 3);


  return panel;
}

GtkWidget * add_tree_item(GtkWidget *tree, gchar *label)
{
  GtkWidget *tree_item;
  GtkWidget *label_widget;

  tree_item = gtk_tree_item_new();
  label_widget = gtk_label_new(label);
  gtk_misc_set_alignment (GTK_MISC (label_widget), 0.0, 0.5);
  
  gtk_container_add (GTK_CONTAINER (tree_item), label_widget);
  gtk_widget_show (label_widget);

  gtk_widget_show(tree_item);

  gtk_tree_append(GTK_TREE(tree), tree_item);
  
  return tree_item;
}

void add_plugins(xmps_session_t *xmps_session)
{
  GList     *list, *plugin;
  GtkWidget *tree_item, *subtree;
  GtkWidget *panel, *item;

  if(xmps_session == NULL || xmps_session->plugin_center == NULL)
    return;

  /* GUI plugins */

  list = xmps_session->plugin_center->gui_plugins_list;
  
  tree_item = add_tree_item(tree1, "GUI Plugins");
  subtree   = gtk_tree_new();

  for(plugin = list; plugin != NULL; plugin = g_list_next(plugin))
    {
      xmps_gui_plugin_t *gui;

      gui = (xmps_gui_plugin_t *) plugin->data;

      panel = gtk_get_config_panel_from_xml(NULL,
					    gui->name);
      
      item = add_tree_item(subtree, gui->name);

      gtk_signal_connect (GTK_OBJECT(item), "select",
                          GTK_SIGNAL_FUNC(display_item_callback), (gpointer) panel);

      //      config_node = xmps_config_node_prepend(xmps_config_node_new(panel, (GList *) gui->get(gui, 
      //											    XMPS_FLAG_XML_CONFIG, 
      //										    NULL), gui->name), config_node);

    }
  
  gtk_tree_item_set_subtree (GTK_TREE_ITEM(tree_item), subtree);
  gtk_tree_item_expand( GTK_TREE_ITEM(tree_item) );
 
  /* media plugins */

  list = xmps_session->plugin_center->media_plugins_list;

  tree_item = add_tree_item(tree1, "Media Plugins");
  subtree   = gtk_tree_new();

  for(plugin = list; plugin != NULL; plugin = g_list_next(plugin))
    {
      xmps_media_plugin_t *media;
      GtkWidget           *item;

      media = (xmps_media_plugin_t *) plugin->data;

      panel = gtk_get_config_panel_from_xml((GList *) media->get(media, XMPS_FLAG_XML_CONFIG, NULL), 
					    g_strconcat(media->name, " Media", NULL));

      item = add_tree_item(subtree, media->name);

      gtk_signal_connect (GTK_OBJECT(item), "select",
                          GTK_SIGNAL_FUNC(display_item_callback), (gpointer) panel);
      
      config_node = xmps_config_node_prepend(xmps_config_node_new(panel, (GList *) media->get(media, 
											      XMPS_FLAG_XML_CONFIG, 
											      NULL), media->name), config_node);
    }
  
  gtk_tree_item_set_subtree (GTK_TREE_ITEM(tree_item), subtree);
  gtk_tree_item_expand( GTK_TREE_ITEM(tree_item) );

  /* system plugins */

  list = xmps_session->plugin_center->system_plugins_list;

  tree_item = add_tree_item(tree1, "System Plugins");
  subtree   = gtk_tree_new();

  for(plugin = list; plugin != NULL; plugin = g_list_next(plugin))
    {
      xmps_system_plugin_t *system;

      system = (xmps_system_plugin_t *) plugin->data;

      panel = gtk_get_config_panel_from_xml((GList *) system->get(system, XMPS_FLAG_XML_CONFIG, NULL), 
					    g_strconcat(system->name, " System", NULL));

      item = add_tree_item(subtree, system->name);

      gtk_signal_connect (GTK_OBJECT(item), "select",
                          GTK_SIGNAL_FUNC(display_item_callback), (gpointer) panel);

      config_node = xmps_config_node_prepend(xmps_config_node_new(panel, (GList *) system->get(system,
											       XMPS_FLAG_XML_CONFIG, 
											       NULL), system->name), config_node);
    }
  
  gtk_tree_item_set_subtree (GTK_TREE_ITEM(tree_item), subtree);
  gtk_tree_item_expand( GTK_TREE_ITEM(tree_item) );

  /* video codec plugins */

  list = xmps_session->plugin_center->video_decoder_plugins_list;

  tree_item = add_tree_item(tree1, "Video Decoder Plugins");
  subtree   = gtk_tree_new();

  for(plugin = list; plugin != NULL; plugin = g_list_next(plugin))
    {
      xmps_video_decoder_plugin_t  *video_codec;
      GtkWidget                  *item;

      video_codec = (xmps_video_decoder_plugin_t *) plugin->data;

      panel = gtk_get_config_panel_from_xml((GList *) video_codec->get(video_codec, XMPS_FLAG_XML_CONFIG, NULL), 
					    g_strconcat(video_codec->name, " Video Decoder", NULL));

      item = add_tree_item(subtree, video_codec->name);

      gtk_signal_connect (GTK_OBJECT(item), "select",
                          GTK_SIGNAL_FUNC(display_item_callback), (gpointer) panel);
    
      config_node = xmps_config_node_prepend(xmps_config_node_new(panel, (GList *) video_codec->get(video_codec, 
												    XMPS_FLAG_XML_CONFIG, 
												    NULL), video_codec->name), config_node);
    }
  
  gtk_tree_item_set_subtree (GTK_TREE_ITEM(tree_item), subtree);
  gtk_tree_item_expand( GTK_TREE_ITEM(tree_item) );

  /* video renderer plugins */

  list = xmps_session->plugin_center->video_renderer_plugins_list;

  tree_item = add_tree_item(tree1, "Video Renderer Plugins");
  subtree   = gtk_tree_new();

  for(plugin = list; plugin != NULL; plugin = g_list_next(plugin))
    {
      xmps_video_renderer_plugin_t *video_renderer;
      GtkWidget                    *item;

      video_renderer = (xmps_video_renderer_plugin_t *) plugin->data;

      panel = gtk_get_config_panel_from_xml((GList *) video_renderer->get(video_renderer, XMPS_FLAG_XML_CONFIG, NULL), 
					    g_strconcat(video_renderer->name, " Renderer", NULL));

      item = add_tree_item(subtree, video_renderer->name);

      gtk_signal_connect (GTK_OBJECT(item), "select",
                          GTK_SIGNAL_FUNC(display_item_callback), (gpointer) panel);
      
      config_node = xmps_config_node_prepend(xmps_config_node_new(panel, (GList *) video_renderer->get(video_renderer, 
												       XMPS_FLAG_XML_CONFIG, 
												       NULL), video_renderer->name), config_node);
    }
  
  gtk_tree_item_set_subtree (GTK_TREE_ITEM(tree_item), subtree);
  gtk_tree_item_expand( GTK_TREE_ITEM(tree_item) );

  /* audio codec plugins */

  list = xmps_session->plugin_center->audio_decoder_plugins_list;

  tree_item = add_tree_item(tree1, "Audio Decoder Plugins");
  subtree   = gtk_tree_new();

  for(plugin = list; plugin != NULL; plugin = g_list_next(plugin))
    {
      xmps_audio_decoder_plugin_t *audio_codec;

      audio_codec = (xmps_audio_decoder_plugin_t *) plugin->data;

      panel = gtk_get_config_panel_from_xml((GList *) audio_codec->get(audio_codec, XMPS_FLAG_XML_CONFIG, NULL), 
					    g_strconcat(audio_codec->name, " Audio Decoder", NULL));

      item = add_tree_item(subtree, audio_codec->name);

      gtk_signal_connect (GTK_OBJECT(item), "select",
                          GTK_SIGNAL_FUNC(display_item_callback), (gpointer) panel);

      config_node = xmps_config_node_prepend(xmps_config_node_new(panel, (GList *) audio_codec->get(audio_codec, 
												    XMPS_FLAG_XML_CONFIG, 
												    NULL), audio_codec->name), config_node);
    }
  
  gtk_tree_item_set_subtree (GTK_TREE_ITEM(tree_item), subtree);
  gtk_tree_item_expand( GTK_TREE_ITEM(tree_item) );

  /* audio renderer plugins */

  list = xmps_session->plugin_center->audio_renderer_plugins_list;

  tree_item = add_tree_item(tree1, "Audio Renderer Plugins");
  subtree   = gtk_tree_new();

  for(plugin = list; plugin != NULL; plugin = g_list_next(plugin))
    {
      xmps_audio_renderer_plugin_t *audio_renderer;
      GtkWidget                    *item;

      audio_renderer = (xmps_audio_renderer_plugin_t *) plugin->data;

      panel = gtk_get_config_panel_from_xml((GList *) audio_renderer->get(audio_renderer, XMPS_FLAG_XML_CONFIG, NULL), 
					    g_strconcat(audio_renderer->name, " Renderer", NULL));

      item = add_tree_item(subtree, audio_renderer->name);

      gtk_signal_connect (GTK_OBJECT(item), "select",
                          GTK_SIGNAL_FUNC(display_item_callback), (gpointer) panel);
    
      config_node = xmps_config_node_prepend(xmps_config_node_new(panel, (GList *) audio_renderer->get(audio_renderer, 
												       XMPS_FLAG_XML_CONFIG, 
												       NULL), audio_renderer->name), config_node);
    }
  
  gtk_tree_item_set_subtree (GTK_TREE_ITEM(tree_item), subtree);
  gtk_tree_item_expand( GTK_TREE_ITEM(tree_item) );
}

void xmps_gtk_config_create(xmps_session_t *xmps_session)
{
  GtkWidget *frame1;
  GtkWidget *scrolledwindow1;
  GtkWidget *viewport1;
  GtkWidget *ok_button;
  GtkWidget *cancel_button;
  GtkWidget *hbox2;
  GtkWidget *close_button;
  GtkWidget *vbox2;

  xmps_config = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (xmps_config), "xmps_config", xmps_config);
  gtk_container_set_border_width (GTK_CONTAINER (xmps_config), 2);
  gtk_window_set_title (GTK_WINDOW (xmps_config), "XMPS Configuration");
  gtk_window_set_position (GTK_WINDOW (xmps_config), GTK_WIN_POS_CENTER);
  gtk_window_set_default_size (GTK_WINDOW (xmps_config), 600, 420);

  hpaned1 = gtk_hpaned_new ();
  gtk_widget_ref (hpaned1);
  gtk_object_set_data_full (GTK_OBJECT (xmps_config), "hpaned1", hpaned1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hpaned1);
  gtk_container_add (GTK_CONTAINER (xmps_config), hpaned1);

  frame1 = gtk_frame_new (" XMPS Configuration : ");
  gtk_widget_ref (frame1);
  gtk_object_set_data_full (GTK_OBJECT (xmps_config), "frame1", frame1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (frame1);
  gtk_paned_pack1 (GTK_PANED (hpaned1), frame1, FALSE, TRUE);
  gtk_widget_set_usize (frame1, 170, -2);
  gtk_container_set_border_width (GTK_CONTAINER (frame1), 4);

  scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (scrolledwindow1);
  gtk_object_set_data_full (GTK_OBJECT (xmps_config), "scrolledwindow1", scrolledwindow1,
                           (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (scrolledwindow1);
  gtk_container_add (GTK_CONTAINER (frame1), scrolledwindow1);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  viewport1 = gtk_viewport_new (NULL, NULL);
  gtk_widget_ref (viewport1);
  gtk_object_set_data_full (GTK_OBJECT (xmps_config), "viewport1", viewport1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (viewport1);
  gtk_container_add (GTK_CONTAINER (scrolledwindow1), viewport1);
  gtk_container_set_border_width (GTK_CONTAINER (viewport1), 4);
  gtk_viewport_set_shadow_type (GTK_VIEWPORT (viewport1), GTK_SHADOW_ETCHED_IN);

  tree1 = gtk_tree_new ();
  gtk_widget_ref (tree1);
  gtk_object_set_data_full (GTK_OBJECT (xmps_config), "tree1", tree1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (tree1);
  gtk_container_add (GTK_CONTAINER (viewport1), tree1);
  gtk_container_set_border_width (GTK_CONTAINER (tree1), 2);
  gtk_tree_set_view_mode (GTK_TREE (tree1), GTK_TREE_VIEW_ITEM);
  gtk_tree_set_view_lines (GTK_TREE (tree1), FALSE);

  viewport2 = gtk_viewport_new (NULL, NULL);
  gtk_container_set_border_width (GTK_CONTAINER (viewport2), 4);
  gtk_widget_ref (viewport2);
  gtk_object_set_data_full (GTK_OBJECT (xmps_config), "viewport2", viewport2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (viewport2);
  
  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox2);
  gtk_object_set_data_full (GTK_OBJECT (vbox2), "vbox2", vbox2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox2);
  gtk_container_set_border_width (GTK_CONTAINER (vbox2), 4);
  gtk_box_pack_start (GTK_BOX (vbox2), viewport2, TRUE, TRUE, 0);


  gtk_paned_pack2 (GTK_PANED (hpaned1), vbox2, TRUE, TRUE);
  
  hbox2 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox2);
  gtk_object_set_data_full (GTK_OBJECT (hbox2), "hbox2", hbox2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox2);
  gtk_container_set_border_width (GTK_CONTAINER (hbox2), 4);

  ok_button = gtk_button_new_with_label("OK");
  gtk_widget_ref (ok_button);
  gtk_object_set_data_full (GTK_OBJECT (ok_button), "ok_button", ok_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_set_usize (ok_button, -2, 40);
  gtk_container_set_border_width (GTK_CONTAINER (ok_button), 4);
  gtk_widget_show (ok_button);

  gtk_signal_connect (GTK_OBJECT (ok_button),
		      "clicked", (GtkSignalFunc) gtk_config_ok, (gpointer) xmps_session);

  gtk_box_pack_start (GTK_BOX (hbox2), ok_button, TRUE, TRUE, 0);
  
  cancel_button = gtk_button_new_with_label("Cancel");
  gtk_widget_ref (cancel_button);
  gtk_object_set_data_full (GTK_OBJECT (cancel_button), "cancel_button", cancel_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_set_usize (cancel_button, -2, 40);
  gtk_container_set_border_width (GTK_CONTAINER (cancel_button), 4);
  gtk_widget_show (cancel_button);

  gtk_signal_connect (GTK_OBJECT (cancel_button),
		      "clicked", (GtkSignalFunc) gtk_config_cancel, NULL );

  gtk_box_pack_start (GTK_BOX (hbox2), cancel_button, TRUE, TRUE, 0);

  close_button = gtk_button_new_with_label("Close");
  gtk_widget_ref (close_button);
  gtk_object_set_data_full (GTK_OBJECT (close_button), "close_button", close_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_set_usize (close_button, -2, 40);
  gtk_container_set_border_width (GTK_CONTAINER (close_button), 4);
  gtk_widget_show (close_button);

  gtk_signal_connect (GTK_OBJECT (close_button),
		      "clicked", (GtkSignalFunc) gtk_config_close, NULL );

  gtk_box_pack_start (GTK_BOX (hbox2), close_button, TRUE, TRUE, 0);

  gtk_box_pack_start (GTK_BOX (vbox2), hbox2, FALSE, FALSE, 0);

  /* the empty frame */

  empty_frame = gtk_frame_new (NULL);
  gtk_widget_ref (empty_frame);
  gtk_object_set_data_full (GTK_OBJECT (xmps_config), "empty_frame", empty_frame,
                            (GtkDestroyNotify) gtk_widget_unref);

  gtk_widget_show(empty_frame);
  gtk_container_add (GTK_CONTAINER (viewport2), empty_frame);

  /* setup of the tree */

  add_tree_item(tree1, "Global parameters");
  add_plugins(xmps_session);

}

void xmps_gtk_config_show()
{
  if(xmps_config == NULL)
    return;
  
  gtk_widget_show(xmps_config);
}

void xmps_gtk_config_hide()
{
  if(xmps_config == NULL)
    return;
  
  gtk_widget_hide(xmps_config);
}

/*
 * MENU FUNCTIONS
 *
 */

void gtk_shared_menu_callback(gpointer cb_data, guint action, GtkWidget * w)
{
  int id;

  id = ((int) cb_data);

  XMPS_DEBUG("action : %d", id);

  switch(id) {

  case 7:
    /*
     * Exit
     */ 

    push_xmps_event(XMPS_EVENT_EXIT);
    break;

  default:
    break;
  }

}

GtkWidget *xmps_gtk_get_menu(xmps_session_t *xmps_session)
{
  GtkWidget *menu, *gtk_item;
  xmps_playback_t *playback;
  int              id;

  if(xmps_session == NULL) {
    return 0;
  }

  playback = (xmps_playback_t *) malloc(sizeof(xmps_playback_t));

  menu = gtk_menu_new ();

  id = 0;
  gtk_item = gtk_menu_item_new_with_label("About XMPS...");
  gtk_widget_show (gtk_item);

  gtk_signal_connect_object (GTK_OBJECT (gtk_item), "activate",
			     GTK_SIGNAL_FUNC (gtk_shared_menu_callback),
			     (gpointer) id);

  gtk_menu_append (GTK_MENU (menu), gtk_item);

  gtk_item = gtk_menu_item_new();
  gtk_widget_show (gtk_item);
  gtk_menu_append (GTK_MENU (menu), gtk_item);

  id = 1;
  gtk_item = gtk_menu_item_new_with_label("Previous Title");
  gtk_widget_show (gtk_item);
  gtk_signal_connect_object (GTK_OBJECT (gtk_item), "activate",
			     GTK_SIGNAL_FUNC (gtk_shared_menu_callback),
			     (gpointer) id);
  gtk_menu_append (GTK_MENU (menu), gtk_item);

  id = 2;
  gtk_item = gtk_menu_item_new_with_label("Stop");
  gtk_widget_show (gtk_item);
  gtk_menu_append (GTK_MENU (menu), gtk_item);

  id = 3;
  gtk_item = gtk_menu_item_new_with_label("Play");
  gtk_widget_show (gtk_item);
  gtk_signal_connect_object (GTK_OBJECT (gtk_item), "activate",
			     GTK_SIGNAL_FUNC (gtk_shared_menu_callback),
			     (gpointer) id);
  gtk_menu_append (GTK_MENU (menu), gtk_item);

  id = 4;
  gtk_item = gtk_menu_item_new_with_label("Pause");
  gtk_widget_show (gtk_item);
  gtk_signal_connect_object (GTK_OBJECT (gtk_item), "activate",
			     GTK_SIGNAL_FUNC (gtk_shared_menu_callback),
			     (gpointer) id);
  gtk_menu_append (GTK_MENU (menu), gtk_item);

  id = 5;
  gtk_item = gtk_menu_item_new_with_label("Next Title");
  gtk_widget_show (gtk_item);
  gtk_signal_connect_object (GTK_OBJECT (gtk_item), "activate",
			     GTK_SIGNAL_FUNC (gtk_shared_menu_callback),
			     (gpointer) id);
  gtk_menu_append (GTK_MENU (menu), gtk_item);
  
  gtk_item = gtk_menu_item_new();
  gtk_widget_show (gtk_item);
  gtk_menu_append (GTK_MENU (menu), gtk_item);

  id = 6;
  gtk_item = gtk_menu_item_new_with_label("Go To Fullscreen Mode");
  gtk_widget_show (gtk_item);
  gtk_signal_connect_object (GTK_OBJECT (gtk_item), "activate",
			     GTK_SIGNAL_FUNC (gtk_shared_menu_callback),
			     (gpointer) id);
  gtk_menu_append (GTK_MENU (menu), gtk_item);

  gtk_item = gtk_menu_item_new();
  gtk_widget_show (gtk_item);
  gtk_menu_append (GTK_MENU (menu), gtk_item);

  id = 7;
  gtk_item = gtk_menu_item_new_with_label("Quit...");
  gtk_widget_show (gtk_item);
  gtk_signal_connect_object (GTK_OBJECT (gtk_item), "activate",
			     GTK_SIGNAL_FUNC (gtk_shared_menu_callback),
			     (gpointer) id);
  gtk_menu_append (GTK_MENU (menu), gtk_item);

  gtk_widget_show(menu);

  return menu;
}
