/*  XMPS - X MPEG Player System
 *  Copyright (C) 1999 Damien Chavarria
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/**
 *  libxmps_config.h
 *
 *  definiton file for the libxmps options storage.
 *  @Author : Damien Chavarria (2000-2001)
 *
 */

#ifndef _XMPS_CONFIG_H
#define _XMPS_CONFIG_H

/*********************************************************************
 *                             INCLUDES                              *
 *********************************************************************/

/*
 * includes : system
 *
 */

#include <glib.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

/*********************************************************************
 *                              TYPES                                *
 *********************************************************************/

typedef struct
{
  gchar *key;
  gchar *value;
}
ConfigLine;

typedef struct
{
  gchar *name;
  GList *lines;
}
ConfigSection;

typedef struct
{
  GList *sections;
}
xmps_config_file_t;

/*********************************************************************
 *                            PROTOTYPES                             *
 *********************************************************************/

xmps_config_file_t *xmps_config_file_new(void);
/*
 * creates a new config 
 * file object
 *
 */

xmps_config_file_t *xmps_config_open_file(gchar * filename);
/*
 * open a existing file 
 * for reading.
 *
 */

gboolean    xmps_config_write_file(xmps_config_file_t * config, 
				gchar * filename);
/*
 * writes the specified configfile
 * to filename.
 *
 */

void        xmps_config_free(xmps_config_file_t * config);
/*
 * free all memory associated
 * with configfile.
 *
 */

xmps_config_file_t *xmps_config_open_default_file(void);
/*
 * default function
 *
 */

gboolean    xmps_config_write_default_file(xmps_config_file_t * config);
/*
 * default function
 *
 */


/*
 * all types read functions
 *
 *
 */

gboolean xmps_config_read_string(xmps_config_file_t * config, 
				 gchar * section, 
				 gchar * key, 
				 gchar ** value);

gboolean xmps_config_read_int(xmps_config_file_t * config, 
			      gchar * section, 
			      gchar * key, 
			      gint * value);

gboolean xmps_config_read_boolean(xmps_config_file_t * config, 
				  gchar * section, 
				  gchar * key, 
				  gboolean * value);

gboolean xmps_config_read_float(xmps_config_file_t * config, 
				gchar * section, 
				gchar * key, 
				gfloat * value);

gboolean xmps_config_read_double(xmps_config_file_t * config, 
				 gchar * section, 
				 gchar * key, 
				 gdouble * value);

/*
 * all types write functions
 *
 *
 */

void xmps_config_write_string(xmps_config_file_t * config, 
			      gchar * section, 
			      gchar * key, 
			      gchar * value);

void xmps_config_write_int(xmps_config_file_t * config, 
			   gchar * section, 
			   gchar * key, 
			   gint value);

void xmps_config_write_boolean(xmps_config_file_t * config, 
			       gchar * section, 
			       gchar * key, 
			       gboolean value);

void xmps_config_write_float(xmps_config_file_t * config, 
			     gchar * section, 
			     gchar * key, 
			     gfloat value);

void xmps_config_write_double(xmps_config_file_t * config, 
			      gchar * section, 
			      gchar * key, 
			      gdouble value);

/*
 * use this to remove
 * a key from the configfile.
 *
 */

void xmps_config_remove_key(xmps_config_file_t * config, 
			    gchar * section, 
			    gchar * key);

#endif



