/*  XMPS - X MPEG Player System
 *  Copyright (C) 1999 Damien Chavarria
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/**
 *  xmps_skins.h
 *
 *  Functions for handling the skins
 *  @Author : Damien Chavarria (1999)
 *
 */

#ifndef _XMPS_SKIN_H
#define _XMPS_SKIN_H

/* INCLUDES */

#include <gtk/gtk.h>
#include "libxmps/libxmps.h"
#include "libxmpsutils/libxmpsutils.h"
#include "skins_draw_buttons.h"
#include "skins_draw_controls.h"
#include "skins_draw_digits.h"
#include "skins_draw_main.h"
#include "skins_draw_titlebar.h"
#include "xmps_skins_utils.h"

/* FUNCTIONS */

void initialize_skins();
/* Initialize the variables -- do not forget to call it !! */ 
void load_default_skin(GdkWindow *window);
/* load the default skin */
void load_skin(gchar *skin, GdkWindow *window);
/* load the 'skin' skin */
void draw_current_skin(GtkWidget *widget, int playing);
/* draws the current skin (i.e. the one in the pixmaps)*/

#endif
