/*  XMPS - X MPEG Player System
 *  Copyright (C) 1999 Damien Chavarria
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/**
 *  skins_draw_playlist.h
 *
 *  Functions for handling the playlist.xpm
 *  @Author : Damien Chavarria (1999)
 *
 */

#ifndef _XMPS_DRAW_PLAYLIST_H
#define _XMPS_DRAW_PLAYLIST_H

/* INCLUDES */

#include "xmps_graphics.h"
#include "skins_pixmaps.h"
#include "libxmps/libxmps.h"
#include "libxmpsutils/libxmpsutils.h"

/* FUNCTIONS */

void draw_playlist_main(GtkWidget *widget);
 /* draws the item portion (without progress_bar) and the bottom */
void draw_playlist_titlebar(GtkWidget *widget, gint state);
 /* draws the item portion (without progress_bar) and the bottom */
void draw_playlist_progress_bar(GtkWidget *widget);
 /* draws the item portion (without progress_bar) and the bottom */
void draw_playlist_add_button(GtkWidget *widget, gint state);
 /* draws the item portion (without progress_bar) and the bottom */
void draw_playlist_remove_button(GtkWidget *widget, gint state);
 /* draws the item portion (without progress_bar) and the bottom */
void draw_playlist_sort_button(GtkWidget *widget, gint state);
 /* draws the item portion (without progress_bar) and the bottom */
void draw_playlist_rand_button(GtkWidget *widget, gint state);
 /* draws the item portion (without progress_bar) and the bottom */
void draw_playlist_resize(GtkWidget *widget);
 /* draws the item portion (without progress_bar) and the bottom */
void draw_playlist_cursor(GtkWidget *widget); 
 /* draws the cursor (without progress_bar) */
void draw_playlist_items(GtkWidget *widget);
 /* draws the item portion (without progress_bar) and the bottom */

#endif






































