/*  XMPS - X MPEG Player System
 *  Copyright (C) 1999 Damien Chavarria
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * main : skinned plugin main file.
 *
 */

/* includes */

#include <skinned_gui.h> 

typedef struct {

  unsigned int inited;
  GtkWidget   *skinned_window;

} skinned_t;
 

/*
 * get_gui_info : MANDATORY
 *
 * Used by the plugin_center to get a pointer to the gui object.
 *
 */

xmps_gui_plugin_t *get_gui_info(void)
{
  xmps_gui_plugin_t *gui;

  gui = (xmps_gui_plugin_t *) malloc(sizeof(xmps_gui_plugin_t));
  
  gui->name = "Skinned Player";
  gui->data = malloc(sizeof(skinned_t));

  gui->init  = skinned_init;
  gui->main  = skinned_main;
  gui->close = skinned_close;

  ((skinned_t *) gui->data)->inited = 0;

  return gui;
}

/* functions */

int skinned_init(xmps_gui_plugin_t *gui, void *arg)
{
  skinned_t       *data;
  xmps_gui_data_t *gui_data;

  if(gui == NULL) {
    return 0;
  }
  
  data = (skinned_t *) gui->data;

  if(data == NULL) {
    return 0;
  }
  
  gui_data = (xmps_gui_data_t *) arg;
  
  XMPS_DEBUG(": argc = %d", gui_data->argc);
  
  add_pixmap_directory (SKIN_PATH);  
  add_pixmap_directory (PIXMAPS_PATH);

  if(!data->inited) {
    
    XMPS_DEBUG("GTK INIT");

    gtk_init(NULL, NULL);
    gdk_rgb_init();
  }
  
  XMPS_DEBUG("init completed");

  xmps_config.playlist      = gui_data->playlist;
  xmps_config.session       = gui_data->session;
  xmps_config.cfgfile       = gui_data->cfgfile;

  xmps_playback_setup_audio(xmps_config.session, 1, "SDL");

  data->skinned_window = skinned_window_new(xmps_config.cfgfile, gui_data->shared_menu);
  
  if(xmps_playlist_get_nbr_items(xmps_config.playlist))
    xmps_config.has_to_play = 1;
  else
    xmps_config.has_to_play = 0;

  return 1;
}

int skinned_main(xmps_gui_plugin_t *gui)
{
  skinned_t       *data;
  
  if(gui == NULL) {
    return 0;
  }
  
  data = (skinned_t *) gui->data;

  if(data == NULL) {
    return 0;
  }  
  
  XMPS_DEBUG("showing window");

  gtk_widget_show(data->skinned_window);
  gtk_widget_set_uposition(data->skinned_window, xmps_config.window_pos_x, xmps_config.window_pos_y);

  if(xmps_config.is_playlist_toggled) {

    xmps_config.playlist_size_x =  xmps_config.window_size_x;
		
    gdk_window_resize(playlist_window->window, xmps_config.playlist_size_x,  105 + 15*(xmps_config.playlist_nbr_lines-3));
    gtk_widget_set_usize(playlist_window, xmps_config.playlist_size_x,  105 + 15*(xmps_config.playlist_nbr_lines-3));
    
    playlist_window_show();
    
    xmps_config.playlist_pos_x = xmps_config.window_pos_x;
    xmps_config.playlist_pos_y = xmps_config.window_pos_y + xmps_config.window_size_y;
    gtk_widget_set_uposition(playlist_window, xmps_config.playlist_pos_x, 
			     xmps_config.playlist_pos_y);
  }

  XMPS_DEBUG("entering main loop");

  gtk_main();
  return 1;
}

int skinned_close(xmps_gui_plugin_t *gui)
{
  skinned_t       *data;
  
  if(gui == NULL) {
    return 0;
  }
  
  data = (skinned_t *) gui->data;

  if(data == NULL) {
    return 0;
  }

  if(data->skinned_window != NULL)
    {
      gtk_widget_hide(data->skinned_window);
      playlist_window_hide();
      gtk_main_quit();
    }
      return 1;
}
