/*  XMPS - X MPEG Player System
 *  Copyright (C) 1999 Damien Chavarria
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * main : gnome window main file header.
 *
 */

#ifndef _GNOME_WINDOW_H
#define _GNOME_WINDOW_H

/* includes */

#include <libgnome/libgnome.h>
#include <gtk/gtk.h>
#include <string.h>

#include "libxmps/libxmps.h"
#include "libxmpsutils/libxmpsutils.h"

#include <gdk/gdkx.h>

/* types */

typedef struct {
  GtkWidget           *window;
  gint                 window_pos_x;
  gint                 window_pos_y;
  gint                 window_size_x;
  gint                 window_size_y;
  int                  has_to_play;
  int                  is_loop;
  int                  keep_aspect;
  gint                 fullscreen;
  gint                 start_time;
  char                *filesel_dir;
  xmps_playlist_t     *playlist;
  xmps_menu_callback_t menu_callback;
  xmps_session_t      *session;
  GtkWidget           *popup_menu;
  GtkWidget           *file_selection;
  GtkAccelGroup       *global_accel;
  xmps_config_file_t  *cfgfile;
} gnome_config;

/* gnome data */

GdkPixmap   *logo_pixmap;
GdkBitmap   *mask;
GtkStyle    *style;
gnome_config config;

#ifdef HAVE_POPT
#include <popt.h>
#endif

#include <libgnomeui/libgnomeui.h>

void
on_file1_activate                      (GtkMenuItem     *menuitem,
                                       gpointer         user_data);

void
on_open1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data);
void
on_open_url1_activate           (GtkMenuItem     *menuitem,
				 gpointer         user_data);

void
on_add_to_playlist1_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_quit1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_edit1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_global_preferences1_activate        (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_help1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_about1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_file_infos1_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_show_playlist1_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_skin_browser1_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_loop1_activate                      (GtkCheckMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_ratio1_activate                      (GtkCheckMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_fullscreen1_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_save_options_now1_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_rewind_clicked                      (GtkButton       *button,
                                        gpointer         user_data);

void
on_stop_clicked                        (GtkButton       *button,
                                        gpointer         user_data);

void
on_play_clicked                        (GtkButton       *button,
                                        gpointer         user_data);

void
on_pause_clicked                       (GtkButton       *button,
                                        gpointer         user_data);

void
on_fast_forward_clicked                (GtkButton       *button,
                                        gpointer         user_data);

void
on_load_clicked                        (GtkButton       *button,
                                        gpointer         user_data);

/* function prototypes */

gint       gnome_gui_idle(gpointer data);
GtkWidget* gnome_window_new(xmps_config_file_t *cfgfile, xmps_menu_t *menu);
void       gnome_save_options();
void       gnome_load_options();

#endif
