/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-2000 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifndef SENDQUEUE_H
#define SENDQUEUE_H


#define SQTYPE_TEXT 1
#define SQTYPE_FILE 2
#define SQTYPE_FTRANS 3
#define SQTYPE_YAPP 4

#define SQTRSTAT_NOSTOP 0
#define SQTRSTAT_STDSTOP 1
#define SQTRSTAT_EMERGSTOP 2
#define SQTRSTAT_ABORT 3

#include <qobject.h>



class Channel;
class FileTransfer;


typedef struct
{
	int fd;
   int comp;
   char *fname;
   int size;
} s_sqfile;


typedef struct
{
	int len;
   char *data;
   int comp;
} s_sqtext;


typedef struct _s_sqtrtext
{
	struct _s_sqtrtext *next;
	int len;
   char *data;
   bool show;
} s_sqtrtext;


typedef struct
{
   char *user, *titel;
   int lt, splitsize, startwith, sendcmd;
} s_sqsendinfo;


typedef struct
{
   FileTransfer *trans;
   int proto;
   char *fname;
	s_sqtrtext *textroot;
   s_sqsendinfo *sendinfo;
   int size;
   int status;
} s_sqtrprot;


typedef struct _s_sqentry
{
   struct _s_sqentry *next;

   int type;
   void *data;
   bool show;
} s_sqentry;


class SendQueue : QObject
{
	Q_OBJECT;

public:
	SendQueue( Channel *channel );
   ~SendQueue();

	void addString( const char *string, int len, int comp, bool show=true );
	void addTextFile( const char *filename, int comp, int size, bool show=true );
	void addFileTransfer( const char *filename, int protocol, s_sqsendinfo *info, int size );
   const char * getData( int & len, bool & show, int & comp );
   bool isTransferActive();
	int whichTransfer();
   s_sqentry *getRoot();
   void deleteEntry( s_sqentry *entry );

	bool allSent();
   void clear();

public slots:
   void slotTransSendString( const char *data, int len, bool show );
   void slotSendData();
	void slotNewTXData();
   void slotDeleteFTData();

private:
   s_sqentry * getNewEntry();
	void getNextDataString();
	bool addNextTextline();
	bool addNextTextFileData();
	bool addNextTransferFileData();
	void deleteNextEntry();
	void sendTransferFileText();
	void deleteThisEntry( s_sqentry *entry );

   Channel *chan;

   s_sqentry *sqroot;

   char *strdata;
   int strlen;
   bool strshow;
   int strcomp;
};


#endif

