/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-2000 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
//---------------------------------------------------------------------------
#include "pref.h"
#include "ax25k.h"
#include "sound.h"
#include "cfg.h"
#include "main.h"

#include <unistd.h>
#include <errno.h>

#include <qfile.h>
#include <qdir.h>
#include <qfiledialog.h>
#include <qbuttongroup.h>
#include <qlabel.h>
#include <qpixmap.h>
#include <qlayout.h>
#include <qfontdialog.h>
#include <qtooltip.h>
#include <qtabwidget.h>
#include <qlayout.h>

#include <kfontdialog.h>
#include <kapp.h>
#include <kmessagebox.h>
#include <kstddirs.h>
//---------------------------------------------------------------------------
extern KApplication *mykapp;
//---------------------------------------------------------------------------
#define OKCANCELWIDTH 80
#define OKCANCELHEIGHT 30
//---------------------------------------------------------------------------
#define BTNWIDTH 80
#define BTNHEIGHT 30
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
PrefAway::PrefAway( QWidget *parent, const QString & caption )
					: PrefWidget( parent, caption )
{
}
//---------------------------------------------------------------------------
PrefAway::~PrefAway()
{
}
//---------------------------------------------------------------------------
// Away-Konfiguration unter ~/.linkt/away.dat im Format UTF-8 abspeichern
void PrefAway::save( KConfig * )
{
	QFile f(conf->localDir()+"/away.dat");
   unsigned int i;
   bool ok;
   QString text="# LinKT Away-Text-File\n# Do not edit manually\n";


   if (currentEntry != -1)
      texte[currentEntry].setText( edText->text() );

	conf->setAway( texte );

   if (f.open(IO_WriteOnly))
   {
		f.writeBlock( text.utf8(), text.utf8().length() );

		for (i=0; i<texte.count(); i++)
      {
			f.writeBlock( texte[i].getAction().utf8()+"\n", texte[i].getAction().utf8().length()+1 );
			f.writeBlock( "  "+texte[i].getText().utf8()+"\n", texte[i].getText().utf8().length()+3 );
      }

   	f.close();
   }


   // Gucken, ob die Action, die beim Oeffnen des Preferences-Fenster aktiv
   // war, noch vorhanden ist. Wenn nicht -> Meldung
   if (!startAction.isEmpty())
   {
   	ok = false;
	   for (i=0; i<texte.count(); i++)
	   	if (texte[i].getAction() == startAction)
         {
         	ok = true;
            config->awayStatus = i;
            break;
			}

		if (!ok)
      {
	      KMessageBox::error( this,
	      						  i18n("Section '%1' is not available.\nSetting away-status to 0 (you are not away).").arg(startAction),
									  i18n("Away-Preferences") );
			config->awayStatus = 0;
			config->awayTime = time( NULL );
         emit awayDataChanged();
      }
	}
}
//---------------------------------------------------------------------------
void PrefAway::createPrefWidget()
{
   QButtonGroup *tmpbtngrp;
   QVBoxLayout *vbox, *vboxMain;
   QLabel *l;
   QHBoxLayout *hbox;
   unsigned int i;


   vboxMain = new QVBoxLayout( this );

   tmpbtngrp = new QButtonGroup( this );
   tmpbtngrp->setFrameStyle( 49 );
   tmpbtngrp->setAlignment( 1 );
   tmpbtngrp->lower();

   vboxMain->addWidget( tmpbtngrp );
	vboxMain->addStretch( 1 );

   vbox = new QVBoxLayout( tmpbtngrp );
   vbox->setMargin( 10 );

   l = new QLabel( i18n("Action"), tmpbtngrp );
   vbox->addWidget( l );

   cmbAction = new QComboBox( tmpbtngrp );
   connect( cmbAction, SIGNAL(activated(int)), SLOT(slotSetText(int)) );
   cmbAction->setInsertionPolicy( QComboBox::NoInsertion );
	vbox->addWidget( cmbAction );

   vbox->addSpacing( 5 );

   hbox = new QHBoxLayout( vbox );

   hbox->addStretch( 1 );
	btnNew = new QPushButton( i18n("&New"), tmpbtngrp );
   connect( btnNew, SIGNAL(clicked()), SLOT(slotNewEntry()) );

   hbox->addWidget( btnNew );
   hbox->addSpacing( 5 );

	btnDelete = new QPushButton( i18n("&Delete"), tmpbtngrp );
   connect( btnDelete, SIGNAL(clicked()), SLOT(slotDeleteEntry()) );

   hbox->addWidget( btnDelete );


   l = new QLabel( i18n("Text"), tmpbtngrp );
   vbox->addWidget( l );

   edText = new QLineEdit( tmpbtngrp );
   vbox->addWidget( edText );



   // Daten einlesen
	texte = conf->getAway();
	for (i=0; i<texte.count(); i++)
   	cmbAction->insertItem( texte[i].getAction() );
   currentEntry = -1;

   if (texte.count() > 0)
	   slotSetText( 0 );
	else
		slotSetText( -1 );

   startAction = texte[config->awayStatus].getAction();
   setCreated();
}
//---------------------------------------------------------------------------
void PrefAway::slotSetText( int id )
{
   if (currentEntry != -1)
   {
   	// Aktuellen Text abspeichern
      texte[currentEntry].setText( edText->text().stripWhiteSpace() );
   }
	currentEntry = id;

   if (id == -1)
   {
      btnDelete->setEnabled( false );
      edText->setEnabled( false );
      edText->clear();
   	return;
   }
  	btnDelete->setEnabled( true );

	edText->setEnabled( true );
   edText->setText( texte[currentEntry].getText() );
}
//---------------------------------------------------------------------------
void PrefAway::slotNewEntry()
{
   if (currentEntry != -1)
      texte[currentEntry].setText( edText->text().stripWhiteSpace() );

   cmbAction->setEditable( true );
	connect( cmbAction->lineEdit(), SIGNAL(returnPressed()), SLOT(slotReturnPressed()) );
   cmbAction->setFocus();
   cmbAction->lineEdit()->show();

   edText->clear();
   edText->setEnabled( false );
   btnNew->setEnabled( false );
   btnDelete->setEnabled( true );
}
//---------------------------------------------------------------------------
void PrefAway::slotReturnPressed()
{
	QListBoxItem *item;

	// Gucken, ob der eingegebene Eintrag schon vorhanden ist
   if ((item = cmbAction->listBox()->findItem(cmbAction->currentText())) != NULL)
   {
      currentEntry = cmbAction->listBox()->index( item );
      cmbAction->setCurrentItem( currentEntry );
      edText->setText( texte[currentEntry].getText() );
   }
	else
	{
		cmbAction->insertItem( cmbAction->currentText() );
		texte.append( AwayInfo(cmbAction->currentText().stripWhiteSpace()) );
	}

   cmbAction->setEditable( false );
   edText->setEnabled( true );
   edText->setFocus();

   btnNew->setEnabled( true );
   btnDelete->setEnabled( true );

   if (item == NULL)
   {
	   currentEntry = cmbAction->count()-1;
	   cmbAction->setCurrentItem( currentEntry );
	}
}
//---------------------------------------------------------------------------
void PrefAway::slotDeleteEntry()
{
	QString tmp;


   if (cmbAction->editable())
   {
      cmbAction->setEditable( true );
      btnNew->setEnabled( true );
      slotSetText( currentEntry );
   	return;
   }

   if (cmbAction->currentText() == i18n("here"))
   {
      KMessageBox::error( this,
      						  i18n("The '%1'-entry is needed. No deletion possible.").arg(i18n("here")),
								  i18n("Delete") );
   	return;
   }

	// Der aktuelle Eintrag wird geloescht
   cmbAction->removeItem( currentEntry );
   texte.remove( texte.at(currentEntry) );

   currentEntry = cmbAction->currentItem();
   edText->setText( texte[currentEntry].getText() );
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
PrefSound::PrefSound( QWidget *parent, const QString & caption )
					:	PrefWidget( parent, caption )
{
}
//---------------------------------------------------------------------------
void PrefSound::createPrefWidget()
{
   QVBoxLayout *vbox, *vboxLarge, *vboxMain;
   QHBoxLayout *hbox;
   QLabel *l;
   QButtonGroup *tmpbtngrp;
   int i;
   QString snd;
   QListBoxItem *lbi;


   vboxMain = new QVBoxLayout( this );

   tmpbtngrp = new QButtonGroup( this );
   tmpbtngrp->setFrameStyle( 49 );
   tmpbtngrp->setAlignment( 1 );
   tmpbtngrp->lower();

   vboxMain->addWidget( tmpbtngrp );

   vboxLarge = new QVBoxLayout( tmpbtngrp );
   vboxLarge->setMargin( 5 );

   // Standardmaessig ist kein Sound aktiviert.
   for (i=0; i<SOUNDCOUNT; i++)
   	eventSound[i] = 0;

   vbox = new QVBoxLayout( vboxLarge );

   l = new QLabel( tmpbtngrp );
   l->setText( i18n("Event:") );

	cmbEvent = new QComboBox( tmpbtngrp );
   connect( cmbEvent, SIGNAL(activated(int)), SLOT(slotSelEvent(int)) );

   vbox->addWidget( l );
   vbox->addWidget( cmbEvent );

   vboxLarge->addSpacing( 3 );

   vbox = new QVBoxLayout( vboxLarge );

   l = new QLabel( tmpbtngrp );
   l->setText( i18n("Sound:") );

   lbFiles = new QListBox( tmpbtngrp );
	connect( lbFiles, SIGNAL(highlighted(QListBoxItem *)), SLOT(slotSelSound(QListBoxItem *)) );

   vbox->addWidget( l );
   vbox->addWidget( lbFiles );

   hbox = new QHBoxLayout( vboxLarge );

   btnTest = new QPushButton( tmpbtngrp );
   btnTest->setText( i18n("&Test") );
   connect( btnTest, SIGNAL(clicked()), SLOT(slotTest()) );

   hbox->addStretch( 1 );
   hbox->addWidget( btnTest );


   cmbEvent->insertItem( i18n("Connection setup"), SOUND_CONN_SETUP );
   cmbEvent->insertItem( i18n("Incoming connection"), SOUND_CONN_IN );
   cmbEvent->insertItem( i18n("Outgoing connection"), SOUND_CONN_OUT );
   cmbEvent->insertItem( i18n("Connection closed"), SOUND_CONN_CLOSED );
   cmbEvent->insertItem( i18n("//RING"), SOUND_RING );
   cmbEvent->insertItem( i18n("Filetransfer start"), SOUND_FILE_START );
   cmbEvent->insertItem( i18n("Filetransfer ready"), SOUND_FILE_READY );
   cmbEvent->insertItem( i18n("Filetransfer abort"), SOUND_FILE_ABORT );


   lbFiles->insertItem( "(none)" );


   // Inhalt von /usr/share/sounds in die File-Liste
   QDir d("/usr/share/sounds");
   d.setFilter( QDir::Files );

   const QFileInfoList *list=d.entryInfoList();
   QFileInfoListIterator it( *list );
   QFileInfo *fi;

   while ((fi=it.current()))
   {
   	lbFiles->insertItem( "/usr/share/sounds/"+fi->fileName() );
   	++it;
   }



   // Zuweisung der konfigurierten Sounds mit den Sounds in der Liste
   for (i=0; i<SOUNDCOUNT; i++)
   {
   	snd = conf->getSound( i );
      if (snd.isEmpty())
   		eventSound[i] = 0;
		else
      {
         // Ok, diesem Event wurde ein File zugewiesen. Gucken, ob es schon
         // in der Liste ist (= sich in /usr/share/sounds befindet)
         if ((lbi=lbFiles->findItem(snd)) == NULL)
         {
         	// Nein, noch nicht enthalten: File hinzufuegen und den Verweis
            // darauf in eventSound setzen.
            lbFiles->insertItem( snd );
            eventSound[i] = lbFiles->count()-1;
         }
         else
         {
         	// Ja, schon vorhanden. Verweis darauf in eventSound setzen.
            eventSound[i] = lbFiles->index( lbi );
         }
      }
	}

   // Den obersten Eintrag in der Event-Combobox und das dazugehoerige
   // Sound-File markieren.
   cmbEvent->setCurrentItem( 0 );
   lbFiles->setSelected( eventSound[0], true );


   setCreated();
}
//---------------------------------------------------------------------------
PrefSound::~PrefSound()
{
}
//---------------------------------------------------------------------------
void PrefSound::save( KConfig *kconfig )
{
	int i;
   QString newSound, oldSound, tmp;


	kconfig->setGroup( "Sound" );

   for (i=0; i<SOUNDCOUNT; i++)
   {
   	if (eventSound[i] == 0)
      	newSound = "";
		else
	   	newSound = lbFiles->text( eventSound[i] );
		oldSound = conf->getSound( i );

      if (newSound != oldSound)
      {
      	switch (i)
         {
         	case SOUND_CONN_SETUP:
            	tmp = "connSetup";
            	break;
         	case SOUND_CONN_IN:
            	tmp = "connIn";
            	break;
         	case SOUND_CONN_OUT:
            	tmp = "connOut";
            	break;
         	case SOUND_CONN_CLOSED:
            	tmp = "connClosed";
            	break;
         	case SOUND_RING:
            	tmp = "ring";
            	break;
         	case SOUND_FILE_START:
            	tmp = "fileStart";
            	break;
         	case SOUND_FILE_READY:
            	tmp = "fileReady";
            	break;
         	case SOUND_FILE_ABORT:
            	tmp = "fileAbort";
            	break;
			}

			kconfig->writeEntry(tmp, newSound);
         conf->setSound( i, newSound );
      }
	}
}
//---------------------------------------------------------------------------
void PrefSound::slotSelEvent( int id )
{
   lbFiles->setSelected( eventSound[id], true );
}
//---------------------------------------------------------------------------
void PrefSound::slotSelSound( QListBoxItem *item )
{
   eventSound[cmbEvent->currentItem()] = lbFiles->index(item);
}
//---------------------------------------------------------------------------
void PrefSound::slotTest()
{
	if (lbFiles->currentText().isEmpty()) return;
	LinKTSound::play( lbFiles->currentText() );
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
PrefFiles::PrefFiles( QWidget *parent, const QString & caption )
					:	PrefWidget( parent, caption )
{
}
//---------------------------------------------------------------------------
void PrefFiles::createPrefWidget()
{
   char tmp[5000];
   FILE *f;
   int i,line;
   int w=310, h=190;


   ctextChanged = false;
   qtextChanged = false;
   infoChanged = false;
   helpChanged = false;
   newsChanged = false;



   QTabWidget *tabwidget = new QTabWidget( this );
   tabwidget->setGeometry( 0, 0, 330, 220 );

   ctext_widg = new QWidget( this );
   ctext_widg->resize( w, h );
   qtext_widg = new QWidget( this );
   qtext_widg->resize( w, h );
   info_widg = new QWidget( this );
   info_widg->resize( w, h );
   help_widg = new QWidget( this );
   help_widg->resize( w, h );
   news_widg = new QWidget( this );
   news_widg->resize( w, h );

   ctext = new QMultiLineEdit( ctext_widg );
   ctext->setGeometry( 5, 5, ctext_widg->width(), ctext_widg->height()-BTNHEIGHT-10 );
   connect( ctext, SIGNAL(textChanged()), SLOT(slotCTextChanged()) );

   qtext = new QMultiLineEdit( qtext_widg );
   qtext->setGeometry( 5, 5, qtext_widg->width(), qtext_widg->height()-BTNHEIGHT-10 );
   connect( qtext, SIGNAL(textChanged()), SLOT(slotQTextChanged()) );

   info = new QMultiLineEdit( info_widg );
   info->setGeometry( 5, 5, info_widg->width(), info_widg->height()-BTNHEIGHT-10 );
   connect( info, SIGNAL(textChanged()), SLOT(slotInfoChanged()) );

   help = new QMultiLineEdit( help_widg );
   help->setGeometry( 5, 5, help_widg->width(), help_widg->height()-BTNHEIGHT-10 );
   connect( help, SIGNAL(textChanged()), SLOT(slotHelpChanged()) );

   news = new QMultiLineEdit( news_widg );
   news->setGeometry( 5, 5, news_widg->width(), news_widg->height()-BTNHEIGHT-10 );
   connect( news, SIGNAL(textChanged()), SLOT(slotNewsChanged()) );


   ctext_imp = new QPushButton( ctext_widg );
   ctext_imp->setGeometry( ctext_widg->width()-5-BTNWIDTH, ctext_widg->height()-BTNHEIGHT, BTNWIDTH, BTNHEIGHT );
   ctext_imp->setText( i18n("&Import") );
   connect( ctext_imp, SIGNAL(clicked()), SLOT(slotImportCText()));

   qtext_imp = new QPushButton( qtext_widg );
   qtext_imp->setGeometry( qtext_widg->width()-5-BTNWIDTH, qtext_widg->height()-BTNHEIGHT, BTNWIDTH, BTNHEIGHT );
   qtext_imp->setText( i18n("&Import") );
   connect( qtext_imp, SIGNAL(clicked()), SLOT(slotImportQText()));

   info_imp = new QPushButton( info_widg );
   info_imp->setGeometry( info_widg->width()-5-BTNWIDTH, info_widg->height()-BTNHEIGHT, BTNWIDTH, BTNHEIGHT );
   info_imp->setText( i18n("&Import") );
   connect( info_imp, SIGNAL(clicked()), SLOT(slotImportHelp()));

   help_imp = new QPushButton( help_widg );
   help_imp->setGeometry( help_widg->width()-5-BTNWIDTH, help_widg->height()-BTNHEIGHT, BTNWIDTH, BTNHEIGHT );
   help_imp->setText( i18n("&Import") );
   connect( help_imp, SIGNAL(clicked()), SLOT(slotImportInfo()));

   news_imp = new QPushButton( news_widg );
   news_imp->setGeometry( news_widg->width()-5-BTNWIDTH, news_widg->height()-BTNHEIGHT, BTNWIDTH, BTNHEIGHT );
   news_imp->setText( i18n("&Import") );
   connect( news_imp, SIGNAL(clicked()), SLOT(slotImportNews()));


	tabwidget->addTab( ctext_widg, i18n("ctext") );
	tabwidget->addTab( qtext_widg, i18n("qtext") );
	tabwidget->addTab( info_widg, i18n("info") );
	tabwidget->addTab( help_widg, i18n("help") );
	tabwidget->addTab( news_widg, i18n("news") );



   //--------------- Daten einlesen ---------------------------------


   ///////////////// Connect-Text ////////////////////////////////
   sprintf(tmp,"%s/ctext", conf->localDir().latin1());
   if ((f = fopen(tmp, "r")) != NULL)
   {
      line = 0;
      while (fgets(tmp, 4999, f) != NULL)
      {
         if ((i = POS('\r', tmp)) > -1)
            tmp[i] = '\0';
         if ((i = POS('\n', tmp)) > -1)
            tmp[i] = '\0';
         ctext->insertLine(tmp, line);
         line++;
      }
      fclose(f);
   }


   ///////////////// Quit-Text ////////////////////////////////
   sprintf(tmp,"%s/qtext", conf->localDir().latin1());
   if ((f = fopen(tmp, "r")) != NULL)
   {
      line = 0;
      while (fgets(tmp, 4999, f) != NULL)
      {
         if ((i = POS('\r', tmp)) > -1)
            tmp[i] = '\0';
         if ((i = POS('\n', tmp)) > -1)
            tmp[i] = '\0';
         qtext->insertLine(tmp, line);
         line++;
      }
      fclose(f);
   }


   ///////////////// Hilfe-Text ////////////////////////////////
   sprintf(tmp,"%s/help.linkt", conf->localDir().latin1());
   if ((f = fopen(tmp, "r")) != NULL)
   {
      line = 0;
      while (fgets(tmp, 4999, f) != NULL)
      {
         if ((i = POS('\r', tmp)) > -1)
            tmp[i] = '\0';
         if ((i = POS('\n', tmp)) > -1)
            tmp[i] = '\0';
         help->insertLine(tmp, line);
         line++;
      }
      fclose(f);
   }


   ///////////////// Info-Text ////////////////////////////////
   sprintf(tmp,"%s/info.linkt", conf->localDir().latin1());
   if ((f = fopen(tmp, "r")) != NULL)
   {
      line = 0;
      while (fgets(tmp, 4999, f) != NULL)
      {
         if ((i = POS('\r', tmp)) > -1)
            tmp[i] = '\0';
         if ((i = POS('\n', tmp)) > -1)
            tmp[i] = '\0';
         info->insertLine(tmp, line);
         line++;
      }
      fclose(f);
   }


   ///////////////// News-Text ////////////////////////////////
   sprintf(tmp,"%s/news.linkt", conf->localDir().latin1());
   if ((f = fopen(tmp, "r")) != NULL)
   {
      line = 0;
      while (fgets(tmp, 4999, f) != NULL)
      {
         if ((i = POS('\r', tmp)) > -1)
            tmp[i] = '\0';
         if ((i = POS('\n', tmp)) > -1)
            tmp[i] = '\0';
         news->insertLine(tmp, line);
         line++;
      }
      fclose(f);
   }


   setCreated();
}
//---------------------------------------------------------------------------
PrefFiles::~PrefFiles()
{
}
//---------------------------------------------------------------------------
void PrefFiles::save( KConfig * )
{
   char tmp[5000];
   FILE *f;
   int i,anz;


   /////////////// Connect-Text //////////////////////////////
   if (ctextChanged)
   {
	   sprintf(tmp,"%s/ctext", conf->localDir().latin1());
	   if ((anz = ctext->numLines()) > 0)
	   {
	      if (anz == 1 && strlen(ctext->textLine(0)) == 0)
	         unlink(tmp);
	      else
	      {
	         if ((f = fopen(tmp, "w")) == NULL)
	         {
	            sprintf(tmp, i18n("The %s-file cannot be created.\n(%s)"), "ctext", strerror(errno));
	            KMessageBox::error( this,
	            						tmp,
											i18n("Fileerror"));
	         }
	         else
	         {
	            for (i=0; i<anz; i++)
	            {
	               strcpy(tmp, ctext->textLine(i));
	               strcat(tmp, "\n");
	               fputs(tmp, f);
	            }
	            fclose(f);
	         }
	      }
	   }
	   else unlink(tmp);
 	}


   /////////////// Quit-Text //////////////////////////////
   if (qtextChanged)
   {
	   sprintf(tmp,"%s/qtext", conf->localDir().latin1());
	   if ((anz = qtext->numLines()) > 0)
	   {
	      if (anz == 1 && strlen(qtext->textLine(0)) == 0)
	         unlink(tmp);
	      else
	      {
	         if ((f = fopen(tmp, "w")) == NULL)
	         {
	            sprintf(tmp, i18n("The %s-file cannot be created.\n(%s)"), "qtext", strerror(errno));
			      KMessageBox::error( this,
			      						tmp,
											i18n("Fileerror"));
	         }
	         else
	         {
	            for (i=0; i<anz; i++)
	            {
	               strcpy(tmp, qtext->textLine(i));
	               strcat(tmp, "\n");
	               fputs(tmp, f);
	            }
	            fclose(f);
	         }
	      }
	   }
	   else unlink(tmp);
	}


   /////////////// Help-Text //////////////////////////////
   if (helpChanged)
   {
	   sprintf(tmp,"%s/help.linkt", conf->localDir().latin1());
	   if ((anz = help->numLines()) > 0)
	   {
	      if (anz == 1 && strlen(help->textLine(0)) == 0)
	         unlink(tmp);
	      else
	      {
	         if ((f = fopen(tmp, "w")) == NULL)
	         {
	            sprintf(tmp, i18n("The %s-file cannot be created.\n(%s)"), "help", strerror(errno));
			      KMessageBox::error( this,
			      						tmp,
											i18n("Fileerror"));
	         }
	         else
	         {
	            for (i=0; i<anz; i++)
	            {
	               strcpy(tmp, help->textLine(i));
	               strcat(tmp, "\n");
	               fputs(tmp, f);
	            }
	            fclose(f);
	         }
	      }
	   }
	   else unlink(tmp);
	}


   /////////////// Info-Text //////////////////////////////
   if (infoChanged)
   {
	   sprintf(tmp,"%s/info.linkt", conf->localDir().latin1());
	   if ((anz = info->numLines()) > 0)
	   {
	      if (anz == 1 && strlen(info->textLine(0)) == 0)
	         unlink(tmp);
	      else
	      {
	         if ((f = fopen(tmp, "w")) == NULL)
	         {
	            sprintf(tmp, i18n("The %s-file cannot be created.\n(%s)"), "info", strerror(errno));
			      KMessageBox::error( this,
			      						tmp,
											i18n("Fileerror"));
	         }
	         else
	         {
	            for (i=0; i<anz; i++)
	            {
	               strcpy(tmp, info->textLine(i));
	               strcat(tmp, "\n");
	               fputs(tmp, f);
	            }
	            fclose(f);
	         }
	      }
	   }
	   else unlink(tmp);
	}


   /////////////// News-Text //////////////////////////////
   if (newsChanged)
   {
	   sprintf(tmp,"%s/news.linkt", conf->localDir().latin1());
	   if ((anz = news->numLines()) > 0)
	   {
	      if (anz == 1 && strlen(news->textLine(0)) == 0)
	         unlink(tmp);
	      else
	      {
	         if ((f = fopen(tmp, "w")) == NULL)
	         {
	            sprintf(tmp, i18n("The %s-file cannot be created.\n(%s)"), "news", strerror(errno));
			      KMessageBox::error( this,
			      						tmp,
											i18n("Fileerror"));
	         }
	         else
	         {
	            for (i=0; i<anz; i++)
	            {
	               strcpy(tmp, news->textLine(i));
	               strcat(tmp, "\n");
	               fputs(tmp, f);
	            }
	            fclose(f);
	         }
	      }
	   }
	   else unlink(tmp);
	}
}
//---------------------------------------------------------------------------
void PrefFiles::slotImportCText()
{
   char tmp[1000];
   int i,line;
   FILE *f;


   strcpy(tmp, conf->localDir().latin1());
   QString str = QFileDialog::getOpenFileName(tmp);

   // Cancel
   if (str.isEmpty()) return;

   strcpy(tmp, (const char *)str);

   if (!file_exist(tmp))
   {
		KMessageBox::error( this,
								i18n("Cannot find specified file."),
								i18n("File not found"));
      return;
   }


   if ((f = fopen(tmp, "r")) != NULL)
   {
      ctext->clear();
      line = 0;
      while (fgets(tmp, 4999, f) != NULL)
      {
         if ((i = POS('\r', tmp)) > -1)
            tmp[i] = '\0';
         if ((i = POS('\n', tmp)) > -1)
            tmp[i] = '\0';
         ctext->insertLine(tmp, line);
         line++;
      }
      fclose(f);
   }
   else
		KMessageBox::error( this,
                        i18n("Cannot open specified file."),
								i18n("Cannot open file"));
}
//---------------------------------------------------------------------------
void PrefFiles::slotImportQText()
{
   char tmp[1000];
   int i,line;
   FILE *f;


   strcpy(tmp, conf->localDir().latin1());
   QString str = QFileDialog::getOpenFileName(tmp);

   // Cancel
   if (str.isEmpty()) return;

   strcpy(tmp, (const char *)str);

   if (!file_exist(tmp))
   {
		KMessageBox::error( this,
                        i18n("Cannot open specified file."),
								i18n("File not found"));
      return;
   }


   if ((f = fopen(tmp, "r")) != NULL)
   {
      qtext->clear();
      line = 0;
      while (fgets(tmp, 4999, f) != NULL)
      {
         if ((i = POS('\r', tmp)) > -1)
            tmp[i] = '\0';
         if ((i = POS('\n', tmp)) > -1)
            tmp[i] = '\0';
         qtext->insertLine(tmp, line);
         line++;
      }
      fclose(f);
   }
   else
		KMessageBox::error( this,
                        i18n("Cannot open specified file."),
								i18n("Cannot open file"));
}
//---------------------------------------------------------------------------
void PrefFiles::slotImportHelp()
{
   char tmp[1000];
   int i,line;
   FILE *f;


   strcpy(tmp, conf->localDir().latin1());
   QString str = QFileDialog::getOpenFileName(tmp);

   // Cancel
   if (str.isEmpty()) return;

   strcpy(tmp, (const char *)str);

   if (!file_exist(tmp))
   {
		KMessageBox::error( this,
                        i18n("Cannot open specified file."),
								i18n("File not found"));
      return;
   }


   if ((f = fopen(tmp, "r")) != NULL)
   {
      help->clear();
      line = 0;
      while (fgets(tmp, 4999, f) != NULL)
      {
         if ((i = POS('\r', tmp)) > -1)
            tmp[i] = '\0';
         if ((i = POS('\n', tmp)) > -1)
            tmp[i] = '\0';
         help->insertLine(tmp, line);
         line++;
      }
      fclose(f);
   }
   else
		KMessageBox::error( this,
                        i18n("Cannot open specified file."),
								i18n("Cannot open file"));
}
//---------------------------------------------------------------------------
void PrefFiles::slotImportInfo()
{
   char tmp[1000];
   int i,line;
   FILE *f;


   strcpy(tmp, conf->localDir().latin1());
   QString str = QFileDialog::getOpenFileName(tmp);

   // Cancel
   if (str.isEmpty()) return;

   strcpy(tmp, (const char *)str);

   if (!file_exist(tmp))
   {
		KMessageBox::error( this,
                        i18n("Cannot open specified file."),
								i18n("File not found"));
      return;
   }


   if ((f = fopen(tmp, "r")) != NULL)
   {
      info->clear();
      line = 0;
      while (fgets(tmp, 4999, f) != NULL)
      {
         if ((i = POS('\r', tmp)) > -1)
            tmp[i] = '\0';
         if ((i = POS('\n', tmp)) > -1)
            tmp[i] = '\0';
         info->insertLine(tmp, line);
         line++;
      }
      fclose(f);
   }
   else
		KMessageBox::error( this,
                        i18n("Cannot open specified file."),
								i18n("Cannot open file"));
}
//---------------------------------------------------------------------------
void PrefFiles::slotImportNews()
{
   char tmp[1000];
   int i,line;
   FILE *f;


   strcpy(tmp, conf->localDir().latin1());
   QString str = QFileDialog::getOpenFileName(tmp);

   // Cancel
   if (str.isEmpty()) return;

   strcpy(tmp, (const char *)str);

   if (!file_exist(tmp))
   {
		KMessageBox::error( this,
                        i18n("Cannot open specified file."),
								i18n("File not found"));
      return;
   }


   if ((f = fopen(tmp, "r")) != NULL)
   {
      news->clear();
      line = 0;
      while (fgets(tmp, 4999, f) != NULL)
      {
         if ((i = POS('\r', tmp)) > -1)
            tmp[i] = '\0';
         if ((i = POS('\n', tmp)) > -1)
            tmp[i] = '\0';
         news->insertLine(tmp, line);
         line++;
      }
      fclose(f);
   }
   else
		KMessageBox::error( this,
                        i18n("Cannot open specified file."),
								i18n("Cannot open file"));
}
//---------------------------------------------------------------------------
void PrefFiles::slotCTextChanged()
{
   ctextChanged = true;
}
//---------------------------------------------------------------------------
void PrefFiles::slotQTextChanged()
{
   qtextChanged = true;
}
//---------------------------------------------------------------------------
void PrefFiles::slotHelpChanged()
{
   helpChanged = true;
}
//---------------------------------------------------------------------------
void PrefFiles::slotInfoChanged()
{
   infoChanged = true;
}
//---------------------------------------------------------------------------
void PrefFiles::slotNewsChanged()
{
   newsChanged = true;
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
PrefCallKey::PrefCallKey( QWidget *parent, const QString & caption )
					:	PrefWidget( parent, caption )
{
}
//---------------------------------------------------------------------------
void PrefCallKey::createPrefWidget()
{
   QButtonGroup *tmpbtngrp;
   QLabel *l;
   int i,y;
   QString tmp;
   s_callKey *callkey;


   tmpbtngrp = new QButtonGroup( this );
   tmpbtngrp->setGeometry( 0, 0, 210, 220 );
   tmpbtngrp->setFrameStyle( 49 );
   tmpbtngrp->setAlignment( 1 );
   tmpbtngrp->lower();
//   tmpbtngrp->setTitle(i18n ("CallKeys"));

   y = 10;
   for (i=0;i<10;i++)
   {
      l = new QLabel( tmpbtngrp );
      l->setGeometry( 10, y, 30, 20 );
      tmp.sprintf("F%i", i+1);
      l->setText( tmp );

      f_keys[i] = new QLineEdit( tmpbtngrp );
      f_keys[i]->setGeometry( 40, y, 100, 20 );
      f_keys[i]->setText( "" );
      f_keys[i]->setMaxLength( 10 );

      ssid[i] = new QCheckBox( tmpbtngrp );
      ssid[i]->setText("ssid");
      ssid[i]->setGeometry(150, y, 50, 20);

      if ((callkey = conf->getCallKey(i)) != NULL)
      {
			f_keys[i]->setText( callkey->call );
			ssid[i]->setChecked( callkey->ssid );
		}

      y += 20;
   }


   setCreated();
}
//---------------------------------------------------------------------------
PrefCallKey::~PrefCallKey()
{
}
//---------------------------------------------------------------------------
void PrefCallKey::save( KConfig *kconfig )
{
   int i;
   QString tmp;
   s_callKey *callkey;


   kconfig->setGroup("CallKey");
   for (i=0;i<10;i++)
   {
      f_keys[i]->setText( f_keys[i]->text().upper() );
		if (conf->getCallKey(i) == NULL)
      {
			if (!f_keys[i]->text().isEmpty())
			{
         	conf->setCallKey(i, f_keys[i]->text(), ssid[i]->isChecked() );

		      tmp.sprintf("F%i", i);
		      kconfig->writeEntry(tmp, conf->getCallKey(i)->call);

		      tmp.sprintf("ssid%i", i);
		      if (ssid[i]->isChecked())
		         kconfig->writeEntry(tmp, "1");
		      else
		         kconfig->writeEntry(tmp, "0");
			}
         continue;
		}


      callkey = conf->getCallKey(i);

   	if ((f_keys[i]->text() != callkey->call) ||
          (ssid[i]->isChecked() != callkey->ssid))
		{
      	// Dieser Eintrag wurde geaendert

         if (f_keys[i]->text().isEmpty())
         {
         	// Der Eintrag wird geloescht
            conf->delCallKey(i);

	   	   tmp.sprintf( "F%i", i );
		      kconfig->writeEntry( tmp, "" );
		      tmp.sprintf( "ssid%i", i );
	         kconfig->writeEntry( tmp, "0" );

         	continue;
         }

         conf->setCallKey( i, f_keys[i]->text(), ssid[i]->isChecked() );

	      tmp.sprintf("F%i", i);
	      kconfig->writeEntry(tmp, conf->getCallKey(i)->call);

	      tmp.sprintf("ssid%i", i);
	      if (ssid[i]->isChecked())
	         kconfig->writeEntry(tmp, "1");
	      else
	         kconfig->writeEntry(tmp, "0");
      }
   }
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
PrefDirs::PrefDirs( QWidget *parent, const QString & caption )
					:	PrefWidget( parent, caption )
{
}
//---------------------------------------------------------------------------
void PrefDirs::createPrefWidget()
{
	QLabel *l;
   int x=0;
   QButtonGroup * tmpbtngrp;


   tmpbtngrp = new QButtonGroup( this );
   tmpbtngrp->setGeometry( 0, 0, 330, 100 );
   tmpbtngrp->setFrameStyle( 49 );
   tmpbtngrp->setAlignment( 1 );
   tmpbtngrp->lower();
//   tmpbtngrp->setTitle( i18n("Position") );



   l = new QLabel( tmpbtngrp );
   l->setGeometry( 10, 10, 10, 20 );
   l->setText( i18n("AutoBIN:") );
   l->resize( l->sizeHint() );
   if (l->width() > x) x = l->width();

   l = new QLabel( tmpbtngrp );
   l->setGeometry( 10, 30, 10, 20 );
   l->setText( i18n("7plus:") );
   l->resize( l->sizeHint() );
   if (l->width() > x) x = l->width();

   l = new QLabel( tmpbtngrp );
   l->setGeometry( 10, 50, 10, 20 );
   l->setText( i18n("down:") );
   l->resize( l->sizeHint() );
   if (l->width() > x) x = l->width();

   l = new QLabel( tmpbtngrp );
   l->setGeometry( 10, 70, 10, 20 );
   l->setText( i18n("up:") );
   l->resize( l->sizeHint() );
   if (l->width() > x) x = l->width();


   x += 10;

   abin = new QLineEdit( tmpbtngrp );
   abin->setGeometry( x+10, 10, tmpbtngrp->width()-20-x, 20 );

   splus = new QLineEdit( tmpbtngrp );
   splus->setGeometry( x+10, 30, tmpbtngrp->width()-20-x, 20 );

   down = new QLineEdit( tmpbtngrp );
   down->setGeometry( x+10, 50, tmpbtngrp->width()-20-x, 20 );

   up = new QLineEdit( tmpbtngrp );
   up->setGeometry( x+10, 70, tmpbtngrp->width()-20-x, 20 );


/*   abin->setText( config->dirABin );
   splus->setText( config->dir7plus );
   down->setText( config->dirDown );
   up->setText( config->dirUp );*/
   abin->setText( conf->getStartDirABin() );
   splus->setText( conf->getStartDir7plus() );
   down->setText( conf->getStartDirDown() );
   up->setText( conf->getStartDirUp() );


	setCreated();
}
//---------------------------------------------------------------------------
PrefDirs::~PrefDirs()
{
}
//---------------------------------------------------------------------------
void PrefDirs::save( KConfig *kconfig )
{
	QString tmp;
/*	const char *tmp;


   tmp = (const char *)abin->text();
	if (!strcmp( tmp, config->dirABin ))
   {
   	free( config->dirABin );
      config->dirABin = (char *) strdup( tmp );
   }

   tmp = (const char *)splus->text();
	if (!strcmp( tmp, config->dir7plus ))
   {
   	free( config->dir7plus );
      config->dir7plus = (char *) strdup( tmp );
   }

   tmp = (const char *)down->text();
	if (!strcmp( tmp, config->dirDown ))
   {
   	free( config->dirDown );
      config->dirDown = (char *) strdup( tmp );
   }

   tmp = (const char *)up->text();
	if (!strcmp( tmp, config->dirUp ))
   {
   	free( config->dirUp );
      config->dirUp = (char *) strdup( tmp );
   }*/

   kconfig->setGroup("Directories");

   tmp = abin->text();
	if (tmp != conf->getDirABin())
   {
      conf->setStartDirABin( tmp );
		kconfig->writeEntry( "abin", tmp );
	}

   tmp = splus->text();
	if (tmp != conf->getDir7plus())
   {
   	conf->setStartDir7plus( tmp );
		kconfig->writeEntry( "7plus", tmp );
	}

   tmp = down->text();
	if (tmp != conf->getDirDown())
   {
   	conf->setStartDirDown( tmp );
		kconfig->writeEntry( "down", tmp );
	}

   tmp = up->text();
	if (tmp != conf->getDirUp())
   {
		conf->setStartDirUp( tmp );
		kconfig->writeEntry( "up", tmp );
	}
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
PrefTerminal::PrefTerminal( QWidget *parent, const QString & caption )
					:	PrefWidget( parent, caption )
{
}
//---------------------------------------------------------------------------
void PrefTerminal::createPrefWidget()
{
   QButtonGroup * tmpbtngrp;


   tmpbtngrp = new QButtonGroup( this );
   tmpbtngrp->setGeometry( 0, 0, 330, 60 );
   tmpbtngrp->setFrameStyle( 49 );
   tmpbtngrp->setAlignment( 1 );
   tmpbtngrp->lower();
//   tmpbtngrp->setTitle( i18n("Position") );

   cmbLog = new QCheckBox( tmpbtngrp );
   cmbLog->setGeometry( 10, 10, tmpbtngrp->width()-20, 20 );
   cmbLog->setText( i18n("Use the logbook") );

	cmbShowTSID = new QCheckBox( tmpbtngrp );
   cmbShowTSID->setGeometry( 10, 30, tmpbtngrp->width()-20, 20 );
   cmbShowTSID->setText( i18n("Show the SID") );

   cmbLog->setChecked( conf->getFlag(CFG_USELOG) );
   cmbShowTSID->setChecked( conf->getFlag(CFG_SHOWTSID) );


   setCreated();
}
//---------------------------------------------------------------------------
PrefTerminal::~PrefTerminal()
{
}
//---------------------------------------------------------------------------
void PrefTerminal::save( KConfig *kconfig )
{
	kconfig->setGroup( "Terminal" );

   if (cmbLog->isChecked() != conf->getFlag(CFG_USELOG) )
		conf->saveFlagToFile( kconfig, CFG_USELOG, "useLogbook", cmbLog->isChecked() );

   if (cmbShowTSID->isChecked() != conf->getFlag(CFG_SHOWTSID) )
		conf->saveFlagToFile( kconfig, CFG_SHOWTSID, "showTSID", cmbShowTSID->isChecked() );
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
PrefQSOWin::PrefQSOWin( QWidget *parent, const QString & caption )
					:	PrefWidget( parent, caption )
{
}
//---------------------------------------------------------------------------
void PrefQSOWin::createPrefWidget()
{
   QLabel *l;
   QButtonGroup *tmpbtngrp;
   char tmp[100];


   tmpbtngrp = new QButtonGroup( this );
   tmpbtngrp->setGeometry( 0, 0, 140, 70 );
   tmpbtngrp->setFrameStyle( 49 );
   tmpbtngrp->setAlignment( 1 );
   tmpbtngrp->lower();
   tmpbtngrp->setTitle(i18n ("Buffersizes (lines)"));

   l = new QLabel( tmpbtngrp );
   l->setGeometry( 10, 20, 60, 20 );
   l->setText(i18n ("QSO window") );

   l = new QLabel( tmpbtngrp );
   l->setGeometry( 10, 40, 60, 20 );
   l->setText(i18n ("TX window") );

   rxSize = new KIntLineEdit( tmpbtngrp );
   rxSize->setGeometry( 80, 20, 50, 20 );
   rxSize->setMaxLength( 5 );

   txSize = new KIntLineEdit( tmpbtngrp );
   txSize->setGeometry( 80, 40, 50, 20 );
   txSize->setMaxLength( 4 );



   // Zeilenumbruch
   tmpbtngrp = new QButtonGroup( this );
   tmpbtngrp->setGeometry( 150, 0, 180, 70 );
   tmpbtngrp->setFrameStyle( 49 );
   tmpbtngrp->setAlignment( 1 );
   tmpbtngrp->lower();
   tmpbtngrp->setTitle(i18n ("line break"));


   chkbUmbruch = new QCheckBox( tmpbtngrp );
   chkbUmbruch->setGeometry( 10, 20, 160, 20 );
   chkbUmbruch->setText( i18n ("automatic line break") );
   connect(chkbUmbruch, SIGNAL(toggled(bool)), this, SLOT(slotToggleUmbruch(bool)));

   l = new QLabel( tmpbtngrp );
   l->setGeometry( 30, 40, 80, 20 );
   l->setText( i18n ("in column")+" " );
   l->resize( l->sizeHint() );

   ledPos = new KIntLineEdit( tmpbtngrp );
   ledPos->setGeometry( 40+l->width(), 40, 50, 20);
   ledPos->setMaxLength( 3 );



   tmpbtngrp = new QButtonGroup( this );
   tmpbtngrp->setGeometry( 0, 80, 140, 70 );
   tmpbtngrp->setFrameStyle( 49 );
   tmpbtngrp->setAlignment( 1 );
   tmpbtngrp->lower();
   tmpbtngrp->setTitle(i18n ("QSO window"));

   rxTop = new QRadioButton( tmpbtngrp );
   rxTop->setGeometry( 10, 20, 120, 20 );
   rxTop->setText( i18n("above TX") );
   tmpbtngrp->insert( rxTop );

   rxBottom = new QRadioButton( tmpbtngrp );
   rxBottom->setGeometry( 10, 40, 120, 20 );
   rxBottom->setText( i18n("below TX") );
   tmpbtngrp->insert( rxBottom );



   tmpbtngrp = new QButtonGroup( this );
   tmpbtngrp->setGeometry( 150, 80, 180, 70 );
   tmpbtngrp->setFrameStyle( 49 );
   tmpbtngrp->setAlignment( 1 );
   tmpbtngrp->lower();
   tmpbtngrp->setTitle(i18n ("TX Windowsize"));

   l = new QLabel( tmpbtngrp );
   l->setGeometry( 10, 15, 20, 20 );
   l->setText( "0%" );

   l = new QLabel( tmpbtngrp );
   l->setGeometry( 130, 15, 40, 20 );
   l->setText( "100%" );
   l->setAlignment( AlignRight );

   lPercent = new QLabel( tmpbtngrp );
   lPercent->setGeometry( 45, 45, 100, 20 );
   lPercent->setText( "0%" );
   lPercent->setAlignment( AlignCenter );
   slotSliderMoved( conf->getTxWinSize() );

   slider = new QSlider( 0, 100, 1, conf->getTxWinSize(), QSlider::Horizontal, tmpbtngrp );
   slider->setGeometry( 10, 35, 160, 10 );
   connect(slider, SIGNAL(valueChanged(int)), SLOT(slotSliderMoved(int)));


   // Variablen besetzen
   sprintf( tmp, "%i", conf->getRxBuffersize() );
   rxSize->setText(tmp);
   sprintf( tmp, "%i", conf->getTxBuffersize() );
   txSize->setText(tmp);

   rxTop->setChecked( !conf->getFlag(CFG_TXWINOBEN) );
   rxBottom->setChecked( !rxTop->isChecked() );

	chkbUmbruch->setChecked( conf->getFlag(CFG_UMBRUCH) );
	ledPos->setEnabled( chkbUmbruch->isChecked() );

   sprintf( tmp, "%i", conf->getUmbruchPos() );
   ledPos->setText( tmp );


   setCreated();
}
//---------------------------------------------------------------------------
PrefQSOWin::~PrefQSOWin()
{
}
//---------------------------------------------------------------------------
void PrefQSOWin::slotSliderMoved( int value )
{
   QString tmp;

   tmp.sprintf("%i%%", value);
   lPercent->setText(tmp);
}
//---------------------------------------------------------------------------
void PrefQSOWin::slotToggleUmbruch( bool active )
{
	ledPos->setEnabled( active );
}
//---------------------------------------------------------------------------
void PrefQSOWin::save( KConfig *kconfig )
{
   kconfig->setGroup("Screen");

	if (conf->getTxWinSize() != slider->value())
   {
	   conf->setTxWinSize( slider->value() );
//	   sprintf( tmp, "%i", config->txWinSize );
	   kconfig->writeEntry( "txWinSize", conf->getTxWinSize() );
	}


   // TX- oder RX-Fenster im QSO-Fenster oben?
   if (rxBottom->isChecked() != conf->getFlag(CFG_TXWINOBEN))
		conf->saveFlagToFile( kconfig, CFG_TXWINOBEN, "txWinOben", rxBottom->isChecked() );


   // Zeilenumbruch
   if (chkbUmbruch->isChecked() != conf->getFlag(CFG_UMBRUCH) ||
       conf->getUmbruchPos() != ledPos->text().toInt())
 	{
		conf->saveFlagToFile( kconfig, CFG_UMBRUCH, "lineBreak", chkbUmbruch->isChecked() );

      // Position des Zeilenumbruchs
      conf->setUmbruchPos( ledPos->text().toInt() );
      kconfig->writeEntry( "lineBreakPos", conf->getUmbruchPos() );
   }


   kconfig->setGroup("Buffersizes" );

   if (conf->getRxBuffersize() != rxSize->text().toInt())
   {
	   kconfig->writeEntry( "receive", rxSize->text() );
	   conf->setRxBuffersize( rxSize->text().toInt() );
   }
   if (conf->getTxBuffersize() != txSize->text().toInt())
   {
	   kconfig->writeEntry( "transmit", txSize->text() );
	   conf->setTxBuffersize( txSize->text().toInt() );
	}
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
PrefScreen::PrefScreen( QWidget *parent, const QString & caption )
					:	PrefWidget( parent, caption )
{
}
//---------------------------------------------------------------------------
void PrefScreen::createPrefWidget()
{
	int y=10;
   int w;
   QButtonGroup *tmpbtngrp;


   tmpbtngrp = new QButtonGroup( this );
   tmpbtngrp->setGeometry( 0, 0, 330, 220 );
   tmpbtngrp->setFrameStyle( 49 );
   tmpbtngrp->setAlignment( 1 );
   tmpbtngrp->lower();
//   tmpbtngrp->setTitle( i18n("Position") );

   w = tmpbtngrp->width()-20;

	chkbCloseWin = new QCheckBox( tmpbtngrp );
   chkbCloseWin->setGeometry( 10, y, w, 20 );
   chkbCloseWin->setText( i18n("Close window on disconnect") );
   y += 20;

	chkbHideWin = new QCheckBox( tmpbtngrp );
   chkbHideWin->setGeometry( 10, y, w, 20 );
   chkbHideWin->setText( i18n("Hide old window when switching the channel") );
   y += 20;

	chkbLocalEcho = new QCheckBox( tmpbtngrp );
   chkbLocalEcho->setGeometry( 10, y, w, 20 );
   chkbLocalEcho->setText( i18n("Local echo") );
   y += 20;

	chkbBeep = new QCheckBox( tmpbtngrp );
   chkbBeep->setGeometry( 10, y, w, 20 );
   chkbBeep->setText( i18n("beep on ctrl-g") );
   y += 20;

   chkbOpenWin = new QCheckBox( tmpbtngrp );
   chkbOpenWin->setGeometry( 10, y, w, 20 );
   chkbOpenWin->setText( i18n("Open channel window immediately") );
   y += 20;


   // Start-Werte einlesen
   chkbCloseWin->setChecked( conf->getFlag(CFG_CLOSEWINDISC) );
   chkbHideWin->setChecked( conf->getFlag(CFG_HIDEWINSWITCH) );
   chkbLocalEcho->setChecked( conf->getFlag(CFG_LOCALECHO) );
   chkbBeep->setChecked( conf->getFlag(CFG_BEEPCTRLG) );
   chkbOpenWin->setChecked( conf->getFlag(CFG_OPENCHANWIN) );


   setCreated();
}
//---------------------------------------------------------------------------
PrefScreen::~PrefScreen()
{
}
//---------------------------------------------------------------------------
void PrefScreen::save( KConfig *kconfig )
{
	kconfig->setGroup( "Screen" );


	if (conf->getFlag(CFG_CLOSEWINDISC) != chkbCloseWin->isChecked())
		conf->saveFlagToFile( kconfig, CFG_CLOSEWINDISC, "closeWinOnDisc", chkbCloseWin->isChecked() );

	if (conf->getFlag(CFG_HIDEWINSWITCH) != chkbHideWin->isChecked())
		conf->saveFlagToFile( kconfig, CFG_HIDEWINSWITCH, "hideWinOnSwitch", chkbHideWin->isChecked() );

	if (conf->getFlag(CFG_LOCALECHO) != chkbLocalEcho->isChecked())
		conf->saveFlagToFile( kconfig, CFG_LOCALECHO, "localEcho", chkbLocalEcho->isChecked() );

	if (conf->getFlag(CFG_BEEPCTRLG) != chkbBeep->isChecked())
		conf->saveFlagToFile( kconfig, CFG_BEEPCTRLG, "beepCtrlG", chkbBeep->isChecked() );

	if (conf->getFlag(CFG_OPENCHANWIN) != chkbOpenWin->isChecked())
		conf->saveFlagToFile( kconfig, CFG_OPENCHANWIN, "openChannelWin", chkbOpenWin->isChecked() );
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
PrefGnuPG::PrefGnuPG( QWidget *parent, const QString & caption )
					:	PrefWidget( parent, caption )

{
}
//---------------------------------------------------------------------------
void PrefGnuPG::createPrefWidget()
{
   QButtonGroup *tmpbtngrp;
   QLabel *l;
   QVBoxLayout *vbox, *vboxmain;
   QHBoxLayout *hbox;


   vboxmain = new QVBoxLayout( this );

   tmpbtngrp = new QButtonGroup( this );
	tmpbtngrp->resize( 330, 120 );
   tmpbtngrp->setFrameStyle( 49 );
   tmpbtngrp->setAlignment( 1 );
   tmpbtngrp->lower();

	vboxmain->addWidget( tmpbtngrp );

	vbox = new QVBoxLayout( tmpbtngrp );
   vbox->setMargin( 5 );
   vbox->setSpacing( 2 );

	enable = new QCheckBox( tmpbtngrp );
   enable->setText( i18n("Autocheck signatures") );
   connect( enable, SIGNAL(toggled(bool)), SLOT(slotEnableToggled(bool)) );

	import = new QCheckBox( tmpbtngrp );
   import->setText( i18n("Autoimport public-keys") );
   connect( import, SIGNAL(toggled(bool)), SLOT(slotImportToggled(bool)) );

	askImport = new QCheckBox( tmpbtngrp );
   askImport->setText( i18n("Ask before importing") );

   addSig = new QCheckBox( tmpbtngrp );
   addSig->setText( i18n("Add signature") );
   connect( addSig, SIGNAL(toggled(bool)), SLOT(slotSigToggled(bool)) );

	l = new QLabel( tmpbtngrp );
   l->setText( i18n("File:") );
   l->resize( l->sizeHint() );

	edSig = new QLineEdit( tmpbtngrp );

	vbox->addWidget( enable );
	vbox->addWidget( import );

   hbox = new QHBoxLayout( vbox );
   hbox->addSpacing( 20 );
	hbox->addWidget( askImport );

	vbox->addWidget( addSig );

   hbox = new QHBoxLayout( vbox );
	hbox->addWidget( l );
   hbox->addSpacing( 3 );
   hbox->addWidget( edSig, 1 );

   tmpbtngrp->resize( tmpbtngrp->width(), vbox->minimumSize().height() );


   vboxmain->addSpacing( 5 );

   tmpbtngrp = new QButtonGroup( this );
   tmpbtngrp->resize( 330, 50 );
   tmpbtngrp->setFrameStyle( 49 );
   tmpbtngrp->setAlignment( 1 );
   tmpbtngrp->lower();
   tmpbtngrp->setTitle( i18n("Use this private key:") );

   vbox = new QVBoxLayout( tmpbtngrp );
   vbox->setMargin( 7 );
   vbox->addSpacing( 10 );

   cmbSecKey = new QComboBox( tmpbtngrp );
   cmbSecKey->insertItem( i18n("default key") );

   vbox->addWidget( cmbSecKey );

   vboxmain->addWidget( tmpbtngrp );

   vboxmain->addStretch( 1 );


	enable->setChecked( conf->getFlag(CFG_GPGSUPPORT) );
	import->setChecked( conf->getFlag(CFG_GPGIMPORTKEYS) );
   askImport->setChecked( conf->getFlag(CFG_GPGASKIMPORTKEYS) );
   addSig->setChecked( conf->getFlag(CFG_GPGADDSIG) );
   edSig->setText( conf->getSig() );

   slotEnableToggled( enable->isChecked() );
   slotSigToggled( addSig->isChecked() );


	key = conf->getGpgID();

	gpgkey = new GPGKeys();
   connect( gpgkey, SIGNAL(gpgKey(s_GPGKey *)), SLOT(slotGpgKey(s_GPGKey *)));
   gpgkey->listSec();


   setCreated();
}
//---------------------------------------------------------------------------
PrefGnuPG::~PrefGnuPG()
{
}
//---------------------------------------------------------------------------
void PrefGnuPG::slotGpgKey( s_GPGKey *gkey )
{
	if (gkey == NULL)
   {
      delete gpgkey;
      gpgkey = NULL;
      return;
   }

	if (!strcmp(gkey->type, "sec"))
   {
      cmbSecKey->insertItem( gkey->uid );
		if (!strcmp(gkey->uid, key))
			cmbSecKey->setCurrentItem( cmbSecKey->count()-1 );
	}

	gpgkey->freeKey( gkey );
}
//---------------------------------------------------------------------------
void PrefGnuPG::save( KConfig *kconfig )
{
	char newkey[500];


	kconfig->setGroup( "GnuPG" );

	if (conf->getFlag(CFG_GPGSUPPORT) != enable->isChecked())
   	conf->saveFlagToFile( kconfig, CFG_GPGSUPPORT, "enable", enable->isChecked() );

	if (conf->getFlag(CFG_GPGIMPORTKEYS) != import->isChecked())
   	conf->saveFlagToFile( kconfig, CFG_GPGIMPORTKEYS, "import", import->isChecked() );

	if (conf->getFlag(CFG_GPGASKIMPORTKEYS) != askImport->isChecked())
   	conf->saveFlagToFile( kconfig, CFG_GPGASKIMPORTKEYS, "askImport", askImport->isChecked() );

	if (conf->getFlag(CFG_GPGADDSIG) != addSig->isChecked())
   	conf->saveFlagToFile( kconfig, CFG_GPGADDSIG, "addSignature", addSig->isChecked() );

   kconfig->writeEntry("signature", edSig->text());
   conf->setSig( edSig->text() );

   if (cmbSecKey->currentItem() == 0)
   	newkey[0] = '\0';
	else
   	strncpy( newkey, (const char *) cmbSecKey->text(cmbSecKey->currentItem()), 499 );

	if (strcmp( newkey, key ))
   {
		kconfig->writeEntry("useKey", newkey);
		conf->setGpgID( newkey );
   }

}
//---------------------------------------------------------------------------
void PrefGnuPG::slotEnableToggled( bool toggled )
{
   if (toggled)
   {
      import->setEnabled( true );
		askImport->setEnabled( import->isChecked() );
   }
   else
   {
		import->setEnabled( false );
		askImport->setEnabled( false );
   }
}
//---------------------------------------------------------------------------
void PrefGnuPG::slotImportToggled( bool toggled )
{
	if (toggled)
		askImport->setEnabled( true );
	else
		askImport->setEnabled( false );
}
//---------------------------------------------------------------------------
void PrefGnuPG::slotSigToggled( bool toggled )
{
	edSig->setEnabled( toggled );
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
PrefShortcuts::PrefShortcuts( QWidget *parent, const QString & caption ) : PrefWidget( parent, caption )
{
}
//---------------------------------------------------------------------------
void PrefShortcuts::createPrefWidget()
{
   QLabel *l;
   int i,y;
   char tmp[20];
   QButtonGroup *tmpbtngrp;
   QString str;


   tmpbtngrp = new QButtonGroup( this );
   tmpbtngrp->setGeometry( 0, 0, 330, 220 );
   tmpbtngrp->setFrameStyle( 49 );
   tmpbtngrp->setAlignment( 1 );
   tmpbtngrp->lower();
//   tmpbtngrp->setTitle( i18n("Position") );


   y = 10;
   for (i=0;i<10;i++)
   {
      l = new QLabel( tmpbtngrp );
      l->setGeometry( 10, y, 75, 20 );
      sprintf(tmp, "CTRL%i", i);
      l->setText( tmp );

      f_keys[i] = new QLineEdit( tmpbtngrp );
      f_keys[i]->setGeometry( 90, y, 230, 20 );
      str = conf->getShortcut(i);
      if (!str.isEmpty())
         f_keys[i]->setText( str );
      else
         f_keys[i]->setText("");

      y += 20;
   }


   setCreated();
}
//---------------------------------------------------------------------------
PrefShortcuts::~PrefShortcuts()
{
}
//---------------------------------------------------------------------------
void PrefShortcuts::save( KConfig *kconfig )
{
	int i;
   char tmp[50];
   QString text;


   kconfig->setGroup("Shortcuts");
   for (i=0;i<10;i++)
   {
      text=conf->getShortcut(i);
      if (text.isNull()) text="";
		if (text == f_keys[i]->text())
			continue;

		conf->setShortcut( i, f_keys[i]->text() );
		sprintf(tmp, "CTRL%i", i);
      kconfig->writeEntry(tmp, f_keys[i]->text());
   }
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
PrefFonts::PrefFonts( QWidget *parent, const QString & caption ) : PrefWidget( parent, caption )
{
}
//---------------------------------------------------------------------------
void PrefFonts::createPrefWidget()
{
   int x=0;
   QLabel *l;
   char tmp[100];
   QButtonGroup *tmpbtngrp;


   tmpbtngrp = new QButtonGroup( this );
//   tmpbtngrp->setGeometry( 0, 0, 295, 150 );
   tmpbtngrp->setGeometry( 0, 0, 295, 200 );
   tmpbtngrp->setFrameStyle( 49 );
   tmpbtngrp->setAlignment( 1 );
   tmpbtngrp->lower();
//   tmpbtngrp->setTitle( i18n("Position") );

   l = new QLabel( tmpbtngrp );
   l->setGeometry( 5, 140, tmpbtngrp->width()-10, 40 );
   l->setAlignment( Qt::AlignLeft | Qt::AlignTop | Qt::WordBreak );
   l->setText( i18n("You can change the font by pressing the '..'-button. You will see the result immediately.") );
   l->setMinimumSize( QSize(tmpbtngrp->width()-10, 0) );
   l->resize( l->sizeHint() );

	tmpbtngrp->setGeometry( 0, 0, 295, 150+l->height() );


   l = new QLabel( tmpbtngrp );
   l->setAlignment( Qt::AlignLeft | Qt::AlignVCenter );
   l->setGeometry( 10, 10, 20, 30 );
	l->setText( i18n("QSO window:") );
   l->resize( l->sizeHint().width(), l->height() );
   if (x < l->width()) x = l->width();

   l = new QLabel( tmpbtngrp );
   l->setAlignment( Qt::AlignLeft | Qt::AlignVCenter );
   l->setGeometry( 10, 40, 20, 30 );
	l->setText( i18n("TX window:") );
   l->resize( l->sizeHint().width(), l->height() );
   if (x < l->width()) x = l->width();

   l = new QLabel( tmpbtngrp );
   l->setAlignment( Qt::AlignLeft | Qt::AlignVCenter );
   l->setGeometry( 10, 70, 20, 30 );
	l->setText( i18n("BoxCheck:") );
   l->resize( l->sizeHint().width(), l->height() );
   if (x < l->width()) x = l->width();

   l = new QLabel( tmpbtngrp );
   l->setAlignment( Qt::AlignLeft | Qt::AlignVCenter );
   l->setGeometry( 10, 100, 20, 30 );
	l->setText( i18n("GPG message:") );
   l->resize( l->sizeHint().width(), l->height() );
   if (x < l->width()) x = l->width();


	x += 15;

   fQso = conf->qsoFont();
   fTx = conf->txFont();
   fBcheck = conf->bcFont();
   fGPG = conf->gpgFont();


	lQso = new QLabel( tmpbtngrp );
   lQso->setAlignment( Qt::AlignLeft | Qt::AlignVCenter );
   lQso->setGeometry( x, 10, 230-x, 30 );
   sprintf( tmp, "%s, %i pt", (const char *)conf->qsoFont().family(), conf->qsoFont().pointSize() );
	lQso->setText( tmp );
   lQso->setFont( fQso );

	lTx = new QLabel( tmpbtngrp );
   lTx->setAlignment( Qt::AlignLeft | Qt::AlignVCenter );
   lTx->setGeometry( x, 40, 230-x, 30 );
   sprintf( tmp, "%s, %i pt", (const char *)conf->txFont().family(), conf->txFont().pointSize() );
	lTx->setText( tmp );
   lTx->setFont( fTx );

	lBcheck = new QLabel( tmpbtngrp );
   lBcheck->setAlignment( Qt::AlignLeft | Qt::AlignVCenter );
   lBcheck->setGeometry( x, 70, 230-x, 30 );
   sprintf( tmp, "%s, %i pt", (const char *)conf->bcFont().family(), conf->bcFont().pointSize() );
	lBcheck->setText( tmp );
   lBcheck->setFont( fBcheck );

	lGPG = new QLabel( tmpbtngrp );
   lGPG->setAlignment( Qt::AlignLeft | Qt::AlignVCenter );
   lGPG->setGeometry( x, 100, 230-x, 30 );
   sprintf( tmp, "%s, %i pt", (const char *)conf->gpgFont().family(), conf->gpgFont().pointSize() );
	lGPG->setText( tmp );
   lGPG->setFont( fGPG );

	btnQso = new QPushButton( tmpbtngrp );
   btnQso->setGeometry( 260, 15, 25, 22 );
   btnQso->setText("..");
   connect( btnQso, SIGNAL(clicked()), this, SLOT(slotQsoFontChange()));
   QToolTip::add( btnQso, i18n("Choose font") );

	btnTx = new QPushButton( tmpbtngrp );
   btnTx->setGeometry( 260, 45, 25, 22 );
   btnTx->setText("..");
   connect( btnTx, SIGNAL(clicked()), this, SLOT(slotTxFontChange()));
   QToolTip::add( btnTx, i18n("Choose font") );

	btnBcheck = new QPushButton( tmpbtngrp );
   btnBcheck->setGeometry( 260, 75, 25, 22 );
   btnBcheck->setText("..");
   connect( btnBcheck, SIGNAL(clicked()), this, SLOT(slotBCheckFontChange()));
   QToolTip::add( btnBcheck, i18n("Choose font") );

	btnGPG = new QPushButton( tmpbtngrp );
   btnGPG->setGeometry( 260, 105, 25, 22 );
   btnGPG->setText("..");
   connect( btnGPG, SIGNAL(clicked()), this, SLOT(slotGPGFontChange()));
   QToolTip::add( btnGPG, i18n("Choose font") );


   setCreated();
}
//---------------------------------------------------------------------------
PrefFonts::~PrefFonts()
{
}
//---------------------------------------------------------------------------
void PrefFonts::save( KConfig *kconfig )
{
   kconfig->setGroup("Fonts");


   if (fQso != conf->qsoFont())
   {
	   kconfig->writeEntry( "qsoWin", getFontString(fQso) );
      conf->setQsoFont( fQso );
	}

   if (fTx != conf->txFont())
   {
	   kconfig->writeEntry("txWin", getFontString(fTx) );
      conf->setTxFont( fTx );
	}

   if (fBcheck != conf->bcFont())
   {
	   kconfig->writeEntry("boxCheck", getFontString(fBcheck) );
      conf->setBcFont( fBcheck );
	}

   if (fGPG != conf->gpgFont())
   {
	   kconfig->writeEntry("gpgWindow", getFontString(fGPG) );
      conf->setGpgFont( fGPG );
	}
}
//---------------------------------------------------------------------------
char * PrefFonts::getFontString( const QFont & font )
{
	static char str[200];
	char flag[50]="";

   if (font.bold())
   	strcat( flag, "B" );
	if (font.italic())
   	strcat( flag, "I" );
 	if (font.underline())
   	strcat( flag, "U" );
	if (font.strikeOut())
   	strcat( flag, "S" );

   sprintf( str, "%s,%i,%s", (const char *)font.family(), font.pointSize(), flag );
   return str;
}
//---------------------------------------------------------------------------
void PrefFonts::slotQsoFontChange()
{
	bool ok;
   QFont font;
   char tmp[100];


	font = QFontDialog::getFont( &ok, fQso, this );

   if (ok)
   {
   	fQso = font;
	   sprintf( tmp, "%s, %i pt", (const char *)fQso.family(), fQso.pointSize() );
		lQso->setText( tmp );
	   lQso->setFont( fQso );
   }
}
//---------------------------------------------------------------------------
void PrefFonts::slotTxFontChange()
{
	bool ok;
   QFont font;
   char tmp[100];


	font = QFontDialog::getFont( &ok, fTx, this );

   if (ok)
   {
   	fTx = font;
	   sprintf( tmp, "%s, %i pt", (const char *)fTx.family(), fTx.pointSize() );
		lTx->setText( tmp );
	   lTx->setFont( fQso );
   }
}
//---------------------------------------------------------------------------
void PrefFonts::slotBCheckFontChange()
{
	bool ok;
   QFont font;
   char tmp[100];


	font = QFontDialog::getFont( &ok, fBcheck, this );

   if (ok)
   {
   	fBcheck = font;
	   sprintf( tmp, "%s, %i pt", (const char *)fBcheck.family(), fBcheck.pointSize() );
		lBcheck->setText( tmp );
	   lBcheck->setFont( fQso );
   }
}
//---------------------------------------------------------------------------
void PrefFonts::slotGPGFontChange()
{
	bool ok;
   QFont font;
   char tmp[100];


	font = QFontDialog::getFont( &ok, fGPG, this );

   if (ok)
   {
   	fGPG = font;
	   sprintf( tmp, "%s, %i pt", (const char *)fGPG.family(), fGPG.pointSize() );
		lGPG->setText( tmp );
	   lGPG->setFont( fQso );
   }
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
PrefColors::PrefColors( QWidget *parent, const QString & caption )
		: PrefWidget( parent, caption )
{
}
//---------------------------------------------------------------------------
void PrefColors::createPrefWidget()
{
   QLabel *l;
   int i;
   int rxcolor, txcolor, statuscolor, gpgcolor, background, txwin;
   int txbackground, markcolor, markback;


   tabs = new QTabWidget( this );
   tabs->resize( 300, 200 );

   qso = new QWidget( tabs );
   tx = new QWidget( tabs );
   marked = new QWidget( tabs );
   chanlist = new QWidget( tabs );


   l = new QLabel( qso );
   l->setGeometry( 10, 20, 80, 20 );
   l->setText(i18n ("RX text") );

   l = new QLabel( qso );
   l->setGeometry( 10, 40, 80, 20 );
   l->setText(i18n ("TX text") );

   l = new QLabel( qso );
   l->setGeometry( 10, 60, 80, 20 );
   l->setText(i18n ("Status") );

   l = new QLabel( qso );
   l->setGeometry( 10, 80, 80, 20 );
   l->setText(i18n ("GPG text") );

   l = new QLabel( qso );
   l->setGeometry( 10, 100, 80, 20 );
   l->setText(i18n ("Background") );


   rxwin_color = new QComboBox( qso );
   rxwin_color->setGeometry( 90, 20, 130, 20 );

   txwin_color = new QComboBox( qso );
   txwin_color->setGeometry( 90, 40, 130, 20 );

   status_color = new QComboBox( qso );
   status_color->setGeometry( 90, 60, 130, 20 );

   gpg_color = new QComboBox( qso );
   gpg_color->setGeometry( 90, 80, 130, 20 );

   background_color = new QComboBox( qso );
   background_color->setGeometry( 90, 100, 130, 20 );

/*   allowANSI = new QCheckBox( this );
   allowANSI->setGeometry( 10, 145, 190, 20 );
   allowANSI->setText( i18n ("Allow ANSI-Codes?") );
*/


   l = new QLabel( tx );
   l->setGeometry( 10, 20, 80, 20 );
   l->setText(i18n ("Text") );

   l = new QLabel( tx );
   l->setGeometry( 10, 40, 80, 20 );
   l->setText(i18n ("Background") );

   txtext_color = new QComboBox( tx );
   txtext_color->setGeometry( 90, 20, 130, 20 );

   txbackground_color = new QComboBox( tx );
   txbackground_color->setGeometry( 90, 40, 130, 20 );


   l = new QLabel( marked );
   l->setGeometry( 10, 20, 80, 20 );
   l->setText(i18n ("Text") );

   l = new QLabel( marked );
   l->setGeometry( 10, 40, 80, 20 );
   l->setText(i18n ("Background") );

   mark_color = new QComboBox( marked );
   mark_color->setGeometry( 90, 20, 130, 20 );

   mark_background = new QComboBox( marked );
   mark_background->setGeometry( 90, 40, 130, 20 );


   tabs->addTab( qso, i18n("QSO window") );
   tabs->addTab( tx, i18n("TX window") );
   tabs->addTab( marked, i18n("Marked text") );


   // Werte setzen
   QPixmap pm( 16, 16 );

   rxcolor = conf->getColor( CFG_COLOR_RX );
   txcolor = conf->getColor( CFG_COLOR_TX );
   statuscolor = conf->getColor( CFG_COLOR_STATUS );
   gpgcolor = conf->getColor( CFG_COLOR_GPG );
   background = conf->getColor( CFG_COLOR_BG );
   txwin = conf->getColor( CFG_COLOR_TXWIN );
   txbackground = conf->getColor( CFG_COLOR_TXWINBG );
   markcolor = conf->getColor( CFG_COLOR_MARKFORE );
   markback = conf->getColor( CFG_COLOR_MARKBACK );


   for (i=0; i<17; i++)
   {
		pm.fill( colors[i].color );

      rxwin_color->insertItem( pm, colors[i].str );
      if (rxcolor == i)
      	rxwin_color->setCurrentItem( rxwin_color->count()-1 );

		txwin_color->insertItem( pm, colors[i].str );
      if (txcolor == i)
      	txwin_color->setCurrentItem( txwin_color->count()-1 );

		status_color->insertItem( pm, colors[i].str );
      if (statuscolor == i)
      	status_color->setCurrentItem( status_color->count()-1 );

		gpg_color->insertItem( pm, colors[i].str );
      if (gpgcolor == i)
      	gpg_color->setCurrentItem( gpg_color->count()-1 );

		background_color->insertItem( pm, colors[i].str );
      if (background == i)
      	background_color->setCurrentItem( background_color->count()-1 );

		txtext_color->insertItem( pm, colors[i].str );
      if (txwin == i)
      	txtext_color->setCurrentItem( txtext_color->count()-1 );

		txbackground_color->insertItem( pm, colors[i].str );
      if (txbackground == i)
      	txbackground_color->setCurrentItem( txbackground_color->count()-1 );

		mark_color->insertItem( pm, colors[i].str );
      if (markcolor == i)
      	mark_color->setCurrentItem( mark_color->count()-1 );

		mark_background->insertItem( pm, colors[i].str );
      if (markback == i)
      	mark_background->setCurrentItem( mark_background->count()-1 );
	}


   setCreated();
}
//---------------------------------------------------------------------------
PrefColors::~PrefColors()
{
}
//---------------------------------------------------------------------------
void PrefColors::save( KConfig *kconfig )
{
printf("PrefColors::save()\n");
	kconfig->setGroup( "Colors" );

   if (conf->getColor(CFG_COLOR_RX) != rxwin_color->currentItem())
		conf->saveColorToFile( kconfig, CFG_COLOR_RX, "receive", rxwin_color->currentItem() );

   if (conf->getColor(CFG_COLOR_TX) != txwin_color->currentItem())
		conf->saveColorToFile( kconfig, CFG_COLOR_TX, "transmit", txwin_color->currentItem() );

   if (conf->getColor(CFG_COLOR_STATUS) != status_color->currentItem())
		conf->saveColorToFile( kconfig, CFG_COLOR_STATUS, "status", status_color->currentItem() );

   if (conf->getColor(CFG_COLOR_GPG) != gpg_color->currentItem())
		conf->saveColorToFile( kconfig, CFG_COLOR_GPG, "gpg", gpg_color->currentItem() );

   if (conf->getColor(CFG_COLOR_BG) != background_color->currentItem())
		conf->saveColorToFile( kconfig, CFG_COLOR_BG, "background", background_color->currentItem() );

   if (conf->getColor(CFG_COLOR_TXWIN) != txtext_color->currentItem())
		conf->saveColorToFile( kconfig, CFG_COLOR_TXWIN, "txwin", txtext_color->currentItem() );

   if (conf->getColor(CFG_COLOR_TXWINBG) != txbackground_color->currentItem())
		conf->saveColorToFile( kconfig, CFG_COLOR_TXWINBG, "txbackground", txbackground_color->currentItem() );

   if (conf->getColor(CFG_COLOR_MARKFORE) != mark_color->currentItem())
		conf->saveColorToFile( kconfig, CFG_COLOR_MARKFORE, "qsoMarkColor", mark_color->currentItem() );

   if (conf->getColor(CFG_COLOR_MARKBACK) != mark_background->currentItem())
		conf->saveColorToFile( kconfig, CFG_COLOR_MARKBACK, "qsoMarkBackground", mark_background->currentItem() );
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
PrefFiletransfer::PrefFiletransfer( QWidget *parent, const QString & caption ) : PrefWidget( parent, caption )
{
}
//---------------------------------------------------------------------------
void PrefFiletransfer::createPrefWidget()
{
   QButtonGroup *btngrp1, *btngrp2;
   int w;
   QLabel *l;
   int i;
   char tmp[10];


   btngrp1 = new QButtonGroup( this );
   btngrp1->setGeometry( 0, 0, 120, 50 );
   btngrp1->setFrameStyle( 49 );
   btngrp1->setAlignment( 1 );
   btngrp1->lower();

   overwriteExisting = new QCheckBox( btngrp1 );
   overwriteExisting->setGeometry( 10, 5, 10, 20 );
   overwriteExisting->setText( i18n("Overwrite existing files") );
   overwriteExisting->resize( overwriteExisting->sizeHint());
   w = overwriteExisting->width();

   allowYappResume = new QCheckBox( btngrp1 );
   allowYappResume->setGeometry( 10, 25, 30, 20 );
   allowYappResume->setText( i18n("Allow YAPP resume mode") );
   allowYappResume->resize( allowYappResume->sizeHint());
   if (allowYappResume->width() > w) w = allowYappResume->width();

   btngrp2 = new QButtonGroup( this );
   btngrp2->setGeometry( 0, 55, 120, 65 );
   btngrp2->setFrameStyle( 49 );
   btngrp2->setAlignment( 1 );
   btngrp2->lower();
   btngrp2->setTitle( i18n("DIDADIT") );

   l = new QLabel( btngrp2 );
   l->setGeometry( 10, 15, 50, 20 );
   l->setText( i18n("Default blocksize") );
   l->resize( l->sizeHint());
   if (l->width() > w) w = l->width();

   RBlocksize = new QComboBox( btngrp2 );
   RBlocksize->setGeometry( 10, 35, 80, 20 );
   RBlocksize->resize( RBlocksize->sizeHint());
   if (RBlocksize->width() > w) w = RBlocksize->width();


   // Groesse der Felder setzen
   btngrp1->resize( w+20, btngrp1->height() );
   overwriteExisting->resize( w, overwriteExisting->height() );
   allowYappResume->resize( w, allowYappResume->height() );
   btngrp2->resize( w+20, btngrp2->height() );
   l->resize( w, l->height() );


   // Werte besetzen
   allowYappResume->setChecked( conf->getFlag(CFG_YAPPRESUME) );
   overwriteExisting->setChecked( conf->getFlag(CFG_OVERWRITEXIST) );

   for (i=0; i<8; i++)
   {
   	sprintf(tmp, "%i", (i+1)*1024);
      RBlocksize->insertItem( tmp );
   }
   RBlocksize->setCurrentItem( conf->getRBlocksize()-1 );


   setCreated();
}
//---------------------------------------------------------------------------
PrefFiletransfer::~PrefFiletransfer()
{
}
//---------------------------------------------------------------------------
void PrefFiletransfer::save( KConfig *kconfig )
{
	char tmp[100];


	kconfig->setGroup( "Filetransfer" );

	if (conf->getFlag(CFG_YAPPRESUME) != allowYappResume->isChecked())
		conf->saveFlagToFile( kconfig, CFG_YAPPRESUME, "yappResume", allowYappResume->isChecked() );

   if (conf->getFlag(CFG_OVERWRITEXIST) != overwriteExisting->isChecked())
		conf->saveFlagToFile( kconfig, CFG_OVERWRITEXIST, "overwriteExisting", overwriteExisting->isChecked() );


   if (RBlocksize->currentItem()+1 != conf->getRBlocksize() )
   {
		conf->setRBlocksize( RBlocksize->currentItem()+1 );
      sprintf(tmp, "%i", conf->getRBlocksize());
		kconfig->writeEntry( "didaditBlocksize", tmp );
	}
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
MyIfaceCheckItem::MyIfaceCheckItem( QListView *parent, s_ports *port )
		: QCheckListItem( parent, port->name, QCheckListItem::CheckBox )
{
	char tmp[100];

   sprintf( tmp, "%i", port->baud );
	sBaud = tmp;
   sprintf( tmp, "%i", port->maxframe );
	sMaxframe = tmp;
	sDesc = port->desc;

   this->port = port;
}
//---------------------------------------------------------------------------
MyIfaceCheckItem::~MyIfaceCheckItem()
{
}
//---------------------------------------------------------------------------
QString MyIfaceCheckItem::getBaud()
{
	return sBaud;
}
//---------------------------------------------------------------------------
QString MyIfaceCheckItem::getMaxframe()
{
	return sMaxframe;
}
//---------------------------------------------------------------------------
QString MyIfaceCheckItem::getDesc()
{
	return sDesc;
}
//---------------------------------------------------------------------------
s_ports * MyIfaceCheckItem::getPort()
{
    return port;
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
PrefInterfaces::PrefInterfaces( QWidget *parent, const QString & caption ) : PrefWidget( parent, caption )
{
}
//---------------------------------------------------------------------------
void PrefInterfaces::createPrefWidget()
{
   s_ports *portstmp;
   QButtonGroup *tmpbtngrp;
   QLabel *l;
   MyIfaceCheckItem *item;
   QFont f;


   tmpbtngrp = new QButtonGroup( this );
   tmpbtngrp->setGeometry( 0, 0, 320, 180 );
   tmpbtngrp->setFrameStyle( 49 );
   tmpbtngrp->setAlignment( 1 );
   tmpbtngrp->lower();
   tmpbtngrp->setTitle(i18n ("Interfaces"));

	list = new QListView( tmpbtngrp );
   list->setGeometry( 10, 20, 100, 150 );
   list->addColumn( i18n("Name") );
   connect( list, SIGNAL(selectionChanged(QListViewItem *)), SLOT(slotSelChanged(QListViewItem *)) );



	l = new QLabel( tmpbtngrp );
   l->setGeometry( 120, 30, 60, 20 );
   l->setText( i18n("Speed") );

   f = l->font();
   f.setBold( true );

	lSpeed = new QLabel( tmpbtngrp );
   lSpeed->setGeometry( 120, 50, 60, 20 );
   lSpeed->setText( "" );
   lSpeed->setFont( f );

	l = new QLabel( tmpbtngrp );
   l->setGeometry( 220, 30, 60, 20 );
   l->setText( i18n("Maxframe") );

	lMaxframe = new QLabel( tmpbtngrp );
   lMaxframe->setGeometry( 220, 50, 60, 20 );
   lMaxframe->setText( "" );
   lMaxframe->setFont( f );

	l = new QLabel( tmpbtngrp );
   l->setGeometry( 120, 80, 180, 20 );
   l->setText( i18n("Description") );

	lDesc = new QLabel( tmpbtngrp );
   lDesc->setGeometry( 120, 100, 180, 20 );
   lDesc->setText( "" );
   lDesc->setFont( f );


   // Die Liste der vorhandenen Ports in die ports-Liste schreiben
   portstmp = portlist;
   for (portstmp = portlist; portstmp; portstmp = portstmp->next)
   {
   	item = new MyIfaceCheckItem( list, portstmp );
		item->setOn( portstmp->ax25 != NULL );
	}


   setCreated();
}
//---------------------------------------------------------------------------
PrefInterfaces::~PrefInterfaces()
{
}
//---------------------------------------------------------------------------
void PrefInterfaces::save( KConfig *kconfig )
{
	QString tmp;
   s_ports *porttmp;
   QListViewItem *item;


   for (item = list->firstChild(); item != NULL; item = item->nextSibling() )
   {
   	porttmp = ((MyIfaceCheckItem *)item)->getPort();

      if (((QCheckListItem *)item)->isOn())
      {
 			// Wenn der Port noch nicht aktiv war, wird er aktiviert
         if (porttmp->ax25 == NULL)
            activate_ax25_port( porttmp );

 			if (tmp.isEmpty())
         	tmp = QString(porttmp->name);
			else
         	tmp += ','+QString(porttmp->name);
      }
      else
      	if (porttmp->ax25 != NULL)
            deactivate_ax25_port( porttmp );
   }

   kconfig->setGroup( "AX.25" );
   kconfig->writeEntry( "ports", tmp );
}
//---------------------------------------------------------------------------
void PrefInterfaces::slotSelChanged( QListViewItem *item )
{
   lSpeed->setText( ((MyIfaceCheckItem *)item)->getBaud() );
   lMaxframe->setText( ((MyIfaceCheckItem *)item)->getMaxframe() );
   lDesc->setText( ((MyIfaceCheckItem *)item)->getDesc() );
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
PrefCalls::PrefCalls( QWidget *parent, const QString & caption ) : PrefWidget( parent, caption )
{
}
//---------------------------------------------------------------------------
void PrefCalls::createPrefWidget()
{
   QButtonGroup *tmpbtngrp;
   s_listCalls *tmpcall;
   int w;


   // TX-MyCall vorbereiten
   tmpbtngrp = new QButtonGroup( this );
   tmpbtngrp->setGeometry( 0, 0, 120, 70 );
   tmpbtngrp->setFrameStyle( 49 );
   tmpbtngrp->setAlignment( 1 );
   tmpbtngrp->lower();
   tmpbtngrp->setTitle(i18n ("TX mycall"));

   sendcall = new QLineEdit( tmpbtngrp );
   sendcall->setGeometry( 10, 20, 100, 20 );
   sendcall->setText( "" );
   sendcall->setMaxLength( 12 );
   w = 100;

   incrementssid = new QCheckBox( tmpbtngrp );
   incrementssid->setGeometry( 10, 45, 100, 20 );
   incrementssid->setText( i18n("Increment SSID") );
   incrementssid->resize( incrementssid->sizeHint());
   if (incrementssid->width() > w) w = incrementssid->width();

   tmpbtngrp->resize( w+20, 70 );


   // Listen-To-Calls
   tmpbtngrp = new QButtonGroup( this );
   tmpbtngrp->setGeometry( 0, 75, 160, 135 );
   tmpbtngrp->setFrameStyle( 49 );
   tmpbtngrp->setAlignment( 1 );
   tmpbtngrp->lower();
   tmpbtngrp->setTitle(i18n ("MyCalls"));

   listencall = new QLineEdit( tmpbtngrp );
   listencall->setGeometry( 10, 20, 80, 20 );
   listencall->setText("");
   connect(listencall, SIGNAL(returnPressed()), this, SLOT(addListenCall()));

   listencalls = new QListBox( tmpbtngrp );
   listencalls->setGeometry( 10, 45, 80, 80 );
   connect(listencalls, SIGNAL(highlighted(QListBoxItem *)), this, SLOT(slotChangeListenCall(QListBoxItem *)));

   addlistenbtn = new QPushButton( tmpbtngrp );
   addlistenbtn->setGeometry( 100, 20, 50, 21 );
   addlistenbtn->setText( i18n("Add") );
   connect(addlistenbtn, SIGNAL(clicked()), this, SLOT(addListenCall()));

   dellistenbtn = new QPushButton( tmpbtngrp );
   dellistenbtn->setGeometry( 100, 45, 50, 21 );
   dellistenbtn->setText( i18n ("Delete") );
	dellistenbtn->setEnabled( false );
   connect(dellistenbtn, SIGNAL(clicked()), this, SLOT(delListenCall()));



   // Disconnect-Calls
   tmpbtngrp = new QButtonGroup( this );
   tmpbtngrp->setGeometry( 170, 75, 160, 135 );
   tmpbtngrp->setFrameStyle( 49 );
   tmpbtngrp->setAlignment( 1 );
   tmpbtngrp->lower();
   tmpbtngrp->setTitle(i18n ("Ignored calls"));


   disconcall = new QLineEdit( tmpbtngrp );
   disconcall->setGeometry( 10, 20, 80, 20 );
   disconcall->setText("");
   connect(disconcall, SIGNAL(returnPressed()), this, SLOT(addDisconCall()));

   disconcalls = new QListBox( tmpbtngrp );
   disconcalls->setGeometry( 10, 45, 80, 80 );
   connect(disconcalls, SIGNAL(highlighted(QListBoxItem *)), this, SLOT(slotChangeDiscCall(QListBoxItem *)));

   adddisconbtn = new QPushButton( tmpbtngrp );
   adddisconbtn->setGeometry( 100, 20, 50, 21 );
   adddisconbtn->setText( i18n("Add") );
   connect(adddisconbtn, SIGNAL(clicked()), this, SLOT(addDisconCall()));

   deldisconbtn = new QPushButton( tmpbtngrp );
   deldisconbtn->setGeometry( 100, 45, 50, 21 );
   deldisconbtn->setText( i18n("Delete") );
	deldisconbtn->setEnabled( false );
   connect(deldisconbtn, SIGNAL(clicked()), this, SLOT(delDisconCall()));


   // Felder vorbesetzen
   for (tmpcall=conf->getListenCalls(); tmpcall; tmpcall = tmpcall->next)
      listencalls->inSort( tmpcall->call);

   for (tmpcall=conf->getDiscCalls(); tmpcall; tmpcall=tmpcall->next)
      disconcalls->inSort( tmpcall->call);

   sendcall->setText( conf->getTxMycall() );

   incrementssid->setChecked( conf->getFlag(CFG_INCSSID) );


   setCreated();
}
//---------------------------------------------------------------------------
PrefCalls::~PrefCalls()
{
}
//---------------------------------------------------------------------------
void PrefCalls::save( KConfig *kconfig )
{
   kconfig->setGroup( "AX.25" );
	conf->setTxMycall( sendcall->text().upper() );
   kconfig->writeEntry( "sendcall", conf->getTxMycall() );

   saveListenToCalls(kconfig);
   saveIgnoredCalls(kconfig);

   if (conf->getFlag(CFG_INCSSID) != incrementssid->isChecked())
		conf->saveFlagToFile( kconfig, CFG_INCSSID, "autoIncSSID", incrementssid->isChecked() );
}
//---------------------------------------------------------------------------
void PrefCalls::saveListenToCalls(KConfig *kconfig)
{
   unsigned int i;
   s_listCalls *tmpcall, *tmpcall2, *saveCalls, *tmproot;
   char tmp[500];


   saveCalls = conf->getListenCalls();

//   tmpcall = config->listento_calls;
//   config->listento_calls = NULL;
/*   while (tmpcall != NULL)
   {
      tmpcall2 = tmpcall;
      tmpcall = tmpcall->next;
      if (tmpcall2->call != NULL) free(tmpcall2->call);
      free(tmpcall2);
   }*/


   tmproot = NULL;
   tmp[0] = '\0';
   for (i = 0; i < listencalls->count(); i++)
   {
      // Neuer Eintrag in die Liste
      if (tmproot == NULL)
      {
         tmproot = (s_listCalls *)malloc(sizeof(s_listCalls));
         tmpcall = tmproot;
      }
      else
      {
         tmpcall = tmproot;
         while (tmpcall->next != NULL) tmpcall = tmpcall->next;
         tmpcall->next = (s_listCalls *)malloc(sizeof(s_listCalls));
         tmpcall = tmpcall->next;
      }

      tmpcall->next = NULL;
      tmpcall->call = (char *) strdup(listencalls->text(i));

      // Wenn das neue Rufzeichen nicht in der alten Liste war, soll
      // auf dieses Call gelauscht werden.
      if (!callIsInList(tmpcall->call, saveCalls))
         addListenCallToPorts(tmpcall->call);

      if (tmp[0] == '\0')
         strcpy(tmp, tmpcall->call);
      else
      {
         strcat(tmp, ",");
         strcat(tmp, tmpcall->call);
      }
   }

   conf->setListenCalls( tmproot );

   // Bei allen Calls, die in saveCalls, aber nicht in config->listento_calls
   // stehen, das lauschen abschalten.
   deleteDroppedCalls( conf->getListenCalls(), saveCalls);

   tmpcall = saveCalls;
   while (tmpcall != NULL)
   {
      tmpcall2 = tmpcall;
      tmpcall = tmpcall->next;
      if (tmpcall2->call != NULL) free(tmpcall2->call);
      free(tmpcall2);
   }

   kconfig->writeEntry("listenToCalls",tmp);
}
//---------------------------------------------------------------------------
void PrefCalls::saveIgnoredCalls(KConfig *kconfig)
{
   unsigned int i;
   s_listCalls *tmpcall,*tmpcall2, *tmproot;
   char tmp[500];


   tmpcall = conf->getDiscCalls();
   while (tmpcall != NULL)
   {
      tmpcall2 = tmpcall;
      tmpcall = tmpcall->next;
      if (tmpcall2->call != NULL) free(tmpcall2->call);
      free(tmpcall2);
   }


   tmproot = NULL;
   tmp[0] = '\0';
   for (i = 0; i < disconcalls->count(); i++)
   {
      // Neuer Eintrag in die Liste
      if (tmproot == NULL)
      {
         tmproot = (s_listCalls *)malloc(sizeof(s_listCalls));
         tmpcall = tmproot;
      }
      else
      {
         tmpcall = tmproot;
         while (tmpcall->next != NULL) tmpcall = tmpcall->next;
         tmpcall->next = (s_listCalls *)malloc(sizeof(s_listCalls));
         tmpcall = tmpcall->next;
      }

      tmpcall->next = NULL;
      tmpcall->call = (char *) strdup(disconcalls->text(i));

      if (tmp[0] == '\0')
         strcpy(tmp, tmpcall->call);
      else
      {
         strcat(tmp, ",");
         strcat(tmp, tmpcall->call);
      }
   }

	conf->setDiscCalls( tmproot );

   kconfig->writeEntry("disconCalls",tmp);
}
//---------------------------------------------------------------------------
void PrefCalls::addListenCall()
{
   char tmp[20];

   strcpy(tmp,listencall->text());
   KillSpacesLeft(tmp);
   KillSpacesRight(tmp);
   Gross(tmp);

   if (tmp[0] != '\0')
      listencalls->inSort(tmp);

   listencall->setText("");
}
//---------------------------------------------------------------------------
void PrefCalls::delListenCall()
{
   if (listencalls->currentItem() != -1)
      listencalls->removeItem(listencalls->currentItem());

	dellistenbtn->setEnabled( false );
}
//---------------------------------------------------------------------------
void PrefCalls::addDisconCall()
{
   char tmp[20];

   strcpy(tmp,disconcall->text());
   KillSpacesLeft(tmp);
   KillSpacesRight(tmp);
   Gross(tmp);

   if (tmp[0] != '\0')
      disconcalls->inSort(tmp);

   disconcall->setText("");
}
//---------------------------------------------------------------------------
void PrefCalls::delDisconCall()
{
   if (disconcalls->currentItem() != -1)
      disconcalls->removeItem(disconcalls->currentItem());

	deldisconbtn->setEnabled( false );
}
//---------------------------------------------------------------------------
void PrefCalls::slotChangeDiscCall( QListBoxItem *item )
{
	if (item == NULL)
      deldisconbtn->setEnabled( false );
	else
      deldisconbtn->setEnabled( true );
}
//---------------------------------------------------------------------------
void PrefCalls::slotChangeListenCall( QListBoxItem *item )
{
	if (item == NULL)
      dellistenbtn->setEnabled( false );
	else
      dellistenbtn->setEnabled( true );
}
//---------------------------------------------------------------------------
//  void CfgCallsPorts::deleteDroppedCalls(s_listCalls *akt, s_listCalls *old)
// Auf alle Calls, die in old aber nicht mehr in akt stehen, soll nicht
// mehr geachtet werden.
void PrefCalls::deleteDroppedCalls(s_listCalls *akt, s_listCalls *old)
{
   s_listCalls *tmpold, *tmpakt;
   bool found;

   tmpold = old;
   while (tmpold != NULL)
   {
      tmpakt = akt;
      found = false;
      while ((tmpakt != NULL) && !found)
      {
         if (!strcmp(tmpakt->call, tmpold->call)) found = true;
         tmpakt = tmpakt->next;
      }

      // Wenn dieses Rufzeichen in der neuen Liste nicht gefunden wurde,
      // wird es aus der ListenTo-Liste entfernt.
      if (!found)
         deleteListenCallToPorts(tmpold->call);

      tmpold = tmpold->next;
   }
}
//---------------------------------------------------------------------------
bool PrefCalls::callIsInList(const char *call, s_listCalls *list)
{
   s_listCalls *tmp;

   tmp = list;
   while (tmp != NULL)
   {
      if (!strcmp(list->call, call))
         return true;
      tmp = tmp->next;
   }
   return false;
}
//---------------------------------------------------------------------------
void PrefCalls::addListenCallToPorts(const char *call)
{
   s_ports *tmp;

   tmp = portlist;

   while (tmp != NULL)
   {
      if (tmp->ax25 != NULL)
         tmp->ax25->listenToCall(call);
      tmp = tmp->next;
   }
}
//---------------------------------------------------------------------------
void PrefCalls::deleteListenCallToPorts(const char *call)
{
   s_ports *tmp;

   tmp = portlist;

   while (tmp != NULL)
   {
      if (tmp->ax25 != NULL)
         tmp->ax25->deleteListenTo(call);
      tmp = tmp->next;
   }
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
ListCategory::ListCategory( QListViewItem *parent, QString text, PrefWidget *window, int id )
			: QListViewItem( parent, text )
{
	win = window;
   this->id = id;
}
//---------------------------------------------------------------------------
ListCategory::ListCategory( QListView *parent, QString text, PrefWidget *window, int id )
			: QListViewItem( parent, text )
{
	win = window;
   this->id = id;
}
//---------------------------------------------------------------------------
ListCategory::~ListCategory()
{
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
PrefWidget::PrefWidget( QWidget *parent, const QString & caption ) : QWidget( parent )
{
	this->caption = caption;
   created = false;
}
//---------------------------------------------------------------------------
PrefWidget::~PrefWidget()
{
}
//---------------------------------------------------------------------------
const QString & PrefWidget::getCaption()
{
	return caption;
}
//---------------------------------------------------------------------------
bool PrefWidget::isCreated()
{
	return created;
}
//---------------------------------------------------------------------------
void PrefWidget::setCreated()
{
	created = true;
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
Preferences::Preferences( TopLevel *parent ) : QDialog( parent, "Preferences", true )
{
	QListViewItem *itmAX25, *itmScreen, *itmTerminal, *itmKeys, *itmTmp, *itmTmp2;
   bool found;


	int x = 145;
   int y = 10;
   int w = 330;
   int h = 220;


	setFixedSize( 480, 280 );

   currentWidget = NULL;

   category = new QListView( this );
   category->setGeometry( 5, y, 130, h );
   connect( category, SIGNAL(selectionChanged(QListViewItem *)), this, SLOT(slotCategoryChanged(QListViewItem *)));
   category->addColumn( i18n("Category:") );
   category->setRootIsDecorated( true );


   itmAX25 = new ListCategory( category, i18n("AX25"), NULL, -1 );
   itmKeys = new ListCategory( category, i18n("Keys"), NULL, -1 );


	screen = new PrefScreen( this, i18n("Screen") );
   screen->setGeometry( x, y, w, h );
   itmScreen = new ListCategory( category, i18n("Screen"), screen, 1 );
   screen->hide();

	terminal = new PrefTerminal( this, i18n("Terminal") );
   terminal->setGeometry( x, y, w, h );
   itmTerminal = new ListCategory( category, i18n("Terminal"), terminal, 2 );
   terminal->hide();



   // Die verschiedenen Eintraege erzeugen
	calls = new PrefCalls( this, i18n("Calls") );
   calls->setGeometry( x, y, w, h );
   new ListCategory( itmAX25, i18n("Calls"), calls, 5 );
   calls->hide();

   ifaces = new PrefInterfaces( this, i18n("Interfaces") );
   ifaces->setGeometry( x, y, w, h );
   new ListCategory( itmAX25, i18n("Interfaces"), ifaces, 6 );
   ifaces->hide();		// Alle Widgets ausser dem obersten unsichtbar machen

   filetrans = new PrefFiletransfer( this, i18n("Filetransfer") );
   filetrans->setGeometry( x, y, w, h );
   new ListCategory( itmTerminal, i18n("Filetransfer"), filetrans, 7 );
   filetrans->hide();	// Alle Widgets ausser dem obersten unsichtbar machen

   colors = new PrefColors( this, i18n("Colors") );
   colors->setGeometry( x, y, w, h );
   new ListCategory( itmScreen, i18n("Colors"), colors, 8 );
   colors->hide();		// Alle Widgets ausser dem obersten unsichtbar machen

	fonts = new PrefFonts( this, i18n("Fonts") );
   fonts->setGeometry( x, y, w, h );
   new ListCategory( itmScreen, i18n("Fonts"), fonts, 9 );
   fonts->hide();		// Alle Widgets ausser dem obersten unsichtbar machen

   shortcuts = new PrefShortcuts( this, i18n("Shortcuts") );
   shortcuts->setGeometry( x, y, w, h );
   new ListCategory( itmKeys, i18n("Shortcuts"), shortcuts, 11 );
   shortcuts->hide();		// Alle Widgets ausser dem obersten unsichtbar machen

   gpg = new PrefGnuPG( this, i18n("GnuPG") );
   gpg->setGeometry( x, y, w, h );
   new ListCategory( itmTerminal, i18n("GnuPG"), gpg, 12 );
   gpg->hide();		// Alle Widgets ausser dem obersten unsichtbar machen

	qsoWin = new PrefQSOWin( this, i18n("QSO window") );
   qsoWin->setGeometry( x, y, w, h );
   new ListCategory( itmScreen, i18n("QSO window"), qsoWin, 13 );
   qsoWin->hide();		// Alle Widgets ausser dem obersten unsichtbar machen

	dirs = new PrefDirs( this, i18n("Directories") );
   dirs->setGeometry( x, y, w, h );
   new ListCategory( itmTerminal, i18n("Directories"), dirs, 14 );
   dirs->hide();		// Alle Widgets ausser dem obersten unsichtbar machen

   callkey = new PrefCallKey( this, i18n("CallKeys") );
   callkey->setGeometry( x, y, w, h );
   new ListCategory( itmKeys, i18n("CallKeys"), callkey, 15 );
   callkey->hide();		// Alle Widgets ausser dem obersten unsichtbar machen

   files = new PrefFiles( this, i18n("Files") );
   files->setGeometry( x, y, w, h );
   new ListCategory( itmTerminal, i18n("Files"), files, 16 );
   files->hide();		// Alle Widgets ausser dem obersten unsichtbar machen

   #ifdef ENABLE_SOUND
      sound = new PrefSound( this, i18n("Sound") );
      sound->setGeometry( x, y, w, h );
      new ListCategory( itmTerminal, i18n("Sound"), sound, 17 );
      sound->hide();		// Alle Widgets ausser dem obersten unsichtbar machen
   #endif

   away = new PrefAway( this, i18n("Away") );
   away->setGeometry( x, y, w, h );
   new ListCategory( itmTerminal, i18n("Away"), away, 18 );
   away->hide();		// Alle Widgets ausser dem obersten unsichtbar machen
   connect( away, SIGNAL(awayDataChanged()), parent, SLOT(slotAwayDataChanged()) );





   // Gucken, welcher Eintrag aktiv sein soll
   found = false;
   for (itmTmp = category->firstChild(); itmTmp; itmTmp = itmTmp->nextSibling() )
   {
	   for (itmTmp2 = itmTmp->firstChild(); itmTmp2; itmTmp2 = itmTmp2->nextSibling() )
	      if (((ListCategory *)itmTmp2)->id == conf->getLastPref())
			{
				slotCategoryChanged( itmTmp2 );
            category->setFocus();
            category->setOpen( itmTmp2->parent(), true );
	         category->setCurrentItem( itmTmp2 );
            found = true;
	         break;
	      }
		if (found) break;
	}


   help = new QPushButton( this );
   help->setGeometry( width()-3*(5+OKCANCELWIDTH)-10, height()-5-OKCANCELHEIGHT, OKCANCELWIDTH, OKCANCELHEIGHT );
   help->setText( i18n("&Help") );
   connect(help, SIGNAL(clicked()), this, SLOT(slotHelp()));

   ok = new QPushButton( this );
   ok->setGeometry( width()-2*(5+OKCANCELWIDTH), height()-5-OKCANCELHEIGHT, OKCANCELWIDTH, OKCANCELHEIGHT );
   ok->setText( i18n("&Ok") );
   connect(ok, SIGNAL(clicked()), this, SLOT(slotSave()));

   cancel = new QPushButton( this );
   cancel->setGeometry( width()-5-OKCANCELWIDTH, height()-5-OKCANCELHEIGHT, OKCANCELWIDTH, OKCANCELHEIGHT );
   cancel->setText( i18n("&Cancel") );
   connect(cancel, SIGNAL(clicked()), this, SLOT(reject()));

}
//---------------------------------------------------------------------------
Preferences::~Preferences()
{
}
//---------------------------------------------------------------------------
void Preferences::slotCategoryChanged( QListViewItem *item )
{
	if (currentWidget != NULL)
	   currentWidget->hide();

	if (item == NULL) return;

	if (((ListCategory *)item)->id > -1)
   {
   	if (!((ListCategory *)item)->win->isCreated())
         ((ListCategory *)item)->win->createPrefWidget();
	   ((ListCategory *)item)->win->show();
	   currentWidget = ((ListCategory *)item)->win;
	}
   else
   	currentWidget = NULL;
   setCaption( i18n("Configuration") + " - " + item->text(0) );
}
//---------------------------------------------------------------------------
void Preferences::slotSave()
{
   KConfig *kconfig;
   char tmp[50];
	QListViewItem *itmTmp=NULL, *itmTmp2=NULL;
   bool found;


   kconfig = KGlobal::config();

	// Alles abspeichern
   for (itmTmp = category->firstChild(); itmTmp; itmTmp = itmTmp->nextSibling() )
	{
   	if (((ListCategory *)itmTmp)->win != NULL)
	      if (((ListCategory *)itmTmp)->win->isCreated())
	         ((ListCategory *)itmTmp)->win->save( kconfig );
   	for (itmTmp2 = itmTmp->firstChild(); itmTmp2; itmTmp2 = itmTmp2->nextSibling() )
		{
	   	if (((ListCategory *)itmTmp2)->win != NULL)
		      if (((ListCategory *)itmTmp2)->win->isCreated())
		         ((ListCategory *)itmTmp2)->win->save( kconfig );
		}
	}


   // Den zuletzt sichtbaren Eintrag merken
	kconfig->setGroup( "Screen" );
   found = false;
   for (itmTmp = category->firstChild(); itmTmp; itmTmp = itmTmp->nextSibling() )
	{
      if (((ListCategory *)itmTmp)->win == currentWidget && currentWidget != NULL)
      {
      	found = true;
         itmTmp2 = NULL;
         break;
      }
   	for (itmTmp2 = itmTmp->firstChild(); itmTmp2; itmTmp2 = itmTmp2->nextSibling() )
		{
	      if (((ListCategory *)itmTmp2)->win == currentWidget)
	      {
            found = true;
	        	break;
			}
		}
      if (found) break;
	}
	if (itmTmp2 == NULL)
   	if (itmTmp == NULL)
	   	conf->setLastPref( -1 );
		else
      	conf->setLastPref( ((ListCategory *)itmTmp)->id );
   else
		conf->setLastPref( ((ListCategory *)itmTmp2)->id );
   sprintf( tmp, "%i", conf->getLastPref() );
   kconfig->writeEntry( "LastPref", tmp );

   kconfig->sync();

   accept();
}
//---------------------------------------------------------------------------
void Preferences::slotHelp()
{
}
//---------------------------------------------------------------------------
#include "pref.moc"

