/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-2000 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "filetrans.h"
#include "filetrans.moc"

#include "global.h"
#include "toolbox.h"
#include "sendqueue.h"
#include "filetransfer.h"
#include "flags.h"

#include <sys/stat.h>
#include <unistd.h>

#include <kapp.h>
#include <kmessagebox.h>

#include <kfiledialog.h>
#include <qfiledialog.h>


#define FNBTNWIDTH 60
#define FNBTNHEIGHT 25

#define BTNWIDTH 80
#define BTNHEIGHT 30


#define PROT_DIDADIT 1
#define PROT_AUTOBIN 2
#define PROT_7PLUS 3
#define PROT_BINSPLIT 4
#define PROT_YAPP 5
#define PROT_TEXT 6


#define HEIGHT_7PLUS 85

#define WIDTH 400
#define HEIGHT 220


typedef struct
{
	int size;
   char text[5];
} s_7plsplits;


#define DEFAULT7PLITEM 7
s_7plsplits split7pl[] = { {5120,	"5k"},
									{8192,	"8k"},
                           {10240,	"10k"},
                           {16384,	"16k"},
                           {20480,	"20k"},
                           {25600,	"25k"},
                           {30720,	"30k"},
                           {36000,	"36k"} };


TransferItem::TransferItem( QListView *list, QListViewItem *last, const char *filename )
			: QListViewItem( list, last )
{
   struct stat st;
   char tmp[500];
   int i;


   longname = (char *) strdup(filename);
   if ((i = lPOS('/', filename)) == -1)
   	shortname = (char *) strdup(filename);
	else
   {
      strncpy(tmp, filename+i+1, 499);
      shortname = (char *) strdup(tmp);
   }

   tmp[0] = '\0';
   if (stat(filename, &st) != -1)
      sprintf(tmp, "%li", st.st_size);

   setText( 0, shortname );
	setText( 1, tmp );
   size = st.st_size;

   if (size < 3072)
      protocol = PROT_AUTOBIN;
   else
      protocol = PROT_DIDADIT;

   empf = NULL;
   titel = NULL;
   mbx = NULL;
   lt = -1;
   size7pl = DEFAULT7PLITEM;
   sizeBS = -1;
   startwith = 1;
   sendcmd = 1;
}


TransferItem::~TransferItem()
{
	if (empf != NULL)
   	free( empf );
	if (titel != NULL)
   	free( titel );
	if (mbx != NULL)
   	free( mbx );
	if (longname != NULL)
   	free( longname );
	if (shortname != NULL)
   	free( shortname );
}


void TransferItem::set7plusData( const char *empf, const char *mbx, const char *titel, int lt, int size, int startwith, int sendcmd )
{
	if (this->empf != NULL)
   	free( this->empf );
	this->empf = (char *) strdup( empf );

   if (this->titel != NULL)
   	free( this->titel );
   this->titel = (char *) strdup( titel );

   if (this->mbx != NULL)
   	free( this->mbx );
   this->mbx = (char *) strdup( mbx );

   this->lt = lt;
   size7pl = size;
   this->startwith = startwith;
   this->sendcmd = sendcmd;
}


const char * TransferItem::getEmpf()
{
	if (empf == NULL)
   	return "";
	return empf;
}


const char * TransferItem::getMbx()
{
	if (mbx == NULL)
   	return "";
	return mbx;
}


const char * TransferItem::getTitel()
{
	if (titel == NULL)
   	return "";
	return titel;
}


int TransferItem::getLifetime()
{
	return lt;
}


const int TransferItem::getSize7pl()
{
	return size7pl;
}


const int TransferItem::getSizeBS()
{
	return sizeBS;
}


const char * TransferItem::getLongname()
{
	return longname;
}


const int TransferItem::getProtocol()
{
	return protocol;
}


void TransferItem::setProtocol( int prot )
{
	protocol = prot;
}


const off_t TransferItem::getSize()
{
	return size;
}


int TransferItem::getStartWith()
{
	return startwith;
}


int TransferItem::getSendCmd()
{
	return sendcmd;
}


void TransferItem::getInfo( s_sqsendinfo *info, bool seven )
{
	char tmp[100];

   if (mbx == NULL)
   	if (empf == NULL)
      	tmp[0] = '\0';
		else
		   strcpy(tmp, empf);
  	else
	   sprintf(tmp, "%s@%s", empf, mbx);
  	info->user = (char *) strdup( tmp );

	if (titel == NULL)
      info->titel = (char *) strdup( "" );
	else
		info->titel = (char *) strdup( titel );

   info->lt = lt;
   if (seven)
	   info->splitsize = split7pl[size7pl].size;
/*	else
	   info->splitsize = sizeBS;*/
   info->startwith = startwith;
   info->sendcmd = sendcmd;
}


//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
DlgFiletransfer::DlgFiletransfer( SendQueue *sq ) : QDialog(0, "", true)
{
	setFixedSize( 400, 225 );
   setCaption(i18n("LinKT: Send file..."));

   sendqueue = sq;
   currentItem = NULL;

   setupWindow();
   protocolSelection = true;
	enableProtocolSelection( false );
}
//---------------------------------------------------------------------------
DlgFiletransfer::~DlgFiletransfer()
{
}
//---------------------------------------------------------------------------
void DlgFiletransfer::setupWindow()
{
   QLabel *l;
   unsigned int i;


	QButtonGroup *grpFName = new QButtonGroup( this );
   grpFName->setGeometry( 5, 5, width()-10, 110 );
   grpFName->setFrameStyle( 49 );
   grpFName->setAlignment( 1 );
   grpFName->lower();
//   grpFname->setTitle( i18n("Filenames") );

   listFName = new QListView( grpFName );
   listFName->setGeometry( 5, 10, grpFName->width()-FNBTNWIDTH-20, grpFName->height()-20 );
   listFName->setSorting( -1 );
   listFName->setAllColumnsShowFocus( true );
   listFName->setVScrollBarMode( QScrollView::AlwaysOn );
   connect( listFName, SIGNAL(selectionChanged(QListViewItem *)), this, SLOT(slotSelectionChanged(QListViewItem *)) );

   listFName->addColumn( i18n("Filename"), listFName->width()-90 );
   listFName->addColumn( i18n("Size"), 70 );

   btnAdd = new QPushButton( grpFName );
	btnAdd->setGeometry( grpFName->width()-10-FNBTNWIDTH, grpFName->height()-2*(FNBTNHEIGHT+5), FNBTNWIDTH, FNBTNHEIGHT );
   btnAdd->setText( i18n("&Add") );
   connect( btnAdd, SIGNAL(clicked()), this, SLOT(slotAddFile()));

   btnDel = new QPushButton( grpFName );
	btnDel->setGeometry( grpFName->width()-10-FNBTNWIDTH, grpFName->height()-(FNBTNHEIGHT+5), FNBTNWIDTH, FNBTNHEIGHT );
   btnDel->setText( i18n("&Remove") );
   btnDel->setEnabled( false );
   connect( btnDel, SIGNAL(clicked()), this, SLOT(slotDelEntry()));



	QButtonGroup *grpProt = new QButtonGroup( this );
   grpProt->setGeometry( 5, 120, width()-10, 60 );
   grpProt->setFrameStyle( 49 );
   grpProt->setAlignment( 1 );
   grpProt->lower();
   grpProt->setTitle( i18n("Protocol") );

   int pos = (grpProt->width()-20)/3-10;

   rdbtnDIDADIT = new QRadioButton( grpProt );
   rdbtnDIDADIT->setGeometry( 10, 15, pos, 20 );
   rdbtnDIDADIT->setText( "DIDADIT" );
   connect( rdbtnDIDADIT, SIGNAL(toggled(bool)), this, SLOT(slotDIDADIT(bool)));
   grpProt->insert( rdbtnDIDADIT );

   rdbtnAutoBIN = new QRadioButton( grpProt );
   rdbtnAutoBIN->setGeometry( 10, 35, pos, 20 );
   rdbtnAutoBIN->setText( "AutoBIN" );
   connect( rdbtnAutoBIN, SIGNAL(toggled(bool)), this, SLOT(slotABIN(bool)));
   grpProt->insert( rdbtnAutoBIN );

   rdbtn7plus = new QRadioButton( grpProt );
   rdbtn7plus->setGeometry( pos+15, 15, pos, 20 );
   rdbtn7plus->setText( "7plus" );
   connect( rdbtn7plus, SIGNAL(toggled(bool)), this, SLOT(slot7plus(bool)));
   grpProt->insert( rdbtn7plus );

   rdbtnBinSplit = new QRadioButton( grpProt );
   rdbtnBinSplit->setGeometry( pos+15, 35, pos, 20 );
   rdbtnBinSplit->setText( "BinSplit" );
   connect( rdbtnBinSplit, SIGNAL(toggled(bool)), this, SLOT(slotBS(bool)));
   grpProt->insert( rdbtnBinSplit );

   rdbtnYAPP = new QRadioButton( grpProt );
   rdbtnYAPP->setGeometry( (pos+15)*2, 15, pos, 20 );
   rdbtnYAPP->setText( "YAPP" );
   connect( rdbtnYAPP, SIGNAL(toggled(bool)), this, SLOT(slotYAPP(bool)));
   grpProt->insert( rdbtnYAPP );

   rdbtnText = new QRadioButton( grpProt );
   rdbtnText->setGeometry( (pos+15)*2, 35, pos, 20 );
   rdbtnText->setText( "Text" );
   connect( rdbtnText, SIGNAL(toggled(bool)), this, SLOT(slotText(bool)));
   grpProt->insert( rdbtnText );

   btnHelp = new QPushButton( this );
   btnHelp->setGeometry( width()-3*(5+BTNWIDTH)-10, height()-5-BTNHEIGHT, BTNWIDTH, BTNHEIGHT );
   btnHelp->setText( i18n("&Help") );
   btnHelp->setDefault( true );
//   connect( btnHelp, SIGNAL(clicked()), this, SLOT(slotSendClicked()));

   btnSend = new QPushButton( this );
   btnSend->setGeometry( width()-(5+BTNWIDTH), height()-5-BTNHEIGHT, BTNWIDTH, BTNHEIGHT );
   btnSend->setText( i18n("&Send") );
   btnSend->setDefault( true );
   connect( btnSend, SIGNAL(clicked()), this, SLOT(slotSendClicked()));

   btnAbort = new QPushButton( this );
   btnAbort->setGeometry( width()-2*(5+BTNWIDTH), height()-5-BTNHEIGHT, BTNWIDTH, BTNHEIGHT );
   btnAbort->setText( i18n("&Abort") );
   connect( btnAbort, SIGNAL(clicked()), this, SLOT(reject()));



	grp7plus = new QButtonGroup( this );
   grp7plus->setGeometry( 5, 190, width()-10, HEIGHT_7PLUS );
   grp7plus->setFrameStyle( 49 );
   grp7plus->setAlignment( 1 );
   grp7plus->lower();
   grp7plus->hide();

   l = new QLabel( grp7plus );
   l->setGeometry( 10, 8, 40, 20 );
   l->setText( i18n("To:") );

	edUser = new QLineEdit( grp7plus );
   edUser->setGeometry( 40, 8, 70, 20 );

   l = new QLabel( grp7plus );
   l->setGeometry( 110, 8, 15, 20 );
   l->setText( "@" );

	edMbx = new QLineEdit( grp7plus );
   edMbx->setGeometry( 125, 8, 70, 20 );

   l = new QLabel( grp7plus );
   l->setGeometry( 198, 8, 12, 20 );
   l->setText( "#" );

	edLt = new KIntLineEdit( grp7plus );
   edLt->setGeometry( 210, 8, 30, 20 );
   edLt->setMaxLength( 3 );

   l = new QLabel( grp7plus );
   l->setGeometry( 10, 30, 40, 20 );
   l->setText( i18n("Subject:") );

	edTitle = new QLineEdit( grp7plus );
	edTitle->setGeometry( 40, 30, 200, 20 );


	l = new QLabel( grp7plus );
	l->setGeometry( 260, 8, 60, 20 );
	l->setText( i18n("Splitsize:") );

	cmbSplitsize = new QComboBox( grp7plus );
   cmbSplitsize->setGeometry( 260, 30, 60, 20 );
   connect( cmbSplitsize, SIGNAL(activated(int)), this, SLOT(slot7plCalcParts(int)));

   for (i=0; i<sizeof(split7pl)/sizeof(s_7plsplits); i++)
   	cmbSplitsize->insertItem( split7pl[i].text );

	cmbSplitsize->setCurrentItem( DEFAULT7PLITEM );

	lParts = new QLabel( grp7plus );
	lParts->setGeometry( 325, 30, 60, 20 );


   grpStartWith = new QButtonGroup( grp7plus );
   grpStartWith->setGeometry( 10, 56, 230, 20 );
   grpStartWith->setFrameStyle( QFrame::NoFrame );

   rdbtnSendAll = new QRadioButton( grpStartWith );
   rdbtnSendAll->setGeometry( 0, 0, 100, 20 );
   rdbtnSendAll->setText( i18n("send all files") );
   grpStartWith->insert( rdbtnSendAll );
   rdbtnSendAll->setChecked( true );

   rdbtnStartWith = new QRadioButton( grpStartWith );
   rdbtnStartWith->setGeometry( 110, 0, 80, 20 );
   rdbtnStartWith->setText( i18n("start with") );
   grpStartWith->insert( rdbtnStartWith );
   connect( rdbtnStartWith, SIGNAL(toggled(bool)), this, SLOT(slotToggleStartWith(bool)));

   edStartWith = new KIntLineEdit( grpStartWith );
   edStartWith->setGeometry( 190, 0, 40, 20 );

   slotToggleStartWith( false );


   grpStartWith = new QButtonGroup( grp7plus );
   grpStartWith->setGeometry( 260, 56, 120, 20 );
   grpStartWith->setFrameStyle( QFrame::NoFrame );

   rdbtnS = new QRadioButton( grpStartWith );
   rdbtnS->setGeometry( 0, 0, 40, 20 );
   rdbtnS->setText( "S" );
   grpStartWith->insert( rdbtnS );

   rdbtnSP = new QRadioButton( grpStartWith );
   rdbtnSP->setGeometry( 40, 0, 40, 20 );
   rdbtnSP->setText( "SP" );
   grpStartWith->insert( rdbtnSP );

   rdbtnSB = new QRadioButton( grpStartWith );
   rdbtnSB->setGeometry( 80, 0, 40, 20 );
   rdbtnSB->setText( "SB" );
   grpStartWith->insert( rdbtnSB );
}
//---------------------------------------------------------------------------
void DlgFiletransfer::resizeEvent(QResizeEvent *event)
{
   QDialog::resizeEvent(event);

   btnSend->setGeometry( width()-2*(5+BTNWIDTH), height()-5-BTNHEIGHT, BTNWIDTH, BTNHEIGHT );
   btnAbort->setGeometry( width()-(5+BTNWIDTH), height()-5-BTNHEIGHT, BTNWIDTH, BTNHEIGHT );
   btnHelp->setGeometry( width()-3*(5+BTNWIDTH)-10, height()-5-BTNHEIGHT, BTNWIDTH, BTNHEIGHT );
}
//---------------------------------------------------------------------------
void DlgFiletransfer::slot7plCalcParts( int index )
{
	char tmp[100];
   int parts, blocksize;
   QListViewItem *item;


   if (index == -1)
   {
   	lParts->setText( "" );
   	return;
   }

   if ((item = listFName->currentItem()) == NULL)
   {
   	lParts->setText( "" );
   	return;
	}

   blocksize = (split7pl[index].size/71-2)*62;
   parts = (int) ((((TransferItem *)item)->getSize() + blocksize-1) / blocksize);

   sprintf(tmp, "(%i ", parts);
   lParts->setText( tmp+i18n("Parts")+")" );
}
//---------------------------------------------------------------------------
void DlgFiletransfer::slotAddFile()
{
   char fname[500];
   QListViewItem *item, *last;
   QFileDialog *qfd;
   QString f;


//   strcpy(fname, config->dirUp);
//   QString f = KFileDialog::getOpenFileName(QString(config->dirUp), QString::null, this, i18n("Send file..."));

	qfd = new QFileDialog( conf->getDirUp(), QString::null, this, "", true);
   qfd->setCaption(i18n("Send file..."));
   qfd->setMode( QFileDialog::ExistingFile );

   qfd->exec();

   f = qfd->selectedFile();

//   QString f = QFileDialog::getOpenFileName(QString(config->dirUp));

   // Cancel
   if (f.isEmpty())
   {
	   delete qfd;
   	return;
	}

   conf->setDirUp( qfd->dir()->absPath() );

   delete qfd;


   strcpy(fname, (const char *)f);

   if (!file_exist(fname))
   {
      KMessageBox::error( this,
								i18n("Cannot find specified file."),
      						i18n("File not found") );
      return;
   }

   item = listFName->firstChild();
   last = NULL;
   while (item != NULL)
   {
      if (!strcmp(((TransferItem *)item)->getLongname(), fname))
      	return;
      last = item;
   	item = item->itemBelow();
   }

   // Alten Eintrag speichern
   if (currentItem != NULL)
	   saveFileData();

   listFName->setSelected( (currentItem = new TransferItem(listFName, last, fname)), true );
   enableProtocolSelection( true );
   btnDel->setEnabled( true );

	showCurrentData();
}
//---------------------------------------------------------------------------
void DlgFiletransfer::slotDelEntry()
{
	QListViewItem *item;


	if ((item = listFName->currentItem()) == NULL) return;

   delete item;

	if (listFName->currentItem() == NULL)
   {
	   enableProtocolSelection( false );
      btnDel->setEnabled( false );
	}
}
//---------------------------------------------------------------------------
void DlgFiletransfer::slotSelectionChanged( QListViewItem *item )
{
	if (item == NULL) return;

	// Alte Daten abspeichern
   if (currentItem != NULL)
	   saveFileData();

	enableProtocolSelection( true );
   btnDel->setEnabled( true );


   switch (((TransferItem *)item)->getProtocol())
   {
   	case PROT_DIDADIT:
   		rdbtnDIDADIT->setChecked( true );
   		break;
   	case PROT_AUTOBIN:
   		rdbtnAutoBIN->setChecked( true );
   		break;
   	case PROT_7PLUS:
   		rdbtn7plus->setChecked( true );
   		break;
   	case PROT_BINSPLIT:
   		rdbtnBinSplit->setChecked( true );
   		break;
   	case PROT_YAPP:
   		rdbtnYAPP->setChecked( true );
   		break;
		case PROT_TEXT:
   		rdbtnText->setChecked( true );
      	break;
   }

   currentItem = item;
	showCurrentData();
}
//---------------------------------------------------------------------------
void DlgFiletransfer::enableProtocolSelection( bool enable )
{
	if (protocolSelection == enable) return;

	rdbtnAutoBIN->setEnabled( enable );
	rdbtnDIDADIT->setEnabled( enable );
	rdbtn7plus->setEnabled( enable );
/*	rdbtnBinSplit->setEnabled( enable );*/
	rdbtnBinSplit->setEnabled( false );
	rdbtnYAPP->setEnabled( enable );
	rdbtnText->setEnabled( enable );

	protocolSelection = enable;
}
//---------------------------------------------------------------------------
void DlgFiletransfer::slotDIDADIT( bool toggled )
{
	QListViewItem *item;


	if (!toggled)
	{
		return;
	}

   if ((item = listFName->currentItem()) == NULL) return;
   ((TransferItem *)item)->setProtocol( PROT_DIDADIT );

   setFixedSize( WIDTH, HEIGHT );
}
//---------------------------------------------------------------------------
void DlgFiletransfer::slotABIN( bool toggled )
{
	QListViewItem *item;


	if (!toggled) return;
   if ((item = listFName->currentItem()) == NULL) return;
   ((TransferItem *)item)->setProtocol( PROT_AUTOBIN );

   setFixedSize( WIDTH, HEIGHT );
}
//---------------------------------------------------------------------------
void DlgFiletransfer::slot7plus( bool toggled )
{
	QListViewItem *item;


	if (!toggled)
	{
		grp7plus->hide();
		return;
	}

   if ((item = listFName->currentItem()) == NULL) return;
   ((TransferItem *)item)->setProtocol( PROT_7PLUS );

   grp7plus->show();
   setFixedSize( WIDTH, HEIGHT+5+HEIGHT_7PLUS );
}
//---------------------------------------------------------------------------
void DlgFiletransfer::slotBS( bool toggled )
{
	QListViewItem *item;


	if (!toggled) return;
   if ((item = listFName->currentItem()) == NULL) return;
   ((TransferItem *)item)->setProtocol( PROT_BINSPLIT );

   setFixedSize( WIDTH, HEIGHT );
}
//---------------------------------------------------------------------------
void DlgFiletransfer::slotYAPP( bool toggled )
{
	QListViewItem *item;


	if (!toggled) return;
   if ((item = listFName->currentItem()) == NULL) return;
   ((TransferItem *)item)->setProtocol( PROT_YAPP );

   setFixedSize( WIDTH, HEIGHT );
}
//---------------------------------------------------------------------------
void DlgFiletransfer::slotText( bool toggled )
{
	QListViewItem *item;


	if (!toggled) return;
   if ((item = listFName->currentItem()) == NULL) return;
   ((TransferItem *)item)->setProtocol( PROT_TEXT );

   setFixedSize( WIDTH, HEIGHT );
}
//---------------------------------------------------------------------------
void DlgFiletransfer::slotSendClicked()
{
   QListViewItem *item;
   s_sqsendinfo *info7=NULL;



   // Aktuellen Eintrag speichern
   if (currentItem != NULL)
      saveFileData();


   // Erstmal gucken, ob je nach Protokoll alle Eintraege, die wichtig sind,
   // gemacht wurden.
   item = listFName->firstChild();
   while (item != NULL)
   {
   	switch (((TransferItem *)item)->getProtocol())
      {
      	case PROT_7PLUS:
         	info7 = (s_sqsendinfo *) malloc(sizeof(s_sqsendinfo));	// wird in sendqueue.cpp wieder freigegeben
         	((TransferItem *)item)->getInfo( info7, true );
				if (info7->user[0] == '\0')
				{
			      KMessageBox::error( this, i18n("You have to specify a boardname.") );
					return;
				}
            if (info7->titel[0] == '\0')
            {
			      KMessageBox::error( this, i18n("You have to specify a mail-title.") );
					return;
            }
         	break;
      	case PROT_BINSPLIT:
         	break;
      }
   	item = item->itemBelow();
   }


   // Ok, alle Eintraege sind da. Uebergabe der Dateinamen etc an die
   // Sendqueue
   item = listFName->firstChild();
   while (item != NULL)
   {
   	switch (((TransferItem *)item)->getProtocol())
      {
      	case PROT_DIDADIT:
            sendqueue->addFileTransfer( ((TransferItem *)item)->getLongname(), FTPROT_DIDADIT, NULL, ((TransferItem *)item)->getSize() );
         	break;
      	case PROT_AUTOBIN:
            sendqueue->addFileTransfer( ((TransferItem *)item)->getLongname(), FTPROT_ABIN, NULL, ((TransferItem *)item)->getSize() );
         	break;
      	case PROT_7PLUS:
            sendqueue->addFileTransfer( ((TransferItem *)item)->getLongname(), FTPROT_7PLUS, info7, ((TransferItem *)item)->getSize() );
         	break;
      	case PROT_BINSPLIT:
         	break;
      	case PROT_YAPP:
            sendqueue->addFileTransfer( ((TransferItem *)item)->getLongname(), FTPROT_YAPP, NULL, ((TransferItem *)item)->getSize() );
         	break;
			case PROT_TEXT:
            sendqueue->addTextFile( ((TransferItem *)item)->getLongname(), COMP_FLAG, ((TransferItem *)item)->getSize() );
         	break;
      }
   	item = item->itemBelow();
   }

   accept();
}
//---------------------------------------------------------------------------
void DlgFiletransfer::saveFileData()
{
	int lt, start, sendcmd=1;


   if (edLt->text()[0] == '\0')
   	lt = -1;
   else
	   lt = atoi(edLt->text());

	if (rdbtnSendAll->isChecked())
      start = 1;
	else
   	start = atoi(edStartWith->text());

	if (rdbtnS->isChecked())
      sendcmd = 1;
	if (rdbtnSP->isChecked())
      sendcmd = 2;
	if (rdbtnSB->isChecked())
      sendcmd = 3;

	switch (((TransferItem *)currentItem)->getProtocol())
   {
   	case PROT_7PLUS:
			((TransferItem *)currentItem)->set7plusData( edUser->text(), edMbx->text(), edTitle->text(), lt, cmbSplitsize->currentItem(), start, sendcmd );
         break;
	}
}
//---------------------------------------------------------------------------
void DlgFiletransfer::showCurrentData()
{
	char tmp[50];
   int i;


	edUser->setText( ((TransferItem *)currentItem)->getEmpf() );
	edMbx->setText( ((TransferItem *)currentItem)->getMbx() );
	edTitle->setText( ((TransferItem *)currentItem)->getTitel() );
   if ((i = ((TransferItem *)currentItem)->getLifetime()) == -1)
	   edLt->setText( "" );
	else
   {
	   sprintf(tmp, "%i", i);
	   edLt->setText( tmp );
	}
	cmbSplitsize->setCurrentItem( ((TransferItem *)currentItem)->getSize7pl() );
   slot7plCalcParts( ((TransferItem *)currentItem)->getSize7pl() );
   if (( i = ((TransferItem *)currentItem)->getStartWith()) == 1)
   {
      rdbtnSendAll->setChecked( true );
      edStartWith->setText( "" );
	}
   else
   {
      rdbtnStartWith->setChecked( true );
      sprintf(tmp, "%i", i);
      edStartWith->setText( tmp );
   }

   switch (((TransferItem *)currentItem)->getSendCmd())
   {
   	case 1: rdbtnS->setChecked( true ); break;
      case 2: rdbtnSP->setChecked( true ); break;
      case 3: rdbtnSB->setChecked( true ); break;
   }
}
//---------------------------------------------------------------------------
void DlgFiletransfer::slotToggleStartWith( bool enabled )
{
   edStartWith->setEnabled( enabled );
}
//---------------------------------------------------------------------------
void DlgFiletransfer::addFile( QString & name )
{
   char fname[500];
   QListViewItem *item, *last;
   int i;


   if ((i = name.find('\r')) != -1)
   	name.truncate( i );
   if ((i = name.find('\n')) != -1)
   	name.truncate( i );

   strcpy(fname, (const char *)name);

   if (!file_exist(fname))
   	return;

   item = listFName->firstChild();
   last = NULL;
   while (item != NULL)
   {
      if (!strcmp(((TransferItem *)item)->getLongname(), fname))
      	return;
      last = item;
   	item = item->itemBelow();
   }

   // Alten Eintrag speichern
   if (currentItem != NULL)
	   saveFileData();

   listFName->setSelected( (currentItem = new TransferItem(listFName, last, fname)), true );
   enableProtocolSelection( true );
   btnDel->setEnabled( true );

	showCurrentData();
}
//---------------------------------------------------------------------------

