// bbkeysConfigQT - front end interface
// Ryan Kelley <kelleyry@bc.edu>
// vanRijn <j_dot_kasper@usa.net>
// check http://movingparts.windsofstorm.net for more bbkeys info
// licensed under the GPL.

#ifndef GUI_HH
#define GUI_HH

#include <qwidget.h>
#include <qdialog.h>
#include <qmenubar.h>
#include <qcombobox.h>
#include <qgroupbox.h>
#include <qlistview.h>
#include <qlist.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qbutton.h>
#include <qevent.h>

class FrontEnd : public QWidget {
  Q_OBJECT
public:
  FrontEnd( QWidget *parent = 0, const char *name = 0 );
  ~FrontEnd();
  bool nowCapturing() { return capturing; }
  void captureKeygrab( XEvent *);

private slots:
  void updatetext(void);
  void grabKey();
  void nukeKeyGrab();
  void clearList();
  void open();
  void save();
  void saveAs();
  void listviewclick();
  void helpscreen();

protected:
  //void keyPressEvent( QKeyEvent * );

private:
  void readFile();
  void writeFile();

  QMenuBar *menubar;
  QLabel *statusbar;
  QGroupBox *editframe;
  QComboBox *combobox;
  QListView *listview;
  QLineEdit *txtcmd;
  QPushButton *cmdchangetext;
  QPushButton *rem;
  QPushButton *remall;
  QPushButton *finsave;
  QPushButton *finnosave;
  QPushButton *cmdgrab;

  QList<QListViewItem> grablist; // linked list of keys grabbed
  QString rcfile;
  bool capturing;
};

#endif // GUI_HH

