/***************************************************************************
                          as10k1.c  -  Main assembler routine
                             -------------------
    Date                 : May 22, 2000
    Copyright            : (C) 2000 by Daniel Bertrand
    Email                : d.bertrand@ieee.ca
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include<stdio.h>
#include "compiler.h"
#include "global.h"
#include "as10k1.h"


int main( int argc, char *argv[] )
{
  FILE *fp;
  int i;
  
	if(argc==4){
                if((dc_fp = fopen(argv[3], "w"))==NULL){
                        fprintf(stderr,"\nerror writing to file %s\n",argv[2]);
                        return(1);
                }
#ifdef DEBUG
                printf("file %s opened for ouputing define constants\n",argv[3]);
#endif    
                
        }else if(argc!=3){        
                fprintf(stderr,"\nusage: as10k1  source.asm binary.bin\n");
                return(1);
        }

        
#ifdef DEBUG        
	printf("First Pass...");
#endif
        asm_open(argv[1]);
	
	RESET();
#ifdef DEBUG
	printf("OK\nSecond Pass...");
#endif DEBUG	
	assemble();
#ifdef DEBUG        
	printf(" OK\n");
#endif    
//The following code is a modified copy/paste of Rui Sousa's main.c function
#ifdef DEBUG
  	for (i = 0; i < DSP_CODE_SIZE / 2; i++)
 	   	printf("0x%03x   0x%08x   0x%08x\n", i, dsp_code[i * 2], dsp_code[i * 2 + 1]);
#endif
 	if((fp = fopen(argv[2], "w"))==NULL){;
		fprintf(stderr,"\nerror writing to file %s\n",argv[2]);	
		return(1);
	}
		
  	for (i = 0; i < 4 * DSP_CODE_SIZE; i++)
    		fprintf(fp, "%c", ((char *) dsp_code)[i]);

  	fclose(fp);
        if(dc_fp!=NULL){
                fclose(dc_fp);
        }
        
              
  	return 0;
}


//(this is my code again:)


/*this function is called to open a asm file and parse it using the parse function.
this function is called by the main function and also by the parse function
when it encounters an "INCLUDE" directive.
*/

void asm_open(char *incl)
{
	FILE *fptr;
	char string[max_line_length];
	int done;
	
	if( (include_depth++) > max_depth){
		fprintf(stderr,"Error: maximum recursive include depth(%d) exceeded",max_depth);
		exit(1);
	}	 		
	
	if( ( fptr = fopen(incl,"r") ) == NULL ){
  		fprintf(stderr,"\nerror opening file %s\n",incl);
  		exit(1);
  	}
#ifdef DEBUG        
  	printf("File %s opened:\n",incl);
#endif	
	
	while ( (fgets(string,max_line_length , fptr) != NULL)&&(done!=1) ){  //line by line parse
		done=parse(string);
		source_line_num++;
	}

        
	if(done!=1)
		printf("Warning: no END directive found in %s\n",incl);

	include_depth--;	
	fclose(fptr);
#ifdef DEBUG	
  	printf("File %s closed:\n",incl);
#endif	
}







