/* vi:set ts=8 sts=0 sw=8:
 * $Id: prefs_nognome.c,v 1.1 2000/03/29 06:22:50 kahn Exp kahn $
 *
 * Copyright (C) 1998 Andy C. Kahn
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "main.h"
#include "gtkfontsel.h"
#include "misc.h"
#include "msgbar.h"
#include "msgbox.h"
#include "win.h"
#include "prefs.h"
#include "prefs_private.h"
#include "prefs_nognome.h"

#include "gnpintl.h"

#ifndef USE_GNOME

static void prefs_color_sel_ok(GtkWidget *wgt, gpointer cbdata);
static void prefs_color_sel_close(GtkWidget *, gpointer cbdata);
static void prefs_color_sel_destroy(GtkWidget *, gpointer cbdata);
static void prefs_font_sel_ok(GtkWidget *wgt, gpointer cbdata);
static void prefs_font_sel_cancel(GtkWidget *wgt, gpointer cbdata);


/*
 * PRIVATE: prefs_text_color_cb
 *
 * creates the color selection dialog and sets up the callbacks.  some of this
 * code was taken from testgtk.c
 *
 * rgb_str: points to either text_fg_str or text_bg_str.
 */
void
prefs_text_color_cb(GtkWidget *wgt, gpointer cbdata)
{
	int which = GPOINTER_TO_INT(cbdata);
	gdouble color[4];
	prefs_color_sel_t *pcsp;
	static char *which_txt[] = { /* some compilers need this to be static */
		"Text Foreground Color Selection",
		"Text Background Color Selection",
		"Text Hightlight Foreground Color Selection",
		"Text Hightlight Background Color Selection"
	};

	pcsp = g_new(prefs_color_sel_t, 1);
	pcsp->cs = gtk_color_selection_dialog_new(which_txt[which]);
	pcsp->which = which;

	switch (which) {
	case Foreground:
		sscanf(prefs.text_fg_str, "%lf %lf %lf",
			&(color[0]), &(color[2]), &(color[1]));
		break;
	case Background:
		sscanf(prefs.text_bg_str, "%lf %lf %lf",
			&(color[0]), &(color[2]), &(color[1]));
		break;
	case HighlightFg:
		sscanf(prefs.text_hlfg_str, "%lf %lf %lf",
			&(color[0]), &(color[2]), &(color[1]));
		break;
	case HighlightBg:
		sscanf(prefs.text_hlbg_str, "%lf %lf %lf",
			&(color[0]), &(color[2]), &(color[1]));
		break;
	}
	color[0] /= COL_VAL_GDK;
	color[1] /= COL_VAL_GDK;
	color[2] /= COL_VAL_GDK;
	gtk_color_selection_set_color(GTK_COLOR_SELECTION(
		GTK_COLOR_SELECTION_DIALOG(pcsp->cs)->colorsel), color);

	(void)gtk_signal_connect(GTK_OBJECT(pcsp->cs), "destroy",
		GTK_SIGNAL_FUNC(prefs_color_sel_destroy), pcsp);

	(void)gtk_signal_connect(GTK_OBJECT(
		GTK_COLOR_SELECTION_DIALOG(pcsp->cs)->ok_button), "clicked",
		GTK_SIGNAL_FUNC(prefs_color_sel_ok), pcsp);

	(void)gtk_signal_connect(GTK_OBJECT(
		GTK_COLOR_SELECTION_DIALOG(pcsp->cs)->cancel_button), "clicked",
		GTK_SIGNAL_FUNC(prefs_color_sel_close), pcsp);

	gtk_widget_show(pcsp->cs);
} /* prefs_text_color_cb */


/*
 * PRIVATE: prefs_color_sel_destroy
 *
 * callback for the "destroy" event for the color selection dialog
 */
static void
prefs_color_sel_destroy(GtkWidget *wgt, gpointer cbdata)
{
	prefs_color_sel_t *pcsp = (prefs_color_sel_t *)cbdata;

	if (pcsp) {
		g_free(pcsp);
		pcsp = NULL;
	}
} /* prefs_color_sel_destroy */


/*
 * PRIVATE: prefs_color_sel_close
 *
 * callback for the "Close" button from the color selection dialog
 */
static void
prefs_color_sel_close(GtkWidget *wgt, gpointer cbdata)
{
	prefs_color_sel_t *pcsp = (prefs_color_sel_t *)cbdata;

	g_assert(pcsp != NULL);
	gtk_widget_destroy(pcsp->cs);
} /* prefs_color_sel_close */

/*
 * PRIVATE: prefs_color_sel_ok
 *
 * callback for the "Ok" button in the color selection dialog.  gets the color
 * from the color selection dialog, then converts it into a character string
 * containing RGB values.
 */
static void
prefs_color_sel_ok(GtkWidget *wgt, gpointer cbdata)
{
	prefs_color_sel_t *pcsp = (prefs_color_sel_t *)cbdata;
	GtkColorSelection *colorsel;
	gdouble color[4];
	char buf[MAX_RGB_STR];

	g_assert(pcsp != NULL);
	colorsel = GTK_COLOR_SELECTION(
			GTK_COLOR_SELECTION_DIALOG(pcsp->cs)->colorsel);

	/*
	 * NOTE!  gtk_color_selection_get_color() returns the color in the
	 * order red-blue-green, instead of red-green-blue.
	 */
	gtk_color_selection_get_color(colorsel, color);

	GNPDBG_PREFS(("prefs_color_sel_ok: colors = (red %f) (green %f) "
		      "(blue %f)\n", color[0], color[2], color[1]));
	g_snprintf(buf, MAX_RGB_STR, "%u %u %u",
		   (unsigned)(color[0] * COL_VAL_GDK),
		   (unsigned)(color[2] * COL_VAL_GDK),
		   (unsigned)(color[1] * COL_VAL_GDK));
	GNPDBG_PREFS(("prefs_color_sel_ok: buf = '%s'\n", buf));

	color_sel_ok_common(pcsp->which, buf);
	gtk_widget_destroy(pcsp->cs);
} /* prefs_color_sel_ok */


/*
 * PRIVATE: prefs_font_sel_cb
 *
 * creates font selection dialog box and sets up callbacks.
 */
void
prefs_font_sel_cb(GtkWidget *wgt, gpointer cbdata)
{
	GtkWidget *tmp;

	tmp = gtk_font_selection_dialog_new("Font Selection");
	(void)gtk_signal_connect(
		GTK_OBJECT(GTK_FONT_SELECTION_DIALOG(tmp)->ok_button),
		"clicked", GTK_SIGNAL_FUNC(prefs_font_sel_ok), tmp);

	(void)gtk_signal_connect(
		GTK_OBJECT(GTK_FONT_SELECTION_DIALOG(tmp)->cancel_button),
		"clicked", GTK_SIGNAL_FUNC(prefs_font_sel_cancel), tmp);

	(void)gtk_signal_connect(GTK_OBJECT(tmp), "destroy",
				 GTK_SIGNAL_FUNC(gtk_widget_destroy), tmp);

	gtk_font_selection_dialog_set_font_name(
		GTK_FONT_SELECTION_DIALOG(tmp), prefs.text_font_str);

	gtk_widget_show(tmp);
} /* prefs_font_sel_cb */


/*
 * PRIVATE: prefs_font_sel_ok
 *
 * callback for "Ok" button on font selection dialog.  gets the font string
 * from the dialog, and calls gdk_font_load() to load it from the system.
 */
static void
prefs_font_sel_ok(GtkWidget *wgt, gpointer cbdata)
{
	GtkFontSelectionDialog *fsd = (GtkFontSelectionDialog *)cbdata;
	char *newfont;

	newfont = gtk_font_selection_dialog_get_font_name(fsd);
	if (newfont == NULL) {
		GNPDBG_PREFS(("prefs_font_sel_ok: no font chosen\n"));
		return;
	}

	font_sel_ok_common(newfont);
	g_free(newfont);
	gtk_widget_destroy(GTK_WIDGET(fsd));
} /* prefs_font_sel_ok */


/*
 * PRIVATE: prefs_font_sel_cancel
 *
 * callback for "Cancel" button on font selection dialog
 */
static void
prefs_font_sel_cancel(GtkWidget *wgt, gpointer cbdata)
{
	GtkFontSelectionDialog *fsd = (GtkFontSelectionDialog *)cbdata;

	gtk_widget_destroy(GTK_WIDGET(fsd));
} /* prefs_font_sel_cancel */


/*
 * PRIVATE: prefs_save_cb
 *
 * callback invoked when user clicks on "Ok" button
 */
void
prefs_save_cb(GtkWidget *wgt, gpointer cbdata)
{
	win_t *w = (win_t *)cbdata;

	GNPDBG_PREFS(("prefs_save_cb() entered\n"));
	gtk_widget_hide(prefs_win);
	prefs_update();
	prefs_save();
	prefs_wgtopt_list_free();
	gtk_widget_destroy(prefs_win);
	appgtk_rc_update(appgtkrc);
	msgbox_printf(_("Preferences saved..."));
	msgbar_printf(w, _("Preferences saved..."));
} /* prefs_save_cb */


/*
 * PRIVATE: prefs_win_cancel
 *
 * callback for 'Cancel' button
 */
void
prefs_win_cancel(GtkWidget *wgt, gpointer cbdata)
{
	gtk_widget_hide(prefs_win);
} /* prefs_win_cancel */


#endif	/* !USE_GNOME */

/* the end */
